/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.mode;

import java.math.BigDecimal;
import java.time.Month;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.ExpItemAmountBO;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.utils.ReimburseControlUtils;

public interface QuotaCtrlMode {
    default public ReimburseAmountControlResultBO validate(List<ExpItemAmountBO> expItemAmountBOS, QuotaAmountBO quotaAmountBO, Integer size) {
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<YearMonth, List<ExpItemAmountBO>> yearMonthAmount = quotaCtlMethodService.groupListDataByHappenDate(expItemAmountBOS);
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode(quotaAmountBO);
        ReimburseAmountControlResultBO result = new ReimburseAmountControlResultBO();
        result.setOver(false);
        DynamicObject expItem = BusinessDataServiceHelper.loadSingleFromCache((Object)quotaAmountBO.getExpenseItemId(), (String)"er_expenseitemedit", (String)"isreimburseamountctl,reimctltype,reimburseamountctlmethod,name,reimburseamountctlcount");
        for (Map.Entry<YearMonth, List<ExpItemAmountBO>> entry : yearMonthAmount.entrySet()) {
            YearMonth yearMonth = entry.getKey();
            List<ExpItemAmountBO> amountList = entry.getValue();
            quotaAmountBO.setHappenDate(yearMonth);
            List<ReimburseAmountDetailBean> reimbursedBills = quotaCtrlMode.getReimbursedBills(quotaAmountBO);
            if (quotaAmountBO.getCtrlCount() != 0 && reimbursedBills.size() + size > quotaAmountBO.getCtrlCount()) {
                result.setOver(true);
                List billNos = reimbursedBills.stream().map(e -> e.getBillno()).collect(Collectors.toList());
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u62a5\u9500%2$s\u6b21\uff08\u5355\u53f7\uff1a%3$s\uff09\uff0c\u5f53\u524d\u62a5\u9500\u8d85\u51fa\u9650\u5236\u6b21\u6570\u3002", (String)"QuotaCtrlMode_0", (String)"fi-er-business", (Object[])new Object[0]), ((OrmLocaleValue)expItem.get("name")).getDefaultItem(), String.valueOf(reimbursedBills.size()), String.join((CharSequence)",", billNos));
                result.setSelfMsg(msg);
                break;
            }
            BigDecimal quotaAmount = this.getQuotaAmount(quotaAmountBO);
            if (quotaAmount == null && "2".equals(quotaAmountBO.getCtrlType())) {
                result.setOver(false);
                break;
            }
            if (quotaAmount == null) {
                result.setInTable(false);
                quotaAmount = BigDecimal.ZERO;
            } else {
                result.setInTable(true);
            }
            BigDecimal reimedAmount = this.getReimedAmount(quotaAmountBO);
            BigDecimal balanceAmount = quotaAmount.subtract(reimedAmount).max(BigDecimal.ZERO);
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < amountList.size(); ++i) {
                ExpItemAmountBO amountItem = amountList.get(i);
                if (balanceAmount.compareTo(amount = amount.add(amountItem.getAmount())) >= 0) continue;
                result.setOver(true);
                result.setBalanceAmount(balanceAmount);
                result.setTotalAmount(quotaAmount);
                result.setBalanceAmount(balanceAmount);
                result.setCurrencyId(quotaAmountBO.getCurrencyId());
                result.setExpenseItemId(quotaAmountBO.getExpenseItemId());
                result.setReimbursePeriod(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"QuotaCtrlMode_1", (String)"fi-er-business", (Object[])new Object[0]), yearMonth.getMonthValue()));
                result.setInTable(true);
                result.setOverIndex(amountItem.getIndex());
                if ("1".equals(quotaAmountBO.getCtrlMode())) {
                    result.setReimUserOrDeptName(ReimburseControlUtils.getUserName(quotaAmountBO.getUserOrDeptId()));
                }
                if (!"2".equals(quotaAmountBO.getCtrlMode())) break;
                result.setReimUserOrDeptName(ReimburseControlUtils.getOrgName(quotaAmountBO.getUserOrDeptId()));
                break;
            }
            if (!result.isOver()) continue;
            break;
        }
        return result;
    }

    public Map<Month, BigDecimal> getMonthQuotaAmount(QuotaAmountBO var1);

    public BigDecimal getQuotaAmount(QuotaAmountBO var1);

    public BigDecimal getReimedAmount(QuotaAmountBO var1);

    public BigDecimal getBalanceAmount(QuotaAmountBO var1);

    public List<ReimburseAmountDetailBean> getReimbursedBills(QuotaAmountBO var1);

    public List<ReimAmountQuotaAmountBO> getReimedAmount(List<QuotaAmountBO> var1);
}

