/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.quota;

import java.math.BigDecimal;
import java.time.Month;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.common.constant.ErExpenseItemConstant;

public interface QuotaQueryService {
    public static final String EMP_FILTER = "company=? and employee=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'";
    public static final String DEPT_FILTER = "dept=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'";
    public static final String EMP_TABLE = "er_reimburseamount";
    public static final String DEPT_TABLE = "er_dept_reimctl";
    public static final String SELECT_FIELDS = "month1,month2,month3,month4,month5,month6,month7,month8,month9,month10,month11,month12,quarter1,quarter2,quarter3,quarter4,totalamount";

    default public DynamicObject queryEmpQuotaAmount(QuotaAmountBO reimAmountBO) {
        QFilter qFilter = QFilter.of((String)EMP_FILTER, (Object[])new Object[]{reimAmountBO.getCompanyId(), reimAmountBO.getUserOrDeptId(), reimAmountBO.getExpenseItemId(), reimAmountBO.getCurrencyId(), String.valueOf(reimAmountBO.getHappenDate().getYear())});
        return BusinessDataServiceHelper.loadSingleFromCache((String)EMP_TABLE, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{qFilter});
    }

    default public DynamicObject queryDeptQuotaAmount(QuotaAmountBO reimAmountBO) {
        QFilter qFilter = QFilter.of((String)DEPT_FILTER, (Object[])new Object[]{reimAmountBO.getUserOrDeptId(), reimAmountBO.getExpenseItemId(), reimAmountBO.getCurrencyId(), String.valueOf(reimAmountBO.getHappenDate().getYear())});
        return BusinessDataServiceHelper.loadSingleFromCache((String)DEPT_TABLE, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{qFilter});
    }

    default public BigDecimal getEmpQuotaAmount(QuotaAmountBO reimAmountBO) {
        DynamicObject quota = null;
        quota = reimAmountBO.getItem() == null ? this.queryEmpQuotaAmount(reimAmountBO) : reimAmountBO.getItem();
        if (quota == null) {
            return null;
        }
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(reimAmountBO.getCtrlMethod());
        return quotaCtlMethodService.getEmpQuotaAmountByCltMethod(quota, reimAmountBO);
    }

    default public BigDecimal getDeptQuotaAmount(QuotaAmountBO reimAmountBO) {
        DynamicObject quota = this.queryDeptQuotaAmount(reimAmountBO);
        if (quota == null) {
            return null;
        }
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(reimAmountBO.getCtrlMethod());
        return quotaCtlMethodService.getDeptQuotaAmountByCltMethod(quota, reimAmountBO);
    }

    default public Map<Month, BigDecimal> getEmpMonthQuotaAmount(QuotaAmountBO reimAmountBO) {
        if (!ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue().equals(reimAmountBO.getCtrlMethod())) {
            return null;
        }
        DynamicObject quota = this.queryEmpQuotaAmount(reimAmountBO);
        return this.queryQuotaMonthAmountMap(quota);
    }

    default public Map<Month, BigDecimal> getDeptMonthQuotaAmount(QuotaAmountBO reimAmountBO) {
        if (!ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue().equals(reimAmountBO.getCtrlMethod())) {
            return null;
        }
        DynamicObject quota = this.queryDeptQuotaAmount(reimAmountBO);
        return this.queryQuotaMonthAmountMap(quota);
    }

    default public Map<Month, BigDecimal> queryQuotaMonthAmountMap(DynamicObject quota) {
        if (quota == null) {
            return null;
        }
        EnumMap<Month, BigDecimal> quotaMonthAmount = new EnumMap<Month, BigDecimal>(Month.class);
        Arrays.stream(Month.values()).forEach(month -> quotaMonthAmount.put((Month)month, new BigDecimal("0")));
        for (int i = 1; i < 13; ++i) {
            BigDecimal amount = quota.getBigDecimal("month" + i);
            amount = amount == null ? BigDecimal.ZERO : amount;
            quotaMonthAmount.put(Month.of(i), amount);
        }
        return quotaMonthAmount;
    }
}

