/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.reimed;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodFactory;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.model.ReimAmountQuotaAmountBO;
import kd.fi.er.business.reimamountctl.reimed.ReimedQueryService;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.model.WrappedObject;

public class TripReimedQueryServiceImpl
implements ReimedQueryService {
    @Override
    public BigDecimal queryEmpReimedAmount(QuotaAmountBO reimAmountBO) {
        QFilter empQueryFilter = this.getEmpQueryFilter(reimAmountBO);
        return this.getReimedAmount(reimAmountBO, empQueryFilter);
    }

    @Override
    public BigDecimal queryDeptReimedAmount(QuotaAmountBO reimAmountBO) {
        QFilter deptQueryFilter = this.getDeptQueryFilter(reimAmountBO);
        return this.getReimedAmount(reimAmountBO, deptQueryFilter);
    }

    private BigDecimal getReimedAmount(QuotaAmountBO reimAmountBO, QFilter queryFilter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)TripReimedQueryServiceImpl.class.getCanonicalName(), (String)"er_tripreimbursebill", (String)("id,tripentry,tripentry.entryentity," + reimAmountBO.getTripAmountKey()), (QFilter[])new QFilter[]{queryFilter}, null);
        WrappedObject wo = new WrappedObject((Object)BigDecimal.ZERO);
        dataSet.forEach(data -> {
            BigDecimal amount = data.getBigDecimal(reimAmountBO.getTripAmountKey());
            wo.setValue((Object)((BigDecimal)wo.getValue()).add(amount));
        });
        dataSet.close();
        return (BigDecimal)wo.getValue();
    }

    @Override
    public List<ReimburseAmountDetailBean> queryEmpReimedBill(QuotaAmountBO quotaAmountBO) {
        QFilter empQueryFilter = this.getEmpQueryFilter(quotaAmountBO);
        return this.getReimedBill(quotaAmountBO, empQueryFilter);
    }

    @Override
    public List<ReimburseAmountDetailBean> queryDeptReimedBill(QuotaAmountBO quotaAmountBO) {
        QFilter deptQueryFilter = this.getDeptQueryFilter(quotaAmountBO);
        return this.getReimedBill(quotaAmountBO, deptQueryFilter);
    }

    private List<ReimburseAmountDetailBean> getReimedBill(QuotaAmountBO quotaAmountBO, QFilter queryFilter) {
        String formName = FormMetadataCache.getFormConfig((String)"er_tripreimbursebill").getCaption().getLocaleValue();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)TripReimedQueryServiceImpl.class.getCanonicalName(), (String)"er_tripreimbursebill", (String)("id,billno,tripentry,tripentry.entryentity,tripentry.entryentity.travelhappendate," + quotaAmountBO.getTripAmountKey()), (QFilter[])new QFilter[]{queryFilter}, null);
        ArrayList<ReimburseAmountDetailBean> deptReimedBills = new ArrayList<ReimburseAmountDetailBean>(16);
        dataSet.forEach(data -> {
            ReimburseAmountDetailBean reimburseAmountDetailBean = new ReimburseAmountDetailBean();
            reimburseAmountDetailBean.setMetaKey("er_tripreimbursebill");
            reimburseAmountDetailBean.setMobFormKey("er_tripreimbursebill_mob");
            reimburseAmountDetailBean.setBillName(formName);
            reimburseAmountDetailBean.setBillId(data.getLong("id"));
            reimburseAmountDetailBean.setBillno(data.getString("billno"));
            reimburseAmountDetailBean.setHappenedDate(ErCommonUtils.getLocalDateFromDate(data.getDate("tripentry.entryentity.travelhappendate")));
            reimburseAmountDetailBean.setReimburseAmount(data.getBigDecimal(quotaAmountBO.getTripAmountKey()));
            deptReimedBills.add(reimburseAmountDetailBean);
        });
        dataSet.close();
        return deptReimedBills;
    }

    @Override
    public QFilter getEmpQueryFilter(QuotaAmountBO quotaAmountBO) {
        QFilter otherFilter = QFilter.of((String)"tripentry.entryentity.trip2travelers.fbasedataid=?", (Object[])new Object[]{quotaAmountBO.getUserOrDeptId()});
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(quotaAmountBO.getCompanyId()));
        List<Long> notInIds = quotaAmountBO.getNotInIds();
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        QFilter qFilter = QFilter.of((String)"tripentry.entryentity.travelexpenseitem = ? ", (Object[])new Object[]{quotaAmountBO.getExpenseItemId()});
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)BILL_STATUS_WITH_REIMBURSE);
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        if (happenDatePeriod != null) {
            otherFilter.and(QFilter.of((String)"tripentry.entryentity.travelhappendate >= ? and tripentry.entryentity.travelhappendate <= ? ", (Object[])new Object[]{ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")), ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"))}));
        }
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(new QFilter(quotaAmountBO.getTripCurrencyKey(), "=", (Object)quotaAmountBO.getCurrencyId()));
        return keyQFilter;
    }

    @Override
    public QFilter getDeptQueryFilter(QuotaAmountBO quotaAmountBO) {
        QFilter otherFilter = QFilter.of((String)"tripentry.entryentity.travelquotactldept=?", (Object[])new Object[]{quotaAmountBO.getUserOrDeptId()});
        List<Long> notInIds = quotaAmountBO.getNotInIds();
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        QFilter qFilter = QFilter.of((String)"tripentry.entryentity.travelexpenseitem = ? ", (Object[])new Object[]{quotaAmountBO.getExpenseItemId()});
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)BILL_STATUS_WITH_REIMBURSE);
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        if (happenDatePeriod != null) {
            otherFilter.and(QFilter.of((String)"tripentry.entryentity.travelhappendate >= ? and tripentry.entryentity.travelhappendate <= ? ", (Object[])new Object[]{ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")), ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"))}));
        }
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(new QFilter(quotaAmountBO.getTripCurrencyKey(), "=", (Object)quotaAmountBO.getCurrencyId()));
        return keyQFilter;
    }

    @Override
    public List<ReimAmountQuotaAmountBO> queryEmpReimedAmount(List<QuotaAmountBO> expenseReimedQueryList) {
        if (expenseReimedQueryList == null || expenseReimedQueryList.isEmpty()) {
            return new ArrayList<ReimAmountQuotaAmountBO>(1);
        }
        QFilter empQueryFilter = this.getEmpQueryFilter(expenseReimedQueryList);
        return this.getReimedAmount(expenseReimedQueryList, empQueryFilter);
    }

    private List<ReimAmountQuotaAmountBO> getReimedAmount(List<QuotaAmountBO> expenseReimedQueryList, QFilter queryFilter) {
        Set tripCurrencyKeys = expenseReimedQueryList.stream().map(er -> er.getTripCurrencyKey()).collect(Collectors.toSet());
        String currencyFields = tripCurrencyKeys.stream().collect(Collectors.joining(","));
        Set tripAmountKeys = expenseReimedQueryList.stream().map(er -> er.getTripAmountKey()).collect(Collectors.toSet());
        String tripAmountFields = tripAmountKeys.stream().collect(Collectors.joining(","));
        String companyField = ReimburseControlUtils.getPersonReimCtlCompanyField();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)TripReimedQueryServiceImpl.class.getCanonicalName(), (String)"er_tripreimbursebill", (String)("id,tripentry,tripentry.entryentity,tripentry.entryentity.trip2travelers.fbasedataid," + companyField + ",tripentry.entryentity.travelhappendate,tripentry.entryentity.travelexpenseitem," + currencyFields + "," + tripAmountFields), (QFilter[])new QFilter[]{queryFilter}, null);
        String employeeKey = "tripentry.entryentity.trip2travelers.fbasedataid";
        String expenseitem = "tripentry.entryentity.travelexpenseitem";
        String quotaDateField = "tripentry.entryentity.travelhappendate";
        return QuotaCtrlUtil.buildReimedAmount(dataSet, expenseReimedQueryList, "er_tripreimbursebill", companyField, employeeKey, expenseitem, quotaDateField);
    }

    private void buildAmount(List<ReimAmountQuotaAmountBO> resultList, Row data, QuotaAmountBO quotaAmountBO, Set<Long> billIDS) {
        String employeeKey = "tripentry.entryentity.trip2travelers.fbasedataid";
        Long dataEmployee = data.getLong(employeeKey) == null ? Long.valueOf(0L) : data.getLong(employeeKey);
        Long employee = quotaAmountBO.getUserOrDeptId() == null ? Long.valueOf(0L) : quotaAmountBO.getUserOrDeptId();
        String currencyKey = quotaAmountBO.getTripCurrencyKey();
        Long dataCurrency = data.getLong(currencyKey) == null ? Long.valueOf(0L) : data.getLong(currencyKey);
        Long currency = quotaAmountBO.getCurrencyId() == null ? Long.valueOf(0L) : quotaAmountBO.getCurrencyId();
        String companyField = ReimburseControlUtils.getPersonReimCtlCompanyField();
        Long dataCompanyId = data.getLong(companyField) == null ? Long.valueOf(0L) : data.getLong(companyField);
        Long companyId = quotaAmountBO.getCompanyId() == null ? Long.valueOf(0L) : quotaAmountBO.getCompanyId();
        String expenseitem = "tripentry.entryentity.travelexpenseitem";
        Long dataExpenseitemId = data.getLong(expenseitem) == null ? Long.valueOf(0L) : data.getLong(expenseitem);
        Long expenseItemId = quotaAmountBO.getExpenseItemId() == null ? Long.valueOf(0L) : quotaAmountBO.getExpenseItemId();
        String quotaDateField = "tripentry.entryentity.travelhappendate";
        QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
        Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
        Date startDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start")) == null ? new Date(Long.MAX_VALUE) : ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start"));
        Date endDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end")) == null ? new Date(Long.MIN_VALUE) : ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"));
        Date dataSetDate = data.getDate(quotaDateField) == null ? new Date() : data.getDate(quotaDateField);
        String tripAmountKey = quotaAmountBO.getTripAmountKey();
        BigDecimal amount = data.getBigDecimal(tripAmountKey);
        if (employee.compareTo(dataEmployee) == 0 && currency.compareTo(dataCurrency) == 0 && companyId.compareTo(dataCompanyId) == 0 && expenseItemId.compareTo(dataExpenseitemId) == 0 && startDate.compareTo(dataSetDate) <= 0 && endDate.compareTo(dataSetDate) >= 0) {
            billIDS.add(data.getLong("id"));
            ReimAmountQuotaAmountBO newReimAmountQuotaAmountBO = new ReimAmountQuotaAmountBO(quotaAmountBO, amount);
            int existIndex = resultList.indexOf(newReimAmountQuotaAmountBO);
            if (existIndex >= 0) {
                ReimAmountQuotaAmountBO existReimAmountQuotaAmountBO = resultList.get(existIndex);
                WrappedObject wo = new WrappedObject((Object)existReimAmountQuotaAmountBO.getReimAmount());
                wo.setValue((Object)((BigDecimal)wo.getValue()).add(amount));
                existReimAmountQuotaAmountBO.setReimAmount((BigDecimal)wo.getValue());
            } else {
                resultList.add(newReimAmountQuotaAmountBO);
            }
        }
    }

    private QFilter getEmpQueryFilter(List<QuotaAmountBO> expenseReimedQueryList) {
        Set travelers = expenseReimedQueryList.stream().map(er -> er.getUserOrDeptId()).collect(Collectors.toSet());
        QFilter otherFilter = new QFilter("tripentry.entryentity.trip2travelers.fbasedataid", "in", travelers);
        Set<Long> companyIds = expenseReimedQueryList.stream().map(er -> er.getCompanyId()).collect(Collectors.toSet());
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyIds));
        ArrayList notInIds = new ArrayList();
        expenseReimedQueryList.stream().forEach(er -> notInIds.addAll(er.getNotInIds() == null ? new ArrayList() : er.getNotInIds()));
        if (!notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        Set expenseItemIdSet = expenseReimedQueryList.stream().map(er -> er.getExpenseItemId()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("tripentry.entryentity.travelexpenseitem", "in", expenseItemIdSet);
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)BILL_STATUS_WITH_REIMBURSE);
        Date minStartDate = null;
        Date maxEndDate = null;
        for (QuotaAmountBO quotaAmountBO : expenseReimedQueryList) {
            QuotaCtlMethodService quotaCtlMethodService = QuotaCtlMethodFactory.get(quotaAmountBO.getCtrlMethod());
            Map<String, LocalDate> happenDatePeriod = quotaCtlMethodService.genHappenDatePeriod(quotaAmountBO);
            Date currentMinStartDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("start"));
            Date currentMaxEndDate = ErCommonUtils.getDateFromLocalDate(happenDatePeriod.get("end"));
            if (minStartDate == null || currentMinStartDate.compareTo(minStartDate) < 0) {
                minStartDate = currentMinStartDate;
            }
            if (maxEndDate != null && currentMaxEndDate.compareTo(maxEndDate) <= 0) continue;
            maxEndDate = currentMaxEndDate;
        }
        if (minStartDate != null && maxEndDate != null) {
            otherFilter.and(QFilter.of((String)"tripentry.entryentity.travelhappendate >= ? and tripentry.entryentity.travelhappendate <= ? ", (Object[])new Object[]{minStartDate, maxEndDate}));
        }
        QFilter currencyFilter = null;
        Set ExpenseCurrencyKeys = expenseReimedQueryList.stream().map(er -> er.getTripCurrencyKey()).collect(Collectors.toSet());
        Set currencyIds = expenseReimedQueryList.stream().filter(er -> er.getCurrencyId() != null).map(er -> er.getCurrencyId()).collect(Collectors.toSet());
        for (String expenseCurrencyKey : ExpenseCurrencyKeys) {
            if (currencyFilter == null) {
                currencyFilter = new QFilter(expenseCurrencyKey, "in", currencyIds);
                continue;
            }
            currencyFilter = currencyFilter.or(new QFilter(expenseCurrencyKey, "in", currencyIds));
        }
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(currencyFilter);
        return keyQFilter;
    }
}

