/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.ExpItemAmountBO;
import kd.fi.er.business.reimamountctl.model.ExpItemCurrencyReimerBO;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class DailyReimQuotaValidate {
    public static List<String> validDailyReimQuota(final DynamicObject dataEntity, String billEntityType, ExtendedDataEntity[] dataEntities) {
        DynamicObjectCollection expenseEntrys;
        ArrayList result = Lists.newArrayListWithExpectedSize((int)0);
        List longSet = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).filter(entity -> ErCommonUtils.getPk(ReimburseControlUtils.getReimburseControlCompany(dataEntity)).equals(ErCommonUtils.getPk(ReimburseControlUtils.getReimburseControlCompany(dataEntity)))).collect(Collectors.toList());
        if (longSet.size() > 1) {
            expenseEntrys = new DynamicObjectCollection();
            for (DynamicObject item : longSet) {
                expenseEntrys.addAll((Collection)item.getDynamicObjectCollection("expenseentryentity"));
            }
        } else {
            expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
        }
        if (expenseEntrys == null || expenseEntrys.isEmpty()) {
            return result;
        }
        Long currBillId = (Long)dataEntity.getPkValue();
        DynamicObject quotaCtrlCompany = ReimburseControlUtils.getReimburseControlCompany(dataEntity);
        if (quotaCtrlCompany == null) {
            return result;
        }
        Long quotaCtrlCompanyId = ErCommonUtils.getPk(quotaCtrlCompany);
        DynamicObject company = dataEntity.getDynamicObject("company");
        Long companyId = ErCommonUtils.getPk(company);
        Long baseCurrencyId = ErCommonUtils.getPk(dataEntity.getDynamicObject("currency"));
        String personCtrlCurrency = (String)ErCommonUtils.getEMParameter(companyId, "personctlcurrency");
        String deptCtrlCurrency = (String)ErCommonUtils.getEMParameter(companyId, "deptctlcurrency");
        HashMap<ExpItemCurrencyReimerBO, List> empExpItemAmount = new HashMap<ExpItemCurrencyReimerBO, List>(expenseEntrys.size());
        HashMap<ExpItemCurrencyReimerBO, List> deptExpItemAmount = new HashMap<ExpItemCurrencyReimerBO, List>(expenseEntrys.size());
        final boolean bizDateQuotaDate = "2".equals(ErStdConfig.get("quotaDateField"));
        Map<Object, List<DynamicObject>> collect = expenseEntrys.stream().collect(Collectors.groupingBy(new Function<DynamicObject, Object>(){

            @Override
            public Object apply(DynamicObject dynamicObject) {
                Date date = dynamicObject.getDate("happendate");
                if (bizDateQuotaDate) {
                    date = dataEntity.getDate("bizdate");
                }
                LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(date);
                StringBuilder builder = new StringBuilder();
                builder.append(dynamicObject.getDynamicObject("expenseitem") != null ? dynamicObject.getDynamicObject("expenseitem").getPkValue() : "");
                builder.append("-");
                builder.append(happenDate != null ? Integer.valueOf(happenDate.getYear()) : "");
                return builder.toString();
            }
        }));
        Map<Object, List<DynamicObject>> second = expenseEntrys.stream().filter(ite -> ite.getDynamicObject("expenseitem") != null && "B".equals(ite.getDynamicObject("expenseitem").get("reimburseamountctlmethod"))).collect(Collectors.groupingBy(new Function<DynamicObject, Object>(){

            @Override
            public Object apply(DynamicObject dynamicObject) {
                Date date = dynamicObject.getDate("happendate");
                if (bizDateQuotaDate) {
                    date = dataEntity.getDate("bizdate");
                }
                LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(date);
                StringBuilder builder = new StringBuilder();
                builder.append(dynamicObject.getDynamicObject("expenseitem").getPkValue());
                builder.append(happenDate != null ? Integer.valueOf(happenDate.getYear()) : "");
                builder.append(happenDate != null ? Integer.valueOf(happenDate.getMonth().getValue()) : "");
                return builder.toString();
            }
        }));
        Map<Object, List<DynamicObject>> secondOnd = expenseEntrys.stream().filter(ite -> ite.getDynamicObject("expenseitem") != null && "E".equals(ite.getDynamicObject("expenseitem").get("reimburseamountctlmethod"))).collect(Collectors.groupingBy(new Function<DynamicObject, Object>(){

            @Override
            public Object apply(DynamicObject dynamicObject) {
                Date date = dynamicObject.getDate("happendate");
                if (bizDateQuotaDate) {
                    date = dataEntity.getDate("bizdate");
                }
                LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(date);
                StringBuilder builder = new StringBuilder();
                builder.append(dynamicObject.getDynamicObject("expenseitem").getPkValue());
                builder.append(happenDate != null ? Integer.valueOf(happenDate.getYear()) : "");
                builder.append(happenDate != null ? Integer.valueOf((happenDate.getMonth().getValue() - 1) / 3) : "");
                return builder.toString();
            }
        }));
        Date bizDate = dataEntity.getDate("bizdate");
        int index = 1;
        for (DynamicObject expenseEntry : expenseEntrys) {
            ExpItemCurrencyReimerBO deptKey;
            StringBuilder builder;
            StringBuilder builder2;
            Integer size;
            BigDecimal reimedAmount;
            Long currencyId;
            DynamicObject entryExpenseitem = expenseEntry.getDynamicObject("expenseitem");
            if (entryExpenseitem == null) continue;
            Long expItemId = (Long)entryExpenseitem.getPkValue();
            Long oriCurrency = (Long)expenseEntry.getDynamicObject("entrycurrency").getPkValue();
            Date date = expenseEntry.getDate("happendate");
            if (bizDateQuotaDate) {
                date = bizDate;
            }
            LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(date);
            String ctrlMode = entryExpenseitem.getString("isreimburseamountctl");
            if ("1".equals(ctrlMode)) {
                ExpItemCurrencyReimerBO empKey;
                int month;
                if ("0".equals(personCtrlCurrency)) {
                    currencyId = oriCurrency;
                    reimedAmount = expenseEntry.getBigDecimal("expeapproveamount");
                } else {
                    currencyId = baseCurrencyId;
                    reimedAmount = expenseEntry.getBigDecimal("expeapprovecurramount");
                }
                Long travelerId = ErEntityTypeUtils.isPublicReimburseBill(billEntityType) ? (expenseEntry.containsProperty("pubreimburser") && expenseEntry.getDynamicObject("pubreimburser") != null ? (Long)expenseEntry.getDynamicObject("pubreimburser").getPkValue() : (Long)dataEntity.getDynamicObject("applier").getPkValue()) : (Long)expenseEntry.getDynamicObject("reimburser").getPkValue();
                size = 1;
                if (expenseEntry.getDynamicObject("expenseitem") != null && happenDate != null) {
                    builder2 = new StringBuilder();
                    builder2.append(expenseEntry.getDynamicObject("expenseitem").getPkValue());
                    builder2.append("-");
                    builder2.append(happenDate.getYear());
                    size = collect.get(builder2.toString()).size();
                }
                if (expenseEntry.getDynamicObject("expenseitem") != null && happenDate != null) {
                    int year = happenDate.getYear();
                    month = happenDate.getMonth().getValue();
                    builder = new StringBuilder();
                    builder.append(expenseEntry.getDynamicObject("expenseitem").getPkValue());
                    builder.append(year);
                    builder.append(month);
                    if (second.get(builder.toString()) != null) {
                        size = second.get(builder.toString()).size();
                    }
                }
                if (expenseEntry.getDynamicObject("expenseitem") != null && happenDate != null) {
                    int year = happenDate.getYear();
                    month = happenDate.getMonth().getValue();
                    builder = new StringBuilder();
                    builder.append(expenseEntry.getDynamicObject("expenseitem").getPkValue());
                    builder.append(year);
                    builder.append(month / 3);
                    if (secondOnd.get(builder.toString()) != null) {
                        size = secondOnd.get(builder.toString()).size();
                    }
                }
                if (!empExpItemAmount.containsKey(empKey = new ExpItemCurrencyReimerBO(expItemId, currencyId, travelerId, size))) {
                    empExpItemAmount.put(empKey, new ArrayList());
                }
                List reimburseAmountBOs = (List)empExpItemAmount.get(empKey);
                reimburseAmountBOs.add(new ExpItemAmountBO(happenDate, reimedAmount, currencyId, index++));
                continue;
            }
            if (!"2".equals(ctrlMode)) continue;
            if ("0".equals(deptCtrlCurrency)) {
                currencyId = oriCurrency;
                reimedAmount = expenseEntry.getBigDecimal("expeapproveamount");
            } else {
                currencyId = baseCurrencyId;
                reimedAmount = expenseEntry.getBigDecimal("expeapprovecurramount");
            }
            Long deptId = (Long)expenseEntry.getDynamicObject("reimctldept").getPkValue();
            size = 1;
            if (expenseEntry.getDynamicObject("expenseitem") != null && happenDate != null) {
                builder2 = new StringBuilder();
                builder2.append(expenseEntry.getDynamicObject("expenseitem").getPkValue());
                builder2.append("-");
                builder2.append(happenDate.getYear());
                size = collect.get(builder2.toString()).size();
            }
            if (expenseEntry.getDynamicObject("expenseitem") != null && happenDate != null) {
                int year = happenDate.getYear();
                int month = happenDate.getMonth().getValue();
                builder = new StringBuilder();
                builder.append(expenseEntry.getDynamicObject("expenseitem").getPkValue());
                builder.append(year);
                builder.append(month);
                if (second.get(builder.toString()) != null) {
                    size = second.get(builder.toString()).size();
                }
            }
            if (expenseEntry.getDynamicObject("expenseitem") != null && happenDate != null) {
                int year = happenDate.getYear();
                int month = happenDate.getMonth().getValue();
                builder = new StringBuilder();
                builder.append(expenseEntry.getDynamicObject("expenseitem").getPkValue());
                builder.append(year);
                builder.append(month / 3);
                if (secondOnd.get(builder.toString()) != null) {
                    size = secondOnd.get(builder.toString()).size();
                }
            }
            if (!deptExpItemAmount.containsKey(deptKey = new ExpItemCurrencyReimerBO(expItemId, currencyId, deptId, size))) {
                deptExpItemAmount.put(deptKey, new ArrayList());
            }
            List deptReimburseAmountBOs = (List)deptExpItemAmount.get(deptKey);
            deptReimburseAmountBOs.add(new ExpItemAmountBO(happenDate, reimedAmount, currencyId, index++));
        }
        List<String> empCltList = SystemParamterUtil.getEmpCltBillList(companyId);
        List<String> deptCltList = SystemParamterUtil.getDeptCltBillList(companyId);
        AtomicBoolean isHaveQuota = new AtomicBoolean(false);
        AtomicBoolean isOverQuota = new AtomicBoolean(false);
        if (empCltList.contains("1") && ErEntityTypeUtils.isDailyReimburseBill(billEntityType) || empCltList.contains("3") && ErEntityTypeUtils.isPublicReimburseBill(billEntityType)) {
            empExpItemAmount.forEach((expItemCurrencyReimerBO, expItemAmountBOs) -> {
                isHaveQuota.set(true);
                QuotaAmountBO quotaAmountBO = new QuotaAmountBO();
                quotaAmountBO.setCompanyId(quotaCtrlCompanyId);
                quotaAmountBO.setEmpCtlBill(empCltList);
                quotaAmountBO.setDeptCtlBill(deptCltList);
                quotaAmountBO.setNotInIds(Lists.newArrayList((Object[])new Long[]{currBillId}));
                quotaAmountBO.setUserOrDeptId(expItemCurrencyReimerBO.getUserOrDeptId());
                QuotaCtrlUtil.genQuotaExpItem(quotaAmountBO, expItemCurrencyReimerBO.getExpItemId());
                QuotaCtrlUtil.genQuotaCurrency(quotaAmountBO, personCtrlCurrency, expItemCurrencyReimerBO.getCurrencyId(), expItemCurrencyReimerBO.getCurrencyId());
                QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode(quotaAmountBO);
                ReimburseAmountControlResultBO res = quotaCtrlMode.validate((List<ExpItemAmountBO>)expItemAmountBOs, quotaAmountBO, expItemCurrencyReimerBO.getExpItemSize());
                if (res.isOver()) {
                    isOverQuota.set(true);
                    if (StringUtils.isNotEmpty((CharSequence)res.getSelfMsg())) {
                        result.add(res.getSelfMsg());
                    } else {
                        result.add(res.getOverDesc());
                    }
                }
            });
        }
        if (deptCltList.contains("1") && ErEntityTypeUtils.isDailyReimburseBill(billEntityType) || deptCltList.contains("3") && ErEntityTypeUtils.isPublicReimburseBill(billEntityType)) {
            deptExpItemAmount.forEach((expItemCurrencyReimerBO, expItemAmountBOs) -> {
                isHaveQuota.set(true);
                QuotaAmountBO quotaAmountBO = new QuotaAmountBO();
                quotaAmountBO.setCompanyId(quotaCtrlCompanyId);
                quotaAmountBO.setEmpCtlBill(empCltList);
                quotaAmountBO.setDeptCtlBill(deptCltList);
                quotaAmountBO.setNotInIds(Lists.newArrayList((Object[])new Long[]{currBillId}));
                quotaAmountBO.setUserOrDeptId(expItemCurrencyReimerBO.getUserOrDeptId());
                QuotaCtrlUtil.genQuotaExpItem(quotaAmountBO, expItemCurrencyReimerBO.getExpItemId());
                QuotaCtrlUtil.genQuotaCurrency(quotaAmountBO, deptCtrlCurrency, expItemCurrencyReimerBO.getCurrencyId(), expItemCurrencyReimerBO.getCurrencyId());
                QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode(quotaAmountBO);
                ReimburseAmountControlResultBO res = quotaCtrlMode.validate((List<ExpItemAmountBO>)expItemAmountBOs, quotaAmountBO, expItemCurrencyReimerBO.getExpItemSize());
                if (res.isOver()) {
                    isOverQuota.set(true);
                    if (StringUtils.isNotEmpty((CharSequence)res.getSelfMsg())) {
                        result.add(res.getSelfMsg());
                    } else {
                        result.add(res.getOverDesc());
                    }
                }
            });
        }
        if (!isHaveQuota.get()) {
            dataEntity.set("abovequota", (Object)"0");
        } else if (isOverQuota.get()) {
            dataEntity.set("abovequota", (Object)"1");
        } else {
            dataEntity.set("abovequota", (Object)"2");
        }
        if (null != result && result.size() > 0) {
            return result.stream().sorted().collect(Collectors.toList());
        }
        return result;
    }
}

