/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.amt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptAmtContext;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class DeptAmtReportDataHandler
implements IMBReportDataHandler<List<Map<String, Object>>> {
    @Override
    public List<Map<String, Object>> doHandler(AbstractReportContext context) {
        ArrayList chartDatas = Lists.newArrayListWithExpectedSize((int)16);
        DeptAmtContext reportCtx = (DeptAmtContext)context;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DeptAmtQueryPageMobPlugin", (String)"er_dept_reimctl", (String)"expenseitem.id,expenseitem.name,expenseitem.reimburseamountctlmethod,dateyear,currency,currency.sign,totalamount,company,dept", (QFilter[])reportCtx.getQFilters(), (String)"expenseitem asc");){
            for (Row row : dataSet) {
                ArrayList<String> deptCltList = new ArrayList<String>();
                deptCltList.add("1");
                deptCltList.add("2");
                deptCltList.add("3");
                QuotaAmountBO reimAmountBO = new QuotaAmountBO();
                reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk(row.get("dept")));
                reimAmountBO.setDeptCtlBill(deptCltList);
                reimAmountBO.setEmpCtlBill(deptCltList);
                reimAmountBO.setExpenseItemId(ErCommonUtils.getPk(row.get("expenseitem.id")));
                reimAmountBO.setCtrlMode("2");
                reimAmountBO.setCtrlMethod(row.getString("expenseitem.reimburseamountctlmethod"));
                String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency(ErCommonUtils.getPk(row.get("company")));
                QuotaCtrlUtil.genQuotaCurrency(reimAmountBO, deptCtrlCurrency, ErCommonUtils.getPk(row.get("currency")), ErCommonUtils.getPk(row.get("currency")));
                YearMonth yearMonth = YearMonth.now();
                LocalDate start = LocalDate.of(yearMonth.getYear(), 1, 1);
                LocalDate end = LocalDate.now();
                int year = Integer.parseInt(row.get("dateyear").toString());
                if (year != yearMonth.getYear()) {
                    yearMonth = YearMonth.of(year, 12);
                }
                if ("lm".equals(reportCtx.getDataFilter())) {
                    yearMonth = yearMonth.minusMonths(1L);
                }
                start = LocalDate.of(yearMonth.getYear(), 1, 1);
                end = LocalDate.of(yearMonth.getYear(), 12, 31);
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                map.put("expenseitem", row.get("expenseitem.name"));
                map.put("expenseitemid", row.get("expenseitem.id"));
                map.put("reimburseamountctlmethod", row.get("expenseitem.reimburseamountctlmethod"));
                map.put("currency", row.get("currency"));
                map.put("sign", row.get("currency.sign"));
                map.put("dept", row.get("dept"));
                map.put("totalamount", row.get("totalamount"));
                map.put("datayear", year);
                this.queryAmt(map, reimAmountBO, start, end, yearMonth);
                chartDatas.add(map);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("DeptAmtReportDataHandler.dohandler", ""), new Object[0]);
        }
        return chartDatas;
    }

    private Map<String, Object> queryAmt(Map<String, Object> map, QuotaAmountBO reimAmountBO, LocalDate start, LocalDate end, YearMonth yearMonth) {
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode(reimAmountBO);
        reimAmountBO.setHappenDatePeriod(start, end);
        BigDecimal thisYearUsedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
        reimAmountBO.setHappenDatePeriod(new HashMap<String, LocalDate>());
        reimAmountBO.setHappenDate(yearMonth);
        BigDecimal thisTermAmount = quotaCtrlMode.getQuotaAmount(reimAmountBO);
        BigDecimal thisTermUsedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
        BigDecimal thisTermBalanceAmount = thisTermAmount.subtract(thisTermUsedAmount);
        if (BigDecimal.ZERO.compareTo(thisTermBalanceAmount) > 0) {
            thisTermBalanceAmount = BigDecimal.ZERO;
        }
        map.put("thisYearUsedAmount", thisYearUsedAmount);
        map.put("thisTermAmount", thisTermAmount);
        map.put("thisTermUsedAmount", thisTermUsedAmount);
        map.put("thisTermBalanceAmount", thisTermBalanceAmount);
        return map;
    }
}

