/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.dept;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptReimAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;

public class Group2ListByMonthHandler
implements IMBReportDataHandler<Map<String, Map<String, List<Object[]>>>> {
    private Map<TableDO, List<Object[]>> data;

    public Group2ListByMonthHandler(Map<TableDO, List<Object[]>> data) {
        this.data = data;
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> doHandler(AbstractReportContext context) {
        Integer monthRange = ((DeptReimAnalysisContext)context).getMonthrange();
        HashMap result = Maps.newHashMapWithExpectedSize((int)monthRange);
        for (Map.Entry<TableDO, List<Object[]>> entry : this.data.entrySet()) {
            List<Object[]> rows = entry.getValue();
            TableDO tableDO = entry.getKey();
            Integer bizDateIndex = tableDO.getFieldIndex(FieldDO.dateField.getAlias());
            for (Object[] row : rows) {
                List list;
                String dateFormat = this.getDateStr((Date)row[bizDateIndex]);
                Map map = (Map)result.get(dateFormat);
                if (map == null) {
                    map = Maps.newHashMapWithExpectedSize((int)4);
                    result.put(dateFormat, map);
                }
                if ((list = (List)map.get(tableDO.getBillType())) == null) {
                    list = Lists.newArrayListWithCapacity((int)16);
                    map.put(tableDO.getBillType(), list);
                }
                list.add(row);
            }
        }
        return result;
    }

    private String getDateStr(Date date, int preMonth) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        if (preMonth != 0) {
            instance.add(2, 0 - preMonth);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(instance.getTime());
    }

    private String getDateStr(Date date) {
        return this.getDateStr(date, 0);
    }
}

