/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.dept;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptReimAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class SumAmountByMonthDataHandler
implements IMBReportDataHandler<JSONObject> {
    private Map<TableDO, List<Object[]>> data;
    private static String[] monthStr = new String[]{SumAmountByMonthDataHandler.getMonth1(), SumAmountByMonthDataHandler.getMonth2(), SumAmountByMonthDataHandler.getMonth3(), SumAmountByMonthDataHandler.getMonth4(), SumAmountByMonthDataHandler.getMonth5(), SumAmountByMonthDataHandler.getMonth6(), SumAmountByMonthDataHandler.getMonth7(), SumAmountByMonthDataHandler.getMonth8(), SumAmountByMonthDataHandler.getMonth9(), SumAmountByMonthDataHandler.getMonth10(), SumAmountByMonthDataHandler.getMonth11(), SumAmountByMonthDataHandler.getMonth12()};

    public SumAmountByMonthDataHandler(Map<TableDO, List<Object[]>> data) {
        this.data = data;
    }

    @Override
    public JSONObject doHandler(AbstractReportContext context) {
        IFormView view = context.getView();
        IDataModel model = view.getModel();
        Object value = model.getValue("bizdate");
        int endMonth = this.getMonth((Date)value);
        Integer monthRange = ((DeptReimAnalysisContext)context).getMonthrange();
        JSONObject json = new JSONObject();
        json.put("xAxis", (Object)this.createMonthXAxis(endMonth, monthRange));
        TreeMap groupMap = Maps.newTreeMap((v1, v2) -> v1 - v2);
        HashSet applierSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet billSet = Sets.newHashSetWithExpectedSize((int)32);
        for (Map.Entry<TableDO, List<Object[]>> entry : this.data.entrySet()) {
            List<Object[]> rows = entry.getValue();
            TableDO tableDO = entry.getKey();
            List<FieldDO> sumFields = tableDO.getSumField();
            FieldDO sumField = sumFields.get(0);
            Integer bizDateIndex = tableDO.getFieldIndex(FieldDO.dateField.getAlias());
            for (Object[] row : rows) {
                Object billno;
                Object amount;
                BigDecimal decimal;
                int month = this.getMonth((Date)row[bizDateIndex]);
                Map map = (Map)groupMap.get(month);
                if (map == null) {
                    map = Maps.newHashMapWithExpectedSize((int)sumFields.size());
                    groupMap.put(month, map);
                }
                if ((decimal = (BigDecimal)map.get(sumField.getAlias())) == null) {
                    decimal = BigDecimal.ZERO;
                }
                decimal = decimal.add((amount = row[tableDO.getFieldIndex(sumField.getAlias())]) == null ? BigDecimal.ZERO : (BigDecimal)amount);
                map.put(sumField.getAlias(), decimal);
                Object applier = row[tableDO.getFieldIndex(FieldDO.applierField.getAlias())];
                if (applier != null) {
                    applierSet.add(Long.valueOf(applier.toString()));
                }
                if ((billno = row[tableDO.getFieldIndex(FieldDO.billnoField.getAlias())]) == null) continue;
                billSet.add((String)billno);
            }
        }
        BigDecimal[] createYAxis = this.createYAxis(groupMap, monthRange, endMonth);
        int applierCount = applierSet.size();
        BigDecimal totalAmt = this.getTotal(createYAxis);
        json.put("yAxis", (Object)createYAxis);
        json.put("appliercount", (Object)applierCount);
        json.put("billcount", (Object)billSet.size());
        json.put("totalamt", (Object)totalAmt);
        json.put("adv", (Object)(applierCount == 0 ? BigDecimal.ZERO : totalAmt.divide(new BigDecimal(applierCount), 2, RoundingMode.HALF_UP)));
        return json;
    }

    private BigDecimal getTotal(BigDecimal[] createYAxis) {
        BigDecimal totalamt = BigDecimal.ZERO;
        for (BigDecimal amount : createYAxis) {
            totalamt = totalamt.add(amount);
        }
        return totalamt;
    }

    private BigDecimal[] createYAxis(Map<Integer, Map<String, BigDecimal>> groupMap, int monthRange, int endMonth) {
        BigDecimal[] values = new BigDecimal[monthRange];
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (int i = 0; i < monthRange; ++i) {
            Map<String, BigDecimal> map = groupMap.get((endMonth - monthRange + 12 + 1 + i) % 12);
            values[i] = map != null && !map.isEmpty() ? map.entrySet().iterator().next().getValue() : BigDecimal.ZERO;
            totalAmt = totalAmt.add(values[i]);
        }
        return values;
    }

    private String[] createMonthXAxis(int month, int monthRange) {
        String[] xAxis = new String[monthRange];
        ++month;
        for (int i = 0; i < monthRange; ++i) {
            xAxis[i] = monthStr[(month + i - monthRange + 12) % 12];
        }
        return xAxis;
    }

    private int getMonth(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        return instance.get(2);
    }

    private static String getMonth1() {
        return ResManager.loadKDString((String)"1\u6708", (String)"SumAmountByMonthDataHandler_0", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth2() {
        return ResManager.loadKDString((String)"2\u6708", (String)"SumAmountByMonthDataHandler_1", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth3() {
        return ResManager.loadKDString((String)"3\u6708", (String)"SumAmountByMonthDataHandler_2", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth4() {
        return ResManager.loadKDString((String)"4\u6708", (String)"SumAmountByMonthDataHandler_3", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth5() {
        return ResManager.loadKDString((String)"5\u6708", (String)"SumAmountByMonthDataHandler_4", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth6() {
        return ResManager.loadKDString((String)"6\u6708", (String)"SumAmountByMonthDataHandler_5", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth7() {
        return ResManager.loadKDString((String)"7\u6708", (String)"SumAmountByMonthDataHandler_6", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth8() {
        return ResManager.loadKDString((String)"8\u6708", (String)"SumAmountByMonthDataHandler_7", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth9() {
        return ResManager.loadKDString((String)"9\u6708", (String)"SumAmountByMonthDataHandler_8", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth10() {
        return ResManager.loadKDString((String)"10\u6708", (String)"SumAmountByMonthDataHandler_9", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth11() {
        return ResManager.loadKDString((String)"11\u6708", (String)"SumAmountByMonthDataHandler_10", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static String getMonth12() {
        return ResManager.loadKDString((String)"12\u6708", (String)"SumAmountByMonthDataHandler_11", (String)"fi-er-business", (Object[])new Object[0]);
    }
}

