/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.loan;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptLoanAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class Group2ListHandler
implements IMBReportDataHandler<Map<String, List<Map<String, Object>>>> {
    private Map<TableDO, List<Object[]>> data;

    public Group2ListHandler(Map<TableDO, List<Object[]>> data) {
        this.data = data;
    }

    @Override
    public Map<String, List<Map<String, Object>>> doHandler(AbstractReportContext context) {
        Integer comingDays = ((DeptLoanAnalysisContext)context).getComingDays();
        Date comingDate = this.getComingDate(comingDays);
        Date now = new Date();
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        ArrayList deadList = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList comingList = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList notdayList = Lists.newArrayListWithExpectedSize((int)32);
        result.put("dead", deadList);
        result.put("coming", comingList);
        result.put("notday", notdayList);
        for (Map.Entry<TableDO, List<Object[]>> entrySet : this.data.entrySet()) {
            TableDO tableDO = entrySet.getKey();
            List<Object[]> value = entrySet.getValue();
            Integer repayIndex = tableDO.getFieldIndex(FieldDO.repayDateField.getAlias());
            Integer amtIndex = tableDO.getFieldIndex(FieldDO.balanceAmtField.getAlias());
            Integer billnoIndex = tableDO.getFieldIndex(FieldDO.billnoField.getAlias());
            Integer applierIndex = tableDO.getFieldIndex(FieldDO.applierField.getAlias());
            for (Object[] row : value) {
                LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)4);
                map.put(FieldDO.repayDateField.getAlias(), (Date)row[repayIndex]);
                map.put(FieldDO.balanceAmtField.getAlias(), this.format((BigDecimal)row[amtIndex]));
                map.put(FieldDO.billnoField.getAlias(), row[billnoIndex]);
                map.put(FieldDO.applierField.getAlias(), row[applierIndex]);
                map.put("avatar", this.getAvatar((Long)row[applierIndex]));
                Date repayDate = (Date)row[repayIndex];
                if (repayDate == null) {
                    repayDate = now;
                }
                if (now.getTime() >= repayDate.getTime()) {
                    deadList.add(map);
                    continue;
                }
                if (comingDate.getTime() > repayDate.getTime()) {
                    comingList.add(map);
                    continue;
                }
                notdayList.add(map);
            }
        }
        return result;
    }

    private String getAvatar(Long applierId) {
        return ErCommonUtils.getUserImageFullPath(applierId);
    }

    private String format(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, RoundingMode.HALF_EVEN).toPlainString();
    }

    private Date getComingDate(Integer comingDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, comingDays);
        return calendar.getTime();
    }
}

