/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.datahandler.analysis.loan;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.context.DeptLoanAnalysisContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.datahandler.IMBReportDataHandler;

public class SumAmountByDeadDateHandler
implements IMBReportDataHandler<Map<String, Object>> {
    private Map<TableDO, List<Object[]>> data;

    public SumAmountByDeadDateHandler(Map<TableDO, List<Object[]>> data) {
        this.data = data;
    }

    @Override
    public Map<String, Object> doHandler(AbstractReportContext context) {
        Integer comingDays = ((DeptLoanAnalysisContext)context).getComingDays();
        Date comingDate = this.getComingDate(comingDays);
        Date now = new Date();
        BigDecimal comingAmt = BigDecimal.ZERO;
        BigDecimal deadAmt = BigDecimal.ZERO;
        BigDecimal notdayAmt = BigDecimal.ZERO;
        for (Map.Entry<TableDO, List<Object[]>> entrySet : this.data.entrySet()) {
            TableDO tableDO = entrySet.getKey();
            List<Object[]> value = entrySet.getValue();
            Integer repayIndex = tableDO.getFieldIndex(FieldDO.repayDateField.getAlias());
            Integer amtIndex = tableDO.getFieldIndex(FieldDO.balanceAmtField.getAlias());
            for (Object[] row : value) {
                Date repayDate = (Date)row[repayIndex];
                if (repayDate == null) {
                    repayDate = now;
                }
                BigDecimal amt = (BigDecimal)row[amtIndex];
                if (now.getTime() >= repayDate.getTime()) {
                    deadAmt = deadAmt.add(amt);
                    continue;
                }
                if (comingDate.getTime() > repayDate.getTime()) {
                    comingAmt = comingAmt.add(amt);
                    continue;
                }
                notdayAmt = notdayAmt.add(amt);
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        result.put("comingAmt", comingAmt.setScale(2, RoundingMode.HALF_EVEN));
        result.put("deadAmt", deadAmt.setScale(2, RoundingMode.HALF_EVEN));
        result.put("notdayAmt", notdayAmt.setScale(2, RoundingMode.HALF_EVEN));
        result.put("totalAmt", comingAmt.add(deadAmt).add(notdayAmt).setScale(2, RoundingMode.HALF_EVEN));
        return result;
    }

    private Date getComingDate(Integer comingDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, comingDays);
        return calendar.getTime();
    }
}

