/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.query.IRptQueryExecute;

public class CommonQueryExecuteProxy
implements IRptQueryExecute {
    private static Log logger = LogFactory.getLog(CommonQueryExecuteProxy.class);
    private IRptQueryExecute rptQueryExecute = null;

    public CommonQueryExecuteProxy(IRptQueryExecute rptQueryExecute) {
        this.rptQueryExecute = rptQueryExecute;
    }

    @Override
    public Map<TableDO, List<Object[]>> doExecute() {
        Map<TableDO, List<Object[]>> resultMap = this.rptQueryExecute.doExecute();
        this.printLog(resultMap);
        return resultMap;
    }

    @Override
    public AbstractReportContext getContext() {
        return this.rptQueryExecute.getContext();
    }

    private void printLog(Map<TableDO, List<Object[]>> resultMap) {
        AbstractReportContext context = this.getContext();
        List<TableDO> tables = context.getTables();
        StringBuilder sb = new StringBuilder();
        for (TableDO table : tables) {
            List<QFilter> qFilters = table.getQFilters();
            List<Object[]> list = resultMap.get(table);
            List<FieldDO> fields = table.getFields();
            sb.append("table:[").append(table.getTableName()).append("],filters:[").append(qFilters.toString()).append(System.lineSeparator());
            for (FieldDO field : fields) {
                sb.append(field.getAlias()).append("\t\t");
            }
            sb.append(System.lineSeparator());
            Iterator<FieldDO> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] row;
                for (Object val : row = (Object[])iterator.next()) {
                    sb.append(val).append("\t\t");
                }
                sb.append(System.lineSeparator());
            }
            sb.append("=============================").append(System.lineSeparator());
        }
        this.writeLog(sb.toString());
    }

    private void writeLog(String log) {
        int endIndex;
        int maxlength = 5000;
        int startIndex = 0;
        int n = endIndex = log.length() >= maxlength ? maxlength : log.length();
        while (endIndex < log.length()) {
            logger.info(log.substring(startIndex, endIndex));
            startIndex = endIndex;
            endIndex = endIndex + maxlength > log.length() ? log.length() : endIndex + maxlength;
        }
    }
}

