/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.StringUtils;

@KSObject
public class CheckingBillServiceHelper {
    private static Log logger = LogFactory.getLog(CheckingBillServiceHelper.class);

    public static CheckDateRange getCheckDateRange(Date checkDate) {
        CheckDateRange checkDateRange = new CheckDateRange();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(checkDate);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        checkDateRange.setStartDate(calendar.getTime());
        calendar.add(2, 1);
        calendar.add(13, -1);
        Date endDate = calendar.getTime();
        checkDateRange.setEndDate(endDate);
        return checkDateRange;
    }

    public static int checkExistUnCheckingRecordWithoutException(Map<String, Object> paramMap) {
        boolean existUnchecking;
        Date happenDateStart = (Date)paramMap.get("checkdate");
        Date limitDate = (Date)paramMap.get("enddate");
        Tuple<Date, Date> checkDateRange = CommonServiceHelper.getDateRange(happenDateStart);
        Date startDate = (Date)checkDateRange.item1;
        Tuple<Date, Date> endDateRange = CommonServiceHelper.getDateRange(limitDate);
        Date endDate = (Date)endDateRange.item2;
        QFilter existUncheckingFilter = new QFilter("isbalance", "=", (Object)"2").or(new QFilter("billstatus", "=", (Object)"A"));
        List<Long> permOrgs = CheckingBillServiceHelper.getPermOrgs((DynamicObjectCollection)paramMap.get("company"));
        existUncheckingFilter = existUncheckingFilter.and(new QFilter("company.id", "in", permOrgs));
        QFilter otherServerFilter = new QFilter("happenddate", ">=", (Object)startDate).and(new QFilter("happenddate", "<=", (Object)endDate));
        existUncheckingFilter = existUncheckingFilter.and(otherServerFilter);
        String server = (String)paramMap.get("server");
        if (StringUtils.isNotBlank((String)server) && !"ALL".equalsIgnoreCase(server)) {
            existUncheckingFilter.and(new QFilter("server", "=", (Object)server));
        }
        if (existUnchecking = QueryServiceHelper.exists((String)"er_allcheckingbill", (QFilter[])new QFilter[]{existUncheckingFilter})) {
            return 1;
        }
        return 0;
    }

    public static Date getNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    @KSMethod
    public static void showOperationResult(IFormView view, OperationResult operationResult) {
        view.showOperationResult(operationResult);
    }

    public static int createCheckingPayBill(Map<String, Object> paramMap) {
        int resultCode = 1;
        resultCode = CheckingBillServiceHelper.checkExistUnCheckingRecordWithoutException(paramMap);
        if (resultCode == 1) {
            return 0;
        }
        resultCode = 1;
        IErDao allCheckingBillDao = ErDaoFactory.getInstance("er_allcheckingbill");
        IErDao checkingPayBillDao = ErDaoFactory.getInstance("er_checkingpaybill");
        Map<String, Set<Long>> queryCompany = CheckingBillServiceHelper.checkIfExist(allCheckingBillDao, checkingPayBillDao, paramMap);
        List<QFilter> filterList = CheckingBillServiceHelper.createQueryFilters(paramMap);
        filterList.add(new QFilter("producttype", "!=", (Object)"2").and(new QFilter("isbalance", "!=", (Object)"3")));
        String queryServer = (String)paramMap.get("server");
        if (StringUtils.isNotBlank((String)queryServer) && !"ALL".equalsIgnoreCase(queryServer)) {
            filterList.add(new QFilter("server", "=", (Object)queryServer));
        }
        QFilter[] allOrderFilters = filterList.toArray(new QFilter[filterList.size()]);
        List<Long> permOrgs = CheckingBillServiceHelper.getPermOrgs((DynamicObjectCollection)paramMap.get("company"));
        try {
            DynamicObject[] allOrderBillInfos;
            HashMap<Object, Long> map = new HashMap<Object, Long>();
            ArrayList<DynamicObject> allOrderBillList = new ArrayList<DynamicObject>();
            String slectFields = "id,server,company,operationtype,happenddate,totalamount,oabillnum,currency.id,checkingformid,paybillnum,payamount,checkingpayid,checkingid,ordernum,totaltax,allorderbase.servicefee";
            DynamicObject[] allCheckOrderBillInfos = allCheckingBillDao.query(slectFields, allOrderFilters);
            HashSet<String> ids = new HashSet<String>(allCheckOrderBillInfos.length);
            for (DynamicObject dyo : allCheckOrderBillInfos) {
                ids.add((String)dyo.get("ordernum"));
            }
            QFilter excludeExistFilterOrg = null;
            for (Map.Entry<String, Set<Long>> serverCompanyEntry : queryCompany.entrySet()) {
                DynamicObject[] companyIds = serverCompanyEntry.getValue();
                if (excludeExistFilterOrg == null) {
                    excludeExistFilterOrg = new QFilter("server", "=", (Object)serverCompanyEntry.getKey()).and(new QFilter("company.id", "not in", companyIds));
                    continue;
                }
                excludeExistFilterOrg = excludeExistFilterOrg.or(new QFilter("server", "=", (Object)serverCompanyEntry.getKey()).and(new QFilter("company.id", "not in", companyIds)));
            }
            QFilter excludeExistFilter = new QFilter("ordernum", "in", ids).and(new QFilter("company.id", "in", permOrgs)).and(excludeExistFilterOrg);
            for (DynamicObject orderDyo : allOrderBillInfos = ErDaoFactory.getInstance("er_allorderbill").query("ordernum,company.id", excludeExistFilter)) {
                map.put(orderDyo.get("ordernum"), (Long)orderDyo.get("company.id"));
            }
            for (DynamicObject checkOrderDyo : allCheckOrderBillInfos) {
                Long companyId = (Long)map.get(checkOrderDyo.get("ordernum"));
                if (companyId == null || companyId == 0L) continue;
                checkOrderDyo.set("company", map.get(checkOrderDyo.get("ordernum")));
                allOrderBillList.add(checkOrderDyo);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM");
            Date checkDate = (Date)paramMap.get("checkdate");
            Date endDate = (Date)paramMap.get("enddate");
            Map<String, List<DynamicObject>> allOrderBillListMap = allOrderBillList.stream().collect(Collectors.groupingBy(d -> d.getString("company") + "_" + d.getString("server") + "_" + d.getString("operationtype")));
            Long curApplier = Long.valueOf(String.valueOf(paramMap.get("curApplier")));
            Map<String, Object> userMap = CommonServiceHelper.getUserMap(curApplier);
            Long applierdept = ErCommonUtils.getPk(userMap.get("org"));
            Long appliercompany = CommonServiceHelper.getCompanyIdByUserId(curApplier);
            ArrayList checkingPaybillList = new ArrayList();
            ArrayList allOrderbillReverseList = new ArrayList();
            ArrayList checkOrders = new ArrayList(10);
            ORM orm = ORM.create();
            allOrderBillListMap.forEach((keyInfo, allCheckingbillList) -> {
                String[] data = keyInfo.split("_");
                String period = sdf.format(checkDate);
                String company = data[0];
                String server = data[1];
                String operationtype = data[2];
                DynamicObject checkingPayBill = checkingPayBillDao.getEmptyDynamicObject();
                long checkingPayId = orm.genLongId("er_invoiceorderbill");
                checkingPayBill.set("id", (Object)checkingPayId);
                checkingPayBill.set("period", (Object)period);
                checkingPayBill.set("company", (Object)Long.parseLong(company));
                checkingPayBill.set("server", (Object)server.trim());
                checkingPayBill.set("operationtype", (Object)operationtype.trim());
                checkingPayBill.set("enddate", (Object)sdf.format(endDate));
                double checkingPayTotalAmount = allCheckingbillList.stream().mapToDouble(order -> {
                    order.set("checkingpayid", (Object)checkingPayId);
                    return order.getBigDecimal("totalamount").doubleValue();
                }).sum();
                checkingPayBill.set("totalamount_head", (Object)checkingPayTotalAmount);
                Long currency = ((DynamicObject)allCheckingbillList.get(0)).getLong("currency.id");
                Date happenddate = ((DynamicObject)allCheckingbillList.get(0)).getDate("happenddate");
                String checkingformid = ((DynamicObject)allCheckingbillList.get(0)).getString("checkingformid");
                checkingPayBill.set("currency", (Object)currency);
                checkingPayBill.set("happenddate", (Object)happenddate);
                checkingPayBill.set("orderformid", (Object)checkingformid);
                checkingPayBill.set("createtime", (Object)new Date());
                String billno = CodeRuleServiceHelper.getNumber((String)"er_invoiceorderbill", (DynamicObject)checkingPayBill, (String)company);
                checkingPayBill.set("billno", (Object)billno);
                checkingPayBill.set("billstatus", (Object)BillStatus.A);
                checkingPayBill.set("applier", (Object)curApplier);
                checkingPayBill.set("appliercompany", (Object)appliercompany);
                checkingPayBill.set("applierdept", (Object)applierdept);
                checkingPayBill.set("bizdate", (Object)new Date());
                checkingPayBill.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                checkingPaybillList.add(checkingPayBill);
                allOrderbillReverseList.addAll(allCheckingbillList);
                for (DynamicObject dynamicObject : allCheckingbillList) {
                    String checkingid = dynamicObject.get("checkingid").toString();
                    ArrayList<Object> list = new ArrayList<Object>(3);
                    list.add(checkingformid);
                    list.add(Long.parseLong(checkingid));
                    list.add(checkingPayId);
                    checkOrders.add(list);
                }
            });
            if (checkingPaybillList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])checkingPaybillList.toArray(new DynamicObject[checkingPaybillList.size()]));
            }
            if (allOrderbillReverseList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])allOrderbillReverseList.toArray(new DynamicObject[allOrderbillReverseList.size()]));
            }
            Map<Long, String> idBillMap = checkingPaybillList.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("billno"), (o, n) -> n));
            ArrayList<DynamicObject> checkingOrder = new ArrayList<DynamicObject>(10);
            for (List l : checkOrders) {
                String type = (String)l.get(0);
                Long id = (Long)l.get(1);
                Long payId = (Long)l.get(2);
                String payCode = idBillMap.get(payId);
                DynamicObject d2 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)type));
                d2.set("id", (Object)id);
                d2.set("paybillid", (Object)payId);
                d2.set("paybillnum", (Object)payCode);
                checkingOrder.add(d2);
            }
            if (checkingOrder.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])checkingOrder.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e2) {
            resultCode = 2;
            logger.error("\u751f\u6210\u6708\u7ed3\u4ed8\u6b3e\u5355\u5931\u8d25\uff1a", (Throwable)e2);
        }
        return resultCode;
    }

    private static List<Long> getPermOrgs(DynamicObjectCollection companyList) {
        return companyList.stream().map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
    }

    private static Map<String, Set<Long>> checkIfExist(IErDao allOrderBillDao, IErDao checkingPayBillDao, Map<String, Object> paramMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Date happenDateStart = (Date)paramMap.get("checkdate");
        Date endDate = (Date)paramMap.get("enddate");
        String queryServer = (String)paramMap.get("server");
        List<Long> permOrgs = CheckingBillServiceHelper.getPermOrgs((DynamicObjectCollection)paramMap.get("company"));
        if (StringUtils.isNotBlank((String)queryServer) && !"ALL".equalsIgnoreCase(queryServer)) {
            filterList.add(new QFilter("server", "=", (Object)queryServer));
        }
        Tuple<Date, Date> checkDateRange = CommonServiceHelper.getDateRange(happenDateStart);
        Tuple<Date, Date> endDateRange = CommonServiceHelper.getDateRange(endDate);
        filterList.add(new QFilter("happenddate", ">=", checkDateRange.item1));
        filterList.add(new QFilter("happenddate", "<=", endDateRange.item2));
        filterList.add(new QFilter("company", "in", permOrgs));
        QFilter[] checkingPayFilters = filterList.toArray(new QFilter[filterList.size()]);
        HashSet existOrgs = new HashSet();
        HashMap<String, Set<Long>> companyMap = new HashMap<String, Set<Long>>();
        DynamicObject[] checkPayBills = BusinessDataServiceHelper.load((String)"er_checkingpaybill", (String)"id,server,company", (QFilter[])checkingPayFilters);
        List<DynamicObject> checkPayBillList = Arrays.asList(checkPayBills);
        Set servers = checkPayBillList.stream().map(d -> d.getString("server")).collect(Collectors.toSet());
        for (String server : servers) {
            checkPayBillList.forEach(dynamicObject -> {
                if (server.equals(dynamicObject.get("server").toString())) {
                    Long companyId = dynamicObject.getLong("company.id");
                    if (companyId != null) {
                        existOrgs.add(companyId);
                    }
                    companyMap.put(server, existOrgs);
                    logger.info("\u6708\u7ed3\u4ed8\u6b3e\u5df2\u5b58\u5728\u7684\u670d\u52a1\u5546\uff1a" + server + ",\u6708\u7ed3\u4ed8\u6b3e\u5df2\u5b58\u5728\u7684\u516c\u53f8\uff1a" + existOrgs);
                }
            });
        }
        return companyMap;
    }

    private static List<QFilter> createQueryFilters(Map<String, Object> paramMap) {
        Date happenDateStart = (Date)paramMap.get("checkdate");
        Date endDate = (Date)paramMap.get("enddate");
        Tuple<Date, Date> checkDateRange = CommonServiceHelper.getDateRange(happenDateStart);
        Tuple<Date, Date> endDateRange = CommonServiceHelper.getDateRange(endDate);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("happenddate", ">=", checkDateRange.item1));
        qFilters.add(new QFilter("happenddate", "<=", endDateRange.item2));
        return qFilters;
    }

    public static void updatCheckingHeaderBillStatus(DynamicObject dataEntity) {
        QFilter qB;
        String checkingbillnum = dataEntity.getString("checkingbillnum");
        QFilter qA = new QFilter("checkingbillnum", "=", (Object)checkingbillnum);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"er_allcheckingbill", (String)"billstatus", (QFilter[])new QFilter[]{qA, qB = new QFilter("billstatus", "!=", (Object)"C")});
        if (null == dynamicObjectCollection || dynamicObjectCollection.isEmpty()) {
            DynamicObject checkingHeaderBill = BusinessDataServiceHelper.loadSingle((String)"er_checkingbill", (String)"billstatusname", (QFilter[])new QFilter[]{new QFilter("billnum", "in", (Object)String.valueOf(checkingbillnum))});
            checkingHeaderBill.set("billstatusname", (Object)"2");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkingHeaderBill});
        }
    }

    public static void updatCheckingHeaderBillStatusList(Set<String> checkingbillnumList) {
        DynamicObject[] checkingHeaderBills;
        WithDistinctable withDistinctable;
        QFilter qA = new QFilter("checkingbillnum", "in", checkingbillnumList);
        QFilter qB = new QFilter("billstatus", "!=", (Object)"C");
        ORM orm = ORM.create();
        DataSet dataSet = orm.queryDataSet("updatCheckingHeaderBillStatusList", "er_allcheckingbill", "ordernum,checkingbillnum", new QFilter[]{qA, qB}, "", -1, (Distinctable)(withDistinctable = WithDistinctable.get()));
        if (null != dataSet && !dataSet.isEmpty()) {
            DynamicObject[] checkingHeaderBills2;
            Iterator iterator = dataSet.iterator();
            HashSet<String> nocheckingbillnumList = new HashSet<String>();
            while (iterator.hasNext()) {
                Row next = (Row)iterator.next();
                String noCheckingbillnum = next.getString("checkingbillnum");
                nocheckingbillnumList.add(noCheckingbillnum);
                checkingbillnumList.remove(noCheckingbillnum);
            }
            if (!nocheckingbillnumList.isEmpty() && null != (checkingHeaderBills2 = BusinessDataServiceHelper.load((String)"er_checkingbill", (String)"billstatusname", (QFilter[])new QFilter[]{new QFilter("billnum", "in", nocheckingbillnumList)}))) {
                for (DynamicObject checkingHeaderBill : checkingHeaderBills2) {
                    checkingHeaderBill.set("billstatusname", (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])checkingHeaderBills2);
            }
        }
        if (null != (checkingHeaderBills = BusinessDataServiceHelper.load((String)"er_checkingbill", (String)"billstatusname", (QFilter[])new QFilter[]{new QFilter("billnum", "in", checkingbillnumList)}))) {
            for (DynamicObject checkingHeaderBill : checkingHeaderBills) {
                checkingHeaderBill.set("billstatusname", (Object)"2");
            }
            SaveServiceHelper.save((DynamicObject[])checkingHeaderBills);
        }
    }

    public static class CheckDateRange {
        private Date startDate;
        private Date endDate;

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }
    }
}

