/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.cache.TraceCache;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.servicehelper.TripExpenseItemServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.servicehelper.operation.ErOperationServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.EntrustReimburseUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.sysparam.ApplierSelectRangeEnum;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;

@KSObject
public class CoreBaseBillServiceHelper {
    private static Log logger = LogFactory.getLog(CoreBaseBillServiceHelper.class);
    private static Long planeExpense = 100009L;
    private static Long trainExpense = 100010L;
    private static Long busExpense = 100011L;
    private static Long othersExpense = 100013L;
    private static Long shipExpense = 100015L;
    public static final Map<String, String> attributeRelate;
    public static final Map<String, String> VEHICLERELATE;
    private static ThreadLocal<TraceCache<String, Long>> accountOrgTL;

    public static Map<String, Object> createNewData(Long applierId) {
        return CoreBaseBillServiceHelper.createNewData(applierId, null);
    }

    public static Map<String, Object> createNewData(Long applierId, Long deptIdDefalut) {
        HashMap<String, Object> billMap = new HashMap<String, Object>();
        if (applierId == null) {
            return billMap;
        }
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(applierId, deptIdDefalut, false);
        if (userMap.isEmpty()) {
            return billMap;
        }
        DynamicObject dept = (DynamicObject)userMap.get("org");
        billMap.put("applier", applierId);
        billMap.put("org", dept);
        billMap.put("costdept", dept);
        Long deptId = null;
        Long companyId = null;
        if (dept != null) {
            deptId = (Long)dept.getPkValue();
            companyId = CoreBaseBillServiceHelper.initCompanyByDept(deptId);
            billMap.put("company", companyId);
            billMap.put("costcompany", CoreBaseBillServiceHelper.getAccountOrgId(deptId));
        }
        billMap.put("tel", userMap.get("tel"));
        billMap.put("applierpositionstr", userMap.get("applierpositionstr"));
        Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(companyId, billMap.get("costcompany"));
        if (currencyId != null) {
            billMap.put("currency", currencyId);
        }
        billMap.put("billstatus", "A");
        billMap.put("creator", CommonServiceHelper.getCurrentUserID());
        return billMap;
    }

    public static Long initCompanyByDept(Long deptId) {
        Long companyId2;
        Long companyId = 0L;
        try {
            String fromOrgType = "01";
            String toOrgType = "01";
            Long billTypeId = 0L;
            companyId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)deptId, (Long)billTypeId);
        }
        catch (Exception e) {
            logger.error("initCompanyByDept:" + ThrowableHelper.toString((Exception)e));
        }
        logger.info("initCompanyByDept-companyId-1:" + companyId);
        if ((companyId == 0L || companyId == null) && (companyId2 = (Long)ActionLocalCache.get().get("kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp.ORG_COMPANY", deptId, () -> {
            logger.info("initCompanyByDept-deptId:" + deptId);
            Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            Long _companyId = null;
            if (company != null) {
                _companyId = (Long)company.get("id");
            }
            logger.info("initCompanyByDept-companyId-2:" + _companyId);
            return _companyId;
        })) != null) {
            companyId = companyId2;
        }
        return companyId;
    }

    public static DynamicObject getFundingOrg(DynamicObject company) {
        boolean isAssetItself = OrgUnitServiceHelper.checkOrgFunction((Long)ErCommonUtils.getPk(company), (String)"08");
        if (isAssetItself) {
            logger.info("\u652f\u4ed8\u516c\u53f8\u4e3a\u81ea\u5df1\uff1a" + ErCommonUtils.getPk(company));
            return company;
        }
        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)ErCommonUtils.getPk(company), (boolean)false);
        if (allToOrg.size() == 1) {
            DynamicObject paycompany = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", allToOrg.get(0))});
            logger.info("\u652f\u4ed8\u516c\u53f8\u4e3a\u59d4\u6258\uff0cid" + ErCommonUtils.getPk(paycompany));
            return paycompany;
        }
        return CoreBaseBillServiceHelper.parentNodeIsFundingOrg(ErCommonUtils.getPk(company));
    }

    private static DynamicObject parentNodeIsFundingOrg(Long company) {
        DynamicObject fundingOrg = null;
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(company));
        if (directSuperiorOrg.size() != 0) {
            Long parent = (Long)directSuperiorOrg.get(company);
            boolean parentIsFundingOrg = OrgUnitServiceHelper.checkOrgFunction((Long)parent, (String)"08");
            fundingOrg = parentIsFundingOrg ? BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parent)}) : CoreBaseBillServiceHelper.parentNodeIsFundingOrg(parent);
        }
        logger.info("\u4e0a\u7ea7\u7ec4\u7ec7id\uff1a" + ErCommonUtils.getPk(fundingOrg));
        return fundingOrg;
    }

    public static void initObjByMap(Object billObj, Map<String, Object> billMap) {
        block4: {
            block3: {
                if (billObj == null || billMap == null) {
                    return;
                }
                if (!(billObj instanceof DynamicObject)) break block3;
                DynamicObject dynamicObject = (DynamicObject)billObj;
                for (Map.Entry<String, Object> entry : billMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    dynamicObject.set(key, ErCommonUtils.getObjectValue(value));
                }
                break block4;
            }
            if (!(billObj instanceof IDataModel)) break block4;
            IDataModel billModel = (IDataModel)billObj;
            for (Map.Entry<String, Object> entry : billMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (billModel.getProperty(key) == null) continue;
                billModel.setValue(key, ErCommonUtils.getObjectValue(value));
            }
        }
    }

    public static void extService(IFormView view, Map<String, Object> billMap) {
        ErExpandServiceFacade.get().invokeInitNewDataMap(view, billMap);
    }

    public static List<DynamicObject> getTripExpenseItems(Long companyId) {
        QFilter filter;
        QFilter queryFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (companyId != null && companyId > 0L && (filter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)companyId)) != null) {
            queryFilter.and(filter);
        }
        return CoreBaseBillServiceHelper.loadTripItems(new QFilter[]{queryFilter});
    }

    public static List<DynamicObject> getDefaultTripExpenseItems(Long companyId) {
        QFilter filter;
        QFilter queryFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (companyId != null && companyId > 0L && (filter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)companyId)) != null) {
            queryFilter.and(filter);
        }
        queryFilter.and(new QFilter("isdefault", "=", (Object)Boolean.TRUE));
        return CoreBaseBillServiceHelper.loadTripItems(new QFilter[]{queryFilter});
    }

    public static List<DynamicObject> loadTripItems(QFilter[] qFilters) {
        String selectPropties = "id,number,name,status,enable,creator,org,comment,modifier,createorg,isdefault,isvactax,attribute,longnumber,expenseitemicon,isinit,ctrltype,taxrate,isoffset";
        DynamicObject[] expenseItems = BusinessDataServiceHelper.load((String)"er_tripexpenseitem", (String)selectPropties, (QFilter[])qFilters, (String)"number asc");
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(expenseItems.length);
        for (DynamicObject expenseItem : expenseItems) {
            resultList.add(expenseItem);
        }
        return resultList;
    }

    public static void addDefaultTripExpenseEntry(IDataModel model, int tripRowIndex) {
        QFilter baseDataFilter;
        DynamicObjectCollection detailedEntrys = ((DynamicObject)((DynamicObjectCollection)model.getValue("tripentry")).get(tripRowIndex)).getDynamicObjectCollection("entryentity");
        ArrayList<String> exsitExpItems = new ArrayList<String>();
        for (DynamicObject entry : detailedEntrys) {
            exsitExpItems.add(entry.getString("expenseitem.attribute"));
        }
        QFilter qA = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qA.and("isdefault", "=", (Object)Boolean.TRUE);
        qA.and("attribute", "not in", exsitExpItems);
        DynamicObject compay = (DynamicObject)model.getValue("company");
        if (compay != null && (baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)compay.getLong("id"))) != null) {
            qA.and(baseDataFilter);
        }
        DynamicObject[] expenseItems = BusinessDataServiceHelper.load((String)"er_tripexpenseitem", (String)"id,attribute,isoffset,taxrate,isvactax,expenseitemicon", (QFilter[])new QFilter[]{qA}, (String)"number asc");
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(expenseItems.length);
        for (DynamicObject expenseItem : expenseItems) {
            resultList.add(expenseItem);
        }
        List<String> sortRef = Arrays.asList("2", "3", "4", "5", "1", "6", "0");
        resultList.sort((u, v) -> sortRef.indexOf(u.getString("attribute")) - sortRef.indexOf(v.getString("attribute")));
        int count = resultList.size();
        if (count > 0) {
            model.setEntryCurrentRowIndex("tripentry", tripRowIndex);
            int[] rowIndexs = model.batchCreateNewEntryRow("entryentity", count);
            Long currencyId = ErCommonUtils.getPk(model.getValue("tripcurrency", tripRowIndex));
            if (currencyId == null) {
                currencyId = ErCommonUtils.getPk(model.getValue("currency"));
            }
            BigDecimal exchangerate = (BigDecimal)model.getValue("tripexchangerate", tripRowIndex);
            String quoteType = model.getProperty("tripquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("tripquotetype")), (Object)"0");
            Object tripDay = model.getValue("tripday", tripRowIndex);
            int i = 0;
            for (int rowIndex : rowIndexs) {
                DynamicObject expenseItem = (DynamicObject)resultList.get(i);
                model.setValue("expenseitem", expenseItem.getPkValue(), rowIndex, tripRowIndex);
                model.setValue("pic", (Object)expenseItem.getString("expenseitemicon"), rowIndex, tripRowIndex);
                model.setValue("entrycurrency", (Object)currencyId, rowIndex, tripRowIndex);
                model.setValue("detailquotetype", (Object)quoteType, rowIndex, tripRowIndex);
                model.setValue("exchangerate", (Object)exchangerate, rowIndex, tripRowIndex);
                model.setValue("daycount", tripDay, rowIndex, tripRowIndex);
                TripReimburseServiceHelper.whenTripItemChanged(model, expenseItem, rowIndex, tripRowIndex);
                ++i;
            }
        }
    }

    @KSMethod
    public static int initDefaultAccountEntry(IDataModel model) {
        Long applierId = ErCommonUtils.getPk(model.getValue("applier"));
        Long userId = CommonServiceHelper.getCurrentUserID();
        applierId = applierId != null ? applierId : userId;
        return CoreBaseBillServiceHelper.initDefaultAccountEntry(model, applierId);
    }

    @KSMethod
    public static int initDefaultAccountEntry(IDataModel model, Long userId) {
        int rowIndex = model.createNewEntryRow("accountentry");
        return CoreBaseBillServiceHelper.initDefaultAccountEntry(model, rowIndex, userId);
    }

    @KSMethod
    public static int initDefaultAccountEntry(IDataModel model, int rowIndex) {
        Long userId = CommonServiceHelper.getCurrentUserID();
        return CoreBaseBillServiceHelper.initDefaultAccountEntry(model, rowIndex, userId);
    }

    @KSMethod
    public static int initDefaultAccountEntry(IDataModel model, int rowIndex, Long userId) {
        DynamicObject defaultAccount = PayeeServiceHelper.getDefaultAccount(userId);
        CoreBaseBillServiceHelper.fillAccountEntry(model, rowIndex, defaultAccount);
        return rowIndex;
    }

    public static void fillAccountEntry(IDataModel model, int rowIndex, DynamicObject defaultAccount) {
        IDataEntityProperty costCompanyProp;
        String settlementtype = null;
        DynamicObject payMode = (DynamicObject)model.getValue("paymode", rowIndex);
        if (payMode == null) {
            payMode = PayeeServiceHelper.getDefaultPayMode();
            if (payMode != null) {
                settlementtype = payMode.getString("settlementtype");
            }
            model.setValue("paymode", (Object)ErCommonUtils.getPk(payMode), rowIndex);
        } else {
            settlementtype = payMode.getString("settlementtype");
        }
        Object payerType = model.getValue("payertype", rowIndex);
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)model.getValue("company")).getPkValue());
        }
        if (defaultAccount != null && PayerTypeEnum.PAYER.getType().equals(payerType)) {
            DynamicObject currency;
            Boolean isCurrency;
            DynamicObject payerCurrency = (DynamicObject)defaultAccount.get("currency");
            if ("1".equals(isgetaccountcurrency)) {
                Long tragCurrency;
                Long l = tragCurrency = payerCurrency == null ? null : (Long)payerCurrency.getPkValue();
                if (tragCurrency != null) {
                    Map<String, Object> exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(tragCurrency, model);
                    String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                    BigDecimal accchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ZERO);
                    model.setValue("accexchangerate", (Object)accchangeRate, rowIndex);
                    model.setValue("accquotetype", (Object)quoteType, rowIndex);
                    model.setValue("accountcurrency", (Object)tragCurrency, rowIndex);
                } else {
                    model.setValue("accountcurrency", (Object)tragCurrency, rowIndex);
                    model.setValue("accexchangerate", (Object)BigDecimal.ZERO, rowIndex);
                    model.setValue("accquotetype", (Object)"0", rowIndex);
                }
            } else {
                model.setValue("accountcurrency", (Object)ErCommonUtils.getPk(model.getValue("currency")), rowIndex);
                model.setValue("accexchangerate", (Object)BigDecimal.ONE, rowIndex);
            }
            model.setValue("payer", defaultAccount.get("id"), rowIndex);
            model.setValue("payername", defaultAccount.get("outpayer"), rowIndex);
            if (settlementtype == null || !"0".equals(settlementtype)) {
                model.setValue("payeraccount", defaultAccount.get("payeraccount"), rowIndex);
                model.setValue("payeraccount02", defaultAccount.get("payeraccount02"), rowIndex);
                model.setValue("payeraccount01", defaultAccount.get("payeraccount01"), rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY(model, "payeraccountname", defaultAccount.get("payeraccountname"), rowIndex);
                model.setValue("payerbank", (Object)ErCommonUtils.getPk(defaultAccount.getDynamicObject("payerbank")), rowIndex);
            }
            if ((isCurrency = (Boolean)model.getValue("iscurrency")).booleanValue() && (currency = defaultAccount.getDynamicObject("CURRENCY")) != null) {
                model.setValue("accountcurrency", currency.getPkValue(), rowIndex);
            }
        }
        if ("1".equals(isgetaccountcurrency)) {
            model.setValue("iscurrency", (Object)Boolean.TRUE);
        }
        if ((ErEntityTypeUtils.isDailyReimburseBill(model.getDataEntityType().getName()) || ErEntityTypeUtils.isTripReimburseBill(model.getDataEntityType().getName())) && (costCompanyProp = model.getProperty("acccostcompany")) != null) {
            model.setValue("acccostcompany", model.getValue("costcompany"), rowIndex);
        }
        PayeeServiceHelper.clearLimitInfo(model);
    }

    @KSMethod
    public static void initSupplierAccountEntry(IDataModel model, IFormView view, ListSelectedRow selectedRow) {
        Long supplierId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject supplierObj = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier");
        DynamicObjectCollection entry_banks = supplierObj.getDynamicObjectCollection("entry_bank");
        DynamicObject accountCurrency = (DynamicObject)model.getValue("currency");
        int rowIndex = model.getEntryCurrentRowIndex("accountentry");
        model.setValue("supplier", (Object)supplierId, rowIndex);
        if (entry_banks != null && entry_banks.size() > 0) {
            HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
            for (DynamicObject entry_bank : entry_banks) {
                long entry_bankId = (Long)entry_bank.getPkValue();
                boolean isdefault_bank = entry_bank.getBoolean("isdefault_bank");
                map.put(entry_bankId, isdefault_bank);
                if (!isdefault_bank) continue;
                DynamicObject bank = entry_bank.getDynamicObject("bank");
                String bankaccount = entry_bank.getString("bankaccount");
                DynamicObject currency = entry_bank.getDynamicObject("currency");
                Map<String, String> ret = PayeeServiceHelper.getAllTypePayerAccount(bankaccount);
                model.setValue("payeraccount", (Object)bankaccount, rowIndex);
                model.setValue("payeraccount01", (Object)ret.get("payeraccount01"), rowIndex);
                model.setValue("payeraccount02", (Object)ret.get("payeraccount02"), rowIndex);
                model.setValue("payerbank", (Object)ErCommonUtils.getPk(bank), rowIndex);
                model.setValue("accountcurrency", (Object)ErCommonUtils.getPk(currency), rowIndex);
            }
            if (!map.values().contains(true)) {
                DynamicObject bank = ((DynamicObject)entry_banks.get(0)).getDynamicObject("bank");
                String bankaccount = ((DynamicObject)entry_banks.get(0)).getString("bankaccount");
                DynamicObject currency = ((DynamicObject)entry_banks.get(0)).getDynamicObject("currency");
                Map<String, String> ret = PayeeServiceHelper.getAllTypePayerAccount(bankaccount);
                model.setValue("payeraccount", (Object)bankaccount, rowIndex);
                model.setValue("payeraccount01", (Object)ret.get("payeraccount01"), rowIndex);
                model.setValue("payeraccount02", (Object)ret.get("payeraccount02"), rowIndex);
                model.setValue("payerbank", (Object)ErCommonUtils.getPk(bank), rowIndex);
                if (currency != null) {
                    model.setValue("accountcurrency", currency.getPkValue(), rowIndex);
                } else {
                    model.setValue("accountcurrency", (Object)ErCommonUtils.getPk(accountCurrency), rowIndex);
                }
            }
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u4f9b\u5e94\u5546\u6536\u6b3e\u4fe1\u606f\u3002", (String)"CoreBaseBillServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]));
            model.setValue("payeraccount", (Object)"", rowIndex);
            model.setValue("payeraccount01", (Object)"", rowIndex);
            model.setValue("payeraccount02", (Object)"", rowIndex);
            model.setValue("payerbank", null, rowIndex);
            model.setValue("accountcurrency", (Object)ErCommonUtils.getPk(accountCurrency), rowIndex);
        }
    }

    public static void setFromStatus(AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        BillShowParameter showParameter = (BillShowParameter)view.getFormShowParameter();
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("billstatus");
        if (property != null && !BillOperationStatus.ADDNEW.equals((Object)showParameter.getBillStatus()) && !BillOperationStatus.VIEW.equals((Object)showParameter.getBillStatus())) {
            String billStatus = (String)model.getValue("billstatus");
            if (ErBillStatusEnum.A.toString().equalsIgnoreCase(billStatus)) {
                ((IBillView)view).setBillStatus(BillOperationStatus.EDIT);
                showParameter.setBillStatus(BillOperationStatus.EDIT);
                view.cacheFormShowParameter();
            } else if (ErBillStatusEnum.B.toString().equals(billStatus)) {
                ((IBillView)view).setBillStatus(BillOperationStatus.SUBMIT);
                showParameter.setBillStatus(BillOperationStatus.SUBMIT);
                view.cacheFormShowParameter();
            } else if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
                showParameter.setBillStatus(BillOperationStatus.AUDIT);
                view.cacheFormShowParameter();
            } else if ("J".equals(billStatus) && ErEntityTypeUtils.isContractBill(view.getEntityId())) {
                ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
                showParameter.setBillStatus(BillOperationStatus.AUDIT);
                view.cacheFormShowParameter();
            }
        }
    }

    public static void setValueVhc(IDataModel model) {
        DynamicObjectCollection entrys = model.getEntryEntity("tripentry");
        block0: for (int index = 0; index < entrys.size(); ++index) {
            DynamicObject entry = (DynamicObject)entrys.get(index);
            String vhStr = entry.getString("vehicles");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vhStr)) {
                return;
            }
            String[] vehicles = vhStr.split(",");
            for (int j = 0; j < vehicles.length; ++j) {
                if (vehicles[j] == null || vehicles[j].trim().length() <= 0) continue;
                model.setValue("vehicle", (Object)vehicles[j], index);
                continue block0;
            }
        }
    }

    public static void refreshVehicleRelateEntry(IDataModel model, String vehicles, int rowIndex) {
        model.setEntryCurrentRowIndex("tripentry", rowIndex);
        DynamicObjectCollection currItemEntry = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(rowIndex)).getDynamicObjectCollection("entryentity");
        Set<Object> newvhcList = Sets.newHashSet();
        if (vehicles != null && vehicles.split(",") != null) {
            newvhcList = Arrays.stream(vehicles.split(",")).filter(vhc -> vhc != null && !vhc.isEmpty()).collect(Collectors.toSet());
        }
        logger.info("\u5dee\u65c5\u660e\u7ec6\uff1a {}\uff0c \u4ea4\u901a\u5de5\u5177\uff1a {}", (Object)currItemEntry.size(), (Object)newvhcList);
        Map<String, Integer> oldItemMap = CoreBaseBillServiceHelper.dataBeforeChange(model, currItemEntry);
        Set<String> oldvhcList = oldItemMap.keySet();
        logger.info("oldItemMap\uff1a {}, {}", (Object)oldItemMap.size(), oldItemMap.keySet());
        HashSet allVhcSet = Sets.newHashSet((Iterable)newvhcList);
        allVhcSet.addAll(oldvhcList);
        ArrayList deleteList = Lists.newArrayList();
        ArrayList addStr = Lists.newArrayList();
        for (String vehicle : allVhcSet) {
            if (!newvhcList.contains(vehicle) && oldvhcList.contains(vehicle)) {
                deleteList.add(oldItemMap.get(vehicle));
            }
            if (!newvhcList.contains(vehicle) || oldvhcList.contains(vehicle)) continue;
            addStr.add(vehicle);
        }
        logger.info(String.format("addStr\uff1a%1$s;deleteList\uff1a%2$s,newvhcList:%3$s", addStr, deleteList, newvhcList));
        CoreBaseBillServiceHelper.filterNotInTripItem(addStr, currItemEntry);
        int startIndex = oldvhcList.size() - deleteList.size() + 1;
        logger.info(String.format("addStr\uff1a%1$s;startIndex\uff1a%2$s", addStr, startIndex));
        CoreBaseBillServiceHelper.mulTripVehicle(model, addStr.stream().map(vhc -> vhc).collect(Collectors.joining(",")), rowIndex, startIndex);
        int count = addStr.size();
        if (count == 0) {
            return;
        }
        int index = startIndex;
        int tripIndex = 1;
        for (DynamicObject item : currItemEntry) {
            if (item.getBoolean("isdefault")) {
                item.set("seq", (Object)tripIndex++);
                continue;
            }
            item.set("seq", (Object)(index++ + count));
        }
        CoreBaseBillServiceHelper.refreshEntryRowSeq(model, false, rowIndex);
        if (!deleteList.isEmpty()) {
            model.deleteEntryRows("entryentity", deleteList.stream().mapToInt(i -> i).toArray());
        }
        DynamicObjectCollection collection = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(rowIndex)).getDynamicObjectCollection("entryentity");
        logger.info("entryentity\uff1a {}", (Object)collection.size());
    }

    @Deprecated
    public static void filterEnableTripItem(List<String> addStr) {
        if (addStr == null || addStr.isEmpty()) {
            return;
        }
        ArrayList filterValue = Lists.newArrayListWithExpectedSize((int)addStr.size());
        Iterator<String> iterator = addStr.iterator();
        while (iterator.hasNext()) {
            String vhc;
            switch (vhc = iterator.next()) {
                case "1": {
                    filterValue.add(planeExpense);
                    break;
                }
                case "2": {
                    filterValue.add(trainExpense);
                    break;
                }
                case "3": {
                    filterValue.add(busExpense);
                    break;
                }
                case "4": {
                    filterValue.add(shipExpense);
                    break;
                }
                case "5": {
                    filterValue.add(othersExpense);
                }
            }
        }
        QFilter queryFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qf = new QFilter("id", "in", (Object)filterValue);
        queryFilter.and(qf);
        List<DynamicObject> list = CoreBaseBillServiceHelper.loadTripItems(new QFilter[]{queryFilter});
        ArrayList newAddStr = Lists.newArrayListWithExpectedSize((int)list.size());
        for (DynamicObject expense : list) {
            long key = (Long)expense.getPkValue();
            String keyNumber = "5";
            if (key == planeExpense) {
                keyNumber = "1";
            } else if (key == trainExpense) {
                keyNumber = "2";
            } else if (key == busExpense) {
                keyNumber = "3";
            } else if (key == shipExpense) {
                keyNumber = "4";
            }
            newAddStr.add(keyNumber);
        }
        addStr.clear();
        addStr.addAll(newAddStr);
    }

    public static void filterNotInTripItem(List<String> addStr, DynamicObjectCollection currItemEntry) {
        Set haveSet = currItemEntry.stream().filter(item -> item.getDynamicObject("expenseitem") != null).map(item -> item.getDynamicObject("expenseitem").getString("attribute")).collect(Collectors.toSet());
        List result = addStr.stream().map(item -> attributeRelate.get(item)).filter(value -> !haveSet.contains(value)).map(item -> VEHICLERELATE.get(item)).collect(Collectors.toList());
        addStr.clear();
        addStr.addAll(result);
    }

    public static Map<String, Integer> dataBeforeChange(IDataModel model, DynamicObjectCollection itemEntry) {
        HashMap oldItemMap = Maps.newHashMap();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return oldItemMap;
        }
        Map<String, Long> allEnableMap = CoreBaseBillServiceHelper.getInitTripExpenseItem(company);
        for (int index = 0; index < itemEntry.size(); ++index) {
            DynamicObject item = (DynamicObject)itemEntry.get(index);
            if (!item.getBoolean("isdefault")) continue;
            String keyNumber = "5";
            DynamicObject expense = item.getDynamicObject("expenseitem");
            if (expense == null) continue;
            long key = (Long)expense.getPkValue();
            boolean isUsed = allEnableMap.containsValue(key);
            if (isUsed) {
                String attribute = expense.getString("attribute");
                keyNumber = VEHICLERELATE.get(attribute);
            }
            oldItemMap.put(keyNumber, index);
        }
        return oldItemMap;
    }

    @Deprecated
    public static Map<String, Integer> dataBeforeChange(DynamicObjectCollection itemEntry) {
        HashMap oldItemMap = Maps.newHashMap();
        for (int index = 0; index < itemEntry.size(); ++index) {
            DynamicObject item = (DynamicObject)itemEntry.get(index);
            if (!item.getBoolean("isdefault")) continue;
            DynamicObject expense = item.getDynamicObject("expenseitem");
            long key = (Long)expense.getPkValue();
            String keyNumber = "5";
            if (key == planeExpense) {
                keyNumber = "1";
            } else if (key == trainExpense) {
                keyNumber = "2";
            } else if (key == busExpense) {
                keyNumber = "3";
            } else if (key == shipExpense) {
                keyNumber = "4";
            }
            oldItemMap.put(keyNumber, index);
        }
        return oldItemMap;
    }

    @Deprecated
    public static void mulTripVehicle(IDataModel model, String vehicles) {
        String[] vhcArr = vehicles.split(",");
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        Map<String, Long> tripExpItemRelateVehicle = CoreBaseBillServiceHelper.getInitTripExpenseItem(company);
        for (String vehicle : vhcArr) {
            Long tripExpItemId;
            if (vehicle == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vehicle) || (tripExpItemId = tripExpItemRelateVehicle.get(attributeRelate.get(vehicle))) == null) continue;
            int index = model.createNewEntryRow("entryentity");
            model.beginInit();
            model.setValue("isdefault", (Object)true, index);
            model.endInit();
            CoreBaseBillServiceHelper.setTripExpenseItem(model, tripExpItemId, index, false);
        }
    }

    public static void mulTripVehicle(IDataModel model, String vehicles, int newTripEntryIndex) {
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        int count = model.getEntryRowCount("tripentry");
        if (count <= 0 || count < newTripEntryIndex) {
            return;
        }
        Map<String, Long> tripExpItemRelateVehicle = CoreBaseBillServiceHelper.getInitTripExpenseItem(company);
        Set vehicleSet = Arrays.asList(vehicles.split(",")).stream().filter(vehicle -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vehicle)).collect(Collectors.toSet());
        model.setEntryCurrentRowIndex("tripentry", newTripEntryIndex);
        for (String vehicle2 : vehicleSet) {
            Long tripExpItemId = tripExpItemRelateVehicle.get(attributeRelate.get(vehicle2));
            if (tripExpItemId == null) continue;
            int index = model.createNewEntryRow("entryentity");
            model.beginInit();
            model.setValue("isdefault", (Object)true, index, newTripEntryIndex);
            model.endInit();
            CoreBaseBillServiceHelper.setTripExpenseItem(model, tripExpItemId, index, newTripEntryIndex, false);
        }
    }

    private static void mulTripVehicle(IDataModel model, String vehicles, int newTripEntryIndex, int newItemIndex) {
        logger.info("vehicles\uff1a {}", (Object)vehicles);
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        int count = model.getEntryRowCount("tripentry");
        if (count <= 0 || count < newTripEntryIndex) {
            return;
        }
        Map<String, Long> tripExpItemRelateVehicle = CoreBaseBillServiceHelper.getInitTripExpenseItem(company);
        Set vehicleSet = Arrays.asList(vehicles.split(",")).stream().filter(vehicle -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vehicle)).collect(Collectors.toSet());
        if ((vehicleSet = vehicleSet.stream().filter(vehicle -> tripExpItemRelateVehicle.get(attributeRelate.get(vehicle)) != null).collect(Collectors.toSet())).isEmpty()) {
            return;
        }
        model.setEntryCurrentRowIndex("tripentry", newTripEntryIndex);
        EntryProp entryProp = (EntryProp)model.getProperty("entryentity");
        DynamicObjectCollection newInsertObjectCol = new DynamicObjectCollection();
        for (int i = 0; i < vehicleSet.size(); ++i) {
            DynamicObject newInsertObj = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
            newInsertObjectCol.add((Object)newInsertObj);
        }
        int[] newIndex = model.batchCreateNewEntryRow("entryentity", newInsertObjectCol.size());
        DynamicObjectCollection collection = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(newTripEntryIndex)).getDynamicObjectCollection("entryentity");
        logger.info("entryentity\uff1a {}", (Object)collection.size());
        int i = 0;
        for (String vehicle2 : vehicleSet) {
            Long tripExpItemId = tripExpItemRelateVehicle.get(attributeRelate.get(vehicle2));
            if (tripExpItemId == null) continue;
            int index = newIndex[i++];
            model.beginInit();
            model.setValue("isdefault", (Object)true, index, newTripEntryIndex);
            model.endInit();
            CoreBaseBillServiceHelper.setTripExpenseItem(model, tripExpItemId, index, newTripEntryIndex, false);
        }
        collection = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("tripentry").get(newTripEntryIndex)).getDynamicObjectCollection("entryentity");
        logger.info("entryentity\uff1a {}", (Object)collection.size());
    }

    private static Map<String, Long> getInitTripExpenseItem(DynamicObject company) {
        List<Long> tripExpItemIdList = TripExpenseItemServiceHelper.getTripExpenseItemByCompanyAndAttribute(ErCommonUtils.getPk(company), "2", "3", "4", "7");
        DynamicObject[] tripExpenseItems = BusinessDataServiceHelper.load((String)"er_tripexpenseitem", (String)"name, number, attribute, isinit, createorg", (QFilter[])new QFilter("id", "in", tripExpItemIdList).toArray());
        logger.info("CoreBaseBillServiceHelper_mulTripVehicle>>> company: " + company + ", tripExpItems: " + tripExpItemIdList);
        HashMap<String, Long> tripExpItemIds = new HashMap<String, Long>();
        for (DynamicObject tripExpItem : tripExpenseItems) {
            String attribuite = tripExpItem.getString("attribute");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)attribuite)) continue;
            Long tripExpenseItemId = (Long)tripExpItemIds.get(attribuite);
            if (tripExpenseItemId == null || tripExpenseItemId == 0L) {
                tripExpenseItemId = ErCommonUtils.getPk(tripExpItem);
            } else {
                String isInit = tripExpItem.getString("isinit");
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)isInit)) {
                    tripExpenseItemId = ErCommonUtils.getPk(tripExpItem);
                } else {
                    DynamicObject createOrg = tripExpItem.getDynamicObject("createorg");
                    if (createOrg != null && company.getPkValue().equals(createOrg.getPkValue())) {
                        tripExpenseItemId = ErCommonUtils.getPk(tripExpItem);
                    }
                }
            }
            tripExpItemIds.put(attribuite, tripExpenseItemId);
        }
        return tripExpItemIds;
    }

    @Deprecated
    public static void chooseTripVehicle(IDataModel model, String vehicle, int itemIndex) {
        switch (vehicle) {
            case "1": {
                CoreBaseBillServiceHelper.setTripExpenseItem(model, planeExpense, itemIndex, false);
                break;
            }
            case "2": {
                CoreBaseBillServiceHelper.setTripExpenseItem(model, trainExpense, itemIndex, false);
                break;
            }
            case "3": {
                CoreBaseBillServiceHelper.setTripExpenseItem(model, busExpense, itemIndex, false);
                break;
            }
            case "4": {
                CoreBaseBillServiceHelper.setTripExpenseItem(model, shipExpense, itemIndex, false);
                break;
            }
            case "5": {
                CoreBaseBillServiceHelper.setTripExpenseItem(model, othersExpense, itemIndex, true);
            }
        }
    }

    @Deprecated
    public static void setTripExpenseItem(IDataModel model, Long expenseItem, int itemIndex, boolean ispassentry) {
        model.beginInit();
        model.setValue("ispassentry", (Object)ispassentry, itemIndex);
        model.endInit();
        DynamicObject expenseItemObj = CommonServiceHelper.getObjById("er_tripexpenseitem", expenseItem);
        CoreBaseBillServiceHelper.fillEntryEntityData(model, expenseItemObj, itemIndex);
    }

    public static void setTripExpenseItem(IDataModel model, Long expenseItem, int itemIndex, int tripIndex, boolean ispassentry) {
        model.beginInit();
        model.setValue("ispassentry", (Object)ispassentry, itemIndex, tripIndex);
        model.endInit();
        DynamicObject expenseItemObj = CommonServiceHelper.getObjById("er_tripexpenseitem", expenseItem);
        CoreBaseBillServiceHelper.fillEntryEntityData(model, expenseItemObj, itemIndex, tripIndex);
    }

    @Deprecated
    public static void fillEntryEntityData(IDataModel model, DynamicObject selectExpenseitem, int index) {
        model.setValue("expenseitem", selectExpenseitem.getPkValue(), index);
        model.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"), index);
        model.beginInit();
        int curTripIndex = model.getEntryCurrentRowIndex("tripentry");
        model.setValue("daycount", model.getValue("tripday", curTripIndex), index);
        model.endInit();
        DynamicObject tripCurrency = (DynamicObject)model.getValue("tripcurrency", curTripIndex);
        if (tripCurrency == null) {
            tripCurrency = (DynamicObject)model.getValue("currency");
        }
        model.setValue("entrycurrency", (Object)ErCommonUtils.getPk(tripCurrency), index);
        TripReimburseServiceHelper.whenTripItemChanged(model, selectExpenseitem, index);
    }

    public static void fillEntryEntityData(IDataModel model, DynamicObject selectExpenseitem, int index, int tripIndex) {
        model.setValue("expenseitem", selectExpenseitem.getPkValue(), index, tripIndex);
        model.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"), index, tripIndex);
        model.beginInit();
        model.setValue("daycount", model.getValue("tripday", tripIndex), index, tripIndex);
        model.endInit();
        DynamicObject tripCurrency = (DynamicObject)model.getValue("tripcurrency", tripIndex);
        if (tripCurrency == null) {
            tripCurrency = (DynamicObject)model.getValue("currency");
        }
        model.setValue("entrycurrency", (Object)ErCommonUtils.getPk(tripCurrency), index, tripIndex);
        TripReimburseServiceHelper.whenTripItemChanged(model, selectExpenseitem, index, tripIndex);
    }

    public static void changeAccountEntry(IDataModel model, Long userId) {
        IDataEntityProperty property = model.getProperty("accountentry");
        if (property == null) {
            return;
        }
        model.deleteEntryData("accountentry");
        DynamicObject defaultAccount = PayeeServiceHelper.getDefaultAccount(userId);
        int rowIndex = model.createNewEntryRow("accountentry");
        CoreBaseBillServiceHelper.fillAccountEntry(model, rowIndex, defaultAccount);
    }

    public static Long getAccountOrgId(Long orgId) {
        return CoreBaseBillServiceHelper.getAccountOrgId(false, orgId);
    }

    public static Long getAccountOrgId(boolean isF7, Long orgId) {
        Boolean isBizUnit = true;
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(orgId, isBizUnit);
        if (isF7 && accountOrgId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"CoreBaseBillServiceHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return accountOrgId;
    }

    public static Long getAccountOrgId(CostDeptF7ChangePram costDeptF7ChangePram) {
        Object company = costDeptF7ChangePram.getCompany();
        Long companyId = ErCommonUtils.getPk(company);
        Long costCompanyId = ErCommonUtils.getPk(costDeptF7ChangePram.getCostCompany());
        Long costDept = ErCommonUtils.getPk(costDeptF7ChangePram.getCostDept());
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(costDept, true);
        String enableCostCompanyEdit = (String)ErCommonUtils.getEMParameter(companyId, "enablecostcompanyedit");
        if (accountOrgId == null && org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)enableCostCompanyEdit) && costDeptF7ChangePram.getIsF7().booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"CoreBaseBillServiceHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return accountOrgId == null ? costCompanyId : accountOrgId;
    }

    public static Long getAccountOrgId(Long orgId, Boolean isBizUnit) {
        RequestContext.get().getTraceId();
        String key = orgId + "$$" + isBizUnit;
        TraceCache<String, Long> traceCache = accountOrgTL.get();
        if (!traceCache.isCurrentTrace()) {
            traceCache.clearAndSetTraceId();
        } else if (traceCache.isCurrentTrace() && traceCache.containKey(key)) {
            return traceCache.get(key);
        }
        Map costCompanyAccountOrg = ErCommonUtils.isXkModeType() || "2".equals(ErStdConfig.get("costcompanyonlyleaf")) ? OrgUnitServiceHelper.getCompanyByAdminOrg((Long)orgId, (Boolean)Boolean.FALSE) : OrgUnitServiceHelper.getCompanyByAdminOrg((Long)orgId, (Boolean)isBizUnit);
        logger.info(String.format("\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7, \u884c\u653f\u7ec4\u7ec7:%1$s,\u662f\u5426\u5b9e\u4f53\uff1a%2$s,\u6838\u7b97\u7ec4\u7ec7\u4e3a\uff1a%3$s", orgId, isBizUnit, SerializationUtils.toJsonString((Object)costCompanyAccountOrg)));
        Long accountOrgId = 0L;
        if (costCompanyAccountOrg != null && costCompanyAccountOrg.size() > 0) {
            Object accountOrg = costCompanyAccountOrg.get("id");
            if (accountOrg instanceof DynamicObject) {
                accountOrgId = (Long)((DynamicObject)accountOrg).getPkValue();
            } else if (accountOrg instanceof Long) {
                accountOrgId = (Long)accountOrg;
            }
        }
        if (accountOrgId.compareTo(Long.valueOf("0")) == 0) {
            Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(orgId);
            logger.info("-----companyId\u503c-----" + (companyId != null ? companyId : "null"));
            String enableCostCompanyEdit = (String)ErCommonUtils.getEMParameter(companyId, "enablecostcompanyedit");
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)enableCostCompanyEdit)) {
                logger.info("-----\u8d70\u91cd\u65b0\u8d4b\u503c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u903b\u8f91-----");
                String costCompanyNumberStr = ErStdConfig.get("Value of Costcompany");
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)costCompanyNumberStr) && !"0".equals(costCompanyNumberStr)) {
                    QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
                    QFilter orgIdFilter = new QFilter("org.number", "=", (Object)costCompanyNumberStr);
                    String selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,isbizunit";
                    QFilter[] filters = new QFilter[]{treeTypeFilter, orgIdFilter};
                    DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
                    accountOrgId = orgInfo != null ? ErCommonUtils.getPk(orgInfo.get("org")) : Long.valueOf(-1L);
                }
            }
            if (accountOrgId.compareTo(Long.valueOf("0")) == 0) {
                accountOrgTL.get().put(key, null);
                return null;
            }
        }
        accountOrgTL.get().put(key, accountOrgId);
        return accountOrgId;
    }

    public static void showTripArea(IDataModel dataModel) {
        DynamicObjectCollection tripEntrys = dataModel.getEntryEntity("tripentry");
        DynamicObject company = (DynamicObject)dataModel.getValue("company");
        if (tripEntrys != null && !tripEntrys.isEmpty()) {
            ArrayList<Long> cityIdList = new ArrayList<Long>(10);
            for (int i = 0; i < tripEntrys.size(); ++i) {
                Long cityId;
                DynamicObject tripEntry;
                DynamicObject toCity;
                if (dataModel.getValue("tripentryarea", i) != null || (toCity = (tripEntry = (DynamicObject)tripEntrys.get(i)).getDynamicObject("to")) == null || cityIdList.contains(cityId = (Long)toCity.getPkValue())) continue;
                cityIdList.add(cityId);
            }
            Map<Object, Object> cityAndTripAreaMap = new HashMap();
            if (cityIdList.size() > 0) {
                cityAndTripAreaMap = CoreBaseBillServiceHelper.getALlTripAreaOfTripEntry(cityIdList, (Long)company.getPkValue());
            }
            for (int i = 0; i < tripEntrys.size(); ++i) {
                DynamicObject tripEntry;
                DynamicObject toCity;
                if (dataModel.getValue("tripentryarea", i) != null || (toCity = (tripEntry = (DynamicObject)tripEntrys.get(i)).getDynamicObject("to")) == null) continue;
                List areaList = (List)cityAndTripAreaMap.get((Long)toCity.getPkValue());
                Long areaId = 0L;
                if (areaList != null) {
                    for (DynamicObject area : areaList) {
                        if (area == null) continue;
                        areaId = (Long)area.getPkValue();
                        break;
                    }
                }
                dataModel.beginInit();
                dataModel.setValue("tripentryarea", (Object)areaId, i);
                dataModel.endInit();
            }
        }
    }

    private static Map<Long, List<DynamicObject>> getALlTripAreaOfTripEntry(List<Long> cityIdList, Long companyId) {
        DynamicObject[] tripAreas;
        HashMap<Long, List<DynamicObject>> tripAreaMap = new HashMap<Long, List<DynamicObject>>(10);
        QFilter filter = new QFilter("entryentity.city.id", "in", cityIdList);
        filter.and(new QFilter("enable", "=", (Object)true));
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triparea", (Long)companyId);
        if (null != baseFilter) {
            filter.and(baseFilter);
        }
        String selectProperties = "id,createorg,entryentity.city";
        for (DynamicObject tripArea : tripAreas = BusinessDataServiceHelper.load((String)"er_triparea", (String)selectProperties, (QFilter[])new QFilter[]{filter})) {
            DynamicObjectCollection areaEntryentity = tripArea.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : areaEntryentity) {
                DynamicObject city = entry.getDynamicObject("city");
                Long cityId = (Long)city.getPkValue();
                if (!cityIdList.contains(cityId)) continue;
                List traipAreaListTmp = (List)tripAreaMap.get(cityId);
                if (traipAreaListTmp != null) {
                    traipAreaListTmp.add(tripArea);
                    tripAreaMap.put(cityId, traipAreaListTmp);
                    continue;
                }
                ArrayList<DynamicObject> traipAreaList = new ArrayList<DynamicObject>(2);
                traipAreaList.add(tripArea);
                tripAreaMap.put(cityId, traipAreaList);
            }
        }
        return tripAreaMap;
    }

    public static Date computeRepaymentDate(IDataModel model) {
        Date biz_date = (Date)model.getValue("bizdate");
        int expectdeDate = 3;
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company != null) {
            long companyId = (Long)company.getPkValue();
            expectdeDate = SystemParamterUtil.getExpectedRepaymentDate(companyId);
        }
        return CoreBaseBillServiceHelper.delayByMonth(biz_date, expectdeDate);
    }

    public static Date computeRepaymentDate(DynamicObject bill) {
        DynamicObject company = (DynamicObject)bill.get("company");
        long companyId = company != null ? (Long)company.getPkValue() : -1L;
        return CoreBaseBillServiceHelper.computeRepaymentDate((Date)bill.get("bizdate"), (Date)bill.get("head_paydate"), companyId);
    }

    public static Date computeRepaymentDate(Date applyDate, Date payDate, long companyId) {
        Date biz_date = applyDate;
        int defaultDelay = 3;
        if (companyId != -1L) {
            defaultDelay = SystemParamterUtil.getExpectedRepaymentDate(companyId);
            if (SystemParamterUtil.getRepaymentDateBase(companyId) == 1) {
                biz_date = payDate != null ? payDate : biz_date;
            }
        }
        return CoreBaseBillServiceHelper.delayByMonth(biz_date, defaultDelay);
    }

    public static Date delayByMonth(Date date, int delayMonth) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        cal.set(2, month + delayMonth);
        return cal.getTime();
    }

    public static QFilter getApplierSelectFilterByCurOrgId(Long orgId, String billtype) {
        Long curUserId = CommonServiceHelper.getCurrentUserID();
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)orgId);
        logger.info("getApplierSelectFilterByCurOrgId: " + orgId + ", " + billtype + ", " + company);
        Long applierCompanyId = company != null ? (Long)company.get("id") : Long.valueOf(0L);
        HashMap<String, Object> orgInfo = new HashMap<String, Object>();
        orgInfo.put("org", orgId);
        orgInfo.put("company", applierCompanyId);
        logger.info("getApplierSelectFilterByCurOrgId: SystemParamterUtil.getApplierSlectRangeType()" + applierCompanyId);
        ApplierSelectRangeEnum selectRange = SystemParamterUtil.getApplierSlectRangeType(applierCompanyId);
        QFilter qFilterApplierF7 = CoreBaseBillServiceHelper.getUserFilterBySelectRange(selectRange, curUserId, billtype, orgInfo);
        QFilter freezeFilter = new QFilter("entryentity.orgstructure.isfreeze", "=", (Object)false);
        qFilterApplierF7.and(freezeFilter);
        return qFilterApplierF7;
    }

    public static QFilter getApplierOrgSelectFilterByCurOrgId(Long applierId, Long deptId, String billtype) {
        DynamicObject applier = BusinessDataServiceHelper.loadSingleFromCache((Object)applierId, (String)"bos_user");
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        Long applierCompanyId = company != null ? (Long)company.get("id") : Long.valueOf(0L);
        ApplierSelectRangeEnum selectRange = SystemParamterUtil.getApplierSlectRangeType(applierCompanyId);
        Set orgIds = applier.getDynamicObjectCollection("entryentity").stream().map(e -> ErCommonUtils.getPk(e.get("dpt"))).collect(Collectors.toSet());
        switch (selectRange) {
            case COMPANY_PLUS: {
                orgIds.add(applierCompanyId);
                List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", Collections.singletonList(applierCompanyId), (boolean)false);
                orgIds.addAll(allSubordinateOrgs);
                break;
            }
            case CONSIGNER_PLUS: 
            case DEPARTMENT_PLUS: {
                orgIds.add(deptId);
            }
        }
        if (orgIds.isEmpty()) {
            return null;
        }
        Set<Long> entrustUserIds = EntrustReimburseUtils.addConsignor(applierId, billtype);
        Set entrustUserDeptIds = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", "in", entrustUserIds)}).values().stream().flatMap(e -> e.getDynamicObjectCollection("entryentity").stream()).map(r -> ErCommonUtils.getPk(r.get("dpt"))).collect(Collectors.toSet());
        orgIds.addAll(entrustUserDeptIds);
        return new QFilter("entryentity.dpt", "in", (Object)orgIds.toArray());
    }

    @Deprecated
    public static QFilter getUserFilterBySelectRange(ApplierSelectRangeEnum selectRange, Long userId, String billtype) {
        DynamicObject dept = (DynamicObject)CommonServiceHelper.getUserMap(userId).get("org");
        Long deptId = dept != null ? (Long)dept.getPkValue() : Long.valueOf(0L);
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        Long companyId = company != null ? (Long)company.get("id") : Long.valueOf(0L);
        HashMap<String, Object> orgInfo = new HashMap<String, Object>();
        orgInfo.put("org", deptId);
        orgInfo.put("company", companyId);
        return CoreBaseBillServiceHelper.getUserFilterBySelectRange(selectRange, userId, billtype, orgInfo);
    }

    private static QFilter getUserFilterBySelectRange(ApplierSelectRangeEnum selectRange, Long userId, String billtype, Map<String, Object> orgInfo) {
        QFilter resultFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Set<Long> userIds = EntrustReimburseUtils.addConsignor(userId, billtype);
        Long userOrgID = (Long)orgInfo.getOrDefault("org", 0L);
        switch (selectRange) {
            case COMPANY_PLUS: {
                userOrgID = (Long)orgInfo.getOrDefault("company", 0L);
            }
            case DEPARTMENT_PLUS: {
                if (userOrgID != null) {
                    userIds.addAll(CoreBaseBillServiceHelper.getAllUserIdOfOrg(userOrgID));
                }
            }
            case CONSIGNER_PLUS: {
                if (userIds.size() <= 0) break;
                resultFilter = resultFilter.and("id", "in", userIds);
            }
        }
        return resultFilter;
    }

    private static Set<Long> getAllUserIdOfOrg(Long curCompanyId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(curCompanyId);
        Set userIDSet = UserServiceHelper.getAllUsersOfOrg((int)1, orgIdList, (boolean)true, (boolean)false);
        userIDSet.addAll(UserServiceHelper.getAllUsersOfOrg((int)2, orgIdList, (boolean)true, (boolean)false));
        return userIDSet;
    }

    public static boolean isDefaultApplierSelectRangeType(Long curCompanyId) {
        return SystemParamterUtil.getApplierSlectRangeType(curCompanyId) == ApplierSelectRangeEnum.CONSIGNER_PLUS;
    }

    public static void setPayeeF7Filter(ListShowParameter accountF7Param, DynamicObject applier, List<Long> entryReimburserIdColl) {
        ArrayList<Long> userIdCollection = new ArrayList<Long>(2);
        Long userId = CommonServiceHelper.getCurrentUserID();
        Long applierId = 0L;
        if (applier != null) {
            applierId = (Long)applier.getPkValue();
        }
        userIdCollection.add(applierId);
        userIdCollection.add(userId);
        if (entryReimburserIdColl == null) {
            entryReimburserIdColl = userIdCollection;
        } else {
            entryReimburserIdColl.addAll(userIdCollection);
        }
        accountF7Param.getListFilterParameter().getQFilters().add(PayeeServiceHelper.getPayeeF7Filter(entryReimburserIdColl, userIdCollection, userIdCollection));
    }

    public static List<Long> getMultiReimburserIdCollection(IFormView view) {
        String entityId = view.getEntityId();
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        DynamicObject ctrlOrg = dataEntity.getDynamicObject("company");
        if (ctrlOrg == null || SystemParamterUtil.isSelectOtherAcctByAuth(ErCommonUtils.getPk(ctrlOrg.getPkValue()))) {
            return null;
        }
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            DynamicObjectCollection detailColl = dataEntity.getDynamicObjectCollection("expenseentryentity");
            return new ArrayList<Long>(detailColl.stream().filter(detail -> detail.get("reimburser") != null).map(detail -> (Long)detail.getDynamicObject("reimburser").getPkValue()).collect(Collectors.toSet()));
        }
        if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            String reimburseShowType = dataEntity.getString("billkind");
            ArrayList<Long> resultList = new ArrayList<Long>();
            DynamicObjectCollection tripEntryColl = dataEntity.getDynamicObjectCollection("tripentry");
            if ("1".equals(reimburseShowType)) {
                for (DynamicObject tripEntry : tripEntryColl) {
                    DynamicObjectCollection detailColl = tripEntry.getDynamicObjectCollection("entryentity");
                    for (DynamicObject detail2 : detailColl) {
                        resultList.addAll(detail2.getDynamicObjectCollection("trip2travelers").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet()));
                    }
                }
            } else {
                for (DynamicObject tripEntry : tripEntryColl) {
                    resultList.addAll(tripEntry.getDynamicObjectCollection("travelers").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet()));
                }
            }
            return resultList;
        }
        return null;
    }

    public static boolean isEnableAlterCostOrgInfoFromSrcBill(Long companyId, DynamicObject targetbill) {
        boolean isEnable = SystemParamterUtil.isEnableAlterCostOrgInfo(companyId);
        if (companyId == null || companyId.compareTo(0L) <= 0 || targetbill == null || isEnable) {
            return true;
        }
        if (targetbill.getDataEntityState().isPushChanged()) {
            return false;
        }
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)"er_tripreimbursebill", (Long[])new Long[]{Long.valueOf(targetbill.getPkValue().toString())});
        if (srcBills.size() > 0) {
            Iterator srcIterator = srcBills.entrySet().iterator();
            HashSet headIds = new HashSet(srcBills.size());
            while (srcIterator.hasNext()) {
                Map.Entry srcBillEntry = srcIterator.next();
                if (!ErEntityTypeUtils.isTripReqBill((String)srcBillEntry.getKey())) continue;
                headIds.addAll((Collection)srcBillEntry.getValue());
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", headIds), new QFilter("isloan", "=", (Object)Boolean.FALSE)};
            boolean exists = QueryServiceHelper.exists((String)"er_tripreqbill", (QFilter[])filters);
            if (exists) {
                return false;
            }
        }
        return true;
    }

    public static void callBillOpFunction(String billOpName, String billEntityName, DynamicObject[] sourceBills, Set<String> srcOpSet) {
        if (CollectionUtils.isEmpty(srcOpSet) || !srcOpSet.contains(billOpName) || StringUtils.isEmpty((CharSequence)billEntityName) || ArrayUtils.isEmpty((Object[])sourceBills)) {
            return;
        }
        try {
            OperationResult result = ErOperationServiceHelper.execOperate(billOpName, billEntityName, sourceBills, OperateOption.create());
            if (!result.isSuccess()) {
                logger.info("\u5355\u636e\u540e\u53f0\u6267\u884c\u64cd\u4f5c->" + billEntityName + SerializationUtils.toJsonString((Object)sourceBills) + "\u5931\u8d25->" + JSONObject.toJSONString((Object)result.getAllErrorOrValidateInfo()));
            }
        }
        catch (KDBizException e1) {
            logger.info("\u5355\u636e\u540e\u53f0\u6267\u884c\u64cd\u4f5c->" + billEntityName + SerializationUtils.toJsonString((Object)sourceBills) + "\u5f02\u5e38->" + e1.getStackTraceMessage());
        }
    }

    public static List<Long> findCostCompanysByCostDept(Long deptID) {
        ArrayList<Long> deptIDs = new ArrayList<Long>();
        deptIDs.add(deptID);
        List selectIds = OrgUnitServiceHelper.getAdminOrgRelation(deptIDs, (boolean)false);
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter isbizunitFilter = null;
        if (ErCommonUtils.costcompanyonlyleaf()) {
            isbizunitFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        }
        QFilter orgFilter = null;
        QFilter[] filters = null;
        DynamicObject orgInfo = null;
        Long costCompany = null;
        String orgFunction = "01";
        while (costCompany == null) {
            orgFilter = new QFilter("org", "=", (Object)deptID);
            filters = new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter, isbizunitFilter};
            orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])filters);
            if (orgInfo != null) {
                costCompany = ErCommonUtils.getPk(orgInfo.get("org"));
                selectIds.add(costCompany);
                break;
            }
            List parents = OrgUnitServiceHelper.getSuperiorOrgs((String)orgFunction, (long)deptID);
            if (parents == null || parents.isEmpty()) break;
            deptID = (Long)parents.get(0);
        }
        return selectIds;
    }

    public static List<Long> findAllCostCompany() {
        ArrayList<Long> selectIds = new ArrayList<Long>();
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter isbizunitFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{treeTypeFilter, isDefaultViewFilter, isbizunitFilter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            collection.forEach(orgInfo -> selectIds.add(ErCommonUtils.getPk(orgInfo.get("org"))));
        }
        return selectIds;
    }

    @Deprecated
    public static void refreshEntryRowSeq(IDataModel model, boolean isAll) {
        DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripEntry.isEmpty()) {
            return;
        }
        int currIdnex = model.getEntryCurrentRowIndex("tripentry");
        for (int i = 0; i < tripEntry.size(); ++i) {
            if (!isAll && i != currIdnex) continue;
            DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entry.size(); ++j) {
                model.setValue("rowseq", (Object)(j + 1 + "."), j, i);
            }
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
    }

    public static void refreshEntryRowSeq(IDataModel model, boolean isAll, int tripIndex) {
        DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripEntry.isEmpty()) {
            return;
        }
        for (int i = 0; i < tripEntry.size(); ++i) {
            if (!isAll && i != tripIndex) continue;
            DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entry.size(); ++j) {
                model.setValue("rowseq", (Object)(j + 1 + "."), j, i);
            }
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
    }

    public static void refreshEntryCostOrgByHeadCostOrg(IDataModel model) {
        String entryCostCompanyNumber;
        String entryCostDeptNumber;
        String entryNumber;
        Object company = model.getValue("company");
        String costOrgShowType = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(company), "expensesassumeshowtypes");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)costOrgShowType)) {
            return;
        }
        Object costDept = model.getValue("costdept");
        Object costCompany = model.getValue("costcompany");
        if (model.getProperty("tripentry") != null) {
            entryNumber = "tripentry";
            entryCostDeptNumber = "entrycostdept";
            entryCostCompanyNumber = "entrycostcompany";
        } else {
            entryNumber = "expenseentryentity";
            entryCostDeptNumber = "entrycostdept";
            entryCostCompanyNumber = "entrycostcompany";
        }
        int entryRowCount = model.getEntryRowCount(entryNumber);
        for (int i = 0; i < entryRowCount; ++i) {
            model.setValue(entryCostDeptNumber, costDept, i);
            model.setValue(entryCostCompanyNumber, costCompany, i);
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"er_tripreimbursebill", (CharSequence)model.getDataEntityType().getName()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)"er_tripreimbursebill_BT_S", (CharSequence)((DynamicObject)model.getValue("stdbilltype")).getString("number"))) {
            DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            if (model.getProperty("travelcostdept") == null || model.getProperty("travelcostcompany") == null) {
                return;
            }
            for (int i = 0; i < tripEntry.size(); ++i) {
                DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("entryentity");
                for (int j = 0; j < entry.size(); ++j) {
                    model.setValue("travelcostdept", costDept, j, i);
                    model.setValue("travelcostcompany", costCompany, j, i);
                }
            }
        }
    }

    public static void refreshTrip2TravelersCount(IDataModel model) {
        if (!model.getDataEntity().getDataEntityState().isPushChanged()) {
            return;
        }
        DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (int i = 0; i < tripEntry.size(); ++i) {
            DynamicObjectCollection travlers = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("travelers");
            int travlerCount = travlers == null ? 0 : travlers.size();
            DynamicObjectCollection entry = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entry.size(); ++j) {
                model.setValue("trip2travelerscount", (Object)travlerCount, j, i);
            }
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
    }

    public static void setBillCostOrgUseMode(IDataModel model) {
        Object company = model.getValue("company");
        if (Objects.nonNull(company) && Objects.nonNull(model.getProperty("costorgusemode"))) {
            String useMode = ErCommonUtils.getCostOrgUseMode(ErCommonUtils.getPk(company));
            model.setValue("costorgusemode", (Object)useMode);
        }
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("1", "2");
        temp.put("2", "4");
        temp.put("3", "3");
        temp.put("4", "7");
        temp.put("5", "6");
        attributeRelate = Collections.unmodifiableMap(temp);
        temp = new HashMap();
        temp.put("2", "1");
        temp.put("4", "2");
        temp.put("3", "3");
        temp.put("7", "4");
        temp.put("6", "5");
        VEHICLERELATE = Collections.unmodifiableMap(temp);
        accountOrgTL = ThreadLocal.withInitial(() -> new TraceCache());
    }
}

