/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;

public class DailyBillServiceHelper {
    private static final Log log = LogFactory.getLog(DailyBillServiceHelper.class);

    public static void refreshCurrency(IFormView view, ChangeData[] valueSet) {
        String billtype;
        IDataModel model = view.getModel();
        if (model.getProperty("formid") != null && ErEntityTypeUtils.isDailyVehicleBill(billtype = (String)model.getValue("formid"))) {
            return;
        }
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        Long oldCurrency = ErCommonUtils.getPk(model.getValue("currency"));
        if (company != null && company.getPkValue() != null) {
            if (costCompany == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErExpenseBaseEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(company, costCompany);
            if (baseCurrencyId == null || baseCurrencyId.compareTo(0L) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DailyBillServiceHelper_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (oldCurrency == null || !oldCurrency.equals(baseCurrencyId)) {
                DailyBillServiceHelper.clearFormData(view, model, baseCurrencyId);
                DailyBillServiceHelper.updateCurrency(model, baseCurrencyId);
            }
        }
    }

    private static void updateCurrency(IDataModel model, Long baseCurrencyId) {
        model.setValue("currency", (Object)baseCurrencyId);
        if (model.getProperty("iscurrency") != null) {
            Boolean iscurrency = (Boolean)model.getValue("iscurrency");
            model.setValue("iscurrency", (Object)(iscurrency == false ? 1 : 0));
            model.setValue("iscurrency", (Object)iscurrency);
        }
    }

    private static void clearFormData(IFormView view, IDataModel model, Long baseCurrencyId) {
        String entityId = view.getEntityId();
        StringBuilder logmsg = new StringBuilder("basecurrency change,clean data:");
        if (ErEntityTypeUtils.isTripReqBill(entityId) || ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            int tripCount = model.getEntryRowCount("tripentry");
            int[] tripIndexs = IntStream.range(0, tripCount).toArray();
            InvoiceUtils.outLog(model, "tripentry", tripIndexs);
            model.deleteEntryRows("tripentry", tripIndexs);
            if (model.getProperty("entryentity") != null) {
                view.updateView("entryentity");
            }
            if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                model.deleteEntryData("writeoffapply");
                model.deleteEntryData("writeofftriprelate");
            }
            if (DailyBillServiceHelper.isNewTripReim(model)) {
                DailyBillServiceHelper.updateCurrency(model, baseCurrencyId);
                DailyBillServiceHelper.initEntryForNewTripReim(model);
            } else {
                view.updateView();
            }
        } else {
            DynamicObjectCollection expenseentryentity = model.getEntryEntity("expenseentryentity");
            if (expenseentryentity != null) {
                for (int i = 0; i < expenseentryentity.size(); ++i) {
                    model.setValue("entrycurrency", model.getValue("currency"), i);
                    model.setValue("exchangerate", (Object)"1.0", i);
                    model.setValue("expenseamount", (Object)BigDecimal.ZERO, i);
                }
                model.deleteEntryData("expenseentryentity");
                logmsg.append("expenseentryentity;");
                view.updateView("expenseentryentity");
            }
        }
        if (model.getDataEntityType().getProperty("invoiceentry") != null) {
            model.deleteEntryData("invoiceentry");
            logmsg.append("invoiceentry;");
        }
        if (model.getDataEntityType().getProperty("invoiceitementry") != null) {
            model.deleteEntryData("invoiceitementry");
            logmsg.append("invoiceitementry;");
        }
        if (model.getDataEntityType().getProperty("invoiceandexpense") != null) {
            model.deleteEntryData("invoiceandexpense");
            logmsg.append("invoiceandexpense;");
        }
        if (model.getDataEntityType().getProperty("accountentry") != null) {
            model.deleteEntryData("accountentry");
            logmsg.append("accountentry;");
            if (view instanceof IMobileView) {
                view.setVisible(Boolean.valueOf(false), new String[]{"accountflexhead", "accountentry", "btn_account_add"});
            }
        }
        if (model.getDataEntityType().getProperty("withholdingentry") != null) {
            model.deleteEntryData("withholdingentry");
            logmsg.append("withholdingentry;");
        }
        if (model.getDataEntityType().getProperty("expenseentryentity_rule") != null) {
            model.deleteEntryData("expenseentryentity_rule");
            logmsg.append("expenseentryentity_rule;");
        }
        if (model.getDataEntityType().getProperty("writeoffapply") != null) {
            model.deleteEntryData("writeoffapply");
            logmsg.append("writeoffapply;");
        }
        if (model.getDataEntityType().getProperty("contractentry") != null) {
            model.deleteEntryData("contractentry");
            logmsg.append("contractentry;");
        }
        if (model.getDataEntityType().getProperty("writeoffmoney") != null) {
            model.deleteEntryData("writeoffmoney");
            logmsg.append("writeoffmoney;");
        }
        if (model.getDataEntityType().getProperty("projectentryentity") != null) {
            model.deleteEntryData("projectentryentity");
            logmsg.append("projectentryentity;");
        }
        log.info(logmsg.toString());
    }

    public static boolean isNewTripReim(IDataModel model) {
        return model.getProperty("billkind") != null && "1".equals(model.getValue("billkind"));
    }

    public static boolean isNewTripReim(DynamicObject dataEntity) {
        return "1".equals(dataEntity.get("billkind"));
    }

    public static void initEntryForNewTripReim(IDataModel model) {
        int entryCurrentRowIndex = model.getEntryRowCount("tripentry");
        if (entryCurrentRowIndex == 0) {
            int rowIndex = model.createNewEntryRow("tripentry");
            if (model.getValue("applier") == null) {
                Map<String, Object> billMap = CoreBaseBillServiceHelper.createNewData(Long.valueOf(RequestContext.get().getUserId()));
                CoreBaseBillServiceHelper.initObjByMap(model, billMap);
            }
            if (model.getValue("tripcurrency", entryCurrentRowIndex) == null) {
                Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(model.getValue("company"), model.getValue("costcompany"));
                model.setValue("tripcurrency", (Object)baseCurrencyId, entryCurrentRowIndex);
            }
            CoreBaseBillServiceHelper.addDefaultTripExpenseEntry(model, rowIndex);
        }
    }
}

