/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class ErPermissionServiceHelper {
    private static final Log logger = LogFactory.getLog(ReimburseControlUtils.class);
    private static final String ALGO = ErPermissionServiceHelper.class.getName();

    public static List<Long> getOrgListWithQueryPerm(String appNum, String entityId) {
        return ErPermissionServiceHelper.getOrgListWithPerm(appNum, entityId, "47150e89000000ac");
    }

    public static List<Long> getOrgListWithPerm(String appNum, String entityId, String permItemId) {
        HasPermOrgResult orgsResult = ErPermissionServiceHelper.getOrgResultWithPerm(appNum, entityId, permItemId);
        if (orgsResult.hasAllOrgPerm()) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            ArrayList<Long> result = new ArrayList<Long>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
                for (Row row : ds) {
                    result.add(row.getLong("id"));
                }
            }
            return result;
        }
        return orgsResult.getHasPermOrgs();
    }

    @Deprecated
    public static List<Long> getCompanyListWithQueryPerm(String appNum, String entityId) {
        return ErPermissionServiceHelper.getCompanyListWithPerm(appNum, entityId, "47150e89000000ac");
    }

    @Deprecated
    public static List<Long> getCompanyListWithPerm(String appNum, String entityId, String permItemId) {
        DynamicObject[] companyDOs;
        QFilter orgFilter = null;
        List<Object> companyIds = Lists.newArrayList();
        HasPermOrgResult orgsResult = ErPermissionServiceHelper.getOrgResultWithPerm(appNum, entityId, permItemId);
        boolean isHasAllOrgPerm = orgsResult.hasAllOrgPerm();
        if (!isHasAllOrgPerm) {
            List orgsList = orgsResult.getHasPermOrgs();
            if (orgsList.isEmpty()) {
                logger.warn("\u5f53\u524d\u7528\u6237\u5bf9" + entityId + "\u6709\u67e5\u8be2\u6743\u9650\u7684\u516c\u53f8\u4e3a\u7a7a");
                return companyIds;
            }
            orgFilter = new QFilter("id", "in", (Object)orgsList);
        }
        if ((companyDOs = (DynamicObject[])QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{ErPermissionServiceHelper.getCompanyFilter(), orgFilter}).toArray((Object[])new DynamicObject[0])).length <= 0) {
            logger.warn("\u5f53\u524d\u7528\u6237\u5bf9" + entityId + "\u6709\u67e5\u8be2\u6743\u9650\u7684\u516c\u53f8\u4e3a\u7a7a");
            return companyIds;
        }
        companyIds = Arrays.stream(companyDOs).map(company -> company.getLong("id")).collect(Collectors.toList());
        logger.info("\u5f53\u524d\u7528\u6237\u5bf9" + entityId + "\u6709\u67e5\u8be2\u6743\u9650\u7684\u516c\u53f8\u4e3a:" + SerializationUtils.toJsonString((Object)companyDOs));
        return companyIds;
    }

    @Deprecated
    public static List<Long> getCompanyListByPerm(String appNum, String entityId, String permItemId) {
        HasPermOrgResult orgsResult = ErPermissionServiceHelper.getOrgResultWithPerm(appNum, entityId, permItemId);
        boolean isHasAllOrgPerm = orgsResult.hasAllOrgPerm();
        if (!isHasAllOrgPerm) {
            return orgsResult.getHasPermOrgs();
        }
        return new ArrayList<Long>(0);
    }

    public static void setOrgFilterByPerm(List<QFilter> qFilters, String orgFilterField, String appNum, String entityNum, String permItemId) {
        HasPermOrgResult orgsResult;
        if (qFilters == null) {
            return;
        }
        if (permItemId == null) {
            permItemId = "47150e89000000ac";
        }
        if (appNum == null || appNum.isEmpty()) {
            appNum = "em";
        }
        if (orgFilterField == null || orgFilterField.isEmpty()) {
            orgFilterField = "company";
        }
        if (!(orgsResult = ErPermissionServiceHelper.getOrgResultWithPerm(appNum, entityNum, permItemId)).hasAllOrgPerm()) {
            List orgsList = orgsResult.getHasPermOrgs();
            qFilters.add(new QFilter(orgFilterField, "in", (Object)orgsList.toArray(new Long[0])));
        }
    }

    private static HasPermOrgResult getOrgResultWithPerm(String appNum, String entityId, String permItemId) {
        String appId = AppMetadataCache.getAppInfo((String)appNum).getAppId();
        Long userId = CommonServiceHelper.getCurrentUserID();
        HasPermOrgResult orgsResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItemId);
        logger.info(String.format("\u5f53\u524d\u7528\u6237:%s,\u5bf9\u5e94\u7528:%s,\u5b9e\u4f53:%s,\u6743\u9650\u9879id:%s,\u662f\u5426\u5177\u6709\u5168\u90e8\u7ec4\u7ec7\u6743\u9650:%s,\u5177\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u4e3a:%s", userId, appNum, entityId, permItemId, orgsResult.hasAllOrgPerm(), SerializationUtils.toJsonString((Object)orgsResult.getHasPermOrgs())));
        return orgsResult;
    }

    private static QFilter getCompanyFilter() {
        QFilter patterntypeFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
        return patterntypeFilter;
    }
}

