/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.provider.param.req.ShowInvoiceUrlReqParam;
import kd.fi.er.business.invoicecloud.util.BillingPoolUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceServiceHelper {
    private static final Log log = LogFactory.getLog(InvoiceServiceHelper.class);

    public static List<String> getAllSerialNos(IDataModel dataModel) {
        return InvoiceServiceHelper.getAllSerialNos(dataModel.getDataEntity(true));
    }

    public static List<String> getAllSerialNos(DynamicObject dataEntity) {
        DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        ArrayList serialNos = new ArrayList();
        serialNos.addAll(invoiceHeadEntryDOs.stream().map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toList()));
        DynamicObjectCollection invoiceMergeEntryDOs = new DynamicObjectCollection();
        boolean hasInvoiceMergeEntry = dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoicemerge");
        if (hasInvoiceMergeEntry) {
            invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
        }
        List serialNosFromOldTable = invoiceMergeEntryDOs.stream().map(invoiceMergeDO -> invoiceMergeDO.getString("serialno_merge")).collect(Collectors.toList());
        serialNos.addAll(serialNosFromOldTable);
        List<String> serialNoWithoutEmpty = serialNos.stream().filter(serial -> StringUtils.isNotBlank((CharSequence)serial)).collect(Collectors.toList());
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u5e8f\u5217\u53f7serialNos\uff1a" + serialNos);
        return serialNoWithoutEmpty;
    }

    public static Map<String, Object> buildXhShowInvoiceParameter(IDataModel model, DynamicObject dyn, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        String entityId = dyn.getDataEntityType().getName();
        String billType = "";
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.getBillTypeCode", "extendHandle", new Object[]{model}, new Class[]{IDataModel.class});
        if (invokeExtService != null && !"-1".equals(invokeExtService)) {
            billType = (String)invokeExtService;
        }
        if ("".equals(billType) || "-1".equals(billType)) {
            billType = entityId;
        }
        customParams.put("billType", billType);
        Object pkId = dyn.getPkValue();
        if (pkId != null) {
            customParams.put("billId", pkId.toString());
        }
        customParams.put("entityId", entityId);
        customParams.put("orgId", config.getInvoiceOrgId());
        if (!serialNos.isEmpty()) {
            ArrayList<String> serialNoList = new ArrayList<String>(serialNos.size());
            serialNoList.addAll(serialNos);
            customParams.put("serialNos", serialNoList);
        }
        ArrayList companyInfos = new ArrayList();
        HashMap<String, String> companyInfo = new HashMap<String, String>();
        companyInfo.put("name", config.getFirmname());
        companyInfo.put("taxNo", config.getTaxRegnum());
        companyInfos.add(companyInfo);
        customParams.put("companyInfo", companyInfos);
        if (otherParam != null && otherParam.containsKey("relevanceExpenseId")) {
            customParams.put("relevanceExpenseId", otherParam.get("relevanceExpenseId"));
        } else {
            List<String> multReimBillIds = BillingPoolUtils.getMultReimBillIds(model);
            if (!multReimBillIds.isEmpty()) {
                customParams.put("relevanceExpenseId", multReimBillIds);
            }
        }
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u67e5\u770b\u53d1\u7968\uff0c\u53c2\u6570customParams\u4e3a\uff1a{}", customParams);
        return customParams;
    }

    public static FormShowParameter buildOutShowInvoiceParameter(DynamicObject dyn, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        String billNoCachedInCloud = APIHelper.getBillNoCachedInCloud(dyn);
        if (otherParam != null && otherParam.get("billId") != null) {
            billNoCachedInCloud = otherParam.get("billId").toString();
        }
        try {
            APIHelper.putSerialNosToInvoiceCloudCache(config, billNoCachedInCloud, serialNos);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u8c03\u7528\u524d\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868\u754c\u9762>>> serialNosKey:" + billNoCachedInCloud + ", serialNos:" + serialNos);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("actionType", "viewInvoiceList");
        customParam.put("invoiceOrgId", config.getInvoiceOrgId());
        customParam.put("onPC", true);
        customParam.put("billNumber", billNoCachedInCloud);
        customParam.put("serialNo", JSON.toJSONString((Object)Lists.newArrayList(serialNos)));
        ShowInvoiceUrlReqParam showInvoiceParam = new ShowInvoiceUrlReqParam();
        showInvoiceParam.setBillId(billNoCachedInCloud);
        showInvoiceParam.setBillNumber(dyn.getString("billno"));
        showInvoiceParam.setOrgId(config.getInvoiceOrgId());
        showInvoiceParam.setSerialNos(serialNos.stream().collect(Collectors.toList()));
        showInvoiceParam.setTaxRegNum(config.getTaxRegnum());
        if (otherParam != null) {
            showInvoiceParam.setOptMode((String)otherParam.get("optMode"));
            showInvoiceParam.setRelevanceExpenseId((String)otherParam.get("relevanceExpenseId"));
        } else {
            showInvoiceParam.setOptMode("0");
        }
        customParam.put("showInvoiceUrlReqParam", JSON.toJSONString((Object)showInvoiceParam));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("er_invoicecloudpage_pc");
        formShowParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        formShowParameter.setCaption("");
        formShowParameter.setShowTitle(false);
        formShowParameter.getCustomParams().putAll(customParam);
        return formShowParameter;
    }
}

