/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ControlLoanEnum;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang.StringUtils;

public class LoanBalanceServiceHelper {
    private static String CLASSNAME = "LoanBalanceServiceHelper";
    private static final Log log = LogFactory.getLog((String)"LoanBalanceServiceHelper");

    @Deprecated
    public static BigDecimal getPersonalLoanBalance(Long applierId) {
        return LoanBalanceServiceHelper.getPersonalLoanBalance(applierId, null);
    }

    public static BigDecimal getPersonalLoanBalance(Long applierId, Long currencyId) {
        log.info(CLASSNAME + " >>> \u8c03\u7528\u67e5\u8be2\u6240\u6709\u501f\u6b3e\u4f59\u989d");
        BigDecimal dailyLoanAmount = LoanBalanceServiceHelper.getPersonalDailyLoanBalance(applierId, currencyId);
        BigDecimal tripLoanAmount = LoanBalanceServiceHelper.getPersonalTripLoanBalance(applierId, currencyId);
        return dailyLoanAmount.add(tripLoanAmount);
    }

    @Deprecated
    public static BigDecimal getPersonalTripLoanBalance(Long applierId) {
        return LoanBalanceServiceHelper.getPersonalTripLoanBalance(applierId, null);
    }

    public static BigDecimal getPersonalTripLoanBalance(Long applierId, Long currencyId) {
        IErDao tripLoanDao;
        log.info(CLASSNAME + " >>> \u67e5\u8be2\u51fa\u5dee\u501f\u6b3e\u5355\u501f\u6b3e\u5355\u501f\u6b3e\u4f59\u989d");
        String reqBillselectField = "balanceamount as balanceamount";
        QFilter tripLoanFilter = new QFilter("applier", "=", (Object)applierId);
        tripLoanFilter.and(new QFilter("isloan", "=", (Object)"1"));
        tripLoanFilter.and(new QFilter("billstatus", "in", Arrays.asList("F", "G")));
        if (currencyId != null) {
            tripLoanFilter.and(new QFilter("currency", "=", (Object)currencyId));
        }
        if ((tripLoanDao = ErDaoFactory.getInstance("er_tripreqbill")) == null) {
            log.info(CLASSNAME + " >>> tripLoanDao is null");
            return BigDecimal.ZERO;
        }
        DataSet queryDataSet = tripLoanDao.queryDataSet(CLASSNAME, reqBillselectField, tripLoanFilter.toArray());
        if (queryDataSet == null) {
            log.info(CLASSNAME + " >>> queryDataSet is null");
            return BigDecimal.ZERO;
        }
        BigDecimal balanceAmount = BigDecimal.ZERO;
        try {
            DataSet result = queryDataSet.groupBy(null).sum("balanceamount").finish();
            while (result.hasNext()) {
                Row row = result.next();
                balanceAmount = balanceAmount.add((BigDecimal)row.get("balanceamount"));
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            balanceAmount = BigDecimal.ONE;
        }
        return balanceAmount;
    }

    @Deprecated
    public static BigDecimal getPersonalDailyLoanBalance(Long applierId) {
        return LoanBalanceServiceHelper.getPersonalDailyLoanBalance(applierId, null);
    }

    public static BigDecimal getPersonalDailyLoanBalance(Long applierId, Long currencyId) {
        log.info(CLASSNAME + " >>> \u67e5\u8be2\u501f\u6b3e\u5355\u501f\u6b3e\u4f59\u989d");
        QFilter dailyLoanFilter = new QFilter("applier", "=", (Object)applierId);
        dailyLoanFilter.and(new QFilter("billstatus", "in", Arrays.asList("F", "G")));
        if (currencyId != null) {
            dailyLoanFilter.and(new QFilter("currency", "=", (Object)currencyId));
        }
        IErDao dailyLoanDao = ErDaoFactory.getInstance("er_dailyloanbill");
        String loanBillSelectField = "balanceamount as balanceamount";
        if (dailyLoanDao == null) {
            log.info(CLASSNAME + " >>> dailyLoanDao is null");
            return BigDecimal.ZERO;
        }
        DataSet dailyLoanDataSet = dailyLoanDao.queryDataSet(CLASSNAME, loanBillSelectField, dailyLoanFilter.toArray());
        if (dailyLoanDataSet == null) {
            log.info(CLASSNAME + " >>> dailyLoanDataSet is null");
            return BigDecimal.ZERO;
        }
        BigDecimal balanceAmount = BigDecimal.ZERO;
        try {
            DataSet result = dailyLoanDataSet.groupBy(null).sum("balanceamount").finish();
            while (result.hasNext()) {
                Row row = result.next();
                balanceAmount = balanceAmount.add((BigDecimal)row.get("balanceamount"));
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            balanceAmount = BigDecimal.ZERO;
        }
        return balanceAmount;
    }

    public static String getloanBillMsg(DynamicObject company, DynamicObject applier) {
        List<DynamicObject> loanBillList;
        StringBuilder msg = new StringBuilder();
        if (company == null || applier == null) {
            return msg.toString();
        }
        String controlType = (String)ErCommonUtils.getEMParameter((Long)company.getPkValue(), "controlloan");
        if (StringUtils.equals((String)ControlLoanEnum.APPLIER_CONTROL.getType(), (String)controlType) && !(loanBillList = LoanBalanceServiceHelper.getPersonalLoanBalance(applier, company)).isEmpty()) {
            msg.append(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u8bf7\u4eba\u5b58\u5728\u672a\u8fd8\u501f\u6b3e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u501f\u6b3e\u3002 \n", (String)"LoanBalanceServiceHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
            loanBillList.forEach(v -> msg.append(ResManager.loadKDString((String)"\u5355\u53f7:", (String)"LoanBalanceServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0])).append(v.getString("billno")).append(",").append(ResManager.loadKDString((String)"\u672a\u8fd8\u91d1\u989d:", (String)"LoanBalanceServiceHelper_2", (String)"fi-er-business", (Object[])new Object[0])).append(ErCommonUtils.getMoneyStringWithSymbol(v.getBigDecimal("balanceamount"), new CurrencyBO((Long)v.getDynamicObject("currency").getPkValue()))).append("\u3002\n"));
        }
        return msg.toString();
    }

    private static List<DynamicObject> getPersonalLoanBalance(DynamicObject applier, DynamicObject company) {
        ArrayList<DynamicObject> DOList = new ArrayList<DynamicObject>();
        Long applierId = (Long)applier.getPkValue();
        String selectField = "billno, balanceamount, currency,formid";
        QFilter commonFilter = new QFilter("applier", "=", (Object)applierId);
        commonFilter.and(new QFilter("balanceamount", ">", (Object)0));
        commonFilter.and(new QFilter("billstatus", "=", (Object)"G"));
        QFilter tripLoanFilter = new QFilter("isloan", "=", (Object)"1");
        DynamicObject[] reqLoanBills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)(selectField + ",tripentry, tripentry.tripexpenseitem, tripentry.oriaccbalanceamount"), (QFilter[])new QFilter[]{commonFilter, tripLoanFilter});
        Arrays.stream(reqLoanBills).forEach(v -> DOList.add((DynamicObject)v));
        boolean storageLimits = ErCommonUtils.storageLimits(ErCommonUtils.getPk(company), "er_dailyloanbill");
        DynamicObject[] dailyLoanBills = BusinessDataServiceHelper.load((String)"er_dailyloanbill", (String)(selectField + ",expenseentryentity, expenseentryentity.expenseitem, expenseentryentity.orgiexpebalanceamount,accountentry,accountentry.payertype"), (QFilter[])new QFilter[]{commonFilter});
        Arrays.stream(dailyLoanBills).forEach(v -> {
            DynamicObjectCollection accEntrys = v.getDynamicObjectCollection("accountentry");
            accEntrys.stream().forEach(entry -> {
                String payerType = entry.getString("payertype");
                if (PayerTypeEnum.PAYER.getType().equals(payerType) || storageLimits) {
                    DOList.add((DynamicObject)v);
                    return;
                }
            });
        });
        return DOList;
    }

    public static String getloanBillMsg(DynamicObject company, DynamicObject applier, Set<Long> expItemSet) {
        String controlType = (String)ErCommonUtils.getEMParameter((Long)company.getPkValue(), "controlloan");
        if (StringUtils.equals((String)controlType, (String)ControlLoanEnum.NO_CONTROL.getType())) {
            return "";
        }
        if (StringUtils.equals((String)controlType, (String)ControlLoanEnum.APPLIER_CONTROL.getType())) {
            return LoanBalanceServiceHelper.getloanBillMsg(company, applier);
        }
        if (StringUtils.equals((String)controlType, (String)ControlLoanEnum.APPLIER_ITEM_CONTROL.getType())) {
            List<DynamicObject> billList = LoanBalanceServiceHelper.getPersonalLoanBalance(applier, company);
            HashMap<Long, StringBuilder> msgMap = new HashMap<Long, StringBuilder>(16);
            for (int i = 0; i < billList.size(); ++i) {
                String amountName;
                String itemName;
                String entryName;
                DynamicObject bill = billList.get(i);
                DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
                if (properties.containsKey((Object)"tripentry")) {
                    entryName = "tripentry";
                    itemName = "tripexpenseitem";
                    amountName = "oriaccbalanceamount";
                } else {
                    entryName = "expenseentryentity";
                    itemName = "expenseitem";
                    amountName = "orgiexpebalanceamount";
                }
                DynamicObjectCollection entry2 = bill.getDynamicObjectCollection(entryName);
                HashSet<Long> excludeItemSet = new HashSet<Long>(16);
                for (int j = 0; j < entry2.size(); ++j) {
                    DynamicObject row = (DynamicObject)entry2.get(j);
                    Long itemPk = ErCommonUtils.getPk(row.get(itemName));
                    if (row.getBigDecimal(amountName).compareTo(BigDecimal.ZERO) <= 0 || !expItemSet.contains(itemPk)) continue;
                    if (!msgMap.containsKey(itemPk)) {
                        excludeItemSet.add(itemPk);
                        msgMap.put(itemPk, new StringBuilder(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee:", (String)"LoanBalanceServiceHelper_3", (String)"fi-er-business", (Object[])new Object[0])).append(row.getDynamicObject(itemName).getString("name")).append(ResManager.loadKDString((String)"\u5728\u5355\u636e: ", (String)"LoanBalanceServiceHelper_4", (String)"fi-er-business", (Object[])new Object[0])).append(bill.getString("billno")).append(" "));
                        continue;
                    }
                    if (excludeItemSet.contains(itemPk)) continue;
                    msgMap.put(itemPk, ((StringBuilder)msgMap.get(itemPk)).append(",").append(bill.getString("billno"))).append(" ");
                }
            }
            if (msgMap.isEmpty()) {
                return "";
            }
            String msgPrefix = ResManager.loadKDString((String)"\u7533\u8bf7\u4eba:", (String)"LoanBalanceServiceHelper_5", (String)"fi-er-business", (Object[])new Object[0]) + applier.getString("name") + "\u3001";
            String msgSuffix = ResManager.loadKDString((String)"\u4e2d\u5b58\u5728\u672a\u8fd8\u501f\u6b3e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u501f\u6b3e\u3002", (String)"LoanBalanceServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]);
            return msgMap.entrySet().stream().map(entry -> ((StringBuilder)entry.getValue()).toString()).collect(Collectors.joining("\n", msgPrefix, msgSuffix));
        }
        return "";
    }
}

