/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgServiceHelper {
    private static final Set<String> companyPatterns = new HashSet<String>(2);

    public static DynamicObject getCompanyBy(long orgId) {
        DynamicObject orgDO = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        if (OrgServiceHelper.isCompany(orgDO)) {
            return orgDO;
        }
        List allSuperiorIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)orgId);
        if (allSuperiorIds == null || allSuperiorIds.isEmpty()) {
            return null;
        }
        Map allSuperOrgDOs = BusinessDataServiceHelper.loadFromCache((Object[])allSuperiorIds.toArray(new Long[allSuperiorIds.size()]), (String)"bos_org");
        for (int i = allSuperiorIds.size() - 1; i >= 0; --i) {
            DynamicObject superOrgDO = (DynamicObject)allSuperOrgDOs.get(allSuperiorIds.get(i));
            if (!OrgServiceHelper.isCompany(superOrgDO)) continue;
            return superOrgDO;
        }
        return null;
    }

    public static boolean isCompany(DynamicObject orgDO) {
        DynamicObject patternDO = orgDO.getDynamicObject("orgpattern");
        String patternType = patternDO.getString("patterntype");
        return companyPatterns.contains(patternType);
    }

    public static List<Long> getAllSubOrgWithoutCompany(Long orgId) {
        List<Long> notCompanyOrgPattern = OrgServiceHelper.getNotCompanyOrgPattern();
        return OrgServiceHelper.getAllSubOrgWithoutCompany(orgId, notCompanyOrgPattern);
    }

    private static List<Long> getAllSubOrgWithoutCompany(Long rootOrgId, List<Long> notCompanyOrgPattern) {
        List<Long> levelNoCompanySubOrg = OrgServiceHelper.getLevel1SubOrgWithoutCompany(rootOrgId, notCompanyOrgPattern);
        LinkedList<Long> list = new LinkedList<Long>();
        for (Long org : levelNoCompanySubOrg) {
            list.add(org);
            list.addAll(OrgServiceHelper.getAllSubOrgWithoutCompany(org, notCompanyOrgPattern));
        }
        return list;
    }

    private static List<Long> getLevel1SubOrgWithoutCompany(Long orgId, List<Long> notCompanyOrgPattern) {
        QFilter viewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        viewFilter.and(new QFilter("view.treetype", "=", (Object)"01"));
        QFilter parentQFilter = QFilter.of((String)"parent.id=?", (Object[])new Object[]{orgId});
        Map orgStructureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"id, org", (QFilter[])new QFilter[]{viewFilter, parentQFilter});
        if (orgStructureMap.isEmpty()) {
            return Collections.emptyList();
        }
        List orgIds = orgStructureMap.values().stream().map(entity -> entity.getDynamicObject("org")).filter(orgDO -> orgDO != null).map(orgDO -> (Long)orgDO.getPkValue()).collect(Collectors.toList());
        QFilter orgIdQFilter = new QFilter("id", "in", orgIds);
        QFilter orgPatternQFilter = new QFilter("orgpattern.id", "in", notCompanyOrgPattern);
        Map orgDOs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgIdQFilter, orgPatternQFilter});
        if (orgDOs.isEmpty()) {
            return Collections.emptyList();
        }
        return orgDOs.values().stream().map(entity -> (Long)entity.getPkValue()).collect(Collectors.toList());
    }

    public static List<Long> getNotCompanyOrgPattern() {
        Map patternMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_pattern", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"patterntype=?", (Object[])new Object[]{"3"})});
        if (patternMap.isEmpty()) {
            return Collections.emptyList();
        }
        return patternMap.values().stream().map(entity -> (Long)entity.getPkValue()).collect(Collectors.toList());
    }

    public static DynamicObject getBosOrgStructureDO(Long orgId, Long viewId) {
        QFilter qFilter = QFilter.of((String)"enable = '1' and isfreeze = ? and status = 'C' and org.id = ? and view.id = ?", (Object[])new Object[]{Boolean.FALSE, orgId, viewId});
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean isAccountingOrg(String orgNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)orgNumber).and("fisaccounting", "=", (Object)"1");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return !Objects.isNull(org);
    }

    public static List<Long> getAllSubOrgWithoutCompany(List<Long> companyIds, Boolean includeCur) {
        ArrayList subOrgs = Lists.newArrayList();
        List allSubIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, companyIds, (boolean)false);
        QFilter orgIdQFilter = new QFilter("id", "in", (Object)allSubIds);
        QFilter orgPatternQFilter = new QFilter("orgpattern.patterntype", "=", (Object)"3");
        Map orgDOs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgIdQFilter, orgPatternQFilter});
        subOrgs.addAll(orgDOs.values().stream().map(entity -> (Long)entity.getPkValue()).collect(Collectors.toList()));
        if (includeCur.booleanValue()) {
            subOrgs.addAll(companyIds);
        }
        return subOrgs;
    }

    static {
        companyPatterns.add("1");
        companyPatterns.add("2");
    }
}

