/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang3.ObjectUtils;

public class PayeeServiceHelper {
    private static Log logger = LogFactory.getLog(PayeeServiceHelper.class);
    private static String commonSelectFields = "id,outpayer,payeraccount,payeraccount01,payeraccount02,payerbank,banklogo,backgroundimg,currency,payer,creator,isdefault, payeraccountname";
    private static final String accountEntryHasHiddenFlag = "accountEntryHasHiddenFlag";

    public static void clearLimitInfo(IDataModel model) {
        if (PayeeServiceHelper.storageLimits(model)) {
            IDataEntityProperty payByHeadProp = model.getProperty("ispaybyhead");
            if (payByHeadProp != null) {
                model.setValue("ispaybyhead", (Object)true);
            }
            int entryRowCount = model.getEntryRowCount("accountentry");
            for (int i = 0; i < entryRowCount; ++i) {
                String payerType = (String)model.getValue("payertype", i);
                if (!PayerTypeEnum.PAYER.getType().equals(payerType) && !PayerTypeEnum.OTHER.getType().equals(payerType)) continue;
                model.setValue("payertype", (Object)PayerTypeEnum.OTHER.getType(), i);
                model.setValue("payeraccount01", null, i);
                model.setValue("payeraccount02", null, i);
                model.setValue("payeraccount", null, i);
                model.setValue("payeraccountname", null, i);
                model.setValue("payerbank", null, i);
                model.setValue("payer", null, i);
                model.setValue("payername", (Object)((DynamicObject)model.getValue("applier")).getString("name"), i);
            }
        }
    }

    public static void clearLimitInfo(DynamicObject bill) {
        if (PayeeServiceHelper.storageLimits(bill)) {
            DynamicProperty accountentryProp;
            DynamicProperty payByHeadProp = bill.getDynamicObjectType().getProperty("ispaybyhead");
            if (payByHeadProp != null) {
                bill.set("ispaybyhead", (Object)true);
            }
            if ((accountentryProp = bill.getDynamicObjectType().getProperty("accountentry")) != null) {
                DynamicObjectCollection accountentry = (DynamicObjectCollection)accountentryProp.getValue((Object)bill);
                for (int i = 0; i < accountentry.size(); ++i) {
                    String payerType = ((DynamicObject)accountentry.get(i)).getString("payertype");
                    if (!PayerTypeEnum.PAYER.getType().equals(payerType) && !PayerTypeEnum.OTHER.getType().equals(payerType)) continue;
                    ((DynamicObject)accountentry.get(i)).set("payertype", (Object)PayerTypeEnum.OTHER.getType());
                    ((DynamicObject)accountentry.get(i)).set("payeraccount01", null);
                    ((DynamicObject)accountentry.get(i)).set("payeraccount02", null);
                    ((DynamicObject)accountentry.get(i)).set("payeraccount", null);
                    ((DynamicObject)accountentry.get(i)).set("payeraccountname", null);
                    ((DynamicObject)accountentry.get(i)).set("payerbank", null);
                    ((DynamicObject)accountentry.get(i)).set("payer", null);
                    ((DynamicObject)accountentry.get(i)).set("payername", (Object)bill.getDynamicObject("applier").getString("name"));
                }
            }
        }
    }

    private static boolean storageLimits(IDataModel model) {
        Object company;
        String entityType = model.getDataEntityType().getName();
        IDataEntityProperty property = model.getProperty("company");
        return property != null && (company = model.getValue("company")) instanceof DynamicObject && ErCommonUtils.storageLimits((Long)((DynamicObject)company).getPkValue(), entityType);
    }

    public static boolean storageLimits(DynamicObject bill) {
        DynamicObject company = bill.getDynamicObject("company");
        String entityType = bill.getDataEntityType().getName();
        return company != null && ErCommonUtils.storageLimits((Long)company.getPkValue(), entityType);
    }

    public static void viewStorageLimits(IFormView view) {
        IDataModel model = view.getModel();
        if (PayeeServiceHelper.storageLimits(model)) {
            view.setVisible(Boolean.valueOf(false), PayeeServiceHelper.getAccountEntryFlexName(view));
            view.getPageCache().put(accountEntryHasHiddenFlag, "1");
        } else if (view.getPageCache().get(accountEntryHasHiddenFlag) != null) {
            view.setVisible(Boolean.valueOf(true), PayeeServiceHelper.getAccountEntryFlexName(view));
            view.getPageCache().remove(accountEntryHasHiddenFlag);
        }
    }

    private static String[] getAccountEntryFlexName(IFormView view) {
        if (view instanceof IMobileView) {
            return new String[]{"accountflex", "flex_accountentryblock"};
        }
        if (ErEntityTypeUtils.isDailyReimburseBill(view.getEntityId())) {
            return new String[]{"advconap21"};
        }
        if (ErEntityTypeUtils.isDailyLoanBill(view.getEntityId()) || ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
            return new String[]{"advconap2"};
        }
        return new String[]{"accountentry"};
    }

    public static DynamicObject getDefaultAccount(Long userId) {
        QFilter uFilter = new QFilter("creator", "=", (Object)userId).or(new QFilter("payer", "=", (Object)userId));
        uFilter = uFilter.and(new QFilter("isdefault", "=", (Object)Boolean.TRUE));
        List<DynamicObject> defaultAccountsMap = PayeeServiceHelper.getEnableAccountByFilter(uFilter);
        DynamicObject defaultAccByCreator = null;
        DynamicObject defaultAccByPayer = null;
        DynamicObject defaultAccByAll = null;
        if (defaultAccountsMap != null && defaultAccountsMap.size() > 0) {
            for (DynamicObject acct : defaultAccountsMap) {
                Long payerId;
                if (acct == null) continue;
                Long creatorId = acct.getLong("creator_id");
                if (creatorId.equals(payerId = Long.valueOf(acct.getLong("payer_id"))) && defaultAccByAll == null) {
                    defaultAccByAll = acct;
                    continue;
                }
                if (payerId.equals(userId) && defaultAccByPayer == null) {
                    defaultAccByPayer = acct;
                    continue;
                }
                if (!creatorId.equals(userId) || defaultAccByCreator != null) continue;
                defaultAccByCreator = acct;
            }
        }
        if (defaultAccByAll != null) {
            return defaultAccByAll;
        }
        if (defaultAccByPayer != null) {
            return defaultAccByPayer;
        }
        if (defaultAccByCreator != null) {
            return defaultAccByCreator;
        }
        return null;
    }

    public static DynamicObject getSingleAccountByPayerID(Long userId) {
        List<DynamicObject> acctList = PayeeServiceHelper.getPayerAccountByPayerID(userId, false);
        DynamicObject defaultAcct = null;
        DynamicObject creatBySelfAcct = null;
        DynamicObject creatByOtherAcct = null;
        for (DynamicObject acct : acctList) {
            if (defaultAcct == null && acct.getBoolean("isdefault")) {
                defaultAcct = acct;
                continue;
            }
            if (creatBySelfAcct == null && userId.equals(acct.getLong("creator_id"))) {
                creatBySelfAcct = acct;
                continue;
            }
            if (creatByOtherAcct != null || !userId.equals(acct.getLong("payer_id"))) continue;
            creatByOtherAcct = acct;
        }
        if (defaultAcct != null) {
            return defaultAcct;
        }
        if (creatBySelfAcct != null) {
            return creatBySelfAcct;
        }
        return creatByOtherAcct;
    }

    public static DynamicObject getDefaultPayMode() {
        QFilter qFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFileds = "id,name,number,settlementtype";
        DynamicObject payMode = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)selectFileds, (QFilter[])qFilters);
        return payMode;
    }

    public static List<DynamicObject> getPayerAccountByCreatorID(Long creatorID, boolean isIncludeUnEnable) {
        QFilter uFilter = new QFilter("creator", "=", (Object)creatorID);
        if (isIncludeUnEnable) {
            return PayeeServiceHelper.getPayerAccountByFilter(uFilter);
        }
        return PayeeServiceHelper.getEnableAccountByFilter(uFilter);
    }

    public static List<DynamicObject> getPayerAccountByPayerID(Long payerID, boolean isIncludeUnEnable) {
        QFilter pFilter = new QFilter("payer", "=", (Object)payerID);
        if (isIncludeUnEnable) {
            return PayeeServiceHelper.getPayerAccountByFilter(pFilter);
        }
        return PayeeServiceHelper.getEnableAccountByFilter(pFilter);
    }

    private static List<DynamicObject> getEnableAccountByFilter(QFilter filter) {
        QFilter qFilter = filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return PayeeServiceHelper.getPayerAccountByFilter(qFilter);
    }

    public static List<DynamicObject> getPayerAccountByFilter(QFilter filter) {
        List<DynamicObject> dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)commonSelectFields, (QFilter[])new QFilter[]{filter}).entrySet().stream().map(t -> (DynamicObject)t.getValue()).collect(Collectors.toList());
        return dynamicObjects;
    }

    public static void changeIsDefaultPayers(Long userId, Object curPayInfoPkID) {
        List<DynamicObject> payAccounts = PayeeServiceHelper.getOtherDefaultAccountByPayerID(userId, curPayInfoPkID, true);
        if (payAccounts != null && payAccounts.size() > 0) {
            for (DynamicObject payAcc : payAccounts) {
                payAcc.set("isdefault", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.update((DynamicObject[])payAccounts.toArray(new DynamicObject[payAccounts.size()]));
        }
    }

    public static List<DynamicObject> getOtherDefaultAccountByPayerID(Long payerID, Object curPayInfoPkID, boolean isIncludeUnEnable) {
        List<DynamicObject> acctsOfPayerID = PayeeServiceHelper.getPayerAccountByPayerID(payerID, isIncludeUnEnable);
        Iterator<DynamicObject> acctIter = acctsOfPayerID.iterator();
        while (acctIter.hasNext()) {
            DynamicObject acct = acctIter.next();
            if (acct.getBoolean("isdefault") && !acct.getPkValue().equals(curPayInfoPkID)) continue;
            acctIter.remove();
        }
        return acctsOfPayerID;
    }

    public static Map<String, String> getPayerBankPicUrl(String numForFinorg) {
        QFilter filter;
        QFilter[] qFilters;
        HashMap<String, String> map = new HashMap<String, String>(2);
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query("bd_finorginfo", "id, logo", qFilters = new QFilter[]{filter = new QFilter("number", "=", (Object)numForFinorg)});
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                String logo = dynamicObject.getString("logo");
                String backgroundimg = "";
                map.put("logo", logo);
                map.put("backgroundimg", backgroundimg);
            }
        }
        return map;
    }

    public static Map<String, String> getAllTypePayerAccount(String payeraccount) {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        if (payeraccount != null) {
            String payeraccount01 = null;
            String payeraccount02 = null;
            String payersub = null;
            int payeraccountLen = payeraccount.length();
            if (payeraccountLen < 4) {
                payeraccount01 = payeraccount;
                payeraccount02 = payeraccount;
            } else if (payeraccountLen >= 4 && payeraccountLen < 10) {
                payersub = payeraccount.substring(payeraccount.length() - 4, payeraccount.length());
                payeraccount01 = "(*" + payersub + ")";
                payeraccount02 = payeraccount;
            } else if (payeraccountLen >= 10) {
                payersub = payeraccount.substring(payeraccount.length() - 4, payeraccount.length());
                payeraccount01 = "(*" + payersub + ")";
                String payerstr02 = payeraccount.substring(0, 6);
                payeraccount02 = payerstr02 + " *** " + payersub;
            }
            ret.put("payeraccount01", payeraccount01);
            ret.put("payeraccount02", payeraccount02);
        }
        return ret;
    }

    @Deprecated
    public static void getPayeeF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        ListShowParameter accountF7Param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        Long userId = CommonServiceHelper.getCurrentUserID();
        DynamicObject applier = (DynamicObject)view.getModel().getValue("applier");
        Long applierId = 0L;
        if (applier != null) {
            applierId = (Long)applier.getPkValue();
        }
        PayeeServiceHelper.setPayeeF7FilterByApplierAndCurrentUser(accountF7Param, applierId, userId);
    }

    @Deprecated
    public static void setPayeeF7FilterByApplierAndCurrentUser(ListShowParameter accountF7Param, Long applierId, Long userId) {
        ArrayList<Long> userIdCollection = new ArrayList<Long>(2);
        userIdCollection.add(applierId);
        userIdCollection.add(userId);
        accountF7Param.getListFilterParameter().getQFilters().add(PayeeServiceHelper.getPayeeF7Filter(userIdCollection, userIdCollection, userIdCollection));
    }

    public static QFilter getPayeeF7Filter(List<Long> payerIdCollection, List<Long> creatorIdCollection, List<Long> authUerBaseDataIdColl) {
        List<Object> authPayerInfoId = PayeeServiceHelper.getPayerAuthUserId(authUerBaseDataIdColl);
        QFilter resultFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter prFilter = new QFilter("payer", "in", payerIdCollection);
        prFilter = prFilter.or("creator", "in", creatorIdCollection);
        resultFilter = resultFilter.and(prFilter);
        logger.info("kd.fi.er.business.servicehelper.PayeeServiceHelper.getPayeeF7Filter QFilter:" + resultFilter);
        QFilter[] qFilters = new QFilter[]{resultFilter};
        String selectPayeePros = "id,payerbank,outpayer,payeraccount";
        DynamicObject[] query = (DynamicObject[])QueryServiceHelper.query((String)"er_payeer", (String)selectPayeePros, (QFilter[])qFilters).toArray((Object[])new DynamicObject[0]);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)query.length);
        HashSet<String> distinctSet = new HashSet<String>(query.length);
        for (int i = 0; i < query.length; ++i) {
            DynamicObject dynamicObject = query[i];
            Long pkId = dynamicObject.getLong("id");
            String payerAccountInfo = dynamicObject.getString("outpayer") + dynamicObject.getString("payerbank") + dynamicObject.getString("payeraccount");
            if (!distinctSet.add(payerAccountInfo)) continue;
            list.add(pkId);
        }
        list.addAll(authPayerInfoId);
        resultFilter = new QFilter("id", "in", (Object)list.toArray());
        logger.info("kd.fi.er.business.servicehelper.PayeeServiceHelper.getPayeeF7Filter after QFilter ids[]:" + list);
        return resultFilter;
    }

    @Deprecated
    public static List<Object> getPayerAuthUserId(Long userId, Long applierId) {
        ArrayList<Long> authUerBaseDataIdColl = new ArrayList<Long>(2);
        authUerBaseDataIdColl.add(userId);
        authUerBaseDataIdColl.add(applierId);
        return PayeeServiceHelper.getPayerAuthUserId(authUerBaseDataIdColl);
    }

    public static List<Object> getPayerAuthUserId(List<Long> authUerBaseDataIdColl) {
        final ArrayList<Object> list = new ArrayList<Object>();
        if (authUerBaseDataIdColl == null || authUerBaseDataIdColl.size() <= 0) {
            return list;
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("SELECT a.FID as payerid,a.FBasedataId as payerUserid ");
        sqlBuffer.append("FROM t_er_payeeuser a ");
        sqlBuffer.append("where a.FBasedataId in (");
        for (int i = 0; i < authUerBaseDataIdColl.size(); ++i) {
            sqlBuffer.append(authUerBaseDataIdColl.get(i));
            if (i >= authUerBaseDataIdColl.size() - 1) continue;
            sqlBuffer.append(",");
        }
        sqlBuffer.append(") ");
        logger.info("getPayerAuthUserId-sqlBuffersql" + sqlBuffer);
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)sqlBuffer.toString(), (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    list.add(rs.getLong("payerid"));
                }
                return null;
            }
        });
        return list;
    }

    public static void defualtCurrencySetting(AfterAddRowEventArgs e, IDataModel model, IFormView view) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)model.getValue("company")).getPkValue());
        }
        Long tragCurrency = null;
        if (rowDataEntities.length > 0) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                Object oldAccountCurrency;
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                DynamicObject paymode = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("accountentry").get(rowIndex)).getDynamicObject("paymode");
                if (paymode == null) {
                    paymode = PayeeServiceHelper.getDefaultPayMode();
                }
                if ((oldAccountCurrency = model.getValue("accountcurrency", rowIndex)) == null) {
                    model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
                }
                model.setValue("paymode", paymode == null ? null : paymode.getPkValue(), rowIndex);
                String billType = model.getDataEntity().getDynamicObjectType().getName();
                if (rowIndex != 0) continue;
                if (!ErEntityTypeUtils.isPublicReimburseBill(billType) && !ErEntityTypeUtils.isDailyLoanBill(billType)) {
                    Object currentUser = model.getValue("applier");
                    DynamicObject payer = null;
                    if (currentUser != null) {
                        payer = PayeeServiceHelper.getDefaultAccount(Long.valueOf(((DynamicObject)currentUser).getPkValue().toString()));
                    }
                    model.setValue("payer", payer == null ? null : payer.getPkValue(), rowIndex);
                    if ("1".equals(isgetaccountcurrency)) {
                        Map<Object, Object> exchangeMap = new HashMap();
                        model.setValue("iscurrency", (Object)Boolean.TRUE);
                        if (payer != null && payer.get("currency") != null) {
                            tragCurrency = payer.get("currency") == null ? null : ErCommonUtils.getPk(payer.get("currency"));
                        } else {
                            Long l = tragCurrency = currency == null ? null : (Long)currency.getPkValue();
                        }
                        if (tragCurrency != null) {
                            exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(tragCurrency, model);
                        }
                        model.setValue("accountcurrency", (Object)tragCurrency, rowIndex);
                        model.beginInit();
                        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                        BigDecimal accchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ZERO);
                        model.setValue("accquotetype", (Object)quoteType, rowIndex);
                        model.setValue("accexchangerate", (Object)accchangeRate, rowIndex);
                        model.endInit();
                        view.updateView("accountcurrency", rowIndex);
                        view.updateView("accexchangerate", rowIndex);
                    } else if ("0".equals(isgetaccountcurrency)) {
                        tragCurrency = model.getValue("currency") != null ? (Long)((DynamicObject)model.getValue("currency")).getPkValue() : null;
                    }
                } else if (ErEntityTypeUtils.isPublicReimburseBill(billType) || ErEntityTypeUtils.isDailyLoanBill(billType) || ErEntityTypeUtils.isPrePayBill(billType)) {
                    if ("0".equals(isgetaccountcurrency)) {
                        tragCurrency = currency == null ? null : (Long)currency.getPkValue();
                        model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
                    } else {
                        tragCurrency = model.getValue("accountcurrency", rowIndex) == null ? null : (Long)((DynamicObject)model.getValue("accountcurrency", rowIndex)).getPkValue();
                    }
                }
                BigDecimal payAmount = BigDecimal.ZERO;
                String loanType = "1";
                if (ErEntityTypeUtils.isDailyReimburseBill(billType) || ErEntityTypeUtils.isPublicReimburseBill(billType)) {
                    payAmount = (BigDecimal)model.getValue("payamount");
                    loanType = (String)model.getValue("writeofftype");
                } else if (ErEntityTypeUtils.isDailyLoanBill(billType)) {
                    payAmount = (BigDecimal)model.getValue("approveamount");
                } else if (ErEntityTypeUtils.isTripReimburseBill(billType)) {
                    payAmount = (BigDecimal)model.getValue("encashamount");
                    loanType = (String)model.getValue("loanchecktype");
                } else if (ErEntityTypeUtils.isTripReqBill(billType)) {
                    payAmount = (BigDecimal)model.getValue("encashamount");
                }
                if (payAmount == null || payAmount.compareTo(BigDecimal.ZERO) <= 0 || tragCurrency == null) continue;
                AmountChangeUtil.setReciveAmount(view, model, payAmount, loanType);
            }
        }
    }
}

