/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class TripExpenseItemServiceHelper {
    public static final Log logger = LogFactory.getLog(TripExpenseItemServiceHelper.class);
    public static final Map<String, String> VEHICLE2ATTRIBUTE;
    public static final Map<String, String> ATTRIBUTE2VEHICLE;
    private static final String FORMID = "er_tripexpenseitem";

    private TripExpenseItemServiceHelper() {
    }

    public static List<Long> getAllTripExpenseiItemIds() {
        return TripExpenseItemServiceHelper.getTripExpenseItemIdsByFilter(null);
    }

    public static List<Long> getTripExpenseItemIdsByCompanyId(Long companyId) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FORMID, (Long)companyId);
        if (baseDataFilter != null) {
            enableFilter.and(baseDataFilter);
        }
        return TripExpenseItemServiceHelper.getTripExpenseItemIdsByFilter(enableFilter);
    }

    public static List<Long> getTripExpenseItemIdsByFilter(QFilter filter) {
        List<Long> tripExpItemIds = new ArrayList<Long>(2);
        DynamicObject[] tripExpenseItems = (DynamicObject[])QueryServiceHelper.query((String)FORMID, (String)"id, name, number", (QFilter[])new QFilter[]{filter}).toArray((Object[])new DynamicObject[0]);
        if (tripExpenseItems.length == 0) {
            return tripExpItemIds;
        }
        tripExpItemIds = Arrays.stream(tripExpenseItems).filter(Objects::nonNull).map(e -> e.getLong("id")).collect(Collectors.toList());
        return tripExpItemIds;
    }

    public static List<Long> getTripExpenseItemByCompanyAndAttribute(Long companyId, String ... attributes) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FORMID, (Long)companyId);
        if (baseDataFilter != null) {
            enableFilter.and(baseDataFilter);
        }
        enableFilter.and(new QFilter("attribute", "in", (Object)attributes));
        return TripExpenseItemServiceHelper.getTripExpenseItemIdsByFilter(enableFilter);
    }

    public static Long getSingleTripExpItemByCompanyAndVehicle(Long companyId, String vehicleType) {
        String selectProps = "id";
        Long tripExpenseItemId = null;
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter attributeFilter = new QFilter("attribute", "=", (Object)VEHICLE2ATTRIBUTE.get(vehicleType));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FORMID, (Long)companyId);
        QFilter isdefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter createOrgFilter = new QFilter("createorg", "=", (Object)companyId);
        DynamicObject tripExpenseItem = null;
        tripExpenseItem = BusinessDataServiceHelper.loadSingle((String)FORMID, (String)selectProps, (QFilter[])new QFilter[]{enableFilter, attributeFilter, baseDataFilter.copy(), isdefaultFilter, createOrgFilter});
        if (tripExpenseItem == null) {
            tripExpenseItem = BusinessDataServiceHelper.loadSingle((String)FORMID, (String)selectProps, (QFilter[])new QFilter[]{enableFilter, attributeFilter, baseDataFilter.copy(), isdefaultFilter});
        }
        if (tripExpenseItem == null) {
            tripExpenseItem = BusinessDataServiceHelper.loadSingle((String)FORMID, (String)selectProps, (QFilter[])new QFilter[]{enableFilter, attributeFilter, baseDataFilter.copy(), createOrgFilter});
        }
        if (tripExpenseItem == null) {
            tripExpenseItem = BusinessDataServiceHelper.loadSingle((String)FORMID, (String)selectProps, (QFilter[])new QFilter[]{enableFilter, attributeFilter, baseDataFilter.copy()});
        }
        if (tripExpenseItem != null) {
            tripExpenseItemId = ErCommonUtils.getPk(tripExpenseItem);
        }
        return tripExpenseItemId;
    }

    public static Map<String, Long> getSingleTripExpItemByCompanyAndVehicle(Long companyId, Set<String> vehicleSet) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Set attributes = vehicleSet.stream().map(v -> VEHICLE2ATTRIBUTE.get(v)).collect(Collectors.toSet());
        QFilter attributeFilter = new QFilter("attribute", "in", attributes);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FORMID, (Long)companyId);
        String selectFields = "id,attribute,createorg,isdefault";
        DynamicObjectCollection tripItems = QueryServiceHelper.query((String)FORMID, (String)selectFields, (QFilter[])new QFilter[]{enableFilter, attributeFilter, baseDataFilter.copy()});
        Map<Object, List<DynamicObject>> tripItemsMap = tripItems.stream().collect(Collectors.groupingBy(v -> v.get("attribute")));
        HashMap<String, Long> tripItemMap = new HashMap<String, Long>(tripItemsMap.size());
        for (Map.Entry<Object, List<DynamicObject>> mapEntry : tripItemsMap.entrySet()) {
            List<DynamicObject> tripItemLst = mapEntry.getValue();
            DynamicObject tripExpenseItem = null;
            if (!tripItemLst.isEmpty()) {
                for (DynamicObject tripItem : tripItemLst) {
                    if (!tripItem.getBoolean("isdefault") || companyId.compareTo(tripItem.getLong("createorg")) != 0) continue;
                    tripExpenseItem = tripItem;
                    break;
                }
                if (tripExpenseItem == null) {
                    for (DynamicObject tripItem : tripItemLst) {
                        if (!tripItem.getBoolean("isdefault")) continue;
                        tripExpenseItem = tripItem;
                        break;
                    }
                }
                if (tripExpenseItem == null) {
                    for (DynamicObject tripItem : tripItemLst) {
                        if (companyId.compareTo(tripItem.getLong("createorg")) != 0) continue;
                        tripExpenseItem = tripItem;
                        break;
                    }
                }
                if (tripExpenseItem == null) {
                    tripExpenseItem = tripItemLst.get(0);
                }
            }
            Long tripExpenseItemId = null;
            if (tripExpenseItem != null) {
                tripExpenseItemId = tripExpenseItem.getLong("id");
            }
            tripItemMap.put(ATTRIBUTE2VEHICLE.get(mapEntry.getKey()), tripExpenseItemId);
        }
        return tripItemMap;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("1", "2");
        temp.put("2", "4");
        temp.put("3", "3");
        temp.put("4", "7");
        VEHICLE2ATTRIBUTE = Collections.unmodifiableMap(temp);
        temp = new HashMap();
        temp.put("2", "1");
        temp.put("4", "2");
        temp.put("3", "3");
        temp.put("7", "4");
        ATTRIBUTE2VEHICLE = Collections.unmodifiableMap(temp);
    }
}

