/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class TripReimburseServiceHelper {
    private static final Log logger = LogFactory.getLog(TripReimburseServiceHelper.class);

    public static void updateTripEntryAmount(DynamicObject targetTripEntry) {
        DynamicObjectCollection reimburseDetails = targetTripEntry.getDynamicObjectCollection("entryentity");
        BigDecimal sumOriAmount = AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "orientryamount");
        BigDecimal sumAmount = AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "entryamount");
        targetTripEntry.set("triporiamount", (Object)sumOriAmount);
        targetTripEntry.set("tripamount", (Object)sumAmount);
        targetTripEntry.set("tripapporiamount", (Object)sumOriAmount);
        targetTripEntry.set("tripappamount", (Object)sumAmount);
        targetTripEntry.set("taxamounttotalori", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "taxamount"));
        targetTripEntry.set("taxamounttotal", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "taxamount"));
        targetTripEntry.set("notaxamounttotalori", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "notaxamount"));
        targetTripEntry.set("notaxamounttotal", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "notaxamount"));
        targetTripEntry.set("tripdeductibletax", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "deductibletax"));
    }

    public static void updateTripEntryAmount(IDataModel model) {
        DynamicObjectCollection tripEntryEntity = model.getEntryEntity("tripentry");
        if (tripEntryEntity != null && tripEntryEntity.size() > 0) {
            for (int tripIdx = 0; tripIdx < tripEntryEntity.size(); ++tripIdx) {
                DynamicObject tripObj = (DynamicObject)tripEntryEntity.get(tripIdx);
                BigDecimal tripAmount = BigDecimal.ZERO;
                BigDecimal tripAppAmount = BigDecimal.ZERO;
                BigDecimal oriTripAmount = BigDecimal.ZERO;
                BigDecimal oriTripAppAmount = BigDecimal.ZERO;
                DynamicObjectCollection entrys = tripObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    tripAmount = tripAmount.add(entry.getBigDecimal("entryamount"));
                    tripAppAmount = tripAppAmount.add(entry.getBigDecimal("entryappamount"));
                    oriTripAmount = oriTripAmount.add(entry.getBigDecimal("orientryamount"));
                    oriTripAppAmount = oriTripAppAmount.add(entry.getBigDecimal("orientryappamount"));
                }
                model.setValue("tripamount", (Object)tripAmount, tripIdx);
                model.setValue("triporiamount", (Object)oriTripAmount, tripIdx);
                model.setValue("tripapporiamount", (Object)oriTripAppAmount, tripIdx);
                model.setValue("tripappamount", (Object)tripAppAmount, tripIdx);
            }
        }
    }

    public static void updateBillHeadAmount(DynamicObject targetBill) {
        List<DynamicObject> entryEntitys = targetBill.getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        List<DynamicObject> monthEntryEntitys = entryEntitys.stream().filter(x -> "2".equals(x.getString("settlementtype"))).collect(Collectors.toList());
        BigDecimal reimburseAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, "entryamount");
        BigDecimal reimburseAppAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, "entryappamount");
        BigDecimal reimburseMonthMountTotal = AmountChangeUtil.sumAmountBy(monthEntryEntitys, "entryappamount");
        targetBill.set("amount", (Object)reimburseAmountTotal);
        targetBill.set("approveamount", (Object)reimburseAppAmountTotal);
        targetBill.set("monthsettleamount", (Object)reimburseMonthMountTotal);
        DynamicObjectCollection entries = targetBill.getDynamicObjectCollection("tripentry");
        BigDecimal finalOffsetamount = BigDecimal.ZERO;
        if (null == entries || entries.isEmpty()) {
            return;
        }
        for (DynamicObject tripentry : entries) {
            DynamicObjectCollection entrys = tripentry.getDynamicObjectCollection("entryentity");
            BigDecimal totalOffsetAmount = entrys.stream().map(v -> v.getBigDecimal("deductibletax")).reduce(BigDecimal.ZERO, BigDecimal::add);
            finalOffsetamount = finalOffsetamount.add(totalOffsetAmount);
        }
        targetBill.set("totaloffsetamount", (Object)finalOffsetamount);
    }

    @Deprecated
    public static void adjuestExpenseDetailOrder(DynamicObjectCollection entrys) {
    }

    public static void adjuestTripEntrys(DynamicObjectCollection entrys) {
        entrys.sort((a, b) -> {
            Long bTripentrysourceid;
            Long aTripentrysourceid = a.getLong("tripentrysourceid");
            if (aTripentrysourceid.compareTo(bTripentrysourceid = Long.valueOf(b.getLong("tripentrysourceid"))) < 0) {
                return -1;
            }
            if (aTripentrysourceid.compareTo(bTripentrysourceid) > 0) {
                return 1;
            }
            return aTripentrysourceid.compareTo(bTripentrysourceid);
        });
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            entry.set("seq", (Object)(i + 1));
        }
    }

    @Deprecated
    public static void whenTripItemChanged(IDataModel model, DynamicObject tripItemDO, int rowIndex) {
        Object company = model.getValue("company");
        Boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(model);
        Boolean offset = company == null ? Boolean.FALSE : SystemParamterUtil.manuallyaddexpenseoffset(ErCommonUtils.getPk(company));
        if (tripItemDO != null) {
            if (isOrgOffset.booleanValue() && offset.booleanValue()) {
                model.setValue("offset", tripItemDO.get("isoffset"), rowIndex);
                model.setValue("taxrate", tripItemDO.get("taxrate"), rowIndex);
            } else {
                model.setValue("offset", (Object)Boolean.FALSE, rowIndex);
                model.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    public static void whenTripItemChanged(IDataModel model, DynamicObject tripItemDO, int rowIndex, int tripIndex) {
        Object company = model.getValue("company");
        Boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(model);
        Boolean offset = company == null ? Boolean.FALSE : SystemParamterUtil.manuallyaddexpenseoffset(ErCommonUtils.getPk(company));
        if (tripItemDO != null) {
            if (isOrgOffset.booleanValue() && offset.booleanValue()) {
                model.setValue("offset", tripItemDO.get("isoffset"), rowIndex, tripIndex);
                model.setValue("taxrate", tripItemDO.get("taxrate"), rowIndex, tripIndex);
            } else {
                model.setValue("offset", (Object)Boolean.FALSE, rowIndex, tripIndex);
                model.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex, tripIndex);
            }
        }
    }

    public static void handleExpenseFieldDefaultValue(IDataModel model) {
        boolean ischanged = model.getDataChanged();
        DynamicObject bill = model.getDataEntity(true);
        DynamicObject costcompany = bill.getDynamicObject("costcompany");
        DynamicObject costdept = bill.getDynamicObject("costdept");
        DynamicObject headexpenseitem = bill.getDynamicObject("headexpenseitem");
        Date headhappendate = bill.getDate("headhappendate");
        DynamicObject company = bill.getDynamicObject("company");
        String costMode = ErCommonUtils.getCostOrgUseMode(company == null ? Long.valueOf(0L) : (Long)company.getPkValue());
        DynamicObjectCollection tripEntrys = bill.getDynamicObjectCollection("tripentry");
        if (tripEntrys != null && tripEntrys.size() > 0) {
            for (int i = 0; i < tripEntrys.size(); ++i) {
                Date tripEntryHappendate;
                DynamicObject tripEntryExpenseitem;
                DynamicObject tripEntryCostdept;
                DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
                DynamicObject tripEntryCostcompany = tripEntry.getDynamicObject("entrycostcompany");
                if (tripEntryCostcompany == null) {
                    model.setValue("entrycostcompany", (Object)costcompany, i);
                }
                if ((tripEntryCostdept = tripEntry.getDynamicObject("entrycostdept")) == null) {
                    model.setValue("entrycostdept", (Object)costdept, i);
                }
                if ((tripEntryExpenseitem = tripEntry.getDynamicObject("tripexpenseitem")) == null) {
                    model.setValue("tripexpenseitem", (Object)headexpenseitem, i);
                }
                if ((tripEntryHappendate = tripEntry.getDate("triphappendate")) == null) {
                    model.setValue("triphappendate", (Object)headhappendate, i);
                }
                DynamicObjectCollection entryEntrys = tripEntry.getDynamicObjectCollection("entryentity");
                Boolean isSettlementtype = false;
                if (entryEntrys != null && entryEntrys.size() > 0) {
                    for (int j = 0; j < entryEntrys.size(); ++j) {
                        String settlementtype;
                        Date entryHappendate;
                        DynamicObject entryExpenseitem;
                        DynamicObject entryCostdept;
                        DynamicObject entry = (DynamicObject)entryEntrys.get(j);
                        DynamicObject entryCostcompany = entry.getDynamicObject("travelcostcompany");
                        if (entryCostcompany == null) {
                            model.setValue("travelcostcompany", (Object)tripEntry.getDynamicObject("entrycostcompany"), j, i);
                        }
                        if ((entryCostdept = entry.getDynamicObject("travelcostdept")) == null) {
                            model.setValue("travelcostdept", (Object)tripEntry.getDynamicObject("entrycostdept"), j, i);
                        }
                        if (!"0".equals(costMode)) {
                            ErCostCenterUtil.initEntryCostCenter(model, "entryentity", j, i);
                        }
                        if ((entryExpenseitem = entry.getDynamicObject("travelexpenseitem")) == null) {
                            Boolean ismultiexpite = false;
                            if (model.getProperty("ismultiexpitem") != null) {
                                ismultiexpite = (Boolean)model.getValue("ismultiexpitem");
                            }
                            if (!ismultiexpite.booleanValue()) {
                                model.setValue("travelexpenseitem", (Object)tripEntry.getDynamicObject("tripexpenseitem"), j, i);
                            }
                            Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)model.getValue("travelexpenseitem", j, i), (DynamicObject)model.getValue("travelcostdept", j, i), model);
                            model.setValue("travelquotactldept", (Object)quotaCtrlDeptId, j, i);
                        }
                        if ((entryHappendate = entry.getDate("travelhappendate")) == null) {
                            model.setValue("travelhappendate", (Object)tripEntry.getDate("triphappendate"), j, i);
                        }
                        if (null == (settlementtype = entry.getString("settlementtype")) || !"2".equals(settlementtype)) continue;
                        isSettlementtype = true;
                    }
                }
                model.setValue("isexistmonthly", (Object)isSettlementtype, i);
            }
        }
        model.setDataChanged(ischanged);
    }
}

