/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper.operation;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ErOperationServiceHelper
extends OperationServiceHelper {
    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult operationResult = ErOperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(ErOperationServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = ErOperationServiceHelper.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("\n");
        }
        return buf.toString();
    }

    public static OperationResult localInvokeOperation(String operationKey, DynamicObject[] dataEntities, OperateOption option) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        String result = operationService.invokeOperation(operationKey, dataEntities, option);
        OperationResult operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)result, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
        if (!operationResult.isSuccess()) {
            throw new KDBizException(ErOperationServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }

    public static OperationResult localInvokeOperation(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        String result = operationService.invokeOperation(operationKey, entityNumber, ids, option);
        OperationResult operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)result, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
        if (!operationResult.isSuccess()) {
            throw new KDBizException(ErOperationServiceHelper.decodeErrorMsg(operationResult));
        }
        return operationResult;
    }
}

