/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.share;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ERHandleBeforeShareService {
    private static final Log logger = LogFactory.getLog(ERHandleBeforeShareService.class);

    public static DynamicObjectCollection buildAndGetDoneEntrys(DynamicObject bill, Boolean isView) {
        Long starttime = System.currentTimeMillis();
        DynamicObjectCollection doneEntrys = new DynamicObjectCollection();
        Boolean isShare = bill.getBoolean("isbeforeshare");
        if (!isShare.booleanValue()) {
            return doneEntrys;
        }
        bill.set("isshared", (Object)true);
        IDataEntityType entityType = bill.getDataEntityType();
        String entityId = entityType.getName();
        Boolean isTripBill = false;
        if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            isTripBill = true;
        }
        DynamicObjectCollection waitEntrys = new DynamicObjectCollection();
        waitEntrys = isTripBill != false ? bill.getDynamicObjectCollection("tripentry") : bill.getDynamicObjectCollection("expenseentryentity");
        if (waitEntrys == null || waitEntrys.size() < 1) {
            return doneEntrys;
        }
        int precision = bill.getDynamicObject("currency").getInt("amtprecision");
        Object shareRule = bill.get("sharerule");
        Object shareMethod = bill.get("sharemethod");
        DynamicObject company = (DynamicObject)bill.get("company");
        Long companyId = null;
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        String taxshareway = "1";
        if (bill.containsProperty("taxshareway")) {
            taxshareway = bill.getString("taxshareway");
        }
        if (isView.booleanValue()) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_sharedetailview");
            DynamicObject shareObject = new DynamicObject((DynamicObjectType)type);
            doneEntrys = shareObject.getDynamicObjectCollection("expenseentryentity");
        } else {
            doneEntrys = bill.getDynamicObjectCollection("sharedetailentry");
        }
        if (doneEntrys != null && doneEntrys.size() > 0) {
            doneEntrys.clear();
        }
        if (ErEntityTypeUtils.isApplyProjectBill(entityId) || ErEntityTypeUtils.isCostEstimateBill(entityId)) {
            for (int i = 0; i < waitEntrys.size(); ++i) {
                DynamicObject expenEntry = (DynamicObject)waitEntrys.get(i);
                DynamicObjectCollection packagetEntrys = new DynamicObjectCollection();
                packagetEntrys.add((Object)expenEntry);
                DynamicObjectCollection newWaitEntrys = ERHandleBeforeShareService.packageWaitEntry(false, packagetEntrys);
                DynamicObjectCollection ruleEntrys = expenEntry.getDynamicObjectCollection("expenseentryentity_rule");
                ERHandleBeforeShareService.handlDoneEntry(entityId, isView, precision, shareRule, shareMethod, newWaitEntrys, ruleEntrys, doneEntrys, companyId, taxshareway);
            }
        } else {
            DynamicObjectCollection newWaitEntrys = ERHandleBeforeShareService.packageWaitEntry(isTripBill, waitEntrys);
            DynamicObjectCollection ruleEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
            DynamicObjectCollection packagetEntrys = new DynamicObjectCollection();
            for (int j = 0; j < newWaitEntrys.size(); ++j) {
                DynamicObject waitEntry = (DynamicObject)newWaitEntrys.get(j);
                if (packagetEntrys != null && packagetEntrys.size() > 0) {
                    packagetEntrys.clear();
                }
                packagetEntrys.add((Object)waitEntry);
                DynamicObjectCollection newRuleEntrys = (DynamicObjectCollection)ruleEntrys.clone();
                if (!isTripBill.booleanValue() && ("amount".equalsIgnoreCase(shareMethod.toString()) || "expenseitemrule".equalsIgnoreCase(shareRule.toString()))) {
                    newRuleEntrys.clear();
                    newRuleEntrys.addAll((Collection)ruleEntrys.stream().filter(ruleEntry -> Long.valueOf(waitEntry.getString("sourceentryid")).compareTo(ruleEntry.getLong("sharewaitid_comrule")) == 0).collect(Collectors.toList()));
                    if (newRuleEntrys == null || newRuleEntrys.size() < 1) {
                        newRuleEntrys.addNew();
                    }
                }
                ERHandleBeforeShareService.handlDoneEntry(entityId, isView, precision, shareRule, shareMethod, packagetEntrys, newRuleEntrys, doneEntrys, companyId, taxshareway);
            }
            if (newWaitEntrys != null && newWaitEntrys.size() > 0) {
                ERHandleBeforeShareService.dealAmountTailDifference(doneEntrys, (DynamicObject)newWaitEntrys.get(newWaitEntrys.size() - 1), true);
            }
        }
        Long endtime = System.currentTimeMillis();
        logger.info("\u5206\u644a\u7ed3\u675f\uff0c\u6b64\u6b21\u5206\u644a\u5171\u8ba1\u82b1\u8d39\u65f6\u957f>>>>>>>>>>>>>>>>>>>>>" + (endtime - starttime) / 1000L + "s");
        return doneEntrys;
    }

    private static DynamicObjectCollection packageWaitEntry(Boolean isTripBill, DynamicObjectCollection expEntrys) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_sharedetailview");
        DynamicObject shareObject = new DynamicObject((DynamicObjectType)type);
        DynamicObjectCollection waitEntrys = shareObject.getDynamicObjectCollection("expenseentryentity_wait");
        DataEntityPropertyCollection waitEntryProps = waitEntrys.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection expEntryProps = expEntrys.getDynamicObjectType().getProperties();
        long[] ids = ERHandleBeforeShareService.getTripEntryDetailNums(expEntrys, isTripBill);
        int count = 0;
        for (int i = 0; i < expEntrys.size(); ++i) {
            DynamicObject expEntry = (DynamicObject)expEntrys.get(i);
            if (isTripBill.booleanValue()) {
                DynamicObjectCollection tripDetailEntrys = expEntry.getDynamicObjectCollection("entryentity");
                if (tripDetailEntrys == null || tripDetailEntrys.size() == 0) continue;
                DataEntityPropertyCollection tripDetailEntryProps = tripDetailEntrys.getDynamicObjectType().getProperties();
                for (int m = 0; m < tripDetailEntrys.size(); ++m) {
                    Long entryId;
                    DynamicObject tripDetailEntry = (DynamicObject)tripDetailEntrys.get(m);
                    BigDecimal oriEntryAmount = tripDetailEntry.getBigDecimal("orientryamount");
                    if (oriEntryAmount == null || oriEntryAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    DynamicObject waitEntry = waitEntrys.addNew();
                    tripDetailEntryProps.forEach(tripDetailEntryProp -> {
                        String tripDetailEntryPropName = tripDetailEntryProp.getName();
                        waitEntryProps.forEach(waitEntryProp -> {
                            String waitEntryPropName = waitEntryProp.getName();
                            if (!(!waitEntryPropName.contains(tripDetailEntryPropName) || tripDetailEntryPropName.contains("id") || waitEntryPropName.equalsIgnoreCase("seq") || waitEntryPropName.equalsIgnoreCase("id") || tripDetailEntryPropName.equalsIgnoreCase("expenseitem") || tripDetailEntryPropName.equalsIgnoreCase("isallowedittaxtaxrate"))) {
                                waitEntry.set(waitEntryPropName, tripDetailEntry.get(tripDetailEntryPropName));
                            }
                        });
                    });
                    waitEntry.set("tripitem_wait", tripDetailEntry.get("expenseitem"));
                    waitEntry.set("expenseamount_wait", (Object)tripDetailEntry.getBigDecimal("orientryamount"));
                    waitEntry.set("currexpenseamount_wait", (Object)tripDetailEntry.getBigDecimal("entryamount"));
                    waitEntry.set("expeapproveamount_wait", (Object)tripDetailEntry.getBigDecimal("orientryappamount"));
                    waitEntry.set("expeapprovecurramount_w", (Object)tripDetailEntry.getBigDecimal("entryappamount"));
                    waitEntry.set("expquotetype_wait", (Object)tripDetailEntry.getBigDecimal("detailquotetype"));
                    waitEntry.set("entrycostcompany_wait", tripDetailEntry.get("travelcostcompany"));
                    waitEntry.set("entrycostdept_wait", tripDetailEntry.get("travelcostdept"));
                    waitEntry.set("expenseitem_wait", tripDetailEntry.get("travelexpenseitem"));
                    waitEntry.set("std_entrycostcenter_wait", tripDetailEntry.get("travelcostcenter"));
                    if (expEntry.get("std_project") != null) {
                        waitEntry.set("std_project_wait", expEntry.get("std_project"));
                    }
                    if (Objects.equals(entryId = (Long)tripDetailEntry.getPkValue(), 0L) && ids != null && ids.length > 0) {
                        tripDetailEntry.set("id", (Object)ids[count++]);
                    }
                    waitEntry.set("sourceentryid", tripDetailEntry.getPkValue());
                }
                continue;
            }
            BigDecimal waitAmount = expEntry.getBigDecimal("expenseamount");
            if (waitAmount == null || waitAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject waitEntry = waitEntrys.addNew();
            expEntryProps.forEach(expEntryProp -> {
                String expEntryPropName = expEntryProp.getName();
                waitEntryProps.forEach(waitEntryProp -> {
                    String waitEntryPropName = waitEntryProp.getName();
                    if (waitEntryPropName.contains(expEntryPropName) && !expEntryPropName.contains("id") && !waitEntryPropName.equalsIgnoreCase("seq") && !waitEntryPropName.equalsIgnoreCase("id")) {
                        waitEntry.set(waitEntryPropName, expEntry.get(expEntryPropName));
                    }
                });
            });
            waitEntry.set("sourceentryid", expEntry.getPkValue());
        }
        return waitEntrys;
    }

    private static void handlDoneEntry(String entityId, Boolean isShareDetailView, int precision, Object shareRule, Object shareMethod, DynamicObjectCollection waitEntrys, DynamicObjectCollection ruleEntrys, DynamicObjectCollection doneEntrys, Long companyId, String taxShareWay) {
        List totalRulesAmountList;
        DataEntityPropertyCollection waitEntryProps = waitEntrys.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection ruleEntryProps = ruleEntrys.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection doneEntryProps = doneEntrys.getDynamicObjectType().getProperties();
        if (StringUtils.equals((CharSequence)shareRule.toString(), (CharSequence)"yearrule")) {
            shareRule = "monthrule";
        }
        Object shareRuleNew = shareRule;
        BigDecimal totalShareRate = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalRulesAmount = BigDecimal.ZERO;
        if ("amount".equalsIgnoreCase(shareMethod.toString()) && ErEntityTypeUtils.isTripReimburseBill(entityId) && !(totalRulesAmountList = ruleEntrys.stream().map(v -> v.getBigDecimal("shareamount_comrule")).collect(Collectors.toList())).isEmpty()) {
            for (BigDecimal amount : totalRulesAmountList) {
                totalRulesAmount = totalRulesAmount.add(amount).setScale(precision, RoundingMode.HALF_UP);
            }
        }
        String approveTaxFormulaType = ErStdConfig.getApproveTaxFormulaType();
        int size = waitEntrys.size();
        for (int j = 0; j < size; ++j) {
            DynamicObject waitEntry = (DynamicObject)waitEntrys.get(j);
            int entryPrecision = waitEntry.getDynamicObject("entrycurrency_wait").getInt("amtprecision");
            BigDecimal waitAmount = waitEntry.getBigDecimal("expenseamount_wait");
            BigDecimal waitAmountCurr = waitEntry.getBigDecimal("currexpenseamount_wait");
            BigDecimal waitApproveAmount = waitEntry.getBigDecimal("expeapproveamount_wait");
            BigDecimal waitApproveAmountCurr = waitEntry.getBigDecimal("expeapprovecurramount_w");
            BigDecimal waitTaxAmount = waitEntry.getBigDecimal("taxamount_wait");
            BigDecimal waitApproveTax = waitEntry.getBigDecimal("approvetax_wait");
            BigDecimal waitDeTaxAmount = waitEntry.getBigDecimal("deductibletax_wait");
            BigDecimal waitItemInoutAmount = waitEntry.getBigDecimal("iteminoutamount_wait");
            BigDecimal waitCurprice = waitEntry.getBigDecimal("curprice_wait");
            BigDecimal balanceWaitAmount = waitAmount;
            BigDecimal balanceWaitAmountCurr = waitAmountCurr;
            BigDecimal balanceWaitApproveAmount = waitApproveAmount;
            BigDecimal balanceWaitApproveAmountCurr = waitApproveAmountCurr;
            BigDecimal balanceWaitTaxAmount = waitTaxAmount;
            BigDecimal balanceWaitApproveTax = waitApproveTax;
            BigDecimal balanceWaitDeTaxAmount = waitDeTaxAmount;
            BigDecimal balanceWaitItemInoutAmount = waitItemInoutAmount;
            BigDecimal balanceWaitCurprice = waitCurprice;
            int ruleEntrySize = ruleEntrys.size();
            BigDecimal shareNum = new BigDecimal(ruleEntrySize);
            for (int i = 0; i < ruleEntrySize; ++i) {
                BigDecimal shareRate;
                BigDecimal approveTax;
                BigDecimal taxAmount;
                BigDecimal approveAmountCurr;
                BigDecimal approveAmount;
                BigDecimal amountCurr;
                BigDecimal amount;
                DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(i);
                DynamicObject doneEntry = doneEntrys.addNew();
                ArrayList currentRuleProps = new ArrayList();
                ruleEntryProps.forEach(ruleEntryProp -> {
                    String ruleEntryPropName = ruleEntryProp.getName();
                    doneEntryProps.forEach(doneEntryProp -> {
                        String doneEntryPropName = doneEntryProp.getName();
                        String doneEntryPropNameNew = ERHandleBeforeShareService.handleColName(doneEntryPropName);
                        if ((ruleEntryPropName.contains("comrule") || ruleEntryPropName.contains(shareRuleNew.toString()) || ruleEntryPropName.contains("remark") || ruleEntryPropName.contains("std_entrycostcenter_crule")) && ruleEntryPropName.contains(doneEntryPropNameNew) && !ruleEntryPropName.contains("id") && !doneEntryPropNameNew.equalsIgnoreCase("seq") && !doneEntryPropNameNew.equalsIgnoreCase("id") && ruleEntry.get(ruleEntryPropName) != null) {
                            doneEntry.set(doneEntryPropName, ruleEntry.get(ruleEntryPropName));
                            currentRuleProps.add(doneEntryPropName);
                        }
                    });
                });
                waitEntryProps.forEach(waitEntryProp -> {
                    String waitEntryPropName = waitEntryProp.getName();
                    doneEntryProps.forEach(doneEntryProp -> {
                        String doneEntryPropName = doneEntryProp.getName();
                        String doneEntryPropNameNew = ERHandleBeforeShareService.handleColName(doneEntryPropName);
                        if (!(currentRuleProps.contains(doneEntryPropName) || !waitEntryPropName.contains(doneEntryPropNameNew) || waitEntryPropName.contains("id") || doneEntryPropNameNew.equalsIgnoreCase("seq") || doneEntryPropNameNew.equalsIgnoreCase("id"))) {
                            doneEntry.set(doneEntryPropName, waitEntry.get(waitEntryPropName));
                        }
                    });
                });
                if (StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) {
                    if (Long.valueOf(waitEntry.getString("sourceentryid")).compareTo(ruleEntry.getLong("sharewaitid_comrule")) == 0) {
                        doneEntry.set("sdexpenseitem", ruleEntry.get("entryexpenseitem"));
                    } else {
                        doneEntry.set("sdexpenseitem", waitEntry.get("expenseitem_wait"));
                    }
                    if (Long.valueOf(waitEntry.getString("sourceentryid")).compareTo(ruleEntry.getLong("sharewaitid_comrule")) == 0) {
                        doneEntry.set("sdentrycostcompany", ruleEntry.get("entrycostcompany_orgrule"));
                        doneEntry.set("sdentrycostdept", ruleEntry.get("entrycostdept_orgrule"));
                    } else {
                        doneEntry.set("sdentrycostcompany", waitEntry.get("entrycostcompany_wait"));
                        doneEntry.set("sdentrycostdept", waitEntry.get("entrycostdept_wait"));
                    }
                }
                doneEntry.set("lkwaitentryid", waitEntry.get("sourceentryid"));
                BigDecimal deTaxAmount = BigDecimal.ZERO;
                BigDecimal itemInoutAmount = BigDecimal.ZERO;
                BigDecimal curprice = BigDecimal.ZERO;
                if ("avg".equalsIgnoreCase(shareMethod.toString())) {
                    amount = waitAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                    amountCurr = waitAmountCurr.divide(shareNum, precision, RoundingMode.HALF_UP);
                    approveAmount = waitApproveAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                    approveAmountCurr = waitApproveAmountCurr.divide(shareNum, precision, RoundingMode.HALF_UP);
                    taxAmount = waitTaxAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                    approveTax = waitApproveTax.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                    deTaxAmount = waitDeTaxAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                    itemInoutAmount = waitItemInoutAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                    curprice = waitCurprice.divide(shareNum, precision, RoundingMode.HALF_UP);
                } else if ("rate".equalsIgnoreCase(shareMethod.toString())) {
                    int scale = doneEntry.getBigDecimal("sdsharerate").scale();
                    shareRate = doneEntry.getBigDecimal("sdsharerate").divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN);
                    amount = waitAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    amountCurr = waitAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                    approveAmount = waitApproveAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveAmountCurr = waitApproveAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                    taxAmount = waitTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveTax = waitApproveTax.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    deTaxAmount = waitDeTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    itemInoutAmount = waitItemInoutAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    curprice = waitCurprice.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                    totalShareRate = totalShareRate.add(shareRate);
                } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                    if (totalRulesAmount.compareTo(BigDecimal.ZERO) <= 0) {
                        return;
                    }
                    int scale = 20;
                    amount = ruleEntry.getBigDecimal("shareamount_comrule").setScale(precision, RoundingMode.HALF_UP);
                    shareRate = amount.divide(totalRulesAmount, scale, RoundingMode.HALF_EVEN);
                    logger.info("----amount----" + amount + "----totalRulesAmount----" + totalRulesAmount + "----shareRate----" + shareRate);
                    if (i == ruleEntrys.size() - 1) {
                        shareRate = BigDecimal.ONE.subtract(totalShareRate);
                    }
                    amount = waitAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    amountCurr = waitAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                    approveAmount = waitApproveAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveAmountCurr = waitApproveAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                    taxAmount = waitTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveTax = waitApproveTax.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    deTaxAmount = waitDeTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    itemInoutAmount = waitItemInoutAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    curprice = waitCurprice.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                    totalShareRate = totalShareRate.add(shareRate);
                    logger.info("----shareRate multiply 100----" + shareRate.multiply(BigDecimal.valueOf(100L)));
                    doneEntry.set("sdsharerate", (Object)shareRate.multiply(BigDecimal.valueOf(100L)));
                } else {
                    BigDecimal waitExchangedRate = waitEntry.getBigDecimal("exchangerate_wait");
                    String waitQuoteType = waitEntry.getString("expquotetype_wait");
                    if (waitQuoteType == null || StringUtils.isBlank((CharSequence)waitQuoteType)) {
                        waitQuoteType = "1";
                    }
                    amount = ruleEntry.getBigDecimal("shareamount_comrule").setScale(entryPrecision, RoundingMode.HALF_UP);
                    amountCurr = AmountUtils.getCurrencyAmount(amount, waitExchangedRate, precision, waitQuoteType);
                    approveAmount = ruleEntry.getBigDecimal("shareappamount_comrule").setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveAmountCurr = AmountUtils.getCurrencyAmount(approveAmount, waitExchangedRate, precision, waitQuoteType);
                    BigDecimal waitTaxRate = waitEntry.getBigDecimal("taxrate_wait");
                    if (waitTaxRate.compareTo(BigDecimal.ZERO) == 0 || "2".equals(taxShareWay)) {
                        waitTaxRate = amount.divide(waitAmount, entryPrecision + 4, RoundingMode.HALF_UP);
                        BigDecimal waitApproveTaxRate = approveAmount.divide(waitApproveAmount, entryPrecision + 4, RoundingMode.HALF_UP);
                        taxAmount = waitTaxAmount.multiply(waitTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                        approveTax = waitApproveTax.multiply(waitApproveTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                        deTaxAmount = waitDeTaxAmount.multiply(waitApproveTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                        itemInoutAmount = waitItemInoutAmount.multiply(waitApproveTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    } else {
                        String formulaType;
                        waitTaxRate = waitTaxRate.divide(BigDecimal.valueOf(100L), entryPrecision + 4, RoundingMode.HALF_UP);
                        taxAmount = amount.multiply(waitTaxRate).divide(BigDecimal.ONE.add(waitTaxRate), entryPrecision + 4, RoundingMode.HALF_UP).setScale(entryPrecision, RoundingMode.HALF_UP);
                        approveTax = approveAmount.multiply(waitTaxRate).divide(BigDecimal.ONE.add(waitTaxRate), entryPrecision + 4, RoundingMode.HALF_UP).setScale(entryPrecision, RoundingMode.HALF_UP);
                        Boolean waitoffset = waitEntry.getBoolean("offset_wait");
                        if (waitoffset.booleanValue()) {
                            deTaxAmount = SystemParamterUtil.isAmountToDeductibletax(companyId) ? approveTax : taxAmount;
                        }
                        itemInoutAmount = StringUtils.equalsIgnoreCase((CharSequence)(formulaType = ErStdConfig.get("transferouttax.formula")), (CharSequence)"1") ? taxAmount.subtract(deTaxAmount) : approveTax.subtract(deTaxAmount);
                    }
                    totalAmount = totalAmount.add(amount);
                }
                if (i == ruleEntrys.size() - 1) {
                    Boolean isLast = false;
                    if (isShareDetailView.booleanValue()) {
                        if (totalShareRate.compareTo(BigDecimal.ONE) == 0 || "avg".equalsIgnoreCase(shareMethod.toString()) || totalAmount.compareTo(waitAmount) == 0 || totalAmount.compareTo(BigDecimal.ZERO) == 0) {
                            isLast = true;
                        }
                    } else {
                        isLast = true;
                    }
                    if (isLast.booleanValue()) {
                        amount = balanceWaitAmount;
                        amountCurr = balanceWaitAmountCurr;
                        taxAmount = balanceWaitTaxAmount;
                        approveTax = balanceWaitApproveTax;
                        approveAmount = balanceWaitApproveAmount;
                        approveAmountCurr = balanceWaitApproveAmountCurr;
                        deTaxAmount = balanceWaitDeTaxAmount;
                        itemInoutAmount = balanceWaitItemInoutAmount;
                        curprice = balanceWaitCurprice;
                    }
                }
                balanceWaitAmount = balanceWaitAmount.subtract(amount);
                balanceWaitAmountCurr = balanceWaitAmountCurr.subtract(amountCurr);
                balanceWaitTaxAmount = balanceWaitTaxAmount.subtract(taxAmount);
                balanceWaitApproveTax = balanceWaitApproveTax.subtract(approveTax);
                balanceWaitApproveAmount = balanceWaitApproveAmount.subtract(approveAmount);
                balanceWaitApproveAmountCurr = balanceWaitApproveAmountCurr.subtract(approveAmountCurr);
                balanceWaitDeTaxAmount = balanceWaitDeTaxAmount.subtract(deTaxAmount);
                balanceWaitItemInoutAmount = balanceWaitItemInoutAmount.subtract(itemInoutAmount);
                balanceWaitCurprice = balanceWaitCurprice.subtract(curprice);
                doneEntry.set("sdexpenseamount", (Object)amount);
                doneEntry.set("sdcurrexpenseamount", (Object)amountCurr);
                doneEntry.set("sdexpeapproveamount", (Object)approveAmount);
                doneEntry.set("sdexpeapprovecurramount", (Object)approveAmountCurr);
                doneEntry.set("sdtaxamount", (Object)taxAmount);
                doneEntry.set("sdorientryamount", (Object)amount.subtract(taxAmount));
                doneEntry.set("sdapprovetax", (Object)approveTax);
                if (!ErEntityTypeUtils.isApplyProjectBill(entityId) && !ErEntityTypeUtils.isCostEstimateBill(entityId)) {
                    doneEntry.set("sddeductibletax", (Object)deTaxAmount);
                }
                if (ErEntityTypeUtils.isApplyProjectBill(entityId) || ErEntityTypeUtils.isCostEstimateBill(entityId)) {
                    deTaxAmount = approveTax;
                }
                BigDecimal price = StringUtils.equals((CharSequence)approveTaxFormulaType, (CharSequence)"1") ? approveAmount.subtract(deTaxAmount) : approveAmount.subtract(approveTax);
                doneEntry.set("sdprice", (Object)price);
                if ("amount".equalsIgnoreCase(shareMethod.toString()) && !ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                    if (i < ruleEntrys.size() - 1) {
                        BigDecimal changeRate = doneEntry.getBigDecimal("sdexchangerate");
                        String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)doneEntry.getString("sdquotetype"), (Object)"0");
                        curprice = AmountUtils.getCurrencyAmount(price, changeRate, precision, detailQuoteType);
                    }
                    balanceWaitCurprice = balanceWaitCurprice.subtract(curprice);
                }
                doneEntry.set("sdcurprice", (Object)curprice);
                if (doneEntry.getDate("sdentrymonth") != null) {
                    doneEntry.set("sdhappendate", (Object)doneEntry.getDate("sdentrymonth"));
                }
                if (!doneEntry.containsProperty("sditeminoutamount")) continue;
                doneEntry.set("sditeminoutamount", (Object)itemInoutAmount);
            }
        }
    }

    private static String handleColName(String doneEntryPropName) {
        String doneEntryPropNameNew = "";
        doneEntryPropNameNew = doneEntryPropName.startsWith("sd") ? doneEntryPropName.substring(2) : doneEntryPropName;
        return doneEntryPropNameNew;
    }

    @Deprecated
    public static void dealAmountTailDifference(DynamicObjectCollection currentDoneEntrys, Boolean isbefore) {
        ArrayList propArr = Lists.newArrayListWithCapacity((int)10);
        if (isbefore.booleanValue()) {
            propArr.addAll(Arrays.asList("sdexpenseamount", "sdcurrexpenseamount", "sdexpeapproveamount", "sdexpeapprovecurramount", "sdtaxamount", "sdapprovetax", "sddeductibletax", "sdorientryamount", "sdprice", "sdcurprice"));
        } else {
            propArr.addAll(Arrays.asList("expenseamount", "currexpenseamount", "expeapproveamount", "expeapprovecurramount", "taxamount", "approvetax", "deductibletax", "orientryamount", "price", "curprice"));
        }
        for (String prop : propArr) {
            ERHandleBeforeShareService.dealAmountPropTailDifference(currentDoneEntrys, null, prop);
        }
    }

    private static void dealAmountPropTailDifference(DynamicObjectCollection currentDoneEntrys, DynamicObject waitEntry, String propName) {
        if (currentDoneEntrys != null && !currentDoneEntrys.isEmpty()) {
            BigDecimal lastAmountValue;
            int size = currentDoneEntrys.size();
            DynamicObject lastEntry = (DynamicObject)currentDoneEntrys.get(size - 1);
            boolean handleTailDifference = Boolean.TRUE;
            if (waitEntry != null && waitEntry.getBigDecimal("expenseamount_wait") != null && waitEntry.getBigDecimal("expenseamount_wait").compareTo(BigDecimal.ZERO) < 0) {
                handleTailDifference = Boolean.FALSE;
            }
            if (handleTailDifference && lastEntry.containsProperty(propName) && (lastAmountValue = lastEntry.getBigDecimal(propName)).compareTo(BigDecimal.ZERO) < 0) {
                lastEntry.set(propName, (Object)BigDecimal.ZERO);
                List amountCurrList = currentDoneEntrys.stream().map(v -> v.getBigDecimal(propName) != null ? v.getBigDecimal(propName) : BigDecimal.ZERO).collect(Collectors.toList());
                BigDecimal maxAmountCurr = (BigDecimal)Collections.max(amountCurrList);
                int maxIndex = amountCurrList.indexOf(maxAmountCurr);
                DynamicObject maxEntry = (DynamicObject)currentDoneEntrys.get(maxIndex);
                maxEntry.set(propName, (Object)maxAmountCurr.add(lastAmountValue));
            }
        }
    }

    @Deprecated
    public static DynamicObjectCollection packageWaitEntry(Boolean isTripBill, DynamicObjectCollection expEntrys, DynamicObject parentBill, Boolean isShareDetailView) {
        return null;
    }

    @Deprecated
    public static void handlDoneEntry(DynamicObjectCollection waitEntrys, DynamicObjectCollection ruleEntrys, DynamicObjectCollection doneEntrys, int precision, Object shareRule, Object shareMethod, Boolean isShareDetailView, String entityId) {
    }

    private static long[] getTripEntryDetailNums(DynamicObjectCollection expEntrys, boolean isTripBill) {
        int count = 0;
        long[] ids = null;
        if (!expEntrys.isEmpty() && isTripBill) {
            for (int i = 0; i < expEntrys.size(); ++i) {
                DynamicObjectCollection tripDetailEntrys = ((DynamicObject)expEntrys.get(i)).getDynamicObjectCollection("entryentity");
                if (tripDetailEntrys.isEmpty()) continue;
                count += tripDetailEntrys.size();
            }
            ids = DB.genLongIds((String)"t_er_reimburseentry", (int)count);
        }
        return ids;
    }

    public static void dealAmountTailDifference(DynamicObjectCollection currentDoneEntrys, DynamicObject waitEntry, Boolean isbefore) {
        ArrayList propArr = Lists.newArrayListWithCapacity((int)10);
        if (isbefore.booleanValue()) {
            propArr.addAll(Arrays.asList("sdexpenseamount", "sdcurrexpenseamount", "sdexpeapproveamount", "sdexpeapprovecurramount", "sdtaxamount", "sdapprovetax", "sddeductibletax", "sdorientryamount", "sdprice", "sdcurprice", "sditeminoutamount"));
        } else {
            propArr.addAll(Arrays.asList("expenseamount", "currexpenseamount", "expeapproveamount", "expeapprovecurramount", "taxamount", "approvetax", "deductibletax", "orientryamount", "price", "curprice", "iteminoutamount"));
        }
        for (String prop : propArr) {
            ERHandleBeforeShareService.dealAmountPropTailDifference(currentDoneEntrys, waitEntry, prop);
        }
    }
}

