/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.share.befshare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.fi.er.business.share.befshare.AbstractBeforeShareBillGenerator;
import kd.fi.er.common.utils.Er;

public class TripReimburseBillBeforeShareBillGenerator
extends AbstractBeforeShareBillGenerator {
    public TripReimburseBillBeforeShareBillGenerator(String entityName) {
        super(entityName);
    }

    @Override
    String getSelectProperties() {
        ArrayList<String> preparePropertys = new ArrayList<String>(58);
        preparePropertys.add("costcompany");
        preparePropertys.add("costdept");
        preparePropertys.add("iscurrency");
        preparePropertys.add("currency");
        preparePropertys.add("billno");
        preparePropertys.add("tripentry.tripexpenseitem");
        preparePropertys.add("tripentry.std_project");
        preparePropertys.add("tripentry.startdate");
        preparePropertys.add("tripentry.expsharedamount");
        preparePropertys.add("tripentry.entryentity");
        preparePropertys.add("entrycurrency");
        preparePropertys.add("exchangerate");
        preparePropertys.add("orientryamount");
        preparePropertys.add("entryamount");
        preparePropertys.add("orientryappamount");
        preparePropertys.add("entryappamount");
        preparePropertys.add("taxrate");
        preparePropertys.add("taxamount");
        preparePropertys.add("notaxamount");
        preparePropertys.add("comment");
        preparePropertys.add("offset");
        preparePropertys.add("deductibletax");
        preparePropertys.add("invoiceno_entry");
        preparePropertys.add("invoicelink");
        preparePropertys.add("taxclasscode");
        preparePropertys.add("price");
        preparePropertys.add("expsharedamount");
        preparePropertys.add("curprice");
        preparePropertys.add("detailquotetype");
        preparePropertys.add("travelcostcenter");
        preparePropertys.add("approvetax");
        preparePropertys.add("entrycostcompany");
        preparePropertys.add("entrycostdept");
        preparePropertys.add("autogenshare");
        preparePropertys.add("company");
        preparePropertys.add("applier");
        preparePropertys.add("org");
        preparePropertys.add("applierpositionstr");
        preparePropertys.add("billno");
        preparePropertys.add("sharerule");
        preparePropertys.add("sharemethod");
        preparePropertys.add("sharerule_startdate");
        preparePropertys.add("sharerule_enddate");
        preparePropertys.add("expenseentryentity_rule.entrycostcompany_orgrule");
        preparePropertys.add("expenseentryentity_rule.entrycostdept_orgrule");
        preparePropertys.add("expenseentryentity_rule.entryexpenseitem");
        preparePropertys.add("expenseentryentity_rule.std_entrycostcenter_crule");
        preparePropertys.add("expenseentryentity_rule.entrymonth_monthrule");
        preparePropertys.add("expenseentryentity_rule.std_project_comrule");
        preparePropertys.add("expenseentryentity_rule.sharecurrency_comrule");
        preparePropertys.add("expenseentryentity_rule.shareamount_comrule");
        preparePropertys.add("expenseentryentity_rule.shareappamount_comrule");
        preparePropertys.add("expenseentryentity_rule.sharewaitseq_comrule");
        preparePropertys.add("expenseentryentity_rule.sharewaitid_comrule");
        preparePropertys.add("expenseentryentity_rule.sharerate_comrule");
        preparePropertys.add("sharedetailentry");
        preparePropertys.add("sharedetailentry.sdexpenseamount");
        preparePropertys.add("sharedetailentry.sdcurrexpenseamount");
        preparePropertys.add("sharedetailentry.sdremark");
        preparePropertys.add("sharedetailentry.sdentrycurrency");
        preparePropertys.add("sharedetailentry.sdorientryamount");
        preparePropertys.add("sharedetailentry.sdstd_entrycostcenter");
        preparePropertys.add("sharedetailentry.lkwaitentryid");
        preparePropertys.add("sharedetailentry.sddeductibletax");
        preparePropertys.add("sharedetailentry.sdinvoicelink");
        preparePropertys.add("sharedetailentry.sdinvoiceno_entry");
        preparePropertys.add("sharedetailentry.sdinvoicetypeitem");
        preparePropertys.add("sharedetailentry.sdserialno_entry");
        preparePropertys.add("sharedetailentry.sdentrycostdept");
        preparePropertys.add("sharedetailentry.sdentrycostcompany");
        preparePropertys.add("sharedetailentry.sdhappendate");
        preparePropertys.add("sharedetailentry.sdexpenseitem");
        preparePropertys.add("sharedetailentry.sdsharerate");
        preparePropertys.add("sharedetailentry.sdprice");
        preparePropertys.add("sharedetailentry.sdcurprice");
        preparePropertys.add("sharedetailentry.sdexpeapproveamount");
        preparePropertys.add("sharedetailentry.sdexpeapprovecurramount");
        preparePropertys.add("sharedetailentry.sdapprovetax");
        preparePropertys.add("sharedetailentry.sdquotetype");
        preparePropertys.add("sharedetailentry.sdexchangerate");
        preparePropertys.add("sharedetailentry.sdairportconstructionfee");
        preparePropertys.add("sharedetailentry.sditemfrom");
        preparePropertys.add("sharedetailentry.sdexpensegoodsname");
        preparePropertys.add("sharedetailentry.sdoffset");
        preparePropertys.add("sharedetailentry.sdtaxamount");
        preparePropertys.add("sharedetailentry.sdtaxrate");
        preparePropertys.add("sharedetailentry.sdtaxclasscode");
        preparePropertys.add("sharedetailentry.sdstd_project");
        preparePropertys.add("sharedetailentry.sdentrymonth");
        preparePropertys.add("sharedetailentry.sdis_special_invoice");
        preparePropertys.add("iteminoutamount");
        return Er.join(preparePropertys, (String)",");
    }

    @Override
    void fillFields(DynamicObject shareBill, DynamicObject reimburseBill) {
        this.setFieldByReimBOTP(shareBill, reimburseBill);
        shareBill.set("sharerule", reimburseBill.get("sharerule"));
        shareBill.set("sharemethod", reimburseBill.get("sharemethod"));
        shareBill.set("sharerule_startdate", reimburseBill.get("sharerule_startdate"));
        shareBill.set("sharerule_enddate", reimburseBill.get("sharerule_enddate"));
        DynamicObjectCollection shareEntries = shareBill.getDynamicObjectCollection("expenseentryentity_rule");
        DynamicObjectCollection srcEntries = reimburseBill.getDynamicObjectCollection("expenseentryentity_rule");
        for (DynamicObject entryentity : srcEntries) {
            DynamicObject shareEntry = shareEntries.addNew();
            shareEntry.set("entrycostcompany_orgrule", entryentity.get("entrycostcompany_orgrule"));
            shareEntry.set("entrycostdept_orgrule", entryentity.get("entrycostdept_orgrule"));
            shareEntry.set("std_entrycostcenter_crule", entryentity.get("std_entrycostcenter_crule"));
            shareEntry.set("entrymonth_monthrule", entryentity.get("entrymonth_monthrule"));
            shareEntry.set("std_project_comrule", entryentity.get("std_project_comrule"));
            shareEntry.set("shareamount_comrule", entryentity.get("shareamount_comrule"));
            shareEntry.set("shareappamount_comrule", entryentity.get("shareamount_comrule"));
            shareEntry.set("sharerate_comrule", entryentity.get("sharerate_comrule"));
        }
        DynamicObjectCollection billHeads = shareBill.getDynamicObjectCollection("billhead_lk");
        Long srcTableId = EntityMetadataCache.loadTableDefine((String)this.entityName, (String)this.entityName).getTableId();
        DynamicObject billHead = billHeads.addNew();
        billHead.set("billhead_lk_stableid", (Object)srcTableId);
        billHead.set("billhead_lk_sbillid", reimburseBill.getPkValue());
        billHead.set("billhead_lk_sid", reimburseBill.getPkValue());
        billHead.set("seq", (Object)1);
        DynamicObjectCollection srcShareDetailEntries = reimburseBill.getDynamicObjectCollection("sharedetailentry");
        DynamicObjectCollection shareDetailEntries = shareBill.getDynamicObjectCollection("expenseentryentity");
        for (DynamicObject srcShareDetailEntry : srcShareDetailEntries) {
            DynamicObject shareDetailEntry = shareDetailEntries.addNew();
            shareDetailEntry.set("expenseamount", srcShareDetailEntry.get("sdexpenseamount"));
            shareDetailEntry.set("currexpenseamount", srcShareDetailEntry.get("sdcurrexpenseamount"));
            shareDetailEntry.set("remark", srcShareDetailEntry.get("sdremark"));
            shareDetailEntry.set("entrycurrency", srcShareDetailEntry.get("sdentrycurrency"));
            shareDetailEntry.set("orientryamount", srcShareDetailEntry.get("sdorientryamount"));
            shareDetailEntry.set("sdstd_entrycostcenter", srcShareDetailEntry.get("sdstd_entrycostcenter"));
            shareDetailEntry.set("lkwaitentryid", srcShareDetailEntry.get("lkwaitentryid"));
            shareDetailEntry.set("deductibletax", srcShareDetailEntry.get("sddeductibletax"));
            shareDetailEntry.set("invoicelink", srcShareDetailEntry.get("sdinvoicelink"));
            shareDetailEntry.set("invoiceno_entry", srcShareDetailEntry.get("sdinvoiceno_entry"));
            shareDetailEntry.set("invoicetypeitem", srcShareDetailEntry.get("sdinvoicetypeitem"));
            shareDetailEntry.set("serialno_entry", srcShareDetailEntry.get("sdserialno_entry"));
            shareDetailEntry.set("entrycostdept", srcShareDetailEntry.get("sdentrycostdept"));
            shareDetailEntry.set("entrycostcompany", srcShareDetailEntry.get("sdentrycostcompany"));
            shareDetailEntry.set("happendate", srcShareDetailEntry.get("sdhappendate"));
            shareDetailEntry.set("expenseitem", srcShareDetailEntry.get("sdexpenseitem"));
            shareDetailEntry.set("sharerate", srcShareDetailEntry.get("sdsharerate"));
            shareDetailEntry.set("price", srcShareDetailEntry.get("sdprice"));
            shareDetailEntry.set("curprice", srcShareDetailEntry.get("sdcurprice"));
            shareDetailEntry.set("expeapproveamount", srcShareDetailEntry.get("sdexpeapproveamount"));
            shareDetailEntry.set("expeapprovecurramount", srcShareDetailEntry.get("sdexpeapprovecurramount"));
            shareDetailEntry.set("approvetax", srcShareDetailEntry.get("sdapprovetax"));
            shareDetailEntry.set("expquotetype", srcShareDetailEntry.get("sdquotetype"));
            shareDetailEntry.set("exchangerate", srcShareDetailEntry.get("sdexchangerate"));
            shareDetailEntry.set("airportconstructionfee", srcShareDetailEntry.get("sdairportconstructionfee"));
            shareDetailEntry.set("itemfrom", srcShareDetailEntry.get("sditemfrom"));
            shareDetailEntry.set("expensegoodsname", srcShareDetailEntry.get("sdexpensegoodsname"));
            shareDetailEntry.set("offset", srcShareDetailEntry.get("sdoffset"));
            shareDetailEntry.set("taxamount", srcShareDetailEntry.get("sdtaxamount"));
            shareDetailEntry.set("taxrate", srcShareDetailEntry.get("sdtaxrate"));
            shareDetailEntry.set("taxclasscode", srcShareDetailEntry.get("sdtaxclasscode"));
            shareDetailEntry.set("std_project", srcShareDetailEntry.get("sdstd_project"));
            shareDetailEntry.set("entrymonth", srcShareDetailEntry.get("sdentrymonth"));
            shareDetailEntry.set("is_special_invoice", srcShareDetailEntry.get("sdis_special_invoice"));
        }
    }

    private void setFieldByReimBOTP(DynamicObject shareBill, DynamicObject reimburseBill) {
        shareBill.set("costcompany", reimburseBill.get("costcompany"));
        shareBill.set("costdept", reimburseBill.get("costdept"));
        shareBill.set("iscurrency", reimburseBill.get("iscurrency"));
        shareBill.set("currency", reimburseBill.get("currency"));
        DynamicObjectCollection tripEntries = reimburseBill.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection waitEntries = shareBill.getDynamicObjectCollection("expenseentryentity_wait");
        int seq = 1;
        for (DynamicObject tripEntry : tripEntries) {
            DynamicObjectCollection entryentities = tripEntry.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> grp = entryentities.stream().collect(Collectors.groupingBy(entryentity -> {
                Object currencyId = entryentity.getDynamicObject("entrycurrency").getPkValue();
                Object taxrate = entryentity.get("taxrate");
                Object offset = entryentity.get("offset");
                return String.format("%s,%s,%s", currencyId, taxrate, offset);
            }));
            for (Map.Entry<String, List<DynamicObject>> entrySet : grp.entrySet()) {
                List<DynamicObject> entries = entrySet.getValue();
                DynamicObject entryentity2 = entries.get(0);
                DynamicObject waitEntry = waitEntries.addNew();
                waitEntry.set("seq", (Object)seq);
                if (tripEntry.getDynamicObject("entrycostcompany") != null) {
                    waitEntry.set("entrycostcompany_wait", (Object)tripEntry.getDynamicObject("entrycostcompany"));
                } else {
                    waitEntry.set("entrycostcompany_wait", reimburseBill.get("costcompany"));
                }
                if (tripEntry.getDynamicObject("entrycostdept") != null) {
                    waitEntry.set("entrycostdept_wait", (Object)tripEntry.getDynamicObject("entrycostdept"));
                } else {
                    waitEntry.set("entrycostdept_wait", reimburseBill.get("costdept"));
                }
                waitEntry.set("srcbilltype", (Object)"er_tripreimbursebill");
                waitEntry.set("sourcebillid", reimburseBill.getPkValue());
                waitEntry.set("sourceentryid", tripEntry.getPkValue());
                waitEntry.set("sourcebillno", reimburseBill.get("billno"));
                waitEntry.set("expenseitem_wait", tripEntry.get("tripexpenseitem"));
                waitEntry.set("std_project_wait", tripEntry.get("std_project"));
                waitEntry.set("happendate_wait", tripEntry.get("startdate"));
                waitEntry.set("entrycurrency_wait", entryentity2.get("entrycurrency"));
                waitEntry.set("exchangerate_wait", entryentity2.get("exchangerate"));
                waitEntry.set("expenseamount_wait", (Object)this.sum(entries, "orientryamount"));
                waitEntry.set("currexpenseamount_wait", (Object)this.sum(entries, "entryamount"));
                waitEntry.set("expeapproveamount_wait", (Object)this.sum(entries, "orientryappamount"));
                waitEntry.set("expeapprovecurramount_w", (Object)this.sum(entries, "entryappamount"));
                waitEntry.set("taxrate_wait", entryentity2.get("taxrate"));
                waitEntry.set("taxamount_wait", (Object)this.sum(entries, "taxamount"));
                waitEntry.set("orientryamount_wait", (Object)this.sum(entries, "notaxamount"));
                waitEntry.set("remark_wait", entryentity2.get("comment"));
                waitEntry.set("offset_wait", entryentity2.get("offset"));
                waitEntry.set("deductibletax_wait", (Object)this.sum(entries, "deductibletax"));
                waitEntry.set("iteminoutamount_wait", (Object)this.sum(entries, "iteminoutamount"));
                waitEntry.set("invoiceno_entry_wait", entryentity2.get("invoiceno_entry"));
                waitEntry.set("invoicelink_wait", entryentity2.get("invoicelink"));
                waitEntry.set("taxclasscode_wait", entryentity2.get("taxclasscode"));
                waitEntry.set("price_wait", (Object)this.sum(entries, "price"));
                waitEntry.set("entrysharedamount", tripEntry.get("expsharedamount"));
                waitEntry.set("curprice_wait", (Object)this.sum(entries, "curprice"));
                waitEntry.set("expquotetype_wait", entryentity2.get("detailquotetype"));
                waitEntry.set("std_entrycostcenter_wait", entryentity2.get("travelcostcenter"));
                waitEntry.set("approvetax_wait", (Object)this.sum(entries, "approvetax"));
                ++seq;
            }
        }
    }

    private BigDecimal sum(List<DynamicObject> entries, String prop) {
        BigDecimal result = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            BigDecimal value = entry.getBigDecimal(prop);
            if (value == null) continue;
            result = result.add(value);
        }
        return result;
    }
}

