/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;

public class TripYearEndReportTask
extends AbstractTask {
    private Log logger = LogFactory.getLog(TripYearEndReportTask.class);
    private static final String INTEGRAL = "integral";
    private static final String HAPPENDATE = "happendate";

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        this.yearEndReportDataUtils();
    }

    public void yearEndReportDataUtils() {
        Date firstTripbillDate = null;
        Date firstlogindate = null;
        Double totalExpense = 0.0;
        Double planeExpense = 0.0;
        Double trainExpense = 0.0;
        Double taxiExpense = 0.0;
        Double busExpense = 0.0;
        Double otherExpense = 0.0;
        Double subsidiesExpense = 0.0;
        Double lodgeExpense = 0.0;
        ArrayList<DynamicObject> personalReports = new ArrayList<DynamicObject>();
        QFilter[] integralDateFilters = new QFilter[]{new QFilter("integraltype", "=", (Object)4)};
        DataSet personalIntegralDates = null;
        DataSet praiseRecordDataSet = null;
        DataSet tripBillsDataSet = null;
        DataSet tripReimburseDataSet = null;
        DataSet personIdDataSet = null;
        DataSet onePersonTripBurse = null;
        DataSet onePersonTripReq = null;
        DataSet personalIntegralDatesTemp = null;
        DataSet firstTripReqDataSet = null;
        DataSet tripDayDataSet = null;
        DataSet totalExpenseDataSet = null;
        DataSet expenseDataSet = null;
        DataSet thisPersonPraiseDaSet = null;
        try {
            personalIntegralDates = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getIntegralDates"), (String)"er_integralrecord", (String)"integral,happendate", (QFilter[])integralDateFilters, (String)"happendate ASC");
            praiseRecordDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getPraiseRecord"), (String)"er_praiserecord", (String)"id,user,praiseuse,nowdate", (QFilter[])new QFilter[0], (String)"nowdate asc");
            tripBillsDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getTripBills"), (String)"er_tripreqbill", (String)"billno,billstatus,applier,bizdate,tripentry.startdate as startDate,tripentry.to as tocity,tripentry.tripday as tripday", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"E")}, (String)"bizdate ASC");
            tripReimburseDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getreiBurseBills"), (String)"er_tripreimbursebill", (String)"billno,billstatus,applier,tripentry.entryentity.expenseitem as expenseitem,tripentry.entryentity.orientryamount as orientryamount", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"E")}, (String)"bizdate ASC");
            personIdDataSet = tripBillsDataSet.copy().groupBy(new String[]{"applier"}).count("billno").finish();
            for (Row row : personIdDataSet) {
                Object oName;
                int tripburseSum;
                DynamicObject onePersonReport = BusinessDataServiceHelper.newDynamicObject((String)"er_personalyearendreport");
                Long curUserId = row.getLong("applier");
                int tripBillSum = row.getInteger("billno");
                onePersonTripBurse = tripReimburseDataSet.copy().filter("applier=" + curUserId);
                onePersonTripReq = tripBillsDataSet.copy().filter("applier=" + curUserId);
                int personIndex = 0;
                personalIntegralDatesTemp = personalIntegralDates.copy();
                for (Row row1 : personalIntegralDatesTemp) {
                    ++personIndex;
                    if (!row1.getLong(INTEGRAL).equals(curUserId)) continue;
                    firstlogindate = row1.getDate(HAPPENDATE);
                    break;
                }
                firstTripReqDataSet = onePersonTripReq.top(1);
                for (Row tripReqRow : firstTripReqDataSet) {
                    if (!tripReqRow.getLong("applier").equals(curUserId)) continue;
                    firstTripbillDate = tripReqRow.getDate("bizdate");
                    break;
                }
                int cityNum = onePersonTripReq.count("tocity", true);
                int tripTimes = tripburseSum = onePersonTripReq.count("billno", true);
                int tripDays = 0;
                tripDayDataSet = onePersonTripReq.groupBy(new String[]{"applier"}).sum("tripday").finish();
                for (Row tripDayRow : tripDayDataSet) {
                    if (!tripDayRow.getLong("applier").equals(curUserId)) continue;
                    tripDays = tripDayRow.getInteger("tripday");
                }
                totalExpenseDataSet = onePersonTripBurse.copy().groupBy(new String[]{"applier"}).sum("orientryamount").finish();
                for (Row totalExpenseRow : totalExpenseDataSet) {
                    if (!totalExpenseRow.getLong("applier").equals(curUserId)) continue;
                    totalExpense = totalExpenseRow.getDouble("orientryamount");
                }
                expenseDataSet = onePersonTripBurse.groupBy(new String[]{"applier", "expenseitem"}).sum("orientryamount").finish();
                for (Row expenseRow : expenseDataSet) {
                    String expenseItem = expenseRow.getString("expenseitem");
                    Double oriRntryAmount = expenseRow.getDouble("orientryamount");
                    if ("100008".equals(expenseItem)) {
                        subsidiesExpense = oriRntryAmount;
                        continue;
                    }
                    if ("100009".equals(expenseItem)) {
                        planeExpense = oriRntryAmount;
                        continue;
                    }
                    if ("100010".equals(expenseItem)) {
                        trainExpense = oriRntryAmount;
                        continue;
                    }
                    if ("100011".equals(expenseItem)) {
                        busExpense = oriRntryAmount;
                        continue;
                    }
                    if ("100012".equals(expenseItem)) {
                        lodgeExpense = oriRntryAmount;
                        continue;
                    }
                    if ("100014".equals(expenseItem)) {
                        taxiExpense = oriRntryAmount;
                        continue;
                    }
                    otherExpense = oriRntryAmount;
                }
                int getPraiseTimes = praiseRecordDataSet.copy().filter("user=" + curUserId).count("id", true);
                int givePraiseTimes = praiseRecordDataSet.copy().filter("praiseuse=" + curUserId).count("id", true);
                thisPersonPraiseDaSet = praiseRecordDataSet.copy().filter("user=" + curUserId);
                Long firstPraiseUserId = null;
                Long lastPraiseUserId = null;
                int index = 0;
                for (Row presonalPraiseRow : thisPersonPraiseDaSet) {
                    if (index == 0) {
                        firstPraiseUserId = presonalPraiseRow.getLong("praiseuse");
                    }
                    ++index;
                    lastPraiseUserId = presonalPraiseRow.getLong("praiseuse");
                }
                String firstPersonName = firstPraiseUserId != null ? ((oName = CommonServiceHelper.getUserMap(firstPraiseUserId).get("name")) != null ? oName.toString() : ResManager.loadKDString((String)"\u4e0a\u5e1d", (String)"TripYearEndReportTask_0", (String)"fi-er-business", (Object[])new Object[0])) : ResManager.loadKDString((String)"\u4e0a\u5e1d", (String)"TripYearEndReportTask_0", (String)"fi-er-business", (Object[])new Object[0]);
                String lastPersonName = lastPraiseUserId != null ? ((oName = CommonServiceHelper.getUserMap(lastPraiseUserId).get("name")) != null ? oName.toString() : ResManager.loadKDString((String)"\u4e18\u6bd4\u7279", (String)"TripYearEndReportTask_1", (String)"fi-er-business", (Object[])new Object[0])) : ResManager.loadKDString((String)"\u4e18\u6bd4\u7279", (String)"TripYearEndReportTask_1", (String)"fi-er-business", (Object[])new Object[0]);
                onePersonReport.set("firstlogindate", (Object)firstTripbillDate);
                onePersonReport.set("firsttripbilldate", (Object)firstlogindate);
                onePersonReport.set("personIndex", (Object)personIndex);
                onePersonReport.set("tripbillsum", (Object)tripBillSum);
                onePersonReport.set("tripbursesum", (Object)tripburseSum);
                onePersonReport.set("tripTimes", (Object)tripTimes);
                onePersonReport.set("citynum", (Object)cityNum);
                onePersonReport.set("tripdays", (Object)tripDays);
                onePersonReport.set("totalexpense", (Object)totalExpense);
                onePersonReport.set("planeexpense", (Object)planeExpense);
                onePersonReport.set("trainexpense", (Object)trainExpense);
                onePersonReport.set("busexpense", (Object)busExpense);
                onePersonReport.set("taxiexpense", (Object)taxiExpense);
                onePersonReport.set("subsidiesexpense", (Object)subsidiesExpense);
                onePersonReport.set("otherexpense", (Object)otherExpense);
                onePersonReport.set("lodgeexpense", (Object)lodgeExpense);
                onePersonReport.set("getpraisetimes", (Object)getPraiseTimes);
                onePersonReport.set("givepraisetimes", (Object)givePraiseTimes);
                onePersonReport.set("firstpersonname", (Object)firstPersonName);
                onePersonReport.set("lastpersonname", (Object)lastPersonName);
                onePersonReport.set("userid", (Object)curUserId);
                personalReports.add(onePersonReport);
            }
            this.closeDataSet(personalIntegralDates);
            this.closeDataSet(praiseRecordDataSet);
            this.closeDataSet(tripBillsDataSet);
            this.closeDataSet(tripReimburseDataSet);
            this.closeDataSet(personIdDataSet);
            this.closeDataSet(onePersonTripBurse);
            this.closeDataSet(onePersonTripReq);
            this.closeDataSet(personalIntegralDatesTemp);
            this.closeDataSet(firstTripReqDataSet);
            this.closeDataSet(tripDayDataSet);
            this.closeDataSet(totalExpenseDataSet);
            this.closeDataSet(expenseDataSet);
            this.closeDataSet(thisPersonPraiseDaSet);
        }
        catch (Exception e) {
            try {
                this.logger.info(String.format("\u5e74\u7ec8\u62a5\u544a\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38%s\u3002", e.getMessage()));
                throw new KDBizException(ResManager.loadKDString((String)"\u5e74\u7ec8\u62a5\u544a\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38\u3002", (String)"TripYearEndReportTask_2", (String)"fi-er-business", (Object[])new Object[0]));
            }
            catch (Throwable throwable) {
                this.closeDataSet(personalIntegralDates);
                this.closeDataSet(praiseRecordDataSet);
                this.closeDataSet(tripBillsDataSet);
                this.closeDataSet(tripReimburseDataSet);
                this.closeDataSet(personIdDataSet);
                this.closeDataSet(onePersonTripBurse);
                this.closeDataSet(onePersonTripReq);
                this.closeDataSet(personalIntegralDatesTemp);
                this.closeDataSet(firstTripReqDataSet);
                this.closeDataSet(tripDayDataSet);
                this.closeDataSet(totalExpenseDataSet);
                this.closeDataSet(expenseDataSet);
                this.closeDataSet(thisPersonPraiseDaSet);
                throw throwable;
            }
        }
        if (personalReports.size() > 0) {
            this.clearOldYearEndReportData();
            SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"er_personalyearendreport"), (Object[])personalReports.toArray());
            this.logger.info("\u4e2a\u4eba\u5dee\u65c5\u5e74\u7ec8\u62a5\u544a\u6570\u636e\u66f4\u65b0" + personalReports);
        }
    }

    public void clearOldYearEndReportData() {
        DynamicObject[] primaryKeys = BusinessDataServiceHelper.load((String)"er_personalyearendreport", (String)"id", (QFilter[])new QFilter[0]);
        if (primaryKeys.length > 0) {
            Object[] keys = new String[primaryKeys.length];
            for (int i = 0; i < primaryKeys.length; ++i) {
                keys[i] = primaryKeys[i].getString("id");
            }
            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"er_personalyearendreport"), (Object[])keys);
        }
    }

    private void closeDataSet(DataSet dataSet) {
        if (dataSet != null) {
            dataSet.close();
        }
    }
}

