/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dailybiz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.context.OrderExpenseDetailContext;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DailyReimCreateOrderEntrysUtil {
    private static final Log logger = LogFactory.getLog(DailyReimCreateOrderEntrysUtil.class);
    private static final String[] setZeroField = new String[]{"tripbookamount", "tripbookcuramount", "expenseamount", "currexpenseamount", "expeapproveamount", "expeapprovecurramount", "taxamount", "approvetax", "orientryamount", "price", "deductibletax"};

    public static void initOrderEntrys(DynamicObject targetBill, DynamicObject expenseEntry, DynamicObjectCollection orderEntries, List<DynamicObject> tripOrders, boolean pullTravelOrders, Map<String, Object> existMontrhEntryMap, DynamicObject applyBill, String formId, OrderExpenseDetailContext orderExpenseDetailContext) {
        int precision;
        boolean expenseAmountEdit;
        Long companyId;
        if (tripOrders == null || tripOrders.isEmpty()) {
            return;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,botp\u914d\u7f6e\u63d2\u4ef6\u4e2d,\u83b7\u53d6\u5173\u8054\u8ba2\u5355\u4fe1\u606f orderBill size : " + tripOrders.size());
        DynamicObject company = targetBill.getDynamicObject("company");
        Long l = companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk(company);
        if (tripOrders == null || tripOrders.size() < 1) {
            return;
        }
        ArrayList<DynamicObject> successInitOrderEntries = new ArrayList<DynamicObject>(tripOrders.size());
        BigDecimal totalTax = BigDecimal.ZERO;
        if (ErCommonUtils.getPk(expenseEntry.getPkValue()) == 0L) {
            ORM.create().setPrimaryKey(expenseEntry);
        }
        for (DynamicObject orderBill : tripOrders) {
            String string = orderBill.getDynamicObjectType().getName();
            DynamicObject orderEntry = orderEntries.addNew();
            for (String s : Arrays.asList("server", "operationtype", "oabillnum", "orderdate", "sourcebookedid", "parentordernum", "ordertype", "servicefee")) {
                orderEntry.set(s, orderBill.get(s));
            }
            if (orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) == 0) {
                orderEntry.set("ordertotalamount", (Object)BigDecimal.ZERO);
            } else {
                orderEntry.set("ordertotalamount", (Object)orderBill.getBigDecimal("totalamount"));
            }
            orderEntry.set("ordernumber", (Object)orderBill.getString("ordernum"));
            orderEntry.set("orderformid", (Object)string);
            orderEntry.set("orderbookeddept", (Object)orderBill.getDynamicObject("bookeddept"));
            orderEntry.set("ordercurrency", (Object)orderBill.getDynamicObject("currency"));
            orderEntry.set("ordercompany", (Object)orderBill.getDynamicObject("company"));
            orderEntry.set("ordercostdept", (Object)orderBill.getDynamicObject("expcommitdepnum"));
            orderEntry.set("ordercostcompany", (Object)orderBill.getDynamicObject("expcommitcomnum"));
            String orderstatus = orderBill.getString("orderstatus");
            orderEntry.set("orderstatusstr", (Object)DailyReimCreateOrderEntrysUtil.getCombofieldName(orderstatus, string, "orderstatus"));
            orderEntry.set("ticketprice", (Object)DailyReimCreateOrderEntrysUtil.getTicketPrice(orderBill, string));
            orderEntry.set("refundamount", (Object)DailyReimCreateOrderEntrysUtil.getRefundAmount(orderBill, string));
            orderEntry.set("assuranceamount", (Object)DailyReimCreateOrderEntrysUtil.getPremium(orderBill, string));
            Map<String, Object> travelmap = DailyReimCreateOrderEntrysUtil.getTraveMap(orderBill, string);
            orderEntry.set("travelername", travelmap.get("travelerName"));
            orderEntry.set("fromplace", travelmap.get("from"));
            orderEntry.set("toplace", travelmap.get("to"));
            orderEntry.set("begintime", travelmap.get("beginTime"));
            orderEntry.set("endtime", travelmap.get("endTime"));
            orderEntry.set("ordexpenseentryid", (Object)ErCommonUtils.getPk(expenseEntry.getPkValue()));
            if ("er_planebill".equals(string)) {
                orderEntry.set("ticketstatus", (Object)orderBill.getString("ticketstatus"));
                orderEntry.set("airportprice", (Object)orderBill.getString("airportprice"));
                orderEntry.set("fuelprice", (Object)orderBill.getString("fuelprice"));
                orderEntry.set("endorsementamount", (Object)orderBill.getString("endorsementamount"));
            }
            Map<String, Object> invoiceSetMap = null;
            String server = orderBill.getString("server");
            if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)string) && (StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"USED") || StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"CHANGED")) || StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)string) || StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)string) || StringUtils.equals((CharSequence)"er_trainbill", (CharSequence)string) || StringUtils.equals((CharSequence)"er_mealbill", (CharSequence)string)) {
                invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderBill, server, null, targetBill);
            } else if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)string) && StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"REFOUND")) {
                invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderBill, server, Serviceitem.SERVICE);
            }
            if (invoiceSetMap != null) {
                BigDecimal orderTotalTax = (BigDecimal)invoiceSetMap.get("totalTax");
                totalTax = totalTax.add(orderTotalTax);
                orderEntry.set("orderdeductibletax", (Object)orderTotalTax);
                orderEntry.set("ticketpricedeductibletax", invoiceSetMap.getOrDefault("orderamounttax", BigDecimal.ZERO));
                orderEntry.set("servicefeedeductibletax", invoiceSetMap.getOrDefault("serviceamounttax", BigDecimal.ZERO));
            }
            successInitOrderEntries.add(orderEntry);
        }
        DynamicObject entrycurrency = tripOrders.get(0).getDynamicObject("currency");
        if (entrycurrency != null) {
            expenseEntry.set("entrycurrency", (Object)entrycurrency);
            Map<String, Object> exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams(companyId, expenseEntry.getDynamicObject("entrycostcompany"), ErCommonUtils.getPk(entrycurrency), ErCommonUtils.getPk(targetBill.getDynamicObject("currency")), targetBill.get("bizdate"));
            String string = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
            BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
            expenseEntry.set("exchangerate", (Object)exchangeRate);
            expenseEntry.set("expquotetype", (Object)string);
        }
        if (!(expenseAmountEdit = SystemParamterUtil.getExpenseAmountEdit(companyId)) && !expenseEntry.getBoolean("isexistmonthly")) {
            for (String field : setZeroField) {
                expenseEntry.set(field, (Object)BigDecimal.ZERO);
            }
        }
        BigDecimal bigDecimal = successInitOrderEntries.stream().filter(m -> m.getBigDecimal("ordertotalamount") != null && ConvertUtil.getOrderAmountInit().compareTo(m.getBigDecimal("ordertotalamount")) != 0).map(v -> v.getBigDecimal("ordertotalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        DynamicObject entryCurrency = expenseEntry.getDynamicObject("entrycurrency");
        BigDecimal exchangeRate = expenseEntry.getBigDecimal("exchangerate");
        String quoteType = expenseEntry.getString("expquotetype");
        int curPrecision = precision = entryCurrency == null ? 4 : entryCurrency.getInt("amtprecision");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        if (currency != null) {
            curPrecision = AmountUtils.getCurrencyPrecision(currency.getPkValue());
        }
        BigDecimal totalcurAmount = AmountUtils.getCurrencyAmount(bigDecimal, exchangeRate, curPrecision, quoteType);
        expenseEntry.set("tripbookamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "tripbookamount", bigDecimal));
        expenseEntry.set("tripbookcuramount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "tripbookcuramount", totalcurAmount));
        expenseEntry.set("expenseamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "expenseamount", bigDecimal));
        expenseEntry.set("currexpenseamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "currexpenseamount", totalcurAmount));
        expenseEntry.set("expeapproveamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "expeapproveamount", bigDecimal));
        expenseEntry.set("expeapprovecurramount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "expeapprovecurramount", totalcurAmount));
        expenseEntry.set("taxamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "taxamount", totalTax));
        expenseEntry.set("approvetax", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "approvetax", totalTax));
        expenseEntry.set("orientryamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "orientryamount", bigDecimal.subtract(totalTax)));
        expenseEntry.set("price", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "price", bigDecimal.subtract(totalTax)));
        expenseEntry.set("deductibletax", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(expenseEntry, "deductibletax", totalTax));
        expenseEntry.set("isexistmonthly", (Object)true);
        expenseEntry.set("itemfrom", (Object)"3");
        if (expenseEntry.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) > 0) {
            expenseEntry.set("is_special_invoice", (Object)true);
            expenseEntry.set("offset", (Object)true);
        }
        targetBill.set("monthsettleamount", (Object)DailyReimCreateOrderEntrysUtil.getAmountAddNew(targetBill, "monthsettleamount", totalcurAmount));
    }

    private static Map<String, Object> getTraveMap(DynamicObject orderBill, String orderFormId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String from = "";
        String to = "";
        String travelerName = "";
        Date beginTime = null;
        Date endTime = null;
        switch (orderFormId) {
            case "er_planebill": {
                from = orderBill.getString("fromcityname");
                to = orderBill.getString("tocityname");
                travelerName = orderBill.getString("travelername");
                beginTime = orderBill.getDate("takeofftime");
                endTime = orderBill.getDate("landingtime");
                break;
            }
            case "er_hotelbill": {
                to = orderBill.getString("cityname");
                travelerName = orderBill.getString("travelername");
                beginTime = orderBill.getDate("checkindate");
                endTime = orderBill.getDate("checkoutdate");
                break;
            }
            case "er_trainbill": {
                from = orderBill.getString("departcity");
                to = orderBill.getString("arrivecity");
                beginTime = orderBill.getDate("departtime");
                endTime = orderBill.getDate("arrivetime");
                travelerName = orderBill.getString("passegername");
                break;
            }
            case "er_vehiclebill": {
                from = orderBill.getString("departaddress");
                to = orderBill.getString("arriveaddress");
                beginTime = orderBill.getDate("usetime");
                travelerName = orderBill.getString("passegername");
                break;
            }
            case "er_mealbill": {
                to = orderBill.getString("mealcityname");
                travelerName = orderBill.getString("bookedname");
                endTime = orderBill.getDate("mealtime");
            }
        }
        map.put("from", from);
        map.put("to", to);
        map.put("travelerName", travelerName);
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        return map;
    }

    public static BigDecimal getPremium(DynamicObject orderBill, String orderFormId) {
        BigDecimal premium = BigDecimal.ZERO;
        switch (orderFormId) {
            case "er_planebill": {
                premium = orderBill.getBigDecimal("assuranceamount");
                break;
            }
            case "er_trainbill": {
                premium = orderBill.getBigDecimal("dealamount");
            }
        }
        return premium;
    }

    public static BigDecimal getRefundAmount(DynamicObject orderBill, String orderFormId) {
        BigDecimal refundamount = BigDecimal.ZERO;
        switch (orderFormId) {
            case "er_hotelbill": {
                refundamount = orderBill.getBigDecimal("unbookfee");
                break;
            }
            case "er_trainbill": 
            case "er_planebill": {
                refundamount = orderBill.getBigDecimal("refundamount");
            }
        }
        return refundamount;
    }

    public static BigDecimal getTicketPrice(DynamicObject orderBill, String orderFormId) {
        BigDecimal ticketprice = BigDecimal.ZERO;
        switch (orderFormId) {
            case "er_hotelbill": {
                ticketprice = orderBill.getBigDecimal("roomamount");
                break;
            }
            case "er_mealbill": {
                ticketprice = orderBill.getBigDecimal("totalamount").subtract(orderBill.getBigDecimal("servicefee"));
                break;
            }
            case "er_vehiclebill": {
                ticketprice = orderBill.getBigDecimal("dealamount");
                break;
            }
            case "er_trainbill": 
            case "er_planebill": {
                ticketprice = orderBill.getBigDecimal("ticketprice");
            }
        }
        return ticketprice;
    }

    public static String getCombofieldName(String orderstatus, String orderFormId, String itemName) {
        String orderstatusName = "";
        ComboProp property = (ComboProp)MetadataServiceHelper.getDataEntityType((String)orderFormId).getProperty(itemName);
        for (ValueMapItem comboItem : property.getComboItems()) {
            String key = comboItem.getValue();
            if (!StringUtils.equals((CharSequence)key, (CharSequence)orderstatus)) continue;
            orderstatusName = comboItem.getName().getLocaleValue();
        }
        return orderstatusName;
    }

    public static BigDecimal getAmountAddNew(DynamicObject entry, String fieldName, BigDecimal amount) {
        BigDecimal oldAmount = entry.getBigDecimal(fieldName);
        BigDecimal newAmount = oldAmount.add(amount);
        return newAmount;
    }

    public static String getOrderNumStr(DynamicObjectCollection orderEntrys, Long detailid) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (DynamicObject orderEntry : orderEntrys) {
            if (detailid.longValue() == orderEntry.getLong("ordexpenseentryid")) {
                builder.append(orderEntry.getString("ordernumber")).append("\uff0c");
                ++i;
            }
            if (i != 3) continue;
            int a = builder.lastIndexOf("\uff0c");
            builder.deleteCharAt(a);
            builder.append("...");
            return builder.toString();
        }
        int index = builder.lastIndexOf("\uff0c");
        if (index > 0) {
            builder.deleteCharAt(builder.lastIndexOf("\uff0c"));
        }
        return builder.toString();
    }

    public static String getAllOrderNumStr(DynamicObjectCollection orderEntrys, Long detailid) {
        StringBuilder builder = new StringBuilder();
        for (DynamicObject orderEntry : orderEntrys) {
            if (detailid.longValue() != orderEntry.getLong("ordexpenseentryid")) continue;
            builder.append(orderEntry.getString("ordernumber")).append("\uff0c");
        }
        int index = builder.lastIndexOf("\uff0c");
        if (index > 0) {
            builder.deleteCharAt(builder.lastIndexOf("\uff0c"));
        }
        return builder.toString();
    }

    public static Map<String, String> getRelationOrderMap(DynamicObjectCollection orderEntrys, Long detailid) {
        HashMap<String, String> orderMap = new HashMap<String, String>();
        StringBuilder orderNum = new StringBuilder();
        StringBuilder orderFormid = new StringBuilder();
        for (DynamicObject orderEntry : orderEntrys) {
            if (detailid.longValue() != orderEntry.getLong("ordexpenseentryid")) continue;
            orderNum.append(orderEntry.getString("ordernumber")).append(",");
            orderFormid.append(orderEntry.getString("orderformid")).append(",");
        }
        if (orderNum.lastIndexOf(",") > 0) {
            orderNum.deleteCharAt(orderNum.lastIndexOf(","));
        }
        if (orderFormid.lastIndexOf(",") > 0) {
            orderFormid.deleteCharAt(orderFormid.lastIndexOf(","));
        }
        orderMap.put("orderNum", orderNum.toString());
        orderMap.put("orderFormid", orderFormid.toString());
        return orderMap;
    }

    public static Map<String, List<DynamicObject>> groupByFormId(List<DynamicObject> notReimbursedOrderList) {
        HashMap<String, List<DynamicObject>> orderMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject order : notReimbursedOrderList) {
            String orderFormId = order.getDataEntityType().getName();
            if (orderMap.get(orderFormId) == null) {
                ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>();
                orderList.add(order);
                orderMap.put(orderFormId, orderList);
                continue;
            }
            ((List)orderMap.get(orderFormId)).add(order);
        }
        return orderMap;
    }
}

