/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dailybiz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.integrationenum.CasWriteBackOperateEnum;
import org.apache.commons.lang.StringUtils;

public class DailyReimWriteBackOrderUtil {
    private static Log logger = LogFactory.getLog(DailyReimWriteBackOrderUtil.class);
    private static Set<String> checkingBillFormIDs = new HashSet<String>(){
        {
            this.add("er_hotelcheckingbill");
            this.add("er_planecheckingbill");
            this.add("er_vehiclecheckingbill");
            this.add("er_traincheckingbill");
            this.add("er_mealcheckingbill");
        }
    };

    public static void reverseOrderBill(Long billId, Boolean isReimburse, Boolean isAudit, String operateKey, String entityName) {
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u62a5\u9500\u5355\u53cd\u5199\u5546\u65c5\u8ba2\u5355\u548c\u7ed3\u7b97\u5355start,\u5355\u636eid:%s,\u662f\u5426\u786e\u8ba4\u62a5\u9500:%s,\u662f\u5426\u5ba1\u6838\u901a\u8fc7:%s, \u64cd\u4f5c\uff1a %s,\u5355\u636e\u6807\u8bc6:  %s", billId, isReimburse, isAudit, operateKey, entityName));
        DynamicObject reimburseBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityName, (String)"id,billno,company,costcompany,costdept,orderentry,ordercostcompany,ordercostdept,server,orderformid,ordernumber");
        HashMap<String, Set<String>> orderNumMap = new HashMap<String, Set<String>>();
        HashSet<String> allOrderNumSet = new HashSet<String>();
        HashSet<String> serverSet = new HashSet<String>();
        DailyReimWriteBackOrderUtil.getEntryOrderInfo(reimburseBill, orderNumMap, allOrderNumSet, serverSet);
        if (orderNumMap.size() < 1) {
            return;
        }
        HashMap<String, DynamicObject[]> billMap = new HashMap<String, DynamicObject[]>();
        Map<String, DynamicObject[]> orderBillMap = DailyReimWriteBackOrderUtil.queryOrderBill(orderNumMap, serverSet, allOrderNumSet);
        if (orderBillMap == null) {
            return;
        }
        billMap.putAll(orderBillMap);
        Map<String, DynamicObject[]> checkingBillMap = DailyReimWriteBackOrderUtil.queryCheckingBill(serverSet, allOrderNumSet);
        billMap.putAll(checkingBillMap);
        String billno = reimburseBill.getString("billno");
        billMap.forEach((billFormId, billArray) -> {
            for (DynamicObject bill : billArray) {
                DailyReimWriteBackOrderUtil.setReverseValue(bill, reimburseBill, isReimburse, isAudit, billno, operateKey);
            }
        });
        billMap.forEach((billFormId, billArray) -> SaveServiceHelper.save((DynamicObject[])billArray));
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u62a5\u9500\u5355\u53cd\u5199\u5546\u65c5\u8ba2\u5355\u548c\u7ed3\u7b97\u5355end");
    }

    private static void getEntryOrderInfo(DynamicObject reimburseBill, Map<String, Set<String>> orderNumMap, Set<String> allOrderNumSet, Set<String> serverSet) {
        DynamicObjectCollection orderEntrys = reimburseBill.getDynamicObjectCollection("orderentry");
        for (DynamicObject orderEntry : orderEntrys) {
            String server = orderEntry.getString("server");
            String orderFormId = orderEntry.getString("orderformid");
            String orderNum = orderEntry.getString("ordernumber");
            if (StringUtils.isBlank((String)server) || StringUtils.isBlank((String)orderFormId) || StringUtils.isBlank((String)orderNum) || orderFormId.indexOf(",") != -1) continue;
            Set<String> orderNumSet = orderNumMap.get(orderFormId);
            if (orderNumSet == null || orderNumSet.size() < 1) {
                orderNumSet = new HashSet<String>();
                orderNumMap.put(orderFormId, orderNumSet);
            }
            orderNumSet.add(orderNum);
            allOrderNumSet.add(orderNum);
            serverSet.add(server);
        }
    }

    private static Map<String, DynamicObject[]> queryOrderBill(Map<String, Set<String>> orderNumMap, Set<String> serverSet, Set<String> allOrderNumSet) {
        String selectOrderFields = "id, server, ordernum, isconfirm, isreimburse, isapprove, company, expcommitcomnum, expcommitdepnum,reimbursenum, reimbursestatus, reimbillformid";
        HashMap<String, DynamicObject[]> orderBillMap = new HashMap<String, DynamicObject[]>();
        orderNumMap.forEach((orderFormId, orderNumSet) -> {
            DynamicObject[] orders = BusinessDataServiceHelper.load((String)orderFormId, (String)selectOrderFields, (QFilter[])new QFilter[]{new QFilter("ordernum", "in", orderNumSet).and(new QFilter("server", "in", (Object)serverSet))});
            if (orders == null || orders.length < 1) {
                return;
            }
            orderBillMap.put((String)orderFormId, orders);
        });
        if (orderBillMap.size() < 1) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("ordernum", "in", allOrderNumSet).and(new QFilter("server", "in", serverSet))};
        DynamicObject[] allOrders = BusinessDataServiceHelper.load((String)"er_allorderbill", (String)selectOrderFields, (QFilter[])filters);
        if (allOrders != null && allOrders.length > 0) {
            orderBillMap.put("er_allorderbill", allOrders);
        }
        return orderBillMap;
    }

    private static Map<String, DynamicObject[]> queryCheckingBill(Set<String> serverSet, Set<String> allOrderNumSet) {
        String selectCheckingFields = "id, server, settlemain, settledept, reimbursestatus,ordernum, reimbillformid";
        QFilter[] filters = new QFilter[]{new QFilter("ordernum", "in", allOrderNumSet).and(new QFilter("server", "in", serverSet))};
        HashMap<String, DynamicObject[]> checkingBillMap = new HashMap<String, DynamicObject[]>();
        checkingBillFormIDs.forEach(checkingBillFormID -> {
            DynamicObject[] checkingBills = BusinessDataServiceHelper.load((String)checkingBillFormID, (String)selectCheckingFields, (QFilter[])filters);
            if (checkingBills != null && checkingBills.length > 0) {
                checkingBillMap.put((String)checkingBillFormID, checkingBills);
            }
        });
        return checkingBillMap;
    }

    private static Map<String, Boolean> getCostParamMap(Set<String> serverSet) {
        HashMap<String, Boolean> costParamMap = new HashMap<String, Boolean>();
        Arrays.stream(Supplier.values()).forEach(supplier -> costParamMap.put(supplier.name(), true));
        Map<Object, DynamicObject> setCostMap = TripCommonUtil.getTripServiceInfoDOMap(serverSet);
        setCostMap.forEach((id, dynamicObject) -> {
            String server = dynamicObject.getString("number");
            String param = dynamicObject.getString("setcostorg");
            boolean flag = param == null || StringUtils.isBlank((String)param) || "0".equalsIgnoreCase(param);
            costParamMap.put(server, flag);
        });
        return costParamMap;
    }

    private static void setReverseValue(DynamicObject bill, DynamicObject reimburseBill, boolean isReimburse, boolean isAudit, String billno, String operateKey) {
        String billFormId = bill.getDataEntityType().getName();
        String formId = reimburseBill.getDataEntityType().getName();
        if (!checkingBillFormIDs.contains(billFormId)) {
            if (!"save".equals(operateKey)) {
                bill.set("isreimburse", (Object)isReimburse);
                if (isReimburse) {
                    bill.set("reimbursenum", (Object)billno);
                    bill.set("reimbillformid", (Object)formId);
                } else {
                    bill.set("reimbursenum", (Object)"");
                    bill.set("reimbillformid", (Object)"");
                }
                bill.set("isconfirm", (Object)isReimburse);
                bill.set("isapprove", (Object)isAudit);
            }
            if (Arrays.asList("er_planebill", "er_trainbill", "er_vehiclebill", "er_hotelbill", "er_mealbill").contains(billFormId)) {
                bill.set("reimbursestatus", (Object)DailyReimWriteBackOrderUtil.getReimburseStatus(operateKey));
            }
        }
        if (checkingBillFormIDs.contains(billFormId)) {
            bill.set("reimbursestatus", (Object)DailyReimWriteBackOrderUtil.getReimburseStatus(operateKey));
            if (isReimburse) {
                bill.set("reimbillformid", (Object)formId);
            } else {
                bill.set("reimbillformid", (Object)"");
            }
        }
    }

    private static String getReimburseStatus(String operateKey) {
        String reimburseStatus = "B";
        if (StringUtils.isEmpty((String)operateKey)) {
            return reimburseStatus;
        }
        if (Arrays.asList("delete", "converttoh", "invalidbtn").contains(operateKey)) {
            reimburseStatus = "A";
        } else if (Arrays.asList("converttoi", "closebill").contains(operateKey)) {
            reimburseStatus = "C";
        }
        return reimburseStatus;
    }

    public static void reimburseStatus(String entityId, Long billId, String reimburseStatus) {
        logger.info(String.format("\u66f4\u65b0\u5546\u65c5\u8ba2\u5355\u62a5\u9500\u72b6\u6001\uff1a billid\uff1a %s, reimburseStatus: %s, \u5355\u636e\u7c7b\u578b\uff1a %s", billId, reimburseStatus, entityId));
        HashMap orderMap = new HashMap(8);
        HashMap<String, Set<String>> orderNumMap = new HashMap<String, Set<String>>();
        if ("er_tripreimbursebill".equals(entityId)) {
            DynamicObject reimburseBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_tripreimbursebill", (String)"id,billno,costcompany,costdept,tripentry,tripentry.entryentity,provider,orderformid,ordernum");
            HashSet<String> allOrderNumSet = new HashSet<String>();
            HashSet<String> serverSet = new HashSet<String>();
            DailyReimWriteBackOrderUtil.getEntryOrderInfo(reimburseBill, orderNumMap, allOrderNumSet, serverSet);
            if (orderNumMap.size() < 1) {
                return;
            }
            for (Map.Entry entry : orderNumMap.entrySet()) {
                DynamicObject[] dynamicObjects = DailyReimWriteBackOrderUtil.listOrdersByOrderNum((Set)entry.getValue(), (String)entry.getKey());
                orderMap.put(entry.getKey(), Arrays.asList(dynamicObjects));
            }
            for (Map.Entry entry : orderMap.entrySet()) {
                DailyReimWriteBackOrderUtil.setReimburseStatus(reimburseStatus, (List)entry.getValue());
            }
            Map<String, DynamicObject[]> checkingBillMap = DailyReimWriteBackOrderUtil.queryCheckingBill(serverSet, allOrderNumSet);
            for (Map.Entry<String, DynamicObject[]> entry : checkingBillMap.entrySet()) {
                Arrays.stream((Object[])entry.getValue()).forEach(e -> e.set("reimbursestatus", (Object)reimburseStatus));
                SaveServiceHelper.save((DynamicObject[])entry.getValue());
            }
        } else if ("er_dailyreimbursebill".equals(entityId) || "er_publicreimbursebill".equals(entityId)) {
            ArrayList<DynamicObject> checkingBills = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> orderBills = new ArrayList<DynamicObject>();
            DailyReimWriteBackOrderUtil.findTravelOrdersByReimburseBill(entityId, billId, checkingBills, orderBills);
            DailyReimWriteBackOrderUtil.setReimburseStatus(reimburseStatus, checkingBills);
            DailyReimWriteBackOrderUtil.setReimburseStatus(reimburseStatus, orderBills);
        }
    }

    private static void setReimburseStatus(String reimburseStatus, List<DynamicObject> checkingBills) {
        if (checkingBills.size() > 0) {
            checkingBills.forEach(e -> e.set("reimbursestatus", (Object)reimburseStatus));
            SaveServiceHelper.save((DynamicObject[])checkingBills.toArray(new DynamicObject[0]));
        }
    }

    private static void findTravelOrdersByReimburseBill(String entityId, Long billId, List<DynamicObject> checkingBills, List<DynamicObject> orderBills) {
        Map sourceBillIds = BFTrackerServiceHelper.findSourceBills((String)entityId, (Long[])new Long[]{billId});
        DynamicObject[] checkings = DailyReimWriteBackOrderUtil.getVehicleCheckingBill(sourceBillIds);
        checkingBills.addAll(Arrays.asList(checkings));
        HashSet<String> orderNumsSet = new HashSet<String>(checkings.length);
        for (int j = 0; j < checkings.length; ++j) {
            orderNumsSet.add(checkings[j].getString("ordernum"));
        }
        orderBills.addAll(Arrays.asList(DailyReimWriteBackOrderUtil.listOrdersByOrderNum(orderNumsSet, "er_vehiclebill")));
    }

    private static DynamicObject[] listOrdersByOrderNum(Set<String> orderNumsSet, String entityId) {
        QFilter qFilter = new QFilter("ordernum", "in", orderNumsSet);
        DynamicObject[] orderBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,ordernum, reimbursestatus", (QFilter[])new QFilter[]{qFilter});
        if (orderBills != null && orderBills.length > 0) {
            return orderBills;
        }
        return new DynamicObject[0];
    }

    private static DynamicObject[] getVehicleCheckingBill(Map<String, HashSet<Long>> sourceBillIds) {
        if (null == sourceBillIds || sourceBillIds.isEmpty()) {
            return new DynamicObject[0];
        }
        HashSet<Long> vehiclecheckingbillIds = sourceBillIds.get("er_vehiclecheckingbill");
        if (null == vehiclecheckingbillIds || vehiclecheckingbillIds.isEmpty()) {
            return new DynamicObject[0];
        }
        String selectField = "id,isapprove,billstatus,ordernum, reimbursestatus";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", vehiclecheckingbillIds)};
        DynamicObject[] checkingBills = BusinessDataServiceHelper.load((String)"er_vehiclecheckingbill", (String)selectField, (QFilter[])qFilters);
        if (checkingBills != null && checkingBills.length > 0) {
            return checkingBills;
        }
        return new DynamicObject[0];
    }

    public static boolean onlyValidate(String operateName) {
        CasWriteBackOperateEnum operateEnum = CasWriteBackOperateEnum.getWriteOperateEnumByValue((String)operateName);
        return CasWriteBackOperateEnum.CANCELPAYVALIDATE == operateEnum || CasWriteBackOperateEnum.PAYVALIDATE == operateEnum || CasWriteBackOperateEnum.CANCELREFUNDVALIDATE == operateEnum || CasWriteBackOperateEnum.CANCELRENOTEVALIDATE == operateEnum;
    }
}

