/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dailybiz;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.seatstd.TripVhcStdChangeUtils;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.servicehelper.invoice.GenerateInvoicerAssistant;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.context.OrderExpenseDetailContext;
import kd.fi.er.business.trip.context.data.ExchangeRateDataKey;
import kd.fi.er.business.trip.context.data.ExchangeRates;
import kd.fi.er.business.trip.context.data.TripItemDataKey;
import kd.fi.er.business.trip.dailybiz.TripBusinessRelatDailyBusinessUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.tripstd.service.imp.ErTripStdControlServiceImpl;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.sdk.fi.er.extpoint.trip.ITripOrderUpdateReimService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TripReimCreateOrderEntrysUtil {
    private static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};
    private static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};
    private static final Log logger = LogFactory.getLog(TripReimCreateOrderEntrysUtil.class);

    public static List<DynamicObject> initOrderEntrys(DynamicObject targetBill, DynamicObject targetTripEntry, Set<Long> travelerIdSet, List<DynamicObject> tripOrders, boolean isShowInvoiceEntry, Map<String, Object> existMontrhEntryMap, DynamicObject reqBill, OrderExpenseDetailContext orderExpenseDetailContext) {
        return TripReimCreateOrderEntrysUtil.initOrderEntrys(targetBill, targetTripEntry, travelerIdSet, tripOrders, isShowInvoiceEntry, false, existMontrhEntryMap, reqBill, orderExpenseDetailContext);
    }

    public static List<DynamicObject> initOrderEntrys(DynamicObject targetBill, DynamicObject targetTripEntry, Set<Long> travelerIdSet, List<DynamicObject> tripOrders, boolean isShowInvoiceEntry, boolean pullTravelOrders, Map<String, Object> existMontrhEntryMap, DynamicObject reqBill, OrderExpenseDetailContext orderExpenseDetailContext) {
        return TripReimCreateOrderEntrysUtil.initOrderEntrys(targetBill, targetTripEntry, travelerIdSet, tripOrders, isShowInvoiceEntry, false, existMontrhEntryMap, reqBill, "", orderExpenseDetailContext);
    }

    public static void fillservicefee(DynamicObject targetBill, DynamicObject targetTripEntry, List<DynamicObject> orderbills, Boolean pulltravelorder, Boolean isadd, OrderExpenseDetailContext orderExpenseDetailContext) {
        Long id;
        DynamicObject tripexpenseitem;
        Long companyId;
        DynamicObject company = targetBill.getDynamicObject("company");
        Long l = companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk(company);
        if (1 != SystemParamterUtil.getcheckparamDefaute(companyId, "ticketservicesplit")) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u670d\u52a1\u8d39\u672a\u62c6\u5206 {}", (Object)companyId);
            return;
        }
        DynamicObject tripItem = TripBusinessRelatDailyBusinessUtil.getExpenseitemByOrder(AbstractOrderModel.OperationType.G.getKey(), companyId);
        if (tripItem == null) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u65e0\u670d\u52a1\u8d39\u7c7b\u578b\u5dee\u65c5\u9879\u76ee {}", (Object)companyId);
            return;
        }
        DynamicObjectCollection entrys = targetTripEntry.getDynamicObjectCollection("entryentity");
        HashMap servicefeeMap = Maps.newHashMapWithExpectedSize((int)0);
        Boolean isdeductible = Boolean.FALSE;
        ArrayList<String> sordernums = new ArrayList<String>();
        int getReimburseMonthlyOffsetValue = SystemParamterUtil.getloancheckparam(companyId, "getreimbursemonthlyoffset");
        for (DynamicObject entry : entrys) {
            String[] ordernums;
            if (entry.get("ordernum") == null || StringUtils.isEmpty((CharSequence)entry.get("ordernum").toString()) || (tripexpenseitem = BusinessDataServiceHelper.loadSingleFromCache((Object)(id = Long.valueOf(entry.getDynamicObject("expenseitem") == null ? 0L : entry.getDynamicObject("expenseitem").getLong("id"))), (String)"er_tripexpenseitem")) == null || tripexpenseitem.getString("operationtype").indexOf(AbstractOrderModel.OperationType.G.getKey()) <= 0) continue;
            for (String ordernum : ordernums = entry.getString("ordernum").split(",")) {
                sordernums.add(ordernum);
            }
        }
        for (DynamicObject entry : entrys) {
            if (entry.get("ordernum") == null || StringUtils.isEmpty((CharSequence)entry.get("ordernum").toString()) || (tripexpenseitem = BusinessDataServiceHelper.loadSingleFromCache((Object)(id = Long.valueOf(entry.getDynamicObject("expenseitem") == null ? 0L : entry.getDynamicObject("expenseitem").getLong("id"))), (String)"er_tripexpenseitem")) != null && tripexpenseitem.getString("operationtype").indexOf(AbstractOrderModel.OperationType.G.getKey()) > 0) continue;
            for (DynamicObject orderbill : orderbills) {
                Set<Long> sourcetravelerids;
                Map<String, BigDecimal> map;
                if (!entry.get("ordernum").equals(orderbill.get("ordernum")) || sordernums.contains(orderbill.getString("ordernum"))) continue;
                String server = orderbill.getString("server");
                String orderFormId = orderbill.getDynamicObjectType().getName();
                String expcommitcomnum = "";
                if (orderbill.getDynamicObject("expcommitcomnum") != null) {
                    expcommitcomnum = orderbill.getDynamicObject("expcommitcomnum").getString("name");
                }
                Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId(orderbill);
                Map<String, Object> invoiceSetMap = null;
                if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && (StringUtils.equals((CharSequence)orderbill.getString("ticketstatus"), (CharSequence)"USED") || StringUtils.equals((CharSequence)orderbill.getString("ticketstatus"), (CharSequence)"CHANGED")) || StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) || StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId) || StringUtils.equals((CharSequence)"er_trainbill", (CharSequence)orderFormId) || StringUtils.equals((CharSequence)"er_mealbill", (CharSequence)orderFormId)) {
                    invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderbill, server, null, targetBill);
                } else if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && StringUtils.equals((CharSequence)orderbill.getString("ticketstatus"), (CharSequence)"REFOUND")) {
                    invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderbill, server, Serviceitem.SERVICE);
                }
                logger.info(String.format("\u670d\u52a1\u8d39\u5dee\u65c5\u9879\u76ee\uff0corderFormId\uff1a%1$s,\u5f00\u7968\u8bbe\u7f6e\uff1a%2$s", orderFormId, JSON.toJSONString(invoiceSetMap)));
                if (invoiceSetMap == null) continue;
                BigDecimal servicefee = orderbill.getBigDecimal("servicefee");
                BigDecimal serviceDeductrate = (BigDecimal)invoiceSetMap.getOrDefault("serviceDeductrate", "0");
                BigDecimal serviceamounttax = (BigDecimal)invoiceSetMap.getOrDefault("serviceamounttax", "0");
                if (((Boolean)invoiceSetMap.get("isdeductible")).booleanValue() && getReimburseMonthlyOffsetValue == 1) {
                    isdeductible = (Boolean)invoiceSetMap.get("isdeductible");
                }
                int precision = AmountUtils.getAmountFieldPrecision(entry, "entryamount");
                Object currencyObj = orderbill.get("currency");
                Long currencyId = currencyObj == null ? Long.valueOf(-1L) : ErCommonUtils.getPk(currencyObj);
                DynamicObject targetCurrencyObj = targetBill.getDynamicObject("currency");
                Long targetCurrencyId = targetCurrencyObj == null ? Long.valueOf(-1L) : ErCommonUtils.getPk(targetCurrencyObj);
                Map<Object, Object> exchangeMap = new HashMap();
                if (null != orderExpenseDetailContext) {
                    ExchangeRates exchangeRates = orderExpenseDetailContext.getExchangeRates();
                    Object orderCosCompany = orderbill.get("expcommitcomnum");
                    Long cosCompanyId = orderCosCompany == null ? Long.valueOf(0L) : ErCommonUtils.getPk(orderCosCompany);
                    ExchangeRateDataKey exchangeRateDataKey = new ExchangeRateDataKey(companyId, cosCompanyId, currencyId, targetCurrencyId, (Date)targetBill.get("bizdate"));
                    if (exchangeRates.exist(exchangeRateDataKey)) {
                        exchangeMap = exchangeRates.get(exchangeRateDataKey).getExchangeRateMap();
                    }
                } else {
                    exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams(companyId, orderbill.get("expcommitcomnum"), currencyId, ErCommonUtils.getPk(targetBill.getDynamicObject("currency")), targetBill.get("bizdate"));
                }
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                String key = server + "," + expcommitcomnum + "," + serviceDeductrate;
                logger.info("\u670d\u52a1\u8d39\u5dee\u65c5\u9879\u76ee\uff0c\u6309\u670d\u52a1\u5546\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7a0e\u7387\u5206\u7ec4 key:{}", (Object)key);
                if (servicefeeMap.containsKey(key)) {
                    map = (Map)servicefeeMap.get(key);
                    map.put("servicefee", ((BigDecimal)map.get("servicefee")).add(servicefee));
                    map.put("serviceamounttax", ((BigDecimal)map.get("serviceamounttax")).add(serviceamounttax));
                    map.put("ordernum", (BigDecimal)((Object)(map.get("ordernum") + "," + orderbill.get("ordernum"))));
                    map.put("formid", (BigDecimal)((Object)(map.get("formid") + "," + orderFormId)));
                    sourcetravelerids = (Set)map.get(key + ",sourcetravelerids");
                    sourcetravelerids.add(sourcetravelerId);
                    map.put(key + ",sourcetravelerids", (BigDecimal)((Object)sourcetravelerids));
                    map.put("orderBill", (BigDecimal)orderbill);
                    map.put("serviceDeductible", (BigDecimal)invoiceSetMap.get("SERVICE"));
                    servicefeeMap.put(key, map);
                } else {
                    map = Maps.newHashMapWithExpectedSize((int)0);
                    sourcetravelerids = new HashSet();
                    map.put("servicefee", servicefee);
                    map.put("serviceamounttax", serviceamounttax);
                    map.put("ordernum", (BigDecimal)orderbill.get("ordernum"));
                    map.put("currencyId", (BigDecimal)((Object)currencyId));
                    map.put("quoteType", (BigDecimal)((Object)quoteType));
                    map.put("exchangeRate", exchangeRate);
                    map.put("precision", (BigDecimal)((Object)Integer.valueOf(precision)));
                    map.put("expcommitcomnum", (BigDecimal)orderbill.getDynamicObject("expcommitcomnum"));
                    map.put("expcommitdepnum", (BigDecimal)orderbill.getDynamicObject("expcommitdepnum"));
                    if (orderFormId.equals("er_hotelbill")) {
                        map.put("checkindate", (BigDecimal)((Object)orderbill.getDate("checkindate")));
                        map.put("checkoutdate", (BigDecimal)((Object)orderbill.getDate("checkoutdate")));
                    }
                    map.put("formid", (BigDecimal)((Object)orderFormId));
                    map.put(key + ",sourcetravelerids", (BigDecimal)((Object)sourcetravelerids));
                    sourcetravelerids.add(sourcetravelerId);
                    map.put("orderBill", (BigDecimal)orderbill);
                    map.put("serviceDeductible", (BigDecimal)invoiceSetMap.get("SERVICE"));
                    servicefeeMap.put(key, map);
                }
                BigDecimal taxamount = entry.getBigDecimal("taxamount");
                BigDecimal totalamount = entry.getBigDecimal("orientryamount");
                if (isadd.booleanValue()) {
                    taxamount = taxamount.subtract(serviceamounttax);
                    totalamount = totalamount.subtract(servicefee);
                }
                entry.set("taxamount", (Object)taxamount);
                entry.set("approvetax", (Object)taxamount);
                entry.set("deductibletax", (Object)taxamount);
                entry.set("orientryamount", (Object)totalamount);
                BigDecimal curTotalAmount = AmountUtils.getCurrencyAmount(totalamount, entry.getBigDecimal("exchangerate"), precision, entry.getString("detailquotetype"));
                entry.set("entryamount", (Object)curTotalAmount);
                entry.set("orientryappamount", (Object)totalamount);
                entry.set("entryappamount", (Object)curTotalAmount);
                entry.set("notaxamount", (Object)totalamount.subtract(taxamount));
                entry.set("price", (Object)totalamount.subtract(taxamount));
                BigDecimal curprice = AmountUtils.getCurrencyAmount(totalamount.subtract(taxamount), entry.getBigDecimal("exchangerate"), precision, entry.getString("detailquotetype"));
                entry.set("curprice", (Object)curprice);
                BigDecimal deductrate = BigDecimal.ZERO;
                deductrate = "er_planebill".equals(orderFormId) && AbstractOrderModel.OrderType.T.getKey().equals(orderbill.getString("ordertype")) ? (BigDecimal)invoiceSetMap.getOrDefault("itineraryRefundDeductrate", "0") : ("er_planebill".equals(orderFormId) && !"0".equals(invoiceSetMap.getOrDefault("itineraryDeductrate", "0").toString()) ? (BigDecimal)invoiceSetMap.getOrDefault("itineraryDeductrate", "0") : (BigDecimal)invoiceSetMap.getOrDefault("ticketDeductrate", "0"));
                logger.info("\u670d\u52a1\u8d39\u6e90\u5355\u5dee\u65c5\u9879\u76ee\uff0c\u7a0e\u7387\uff1a{}", (Object)deductrate);
                entry.set("taxrate", (Object)deductrate.multiply(new BigDecimal(100)));
            }
        }
        Iterator iterator = servicefeeMap.entrySet().iterator();
        ArrayList<Long> travlerids = new ArrayList<Long>(8);
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            Map map = (Map)mapEntry.getValue();
            logger.info("\u670d\u52a1\u8d39\u5dee\u65c5\u9879\u76ee\uff0c\u65b0\u589e\u670d\u52a1\u8d39\u9879\u76ee\u7ec4\uff1a{}", (Object)map);
            String key = (String)mapEntry.getKey();
            String server = key.split(",")[0];
            String serviceDeductrate = key.split(",")[2];
            BigDecimal servicefee = (BigDecimal)map.get("servicefee");
            int precision = (Integer)map.get("precision");
            if (servicefee.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal serviceamounttax = (BigDecimal)map.get("serviceamounttax");
            DynamicObject expcommitcomnum = (DynamicObject)map.get("expcommitcomnum");
            DynamicObject expcommitdepnum = (DynamicObject)map.get("expcommitdepnum");
            String ordernum = (String)map.get("ordernum");
            String formid = (String)map.get("formid");
            Long currencyId = (Long)map.get("currencyId");
            BigDecimal exchangeRate = (BigDecimal)map.get("exchangeRate");
            String quoteType = (String)map.get("quoteType");
            Set sourcetraveleridList = (Set)map.get(key + ",sourcetravelerids");
            DynamicObject dynamicObject = new DynamicObject(((DynamicObject)entrys.get(0)).getDynamicObjectType());
            dynamicObject.set("taxrate", (Object)new BigDecimal(serviceDeductrate).multiply(new BigDecimal(100)));
            dynamicObject.set("expenseitem", (Object)tripItem);
            dynamicObject.set("pic", (Object)tripItem.getString("expenseitemicon"));
            dynamicObject.set("offset", getReimburseMonthlyOffsetValue == 1 ? map.get("serviceDeductible") : isdeductible);
            dynamicObject.set("entrycurrency_id", (Object)currencyId);
            dynamicObject.set("exchangerate", (Object)exchangeRate);
            dynamicObject.set("detailquotetype", (Object)quoteType);
            BigDecimal totalAmount = servicefee;
            BigDecimal curTotalAmount = AmountUtils.getCurrencyAmount(totalAmount, exchangeRate, precision, quoteType);
            dynamicObject.set("taxamount", (Object)serviceamounttax);
            dynamicObject.set("approvetax", (Object)serviceamounttax);
            dynamicObject.set("deductibletax", (Object)serviceamounttax);
            dynamicObject.set("orientryamount", (Object)totalAmount);
            dynamicObject.set("entryamount", (Object)curTotalAmount);
            dynamicObject.set("orientryappamount", (Object)totalAmount);
            dynamicObject.set("entryappamount", (Object)curTotalAmount);
            dynamicObject.set("notaxamount", (Object)totalAmount.subtract(serviceamounttax));
            dynamicObject.set("price", (Object)totalAmount.subtract(dynamicObject.getBigDecimal("deductibletax") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("deductibletax")));
            BigDecimal curPrice = AmountUtils.getCurrencyAmount(dynamicObject.getBigDecimal("price"), exchangeRate, precision, quoteType);
            dynamicObject.set("curprice", (Object)curPrice);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)targetBill.getString("billkind"))) {
                dynamicObject.set("trip2startdate", (Object)targetTripEntry.getDate("startdate"));
                dynamicObject.set("trip2enddate", (Object)targetTripEntry.getDate("enddate"));
            }
            TripReimCreateOrderEntrysUtil.aboutOrder(companyId, null, dynamicObject, "");
            if (formid.equals("er_hotelbill")) {
                dynamicObject.set("trip2startdate", map.get("checkindate"));
                dynamicObject.set("trip2enddate", map.get("checkoutdate"));
            }
            dynamicObject.set("pulltravelorder", (Object)pulltravelorder);
            dynamicObject.set("provider", (Object)server);
            dynamicObject.set("ordernum", (Object)ordernum);
            dynamicObject.set("orderformid", (Object)formid);
            DynamicObjectCollection tripTravlerColl = dynamicObject.getDynamicObjectCollection("trip2travelers");
            logger.info("\u670d\u52a1\u8d39\u5dee\u65c5\u9879\u76ee\uff0c\u591a\u51fa\u5dee\u4eba:{}", (Object)sourcetraveleridList);
            if (tripTravlerColl.size() > 0) {
                tripTravlerColl.clear();
            }
            for (Long aLong : sourcetraveleridList) {
                if (travlerids.contains(aLong)) continue;
                DynamicObject tripTravler = tripTravlerColl.addNew();
                tripTravler.set("fbasedataid_id", (Object)aLong);
                travlerids.add(aLong);
            }
            dynamicObject.set("trip2travelerscount", (Object)sourcetraveleridList.size());
            dynamicObject.set("travelcostcompany_id", (Object)ErCommonUtils.getPk(expcommitcomnum));
            dynamicObject.set("travelcostdept_id", (Object)ErCommonUtils.getPk(expcommitdepnum));
            TripReimCreateOrderEntrysUtil.setExpenseItemLqouotactl(targetBill, targetTripEntry, dynamicObject);
            TripReimCreateOrderEntrysUtil.updateServiceOrderEntrys(targetTripEntry, dynamicObject);
        }
    }

    public static List<String> deleteServiceOrderEntrys(DynamicObject targetBill, DynamicObject targetTripEntry, DynamicObject dynamicObject, List<String> ordernumList, String type) {
        DynamicObjectCollection entrys = targetTripEntry.getDynamicObjectCollection("entryentity");
        logger.info("\u5220\u9664\u8ba2\u5355\uff0c\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)dynamicObject.getString("ordernum"));
        if (1 != SystemParamterUtil.getcheckparamDefaute(ErCommonUtils.getPk(targetBill.getDynamicObject("company")), "ticketservicesplit")) {
            return ordernumList;
        }
        if (entrys.size() == 0) {
            return ordernumList;
        }
        Iterator iterator = entrys.iterator();
        while (iterator.hasNext()) {
            List<String> list;
            DynamicObject entry = (DynamicObject)iterator.next();
            if (null == dynamicObject.getString("ordernum") || dynamicObject.getString("ordernum").isEmpty() || !(list = Arrays.asList(entry.getString("ordernum").split(","))).contains(dynamicObject.getString("ordernum"))) continue;
            logger.info("\u5220\u9664\u8ba2\u5355\uff0c\u540c\u6b65\u5220\u9664\u670d\u52a1\u8d39\u8ba2\u5355\uff0c\u8ba2\u5355\u53f7\u6ee1\u8db3\u6761\u4ef6\uff1a{}", (Object)entry.getString("ordernum"));
            if (null == entry.getDynamicObject("expenseitem")) continue;
            Long id = entry.getDynamicObject("expenseitem").getLong("id");
            DynamicObject tripexpenseitem = QueryServiceHelper.queryOne((String)"er_tripexpenseitem", (String)"operationtype,id,attribute,expenseitemicon,taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (null == tripexpenseitem || tripexpenseitem.getString("operationtype").indexOf(AbstractOrderModel.OperationType.G.getKey()) == -1) continue;
            logger.info("\u5220\u9664\u8ba2\u5355\uff0c\u540c\u6b65\u5220\u9664\u670d\u52a1\u8d39\u8ba2\u5355\uff0c\u670d\u52a1\u8d39\u6ee1\u8db3\u6761\u4ef6\uff1a{}", (Object)dynamicObject.getString("ordernum"));
            if (entry.getString("ordernum").equals(dynamicObject.getString("ordernum"))) {
                logger.info("\u5220\u9664\u8ba2\u5355\uff0c\u540c\u6b65\u5220\u9664\u670d\u52a1\u8d39\u8ba2\u5355\uff0citerator.remove();\uff1a{}", (Object)entry.getString("ordernum"));
                if ("move".equals(type)) {
                    iterator.remove();
                    continue;
                }
                ordernumList.add(entry.getString("ordernum"));
                continue;
            }
            String orderformid = dynamicObject.getString("orderformid");
            DynamicObject orderbill = BusinessDataServiceHelper.loadSingle((String)orderformid, (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "=", (Object)dynamicObject.getString("ordernum"))});
            if (null == orderbill || null == (orderbill = BusinessDataServiceHelper.loadSingle((Object)orderbill.getLong("id"), (String)orderformid))) continue;
            String server = orderbill.getString("server");
            Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId(orderbill);
            Map<String, Object> invoiceSetMap = null;
            if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderformid) && (StringUtils.equals((CharSequence)orderbill.getString("ticketstatus"), (CharSequence)"USED") || StringUtils.equals((CharSequence)orderbill.getString("ticketstatus"), (CharSequence)"CHANGED")) || StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderformid) || StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderformid) || StringUtils.equals((CharSequence)"er_trainbill", (CharSequence)orderformid) || StringUtils.equals((CharSequence)"er_mealbill", (CharSequence)orderformid)) {
                invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderbill, server, null);
            } else if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderformid) && StringUtils.equals((CharSequence)orderbill.getString("ticketstatus"), (CharSequence)"REFOUND")) {
                invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderbill, server, Serviceitem.SERVICE);
            }
            if (invoiceSetMap == null) continue;
            BigDecimal servicefee = orderbill.getBigDecimal("servicefee");
            BigDecimal serviceamounttax = (BigDecimal)invoiceSetMap.getOrDefault("serviceamounttax", "0");
            entry.set("taxamount", (Object)entry.getBigDecimal("taxamount").subtract(serviceamounttax));
            entry.set("approvetax", (Object)entry.getBigDecimal("taxamount"));
            entry.set("orientryamount", (Object)entry.getBigDecimal("orientryamount").subtract(servicefee));
            entry.set("entryamount", (Object)entry.getBigDecimal("entryamount").subtract(servicefee));
            entry.set("orientryappamount", (Object)entry.getBigDecimal("orientryappamount").subtract(servicefee));
            entry.set("entryappamount", (Object)entry.getBigDecimal("entryappamount").subtract(servicefee));
            entry.set("notaxamount", (Object)(entry.getBigDecimal("entryappamount").subtract(entry.getBigDecimal("taxamount")) == null ? BigDecimal.ZERO : entry.getBigDecimal("entryappamount").subtract(entry.getBigDecimal("taxamount"))));
            entry.set("price", (Object)entry.getBigDecimal("entryappamount").subtract(entry.getBigDecimal("taxamount")));
            entry.set("curprice", (Object)entry.getBigDecimal("price"));
            entry.set("deductibletax", (Object)entry.getBigDecimal("deductibletax").subtract(serviceamounttax));
            String ordernum = entry.getString("ordernum");
            String formid = entry.getString("orderformid");
            StringBuilder sbnum = new StringBuilder();
            StringBuilder sbid = new StringBuilder();
            String[] nums = ordernum.split(",");
            String[] ids = formid.split(",");
            for (int i = 0; i < nums.length; ++i) {
                String num = nums[i];
                if (num.equals(dynamicObject.getString("ordernum"))) continue;
                sbnum.append(num);
                sbid.append(ids[i]);
                if (i == nums.length - 1) continue;
                sbnum.append(",");
                sbid.append(",");
            }
            entry.set("ordernum", (Object)(sbnum.toString().endsWith(",") ? sbnum.substring(0, sbnum.length() - 1) : sbnum.toString()));
            entry.set("orderformid", (Object)(sbid.toString().endsWith(",") ? sbid.substring(0, sbid.length() - 1) : sbid.toString()));
            DynamicObjectCollection tripTravlerColl = entry.getDynamicObjectCollection("trip2travelers");
            DynamicObject tripTravler = tripTravlerColl.addNew();
            tripTravler.set("fbasedataid_id", (Object)sourcetravelerId);
            tripTravlerColl.remove((Object)tripTravler);
            entry.set("trip2travelerscount", (Object)(dynamicObject.getLong("trip2travelerscount") - 1L));
        }
        return ordernumList;
    }

    private static void updateServiceOrderEntrys(DynamicObject targetTripEntry, DynamicObject dynamicObject) {
        logger.info("\u670d\u52a1\u8d39\u5dee\u65c5\u9879\u76ee\uff0c\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u8d39\uff1a{}", (Object)dynamicObject);
        DynamicObjectCollection entrys = targetTripEntry.getDynamicObjectCollection("entryentity");
        Boolean isUpdate = Boolean.FALSE;
        for (DynamicObject entry : entrys) {
            if (!TripReimCreateOrderEntrysUtil.isServicefee(dynamicObject, entry)) continue;
            if (entry.getString("ordernum").indexOf(dynamicObject.getString("ordernum")) != -1) {
                isUpdate = Boolean.TRUE;
                continue;
            }
            entry.set("orientryamount", (Object)entry.getBigDecimal("orientryamount").add(dynamicObject.getBigDecimal("orientryamount")));
            entry.set("entryamount", (Object)entry.getBigDecimal("entryamount").add(dynamicObject.getBigDecimal("entryamount")));
            entry.set("orientryappamount", (Object)entry.getBigDecimal("orientryappamount").add(dynamicObject.getBigDecimal("orientryappamount")));
            entry.set("entryappamount", (Object)entry.getBigDecimal("entryappamount").add(dynamicObject.getBigDecimal("entryappamount")));
            entry.set("notaxamount", (Object)entry.getBigDecimal("notaxamount").add(dynamicObject.getBigDecimal("notaxamount")));
            entry.set("price", (Object)entry.getBigDecimal("price").add(dynamicObject.getBigDecimal("price")));
            entry.set("curprice", (Object)entry.getBigDecimal("curprice").add(dynamicObject.getBigDecimal("curprice")));
            entry.set("taxamount", (Object)entry.getBigDecimal("taxamount").add(dynamicObject.getBigDecimal("taxamount")));
            entry.set("approvetax", (Object)entry.getBigDecimal("taxamount"));
            entry.set("deductibletax", (Object)entry.getBigDecimal("deductibletax").add(dynamicObject.getBigDecimal("deductibletax")));
            entry.set("ordernum", (Object)(entry.getString("ordernum") + "," + dynamicObject.getString("ordernum")));
            entry.set("orderformid", (Object)(entry.getString("orderformid") + "," + dynamicObject.getString("orderformid")));
            DynamicObjectCollection tripTravlerCollNew = dynamicObject.getDynamicObjectCollection("trip2travelers");
            DynamicObjectCollection tripTravlerColl = entry.getDynamicObjectCollection("trip2travelers");
            ArrayList<Long> travlerids = new ArrayList<Long>(8);
            if (null != tripTravlerColl && !tripTravlerColl.isEmpty()) {
                for (DynamicObject object : tripTravlerColl) {
                    if (null == object.get("fbasedataid_id")) continue;
                    travlerids.add(object.getLong("fbasedataid_id"));
                }
            }
            if (null != tripTravlerColl && null != tripTravlerCollNew && !tripTravlerCollNew.isEmpty()) {
                for (DynamicObject travler : tripTravlerCollNew) {
                    Long id;
                    if (null == travler.get("fbasedataid_id") || travlerids.contains(id = Long.valueOf(travler.getLong("fbasedataid_id")))) continue;
                    tripTravlerColl.add((Object)travler);
                    travlerids.add(id);
                }
            }
            entry.set("trip2travelerscount", (Object)(entry.getLong("trip2travelerscount") + dynamicObject.getLong("trip2travelerscount")));
            isUpdate = Boolean.TRUE;
        }
        if (!isUpdate.booleanValue()) {
            entrys.add((Object)dynamicObject);
        }
    }

    private static boolean isServicefee(DynamicObject dynamicObject, DynamicObject entry) {
        if (null == entry.getDynamicObject("expenseitem")) {
            logger.info("\u672a\u5339\u914d\u5dee\u65c5\u9879\u76ee");
            return false;
        }
        Long id = entry.getDynamicObject("expenseitem").getLong("id");
        DynamicObject tripexpenseitem = QueryServiceHelper.queryOne((String)"er_tripexpenseitem", (String)"operationtype,id,attribute,expenseitemicon,taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (null == tripexpenseitem || tripexpenseitem.getString("operationtype").indexOf(AbstractOrderModel.OperationType.G.getKey()) == -1) {
            logger.info("\u5dee\u65c5\u9879\u76ee\u975e\u670d\u52a1\u8d39");
            return false;
        }
        if (!entry.getString("provider").equals(dynamicObject.getString("provider"))) {
            logger.info("\u975e \u76f8\u540c\u670d\u52a1\u5546");
            return false;
        }
        if (null != entry.get("travelcostcompany_id") && !entry.get("travelcostcompany_id").equals(dynamicObject.get("travelcostcompany_id"))) {
            logger.info("\u975e \u76f8\u540c\u8d39\u7528\u627f\u62c5\u516c\u53f8");
            return false;
        }
        if (entry.getBigDecimal("taxrate").compareTo(dynamicObject.getBigDecimal("taxrate")) != 0) {
            logger.info("\u975e \u76f8\u540c\u7a0e\u7387");
            return false;
        }
        return true;
    }

    private static void setExpenseItemLqouotactl(DynamicObject targetBill, DynamicObject targetTripEntry, DynamicObject entry) {
        DynamicObject company = targetBill.getDynamicObject("company");
        DynamicObject dept = targetBill.getDynamicObject("org");
        DynamicObject tripEntryCostdept = targetTripEntry.getDynamicObject("entrycostdept");
        Date tripEntryHappendate = targetTripEntry.getDate("triphappendate");
        if (entry.getDate("travelhappendate") == null) {
            entry.set("travelhappendate", (Object)tripEntryHappendate);
        }
        DynamicObject tripEntryExpenseitem = targetTripEntry.getDynamicObject("tripexpenseitem");
        if (entry.getDynamicObject("travelexpenseitem") == null) {
            entry.set("travelexpenseitem", (Object)tripEntryExpenseitem);
        }
        if (entry.getDynamicObject("travelquotactldept") == null) {
            Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId(tripEntryExpenseitem, company, dept, tripEntryCostdept);
            entry.set("travelquotactldept_id", (Object)quotaCtrlDeptId);
        }
    }

    private static void deleteExistMonthInvoiceEntry(DynamicObject targetBill, DynamicObject orderBill, String orderType) {
        String ticketnum = orderBill.getString("ticketnum");
        String orderNum = orderBill.getString("ordernum");
        DynamicObjectCollection invoiceHeadEntrys = targetBill.getDynamicObjectCollection("invoiceentry");
        Iterator invoiceEntrys = invoiceHeadEntrys.iterator();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        while (invoiceEntrys.hasNext()) {
            DynamicObject invoiceEntry = (DynamicObject)invoiceEntrys.next();
            String invoiceFrom = invoiceEntry.getString("invoicefrom");
            String invoiceNo = invoiceEntry.getString("invoiceno");
            String invoiceOrderType = invoiceEntry.getString("orderType");
            String invoiceOrderNum = invoiceEntry.getString("invoiceordernum");
            if (!"3".equals(invoiceFrom) || !StringUtils.equals((CharSequence)invoiceOrderNum, (CharSequence)orderNum) || invoiceOrderType == null || !invoiceOrderType.equals(orderType)) continue;
            collection.add((Object)invoiceEntry);
        }
        if (collection.size() > 0) {
            invoiceHeadEntrys.removeAll((Collection)collection);
        }
    }

    private static void fillTripOrderMonthEntry(DynamicObject orderBill, DynamicObject targetBill, DynamicObject targetTripEntry, Map<String, Object> montrhEntryMap, boolean pullTravelOrdrs, String formId, OrderExpenseDetailContext orderExpenseDetailContext) {
        DynamicObject orderCurrency;
        Long entryCurrencyId;
        DynamicObjectCollection mulseatgradeCol;
        DynamicObject entry;
        DynamicObject company = targetBill.getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk(company);
        targetTripEntry.set("isexistmonthly", (Object)Boolean.TRUE);
        Object tripCurrency = orderBill.get("currency");
        if (tripCurrency != null) {
            Map<Object, Object> exchangeMap = new HashMap();
            if (null != orderExpenseDetailContext) {
                ExchangeRateDataKey exchangeRateDataKey;
                Object costCompany = orderBill.get("expcommitcomnum");
                Long costCompanyId = costCompany == null ? Long.valueOf(0L) : ErCommonUtils.getPk(costCompany);
                Long tripCurrencyId = ErCommonUtils.getPk(tripCurrency);
                DynamicObject targetBillCurrentcy = targetBill.getDynamicObject("currency");
                Long targetBillCurrentcyId = targetBillCurrentcy == null ? Long.valueOf(0L) : ErCommonUtils.getPk(targetBillCurrentcy);
                ExchangeRates exchangeRates = orderExpenseDetailContext.getExchangeRates();
                if (exchangeRates.exist(exchangeRateDataKey = new ExchangeRateDataKey(companyId, costCompanyId, tripCurrencyId, targetBillCurrentcyId, (Date)targetBill.get("bizdate")))) {
                    exchangeMap = exchangeRates.get(exchangeRateDataKey).getExchangeRateMap();
                }
            } else {
                exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams(companyId, orderBill.get("expcommitcomnum"), ErCommonUtils.getPk(tripCurrency), ErCommonUtils.getPk(targetBill.getDynamicObject("currency")), targetBill.get("bizdate"));
            }
            targetTripEntry.set("tripcurrency", tripCurrency);
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
            BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
            targetTripEntry.set("tripexchangerate", (Object)exchangeRate);
            targetTripEntry.set("tripquotetype", (Object)quoteType);
        }
        logger.info("\u5dee\u65c5\u62a5\u9500\u5355\u65b0\u589e\u8ba2\u5355,ordernum\u5339\u914d\uff1a{}", (Object)orderBill.getString("ordernum"));
        DynamicObjectCollection entrys = targetTripEntry.getDynamicObjectCollection("entryentity");
        if (montrhEntryMap != null && montrhEntryMap.get(orderBill.getString("ordernum")) != null) {
            entry = (DynamicObject)montrhEntryMap.get(orderBill.getString("ordernum"));
            TripReimCreateOrderEntrysUtil.deleteServiceOrderEntrys(targetBill, targetTripEntry, entry, new ArrayList<String>(), "move");
            entrys.remove((Object)entry);
            logger.info("\u5dee\u65c5\u62a5\u9500\u5355\u65b0\u589e\u8ba2\u5355,montrhEntryMap\u5339\u914d\uff1a{}", (Object)JSON.toJSONString(montrhEntryMap.keySet()));
        } else {
            entry = entrys.addNew();
            long[] longs = DBServiceHelper.genLongIds((String)entry.getDataEntityType().getAlias(), (int)1);
            entry.set("id", (Object)longs[0]);
            entrys.remove((Object)entry);
        }
        String operationType = orderBill.getString("operationtype");
        DynamicObject tripItem = null;
        if (null != orderExpenseDetailContext) {
            TripItemDataKey TripItemDataKey2 = new TripItemDataKey(operationType, companyId);
            tripItem = orderExpenseDetailContext.getTripItems().get(TripItemDataKey2);
        } else {
            tripItem = TripBusinessRelatDailyBusinessUtil.getExpenseitemByOrder(operationType, companyId);
        }
        if (tripItem != null) {
            entry.set("expenseitem", (Object)tripItem);
            entry.set("pic", (Object)tripItem.getString("expenseitemicon"));
        }
        if (tripItem != null) {
            if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(tripItem.getString("attribute"))) {
                String tripStandardControlMethod = SystemParamterUtil.getTripStandardControlLevel(companyId).getValue();
                entry.set("controlmethod", (Object)tripStandardControlMethod);
            } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(tripItem.getString("attribute"))) {
                String vehicleConType = SystemParamterUtil.getVehicleStdControlLevel(companyId).getValue();
                entry.set("controlmethod", (Object)vehicleConType);
            }
        }
        if ((mulseatgradeCol = TripReimCreateOrderEntrysUtil.getTripOrderBillMulSeatGrage(targetTripEntry, orderBill, entry)) != null) {
            DynamicObjectCollection mulseatgrades = entry.getDynamicObjectCollection("mulseatgrade");
            if (mulseatgrades.size() > 0) {
                mulseatgrades.clear();
            }
            for (DynamicObject dynamicObject : mulseatgradeCol) {
                DynamicObject mulseatgrade = mulseatgrades.addNew();
                mulseatgrade.set("fbasedataid_id", dynamicObject.get("fbasedataid_id"));
            }
        }
        String server = orderBill.getString("server");
        String orderFormId = orderBill.getDynamicObjectType().getName();
        BigDecimal totalTax = BigDecimal.ZERO;
        Map<String, Object> invoiceSetMap = null;
        int paramValue = (Integer)ActionLocalCache.get().get("order_status_control", "order_status_control", () -> TripSyncConfigUtil.getIntValue("order_status_control", 0));
        if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && (StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"USED") || StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"CHANGED") || paramValue == 0) || StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) || StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId) || StringUtils.equals((CharSequence)"er_trainbill", (CharSequence)orderFormId) || StringUtils.equals((CharSequence)"er_mealbill", (CharSequence)orderFormId)) {
            invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderBill, server, null, targetBill);
        } else if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"REFOUND")) {
            invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderBill, server, Serviceitem.SERVICE);
        }
        if (invoiceSetMap != null) {
            totalTax = (BigDecimal)invoiceSetMap.get("totalTax");
            entry.set("deductibletax", (Object)totalTax);
            entry.set("taxamount", (Object)totalTax);
            entry.set("approvetax", (Object)entry.getBigDecimal("taxamount"));
            entry.set("approvetax", (Object)totalTax);
            int getReimburseMonthlyOffsetValue = SystemParamterUtil.getloancheckparam(companyId, "getreimbursemonthlyoffset");
            Boolean isdeductible = Boolean.FALSE;
            if (getReimburseMonthlyOffsetValue == 1) {
                isdeductible = (Boolean)invoiceSetMap.get("isdeductible");
            }
            entry.set("offset", (Object)isdeductible);
        }
        entry.set("entrycurrency_id", (Object)((entryCurrencyId = ErCommonUtils.getPk(orderCurrency = orderBill.getDynamicObject("currency"))) == null ? Long.valueOf(1L) : entryCurrencyId));
        Map<String, Object> exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams(companyId, orderBill.get("expcommitcomnum"), entryCurrencyId, ErCommonUtils.getPk(targetBill.getDynamicObject("currency")), targetBill.get("bizdate"));
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
        entry.set("exchangerate", (Object)exchangeRate);
        entry.set("detailquotetype", (Object)quoteType);
        BigDecimal oriTotalAmount = orderBill.getBigDecimal("totalamount");
        int precision = orderCurrency == null ? 4 : orderCurrency.getInt("amtprecision");
        BigDecimal totalAmount = AmountUtils.getCurrencyAmount(oriTotalAmount, exchangeRate, precision, quoteType);
        entry.set("orientryamount", (Object)oriTotalAmount);
        entry.set("entryamount", (Object)totalAmount);
        entry.set("orientryappamount", (Object)oriTotalAmount);
        entry.set("entryappamount", (Object)totalAmount);
        entry.set("notaxamount", (Object)oriTotalAmount.subtract(totalTax));
        BigDecimal price = oriTotalAmount.subtract(entry.getBigDecimal("deductibletax") == null ? BigDecimal.ZERO : entry.getBigDecimal("deductibletax"));
        entry.set("price", (Object)price);
        BigDecimal curPrice = AmountUtils.getCurrencyAmount(price, exchangeRate, precision, quoteType);
        entry.set("curprice", (Object)curPrice);
        if (StringUtils.equals((CharSequence)"0", (CharSequence)targetBill.getString("billkind"))) {
            entry.set("trip2startdate", (Object)targetTripEntry.getDate("startdate"));
            entry.set("trip2enddate", (Object)targetTripEntry.getDate("enddate"));
        }
        int dayCount = targetTripEntry.getInt("tripday");
        entry.set("daycount", (Object)dayCount);
        BigDecimal calDaycount = BigDecimal.valueOf(dayCount);
        if (tripItem != null && Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(tripItem.getString("attribute"))) {
            TripReimCreateOrderEntrysUtil.caculHighDayByOrder(targetTripEntry, entry, companyId, tripItem, orderExpenseDetailContext);
        }
        if (tripItem != null && tripItem.getString("attribute").equals("1")) {
            ErTripStdControlServiceImpl erTripStdControlService = new ErTripStdControlServiceImpl();
            calDaycount = erTripStdControlService.calDaycount(dayCount, companyId);
        }
        entry.set("caldaycount", (Object)calDaycount);
        TripReimCreateOrderEntrysUtil.aboutOrder(companyId, orderBill, entry, formId);
        entry.set("pulltravelorder", (Object)pullTravelOrdrs);
        if (pullTravelOrdrs) {
            entry.set("travelcostcompany_id", (Object)ErCommonUtils.getPk(orderBill.get("expcommitcomnum")));
            entry.set("travelcostdept_id", (Object)ErCommonUtils.getPk(orderBill.get("expcommitdepnum")));
            TripReimCreateOrderEntrysUtil.setExpenseItemLqouotactl(targetBill, targetTripEntry, entry);
        }
        entrys.add((Object)entry);
    }

    private static void caculHighDayByOrder(DynamicObject targetTripEntry, DynamicObject entry, Long companyId, DynamicObject tripItem, OrderExpenseDetailContext orderExpenseDetailContext) {
        BigDecimal originHighDay;
        Date begin = targetTripEntry.getDate("startdate");
        Date end = targetTripEntry.getDate("enddate");
        DynamicObject area = targetTripEntry.getDynamicObject("tripentryarea");
        if (area == null) {
            if (null != orderExpenseDetailContext) {
                Long cityId = ErCommonUtils.getPk(targetTripEntry.getDynamicObject("to"));
                QFilter tripareaOrgCtrlFilter = orderExpenseDetailContext.getTripAreaOrgCtrlFilterMap().get(ErCommonUtils.getPk(companyId));
                area = TripVhcStdChangeUtils.getTripAreaByCityIdAndCompanyId(cityId, tripareaOrgCtrlFilter);
            } else {
                ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                area = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk(targetTripEntry.getDynamicObject("to")), ErCommonUtils.getPk(companyId));
            }
        }
        if ((originHighDay = TripHighSeasonStandardUtil.getHighSeasonDays(companyId, begin, end, area, tripItem)) != null && originHighDay.compareTo(BigDecimal.ZERO) > 0) {
            entry.set("highseason", (Object)"1");
            entry.set("originhighseasondays", (Object)originHighDay);
            targetTripEntry.set("tripentryarea", (Object)area);
        }
        entry.set("triparea", (Object)area);
    }

    private static void aboutOrder(Long companyId, DynamicObject orderBill, DynamicObject entry, String formId) {
        DynamicObjectCollection tripTravlerColl;
        String fromCity = "";
        String toCity = "";
        String checkinDate = "";
        String checkoutDate = "";
        String orderFormId = "";
        String server = "";
        String ordernum = "";
        String iscancel = "";
        Long sourcetravelerId = 0L;
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        paramMap.put("formId", formId);
        if (null != orderBill) {
            logger.info("\u5904\u7406\u8ba2\u5355\u76f8\u5173\u4fe1\u606f:{}", (Object)companyId, (Object)orderBill.getString("ordernum"));
            orderFormId = orderBill.getDynamicObjectType().getName();
            server = orderBill.getString("server");
            ordernum = orderBill.getString("ordernum");
            iscancel = orderBill.getString("ordertype");
            sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId(orderBill);
            paramMap.put("orderFormId", orderFormId);
            if (orderFormId.equals("er_planebill")) {
                fromCity = orderBill.getString("fromcityname");
                toCity = orderBill.getString("tocityname");
                checkinDate = orderBill.getString("takeofftime");
                checkoutDate = checkinDate = checkinDate != null ? checkinDate.substring(5, 10) : checkinDate;
                BigDecimal airportprice = orderBill.getBigDecimal("airportprice");
                entry.set("airportconstructionfee", (Object)airportprice);
                if (StringUtils.equals((CharSequence)orderBill.getString("ordersort"), (CharSequence)"1") && StringUtils.equals((CharSequence)orderBill.getString("ticketstatus"), (CharSequence)"USED")) {
                    entry.set("invoiceno_entry", (Object)orderBill.getString("ticketnum"));
                }
                paramMap.put("startDate", orderBill.getString("takeofftime"));
                paramMap.put("endDate", orderBill.getString("landingtime"));
                paramMap.put("sourceCity", fromCity);
                paramMap.put("targetCity", toCity);
                TripReimCreateOrderEntrysUtil.dealOrderBillDetailMsg(paramMap, entry);
            } else if (orderFormId.equals("er_hotelbill")) {
                Date sDate = orderBill.getDate("checkindate");
                Date eDate = orderBill.getDate("checkoutdate");
                Long hotelNightDays = CommonServiceHelper.calcHotelNightDays(sDate, eDate);
                entry.set("caldaycount", (Object)hotelNightDays);
                toCity = fromCity = orderBill.getString("cityname");
                checkinDate = orderBill.getString("checkindate").substring(5, 10);
                checkoutDate = orderBill.getString("checkoutdate").substring(5, 10);
                entry.set("overdesc", (Object)orderBill.getString("overdesc"));
                entry.set("trip2startdate", (Object)sDate);
                entry.set("trip2enddate", (Object)eDate);
                if (entry.getBoolean("highseason")) {
                    DynamicObject expenseItem = entry.getDynamicObject("expenseitem");
                    DynamicObject area = entry.getDynamicObject("triparea");
                    BigDecimal originHighDay = TripHighSeasonStandardUtil.getHighSeasonDays(companyId, sDate, eDate, area, expenseItem);
                    entry.set("highseasondaycount", (Object)originHighDay);
                }
                paramMap.put("targetCity", fromCity);
                TripReimCreateOrderEntrysUtil.dealOrderBillDetailMsg(paramMap, entry);
            } else if (orderFormId.equals("er_vehiclebill")) {
                fromCity = orderBill.getString("departaddress");
                toCity = orderBill.getString("arriveaddress");
                checkoutDate = checkinDate = orderBill.getString("usetime") == null ? "" : orderBill.getString("usetime").substring(5, 10);
            } else if (orderFormId.equals("er_trainbill")) {
                fromCity = orderBill.getString("departaddress");
                toCity = orderBill.getString("arriveaddress");
                if (StringUtils.isNotBlank((CharSequence)orderBill.getString("departtime"))) {
                    String string = checkinDate = orderBill.getString("departtime") == null ? "" : orderBill.getString("departtime").substring(5, 10);
                }
                if (StringUtils.isNotBlank((CharSequence)orderBill.getString("arrivetime"))) {
                    checkoutDate = orderBill.getString("arrivetime") == null ? "" : orderBill.getString("arrivetime").substring(5, 10);
                }
                paramMap.put("sourceCity", orderBill.getString("departcity"));
                paramMap.put("targetCity", orderBill.getString("arrivecity"));
                paramMap.put("startDate", orderBill.getString("departtime"));
                paramMap.put("endDate", orderBill.getString("arrivetime"));
                TripReimCreateOrderEntrysUtil.dealOrderBillDetailMsg(paramMap, entry);
            } else if (orderFormId.equals("er_mealbill")) {
                toCity = orderBill.getString("mealcityname");
                paramMap.put("targetCity", orderBill.getString("mealcityname"));
                paramMap.put("startDate", orderBill.getString("mealtime"));
                paramMap.put("endDate", orderBill.getString("mealtime"));
                TripReimCreateOrderEntrysUtil.dealOrderBillDetailMsg(paramMap, entry);
            }
        }
        entry.set("orderformid", (Object)orderFormId);
        entry.set("fromcity", (Object)fromCity);
        entry.set("tocity", (Object)toCity);
        entry.set("checkindate", (Object)checkinDate);
        entry.set("checkoutdate", (Object)checkoutDate);
        entry.set("itemfrom", (Object)ItemFrom.TripBusiness.getValue());
        entry.set("provider", (Object)server);
        entry.set("orderformid", (Object)orderFormId);
        entry.set("ordernum", (Object)ordernum);
        entry.set("settlementtype", (Object)"2");
        if ("T".equalsIgnoreCase(iscancel)) {
            entry.set("iscancelorder", (Object)true);
        }
        if ((tripTravlerColl = entry.getDynamicObjectCollection("trip2travelers")).size() > 0) {
            tripTravlerColl.clear();
        }
        if (null != orderBill) {
            DynamicObject tripTravler = tripTravlerColl.addNew();
            tripTravler.set("fbasedataid_id", (Object)sourcetravelerId);
            entry.set("trip2travelerscount", (Object)1);
        }
    }

    private static DynamicObjectCollection getTripOrderBillMulSeatGrage(DynamicObject targetTripEntry, DynamicObject orderBill, DynamicObject entry) {
        DynamicObject mulseatgrade;
        String[] vhcSeatGradeArr;
        String orderFormId = orderBill.getDynamicObjectType().getName();
        String attribute = null;
        String vhcName = null;
        DynamicObjectCollection mulseatgradeCol = null;
        if (StringUtils.equals((CharSequence)orderFormId, (CharSequence)"er_planebill")) {
            vhcName = orderBill.getString("cabinclass");
            attribute = "2";
        }
        if (StringUtils.equals((CharSequence)orderFormId, (CharSequence)"er_trainbill")) {
            String vhcNumber = orderBill.getString("trainseat");
            ComboProp property = (ComboProp)MetadataServiceHelper.getDataEntityType((String)"er_trainbill").getProperty("trainseat");
            HashMap<String, LocaleString> trainSeatMap = new HashMap<String, LocaleString>(property.getComboItems().size());
            for (ValueMapItem comboItem : property.getComboItems()) {
                String key = comboItem.getValue();
                LocaleString value = comboItem.getName();
                trainSeatMap.put(key, value);
            }
            vhcName = String.valueOf(trainSeatMap.get(vhcNumber));
            attribute = "4";
        }
        if ((vhcSeatGradeArr = TripVhcStdChangeUtils.getFuzzyMatchingVhcSeatGrade(vhcName, attribute)) != null && vhcSeatGradeArr.length > 0 && (mulseatgrade = TripVhcStdChangeUtils.getMulSeatGradeBasedataId(vhcSeatGradeArr[0], vhcSeatGradeArr[1])) != null) {
            mulseatgradeCol = BillRelateUtils.generateMultiPropValue(targetTripEntry, entry, "mulseatgrade", mulseatgrade);
        }
        return mulseatgradeCol;
    }

    private static void fillInvoiceHeadEntry(DynamicObject targetBill, DynamicObject orderBill, boolean isShowInvoiceEntry) {
        if (!isShowInvoiceEntry) {
            return;
        }
        DynamicObjectCollection invoiceHeadEntrys = targetBill.getDynamicObjectCollection("invoiceentry");
        DynamicObject invoiceHeadEntry = new DynamicObject(invoiceHeadEntrys.getDynamicObjectType());
        String orderFormId = orderBill.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && StringUtils.equals((CharSequence)orderBill.getString("ordersort"), (CharSequence)"1") && StringUtils.equalsAny((CharSequence)orderBill.getString("ticketstatus"), (CharSequence[])new CharSequence[]{"USED", "CHANGED"})) {
            invoiceHeadEntry.set("invoicetype", (Object)"10");
            Date itinerarydate = orderBill.getDate("itinerarydate");
            invoiceHeadEntry.set("invoicedate", (Object)itinerarydate);
            if (itinerarydate == null) {
                invoiceHeadEntry.set("invoicecode", (Object)"-");
            } else {
                invoiceHeadEntry.set("invoicecode", (Object)TripCommonUtil.date2TimeStamp(itinerarydate, "yyyyMMdd"));
            }
            String ticketnum = orderBill.getString("ticketnum");
            if (StringUtils.isBlank((CharSequence)ticketnum)) {
                ticketnum = "-";
            }
            invoiceHeadEntry.set("invoiceno", (Object)ticketnum);
            invoiceHeadEntry.set("invoiceordernum", (Object)orderBill.getString("ordernum"));
            BigDecimal servicefee = orderBill.getBigDecimal("servicefee");
            BigDecimal totalamount = orderBill.getBigDecimal("totalamount");
            totalamount = totalamount.subtract(servicefee);
            if (totalamount.compareTo(BigDecimal.ZERO) <= 0) {
                return;
            }
            invoiceHeadEntry.set("totalamount", (Object)totalamount);
            invoiceHeadEntry.set("passengername", (Object)orderBill.getString("travelername"));
            Map<String, Object> invoiceSetMap = TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderBill, orderBill.getString("server"), null);
            int itineraryDeductrate = ((BigDecimal)invoiceSetMap.get("itineraryDeductrate")).multiply(new BigDecimal(100)).intValue();
            invoiceHeadEntry.set("alltaxrate", (Object)itineraryDeductrate);
            BigDecimal ticketprice = orderBill.getBigDecimal("ticketprice");
            BigDecimal fuelprice = orderBill.getBigDecimal("fuelprice");
            BigDecimal totalTax = ticketprice.add(fuelprice).multiply((BigDecimal)invoiceSetMap.get("itineraryDeductrate")).divide(BigDecimal.ONE.add((BigDecimal)invoiceSetMap.get("itineraryDeductrate")), 2, RoundingMode.HALF_UP);
            invoiceHeadEntry.set("taxamount_invoice", (Object)totalTax);
            int getReimburseMonthlyOffsetValue = SystemParamterUtil.getloancheckparam(ErCommonUtils.getPk(targetBill.getDynamicObject("company")), "getreimbursemonthlyoffset");
            Boolean isdeductible = Boolean.FALSE;
            if (getReimburseMonthlyOffsetValue == 1) {
                isdeductible = (Boolean)invoiceSetMap.get("isdeductible");
            }
            invoiceHeadEntry.set("offset_invoice", (Object)isdeductible);
            if (isdeductible.booleanValue()) {
                invoiceHeadEntry.set("offsetamount", (Object)totalTax);
            } else {
                invoiceHeadEntry.set("offsetamount", (Object)BigDecimal.ZERO);
            }
            invoiceHeadEntry.set("count", (Object)1);
            invoiceHeadEntry.set("frominvoicecloud", (Object)Boolean.FALSE);
            invoiceHeadEntry.set("invoicefrom", (Object)"3");
            invoiceHeadEntry.set("orderType", orderBill.get("orderType"));
            invoiceHeadEntry.set("invoiceairportconstfee", (Object)orderBill.getBigDecimal("airportprice"));
            invoiceHeadEntry.set("invoicecurrency", orderBill.get("currency"));
            invoiceHeadEntry.set("invoicecurrency_id", (Object)ErCommonUtils.getPk(orderBill.get("currency")));
            invoiceHeadEntrys.add((Object)invoiceHeadEntry);
        }
    }

    public static Map<String, Object> getInvoiceInfoByOperation(DynamicObject orderBill, String server, Serviceitem serviceitem, DynamicObject targetBill) {
        Map<String, Object> invoiceSetMap;
        String orderFormId;
        int getReimburseMonthlyOffsetValue = 0;
        int isSplitServiceFee = 0;
        if (targetBill != null) {
            DynamicObject company = targetBill.getDynamicObject("company");
            Long companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk(company);
            getReimburseMonthlyOffsetValue = SystemParamterUtil.getloancheckparam(companyId, "getreimbursemonthlyoffset");
            isSplitServiceFee = SystemParamterUtil.getcheckparamDefaute(companyId, "ticketservicesplit");
            boolean tripReimburseBill = ErEntityTypeUtils.isTripReimburseBill(targetBill.getDataEntityType().getName());
            if (!tripReimburseBill) {
                getReimburseMonthlyOffsetValue = 1;
            }
        }
        List<Map<String, String>> invoiceSetting = GenerateInvoicerAssistant.getInvoiceSetting(server, null);
        Map<Object, List<Map>> invoiceSetGroup = invoiceSetting.stream().collect(Collectors.groupingBy(v -> (String)v.get("operationtype")));
        List<Map<String, String>> invoiceSetByOperation = invoiceSetGroup.get(orderBill.getString("operationtype"));
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal ticketAmount = BigDecimal.ZERO;
        switch (orderFormId = orderBill.getDynamicObjectType().getName()) {
            case "er_mealbill": 
            case "er_vehiclebill": 
            case "er_hotelbill": {
                String producttype = orderBill.getString("producttype");
                if (producttype.equals("1")) {
                    ticketAmount = orderBill.getBigDecimal("totalamount").subtract(orderBill.getBigDecimal("servicefee"));
                }
                invoiceSetMap = TripReimCreateOrderEntrysUtil.calculateInvoiceSet(orderBill, invoiceSetByOperation, ticketAmount, totalTax, serviceitem);
                invoiceSetMap.put("isSplitServiceFee", isSplitServiceFee);
                if (!TripReimCreateOrderEntrysUtil.judgeIfContinue(orderBill, getReimburseMonthlyOffsetValue)) break;
                TripReimCreateOrderEntrysUtil.judgeIsDeductible(invoiceSetMap, orderBill, ticketAmount);
                break;
            }
            case "er_planebill": {
                BigDecimal ticketprice = orderBill.getBigDecimal("ticketprice");
                BigDecimal fuelprice = orderBill.getBigDecimal("fuelprice");
                String planeProducttype = orderBill.getString("producttype");
                if (planeProducttype.equals("1")) {
                    ticketAmount = ticketprice.add(fuelprice);
                }
                invoiceSetMap = TripReimCreateOrderEntrysUtil.calculateInvoiceSet(orderBill, invoiceSetByOperation, ticketAmount, totalTax, serviceitem);
                break;
            }
            case "er_trainbill": {
                String tproducttype = orderBill.getString("producttype");
                if (tproducttype.equals("1")) {
                    ticketAmount = orderBill.getBigDecimal("ticketprice").subtract(orderBill.getBigDecimal("personalfee"));
                }
                invoiceSetMap = TripReimCreateOrderEntrysUtil.calculateInvoiceSet(orderBill, invoiceSetByOperation, ticketAmount, totalTax, serviceitem);
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u8ba2\u5355\u7c7b\u578bKey: %1$s", (String)"TripReimCreateOrderEntrysUtil_0", (String)"fi-er-business", (Object[])new Object[0]), orderFormId));
            }
        }
        logger.info("\u6839\u636e\u8ba2\u5355\u7c7b\u578b\u83b7\u53d6\u5f00\u7968\u8bbe\u7f6e\u4fe1\u606finvoiceSetMap:{}", (Object)JSON.toJSONString(invoiceSetMap));
        return invoiceSetMap;
    }

    public static Map<String, Object> getInvoiceInfoByOperation(DynamicObject orderBill, String server, Serviceitem serviceitem) {
        return TripReimCreateOrderEntrysUtil.getInvoiceInfoByOperation(orderBill, server, serviceitem, null);
    }

    public static Map<String, Object> calculateInvoiceSet(DynamicObject orderBill, List<Map<String, String>> invoiceSetByOperation, BigDecimal ticketAmount, BigDecimal totalTax, Serviceitem item) {
        HashMap<String, Object> invoiceSetMap = new HashMap<String, Object>();
        BigDecimal orderamounttax = BigDecimal.ZERO;
        BigDecimal itineraryRefundamounttax = BigDecimal.ZERO;
        BigDecimal serviceamounttax = BigDecimal.ZERO;
        BigDecimal itineraryDeductrate = BigDecimal.ZERO;
        BigDecimal serviceDeductrate = BigDecimal.ZERO;
        BigDecimal ticketDeductrate = BigDecimal.ZERO;
        BigDecimal itineraryRefundDeductrate = BigDecimal.ZERO;
        ArrayList invoiceTypeTotal = Lists.newArrayListWithCapacity((int)8);
        boolean isdeductible = false;
        if (invoiceSetByOperation != null) {
            for (Map<String, String> invoiceSet : invoiceSetByOperation) {
                Serviceitem serviceItem = Serviceitem.getItem(invoiceSet.get("serviceitem"));
                if (item != null && !serviceItem.equals(item)) continue;
                if (!isdeductible) {
                    isdeductible = Boolean.parseBoolean(invoiceSet.get("isdeductible"));
                }
                if (Serviceitem.ITINERARY.equals(serviceItem)) {
                    itineraryDeductrate = new BigDecimal(invoiceSet.getOrDefault("deductrate", "0"));
                    orderamounttax = ticketAmount.multiply(itineraryDeductrate).divide(BigDecimal.ONE.add(itineraryDeductrate), 2, RoundingMode.HALF_UP);
                    logger.info("\u5546\u65c5\u96c6\u6210,\u884c\u7a0b\u5355\u7a0e\u7387\u548c\u7a0e\u989d,calculateInvoiceSet ITINERARY\uff1a" + ticketAmount + "itineraryDeductrate:" + itineraryDeductrate + "orderamounttax:" + orderamounttax);
                    continue;
                }
                if (Serviceitem.SERVICE.equals(serviceItem)) {
                    serviceDeductrate = new BigDecimal(invoiceSet.getOrDefault("deductrate", "0"));
                    BigDecimal servicefee = orderBill.getBigDecimal("servicefee");
                    serviceamounttax = servicefee.multiply(serviceDeductrate).divide(BigDecimal.ONE.add(serviceDeductrate), 2, RoundingMode.HALF_UP);
                    invoiceSetMap.put(serviceItem.getValue(), Boolean.parseBoolean(invoiceSet.get("isdeductible")));
                    logger.info("\u5546\u65c5\u96c6\u6210,\u670d\u52a1\u8d39\u7a0e\u7387\u548c\u7a0e\u989d,calculateInvoiceSet SERVICE\uff1a" + servicefee + "serviceDeductrate:" + serviceDeductrate + "orderamounttax:" + serviceamounttax);
                    continue;
                }
                if (Serviceitem.TICKET.equals(serviceItem)) {
                    ticketDeductrate = new BigDecimal(invoiceSet.getOrDefault("deductrate", "0"));
                    orderamounttax = ticketAmount.multiply(ticketDeductrate).divide(BigDecimal.ONE.add(ticketDeductrate), 2, RoundingMode.HALF_UP);
                    invoiceTypeTotal.add(invoiceSet.get("invoicetype"));
                    invoiceSetMap.put(invoiceSet.get("invoicetype"), invoiceSet.get("isdeductible") + "," + ticketDeductrate.toString());
                    logger.info("\u5546\u65c5\u96c6\u6210,\u7968\u4ef7\u7a0e\u7387\u548c\u7a0e\u989d,calculateInvoiceSet TICKET\uff1a" + ticketAmount + "ticketDeductrate:" + ticketDeductrate + "orderamounttax:" + orderamounttax);
                    continue;
                }
                if (!Serviceitem.TICKREFUND.equals(serviceItem)) continue;
                itineraryRefundDeductrate = new BigDecimal(invoiceSet.getOrDefault("deductrate", "0"));
                itineraryRefundamounttax = ticketAmount.multiply(itineraryRefundDeductrate).divide(BigDecimal.ONE.add(itineraryRefundDeductrate), 2, RoundingMode.HALF_UP);
                logger.info("\u5546\u65c5\u96c6\u6210,\u884c\u7a0b\u5355\u9000\u7968\u7a0e\u7387\u548c\u7a0e\u989d,calculateInvoiceSet TICKREFUND\uff1a" + ticketAmount + "itineraryRefundDeductrate:" + itineraryDeductrate + "itineraryRefundamounttax:" + itineraryRefundamounttax);
            }
        }
        totalTax = orderamounttax.add(serviceamounttax);
        BigDecimal totalItineraryRefundTax = itineraryRefundamounttax.add(serviceamounttax);
        invoiceSetMap.put("totalTax", totalTax);
        invoiceSetMap.put("orderamounttax", orderamounttax);
        invoiceSetMap.put("totalItineraryRefundTax", totalItineraryRefundTax);
        invoiceSetMap.put("isdeductible", isdeductible);
        invoiceSetMap.put("itineraryDeductrate", itineraryDeductrate);
        invoiceSetMap.put("ticketDeductrate", ticketDeductrate);
        invoiceSetMap.put("serviceDeductrate", serviceDeductrate);
        invoiceSetMap.put("serviceamounttax", serviceamounttax);
        invoiceSetMap.put("itineraryRefundDeductrate", itineraryRefundDeductrate);
        invoiceSetMap.put("invoiceTypeTotal", invoiceTypeTotal);
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5f00\u7968\u8bbe\u7f6e,invoiceSetMap totalTax=%s,isdeductible=%s,totalItineraryRefundTax=%s", totalTax, isdeductible, totalItineraryRefundTax));
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u5f00\u7968\u8bbe\u7f6e,invoiceSetMap itineraryDeductrate=%s,ticketDeductrate=%s,itineraryRefundDeductrate=%s", itineraryDeductrate, ticketDeductrate, itineraryRefundDeductrate));
        return invoiceSetMap;
    }

    public static void adjuestExpenseDetailOrder(DynamicObjectCollection entrys) {
        entrys.sort((a, b) -> {
            String bSettlement;
            String aSettlement = (String)StringUtils.defaultIfBlank((CharSequence)a.getString("settlementtype"), (CharSequence)"1");
            if (StringUtils.equalsIgnoreCase((CharSequence)aSettlement, (CharSequence)(bSettlement = (String)StringUtils.defaultIfBlank((CharSequence)b.getString("settlementtype"), (CharSequence)"1"))) && StringUtils.equalsIgnoreCase((CharSequence)aSettlement, (CharSequence)"2")) {
                String aOrderFormId = (String)StringUtils.defaultIfBlank((CharSequence)a.getString("orderformid"), (CharSequence)"");
                String bOrderFormId = (String)StringUtils.defaultIfBlank((CharSequence)b.getString("orderformid"), (CharSequence)"");
                return aOrderFormId.compareTo(bOrderFormId);
            }
            if (aSettlement.equalsIgnoreCase("2")) {
                return -1;
            }
            if (bSettlement.equalsIgnoreCase("2")) {
                return 1;
            }
            return aSettlement.compareTo(bSettlement);
        });
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            entry.set("seq", (Object)(i + 1));
        }
    }

    public static List<DynamicObject> initOrderEntrys(DynamicObject targetBill, DynamicObject targetTripEntry, Set<Long> travelerIdSet, List<DynamicObject> tripOrders, boolean isShowInvoiceEntry, boolean pullTravelOrders, Map<String, Object> existMontrhEntryMap, DynamicObject reqBill, String formId, OrderExpenseDetailContext orderExpenseDetailContext) {
        ArrayList<DynamicObject> successInitOrderBills = new ArrayList<DynamicObject>();
        if (tripOrders == null || tripOrders.isEmpty()) {
            return successInitOrderBills;
        }
        int ordertripreimburse = SystemParamterUtil.getcheckparamDefaute(ErCommonUtils.getPk(targetBill.getDynamicObject("company")), "ordertripreimburse");
        int carordertripreimburse = SystemParamterUtil.getcheckparamDefaute(ErCommonUtils.getPk(targetBill.getDynamicObject("company")), "carordertripreimburse");
        int mealOrderTripReimburse = SystemParamterUtil.getcheckparamDefaute(ErCommonUtils.getPk(targetBill.getDynamicObject("company")), "mealordertripreimburse");
        for (DynamicObject orderBill : tripOrders) {
            String orderFormId = orderBill.getDynamicObjectType().getName();
            if ((StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_planebill") || StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_trainbill") || StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_hotelbill")) && ordertripreimburse == 0) {
                logger.info("\u5546\u65c5\u96c6\u6210,botp\u914d\u7f6e\u63d2\u4ef6\u4e2d,\u8fc7\u6ee4" + ordertripreimburse + "\u8ba2\u5355\u4fe1\u606f orderBill" + orderBill.getString("ordernum"));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_vehiclebill") && carordertripreimburse == 0) {
                logger.info("\u5546\u65c5\u96c6\u6210,botp\u914d\u7f6e\u63d2\u4ef6\u4e2d,\u8fc7\u6ee4" + carordertripreimburse + "\u8ba2\u5355\u4fe1\u606f orderBill" + orderBill.getString("ordernum"));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_mealbill") && mealOrderTripReimburse == 0) {
                logger.info("\u5546\u65c5\u96c6\u6210,botp\u914d\u7f6e\u63d2\u4ef6\u4e2d,\u8fc7\u6ee4" + mealOrderTripReimburse + "\u8ba2\u5355\u4fe1\u606f orderBill" + orderBill.getString("ordernum"));
                continue;
            }
            logger.info("\u5546\u65c5\u96c6\u6210,botp\u914d\u7f6e\u63d2\u4ef6\u4e2d,\u83b7\u53d6\u5173\u8054\u8ba2\u5355\u4fe1\u606f orderBill" + orderBill.getString("ordernum"));
            if (isShowInvoiceEntry && StringUtils.equalsIgnoreCase((CharSequence)orderFormId, (CharSequence)"er_planebill")) {
                TripReimCreateOrderEntrysUtil.deleteExistMonthInvoiceEntry(targetBill, orderBill, orderBill.getString("ordertype"));
            }
            if (!TripNotReimbursedOrderUtil.checkAvailableOrder(orderBill)) continue;
            Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId(orderBill);
            logger.info("\u5dee\u65c5\u62a5\u9500\u5355\u65b0\u589e\u8ba2\u5355,\u51fa\u884c\u4eba\u5339\u914d\uff1a{},{}", travelerIdSet, (Object)sourcetravelerId);
            if ((travelerIdSet == null || travelerIdSet.isEmpty() || !travelerIdSet.contains(sourcetravelerId)) && sourcetravelerId != null && sourcetravelerId.compareTo(0L) != 0) continue;
            TripReimCreateOrderEntrysUtil.fillTripOrderMonthEntry(orderBill, targetBill, targetTripEntry, existMontrhEntryMap, pullTravelOrders, formId, orderExpenseDetailContext);
            TripReimCreateOrderEntrysUtil.fillInvoiceHeadEntry(targetBill, orderBill, isShowInvoiceEntry);
            successInitOrderBills.add(orderBill);
        }
        if (targetBill.containsProperty("invoiceoffsetamount")) {
            BigDecimal invoiceOffsetAmount = targetBill.getDynamicObjectCollection("invoiceentry").stream().map(v -> v.getBigDecimal("offsetamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            targetBill.set("invoiceoffsetamount", (Object)invoiceOffsetAmount);
        }
        TripReimCreateOrderEntrysUtil.fillservicefee(targetBill, targetTripEntry, tripOrders, pullTravelOrders, true, orderExpenseDetailContext);
        TripReimburseServiceHelper.updateTripEntryAmount(targetTripEntry);
        TripReimCreateOrderEntrysUtil.adjuestExpenseDetailOrder(targetTripEntry.getDynamicObjectCollection("entryentity"));
        if (reqBill != null) {
            String orgType = ErCommonUtils.getTripAreaOrgType();
            DynamicObject areaUseOrg = targetBill.getDynamicObject(orgType);
            DynamicObjectCollection reqBillTripEntrys = reqBill.getDynamicObjectCollection("tripentry");
            Map<String, DynamicObject> newOrderMap = tripOrders.stream().collect(Collectors.toMap(v -> v.getString("ordernum"), v -> v));
            for (DynamicObject entry : targetTripEntry.getDynamicObjectCollection("entryentity")) {
                Object value;
                DynamicObject order;
                String ordernum = entry.getString("ordernum");
                if (!StringUtils.isNotEmpty((CharSequence)ordernum) || null == (order = newOrderMap.get(ordernum = ordernum.split(",")[0]))) continue;
                String tripId = order.getString("tripid");
                for (DynamicObject srcEntry : reqBillTripEntrys) {
                    String reqTripEntryid = String.valueOf(srcEntry.getPkValue());
                    if (!StringUtils.equals((CharSequence)tripId, (CharSequence)reqTripEntryid)) continue;
                    Object from = srcEntry.get("from");
                    Object to = srcEntry.get("to");
                    int tripDay = (Integer)srcEntry.get("tripday");
                    entry.set("trip2from_id", (Object)ErCommonUtils.getPk(from));
                    entry.set("trip2to_id", (Object)ErCommonUtils.getPk(to));
                    entry.set("daycount", (Object)tripDay);
                    DynamicObject tripArea = null;
                    if (null != orderExpenseDetailContext) {
                        QFilter tripareaOrgCtrlFilter = orderExpenseDetailContext.getTripAreaOrgCtrlFilterMap().get(ErCommonUtils.getPk(areaUseOrg));
                        tripArea = TripVhcStdChangeUtils.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk(to), tripareaOrgCtrlFilter);
                    } else {
                        ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                        tripArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk(to), ErCommonUtils.getPk(areaUseOrg));
                    }
                    entry.set("triparea_id", (Object)ErCommonUtils.getPk(tripArea));
                    break;
                }
                if ((value = targetBill.get("billkind")) != null && "1".equals(value.toString())) {
                    Map<String, String> paramMap = TripReimCreateOrderEntrysUtil.constructParamMap(order, entry);
                    paramMap.put("formId", "er_tripreimbill_grid");
                    Long expenseitemId = ErCommonUtils.getPk(entry.get("expenseitem"));
                    if (expenseitemId != null) {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)expenseitemId, (String)"er_tripexpenseitem");
                        String operationtype = dynamicObject.getString("operationtype");
                        logger.info(String.format("Line 1169 \u8d39\u7528\u9879\u76ee %1$s \u5dee\u65c5\u9879\u76ee\u670d\u52a1\u7c7b\u578b %2$s \u5dee\u65c5\u9879\u76ee %3$s", expenseitemId, operationtype, dynamicObject.get("longnumber")));
                        if (operationtype.contains("7")) {
                            entry.set("trip2startdate", (Object)"");
                            entry.set("trip2enddate", (Object)"");
                            entry.set("trip2to_id", (Object)0L);
                            entry.set("trip2from_id", (Object)0L);
                            entry.set("triparea_id", (Object)0L);
                            continue;
                        }
                    }
                    if (!"er_vehiclebill".equals(entry.getString("orderformid"))) {
                        TripReimCreateOrderEntrysUtil.dealOrderBillDetailMsg(paramMap, entry);
                        DynamicObject tripArea = null;
                        if (null != orderExpenseDetailContext) {
                            QFilter tripareaOrgCtrlFilter = orderExpenseDetailContext.getTripAreaOrgCtrlFilterMap().get(ErCommonUtils.getPk(areaUseOrg));
                            tripArea = TripVhcStdChangeUtils.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk(entry.get("trip2to")), tripareaOrgCtrlFilter);
                        } else {
                            ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                            tripArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk(entry.get("trip2to")), ErCommonUtils.getPk(areaUseOrg));
                        }
                        entry.set("triparea_id", (Object)ErCommonUtils.getPk(tripArea));
                    }
                }
                DynamicObject tripEntryCostcompany = targetTripEntry.getDynamicObject("entrycostcompany");
                if (entry.getDynamicObject("travelcostcompany") == null) {
                    entry.set("travelcostcompany", (Object)tripEntryCostcompany);
                }
                DynamicObject tripEntryCostdept = targetTripEntry.getDynamicObject("entrycostdept");
                if (entry.getDynamicObject("travelcostdept") == null) {
                    entry.set("travelcostdept", (Object)tripEntryCostdept);
                }
                TripReimCreateOrderEntrysUtil.setExpenseItemLqouotactl(targetBill, targetTripEntry, entry);
            }
        } else {
            Object value = targetBill.get("billkind");
            if (value != null && "1".equals(value.toString())) {
                String orgType = ErCommonUtils.getTripAreaOrgType();
                DynamicObject areaUseOrg = targetBill.getDynamicObject(orgType);
                for (DynamicObject entry : targetTripEntry.getDynamicObjectCollection("entryentity")) {
                    Long expenseitemId = ErCommonUtils.getPk(entry.get("expenseitem"));
                    if (expenseitemId == null) continue;
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)expenseitemId, (String)"er_tripexpenseitem");
                    String operationtype = dynamicObject.getString("operationtype");
                    logger.info(String.format("Line 1205 \u8d39\u7528\u9879\u76ee %1$s \u5dee\u65c5\u9879\u76ee\u670d\u52a1\u7c7b\u578b %2$s \u5dee\u65c5\u9879\u76ee %3$s", expenseitemId, operationtype, dynamicObject.get("longnumber")));
                    if (operationtype.contains("7")) {
                        entry.set("trip2startdate", (Object)"");
                        entry.set("trip2enddate", (Object)"");
                        entry.set("trip2to_id", (Object)0L);
                        entry.set("trip2from_id", (Object)0L);
                        entry.set("triparea_id", (Object)0L);
                        continue;
                    }
                    if ("er_vehiclebill".equals(entry.getString("orderformid"))) continue;
                    ErTripStdServiceImp stdService = new ErTripStdServiceImp();
                    DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(ErCommonUtils.getPk(entry.get("trip2to")), ErCommonUtils.getPk(areaUseOrg));
                    entry.set("triparea_id", (Object)ErCommonUtils.getPk(tripArea));
                }
            }
        }
        PluginProxy tripOrderUpdateReimServicePluginProxy = PluginProxy.create(null, ITripOrderUpdateReimService.class, (String)"FI_ER_TRIP_ORDERUPDATEREIM", null);
        tripOrderUpdateReimServicePluginProxy.callReplace(p -> {
            p.orderUpdateReim(targetBill);
            return null;
        });
        return successInitOrderBills;
    }

    public static void dealOrderBillDetailMsg(Map<String, String> paramMap, DynamicObject entry) {
        if (paramMap.containsKey("formId") && !Arrays.asList("er_tripreimbill_grid", "er_tripreim_grid_mb").contains(paramMap.get("formId"))) {
            return;
        }
        if (paramMap.containsKey("orderFormId") && "er_vehiclebill".equals(paramMap.get("orderFormId"))) {
            return;
        }
        TripReimCreateOrderEntrysUtil.setDate(paramMap, entry);
        TripReimCreateOrderEntrysUtil.setCity(paramMap, entry);
    }

    private static void setCity(Map<String, String> paramMap, DynamicObject entry) {
        String sourceCity = StringUtils.isEmpty((CharSequence)paramMap.get("sourceCity")) ? "" : paramMap.get("sourceCity");
        String targetCity = StringUtils.isEmpty((CharSequence)paramMap.get("targetCity")) ? "" : paramMap.get("targetCity");
        sourceCity = TripCityUtil.judgeCityName(sourceCity);
        targetCity = TripCityUtil.judgeCityName(targetCity);
        QFilter sourceCityfilter = null;
        QFilter targetCityfilter = null;
        QFilter cityfilter = null;
        if (sourceCity != null && !sourceCity.trim().isEmpty()) {
            sourceCityfilter = new QFilter("name", "like", (Object)(sourceCity + "%"));
        }
        if (targetCity != null && !targetCity.trim().isEmpty()) {
            targetCityfilter = new QFilter("name", "like", (Object)(targetCity + "%"));
        }
        if (null != sourceCityfilter) {
            cityfilter = sourceCityfilter;
            if (null != targetCityfilter) {
                cityfilter.or(targetCityfilter);
            }
        } else if (null != targetCityfilter) {
            cityfilter = targetCityfilter;
        }
        if (null == cityfilter) {
            return;
        }
        QFilter filter = new QFilter("iscity", "=", (Object)"1");
        filter.and(cityfilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map bdAdmindivision = BusinessDataServiceHelper.loadFromCache((String)"bd_admindivision", (String)String.join((CharSequence)",", "id,name"), (QFilter[])new QFilter[]{filter, enableFilter});
        if (null == bdAdmindivision || bdAdmindivision.isEmpty()) {
            return;
        }
        DynamicObject[] allCityList = bdAdmindivision.values().toArray(new DynamicObject[0]);
        for (int i = 0; i < allCityList.length; ++i) {
            DynamicObject dynamicObject = allCityList[i];
            String cityName = dynamicObject.getString("name");
            if (StringUtils.isEmpty((CharSequence)cityName)) continue;
            if ((cityName = TripCityUtil.judgeCityName(cityName)).equals(sourceCity)) {
                entry.set("trip2from", (Object)dynamicObject);
            }
            if (!cityName.equals(targetCity)) continue;
            entry.set("trip2to", (Object)dynamicObject);
        }
    }

    private static void setDate(Map<String, String> paramMap, DynamicObject entry) {
        if ("er_hotelbill".equals(paramMap.get("orderFormId"))) {
            return;
        }
        Date startDate = TripReimCreateOrderEntrysUtil.parseDate(paramMap.get("startDate"));
        Date endDate = TripReimCreateOrderEntrysUtil.parseDate(paramMap.get("endDate"));
        entry.set("trip2startdate", startDate == null ? entry.get("trip2startdate") : startDate);
        entry.set("trip2enddate", endDate == null ? entry.get("trip2enddate") : endDate);
    }

    private static Date parseDate(String dateText) {
        Date returnDate = null;
        if (StringUtils.isEmpty((CharSequence)dateText)) {
            return returnDate;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            returnDate = format.parse(dateText);
            return returnDate;
        }
        catch (ParseException e) {
            logger.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25" + dateText);
            return returnDate;
        }
    }

    private static Map<String, String> constructParamMap(DynamicObject order, DynamicObject entry) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        String orderformid = entry.getString("orderformid");
        paramMap.put("orderFormId", orderformid);
        switch (orderformid) {
            case "er_planebill": {
                paramMap.put("startDate", order.getString("takeofftime"));
                paramMap.put("endDate", order.getString("landingtime"));
                paramMap.put("sourceCity", order.getString("fromcityname"));
                paramMap.put("targetCity", order.getString("tocityname"));
                break;
            }
            case "er_hotelbill": {
                paramMap.put("targetCity", order.getString("cityname"));
                paramMap.put("startDate", order.getString("checkindate").substring(5, 10));
                paramMap.put("endDate", order.getString("checkoutdate").substring(5, 10));
                break;
            }
            case "er_trainbill": {
                paramMap.put("sourceCity", order.getString("departcity"));
                paramMap.put("targetCity", order.getString("arrivecity"));
                paramMap.put("startDate", order.getString("departtime"));
                paramMap.put("endDate", order.getString("arrivetime"));
            }
        }
        return paramMap;
    }

    private static void judgeIsVehicleOrder(DynamicObject targetTripEntry, DynamicObject targetBill, OrderExpenseDetailContext orderExpenseDetailContext) {
        DynamicObjectCollection entrys = targetTripEntry.getDynamicObjectCollection("entryentity");
        HashSet<String> orderNumsSet = new HashSet<String>(entrys.size());
        DynamicObject company = targetBill.getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : ErCommonUtils.getPk(company);
        DynamicObject tripItem = null;
        if (null != orderExpenseDetailContext) {
            TripItemDataKey TripItemDataKey2 = new TripItemDataKey(AbstractOrderModel.OperationType.G.getKey(), companyId);
            tripItem = orderExpenseDetailContext.getTripItems().get(TripItemDataKey2);
        } else {
            tripItem = TripBusinessRelatDailyBusinessUtil.getExpenseitemByOrder(AbstractOrderModel.OperationType.G.getKey(), companyId);
        }
        Long feeId = null;
        if (tripItem != null) {
            feeId = ErCommonUtils.getPk(tripItem);
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject dynamicObject2 = (DynamicObject)entrys.get(i);
            String orderFormId = dynamicObject2.getString("orderformid");
            if (!StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId)) continue;
            Long pk = ErCommonUtils.getPk(dynamicObject2.get("expenseitem"));
            if (pk != null && pk.equals(feeId)) {
                logger.info("fee entry tax" + dynamicObject2.get("taxamount"));
                continue;
            }
            String orderNum = dynamicObject2.getString("ordernum");
            logger.info("Line 1374 orderNum" + orderNum);
            orderNumsSet.add(orderNum);
        }
        DynamicObjectCollection vehicleBills = QueryServiceHelper.query((String)"er_vehiclebill", (String)"id,orderstatus,ordernum,servicefee,server,producttype,totalamount,operationtype", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", orderNumsSet)});
        if (CollectionUtils.isNotEmpty((Collection)vehicleBills)) {
            List vehicleOrderNums = vehicleBills.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("orderstatus")) && "Canceled".equalsIgnoreCase(dynamicObject.getString("orderstatus"))).map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toList());
            for (DynamicObject entry : entrys) {
                String entryOrderNum = entry.getString("ordernum");
                if (!vehicleOrderNums.contains(entryOrderNum)) continue;
                Long pk = ErCommonUtils.getPk(entry.get("expenseitem"));
                if (pk != null && pk.equals(feeId)) {
                    logger.info("fee entry tax" + entry.get("taxamount"));
                    continue;
                }
                int ticketservicesplit = SystemParamterUtil.getcheckparamDefaute(companyId, "ticketservicesplit");
                if (ticketservicesplit == 0) {
                    TripReimCreateOrderEntrysUtil.calcServiceFee(vehicleBills, entryOrderNum, entry);
                } else {
                    entry.set("deductibletax", (Object)BigDecimal.ZERO);
                    entry.set("taxamount", (Object)BigDecimal.ZERO);
                    entry.set("approvetax", (Object)entry.getBigDecimal("taxamount"));
                    entry.set("notaxamount", (Object)entry.getBigDecimal("orientryamount").subtract(entry.getBigDecimal("taxamount")));
                }
                int precision = AmountUtils.getAmountFieldPrecision(entry, "entryamount");
                BigDecimal curprice = AmountUtils.getCurrencyAmount(entry.getBigDecimal("orientryamount").subtract(entry.getBigDecimal("taxamount")), entry.getBigDecimal("exchangerate"), precision, entry.getString("detailquotetype"));
                entry.set("curprice", (Object)curprice);
            }
        }
    }

    private static void calcServiceFee(DynamicObjectCollection vehicleBills, String entryOrderNum, DynamicObject entry) {
        List vehicleBill = vehicleBills.stream().filter(dynamicObject -> dynamicObject != null && dynamicObject.getString("ordernum").equals(entryOrderNum)).collect(Collectors.toList());
        for (DynamicObject orderBill : vehicleBill) {
            BigDecimal serviceamounttax;
            List<Map<String, String>> invoiceSetting = GenerateInvoicerAssistant.getInvoiceSetting(orderBill.getString("server"), null);
            Map<Object, List<Map>> invoiceSetGroup = invoiceSetting.stream().collect(Collectors.groupingBy(v -> (String)v.get("operationtype")));
            List<Map<String, String>> invoiceSetByOperation = invoiceSetGroup.get(orderBill.getString("operationtype"));
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal ticketAmount = BigDecimal.ZERO;
            String producttype = orderBill.getString("producttype");
            if (producttype.equals("1")) {
                ticketAmount = orderBill.getBigDecimal("totalamount").subtract(orderBill.getBigDecimal("servicefee"));
            }
            Map<String, Object> invoiceSetMap = TripReimCreateOrderEntrysUtil.calculateInvoiceSet(orderBill, invoiceSetByOperation, ticketAmount, totalTax, Serviceitem.SERVICE);
            BigDecimal taxamount = BigDecimal.ZERO;
            BigDecimal totalamount = entry.getBigDecimal("orientryamount");
            taxamount = serviceamounttax = (BigDecimal)invoiceSetMap.getOrDefault("serviceamounttax", "0");
            entry.set("taxamount", (Object)taxamount);
            entry.set("approvetax", (Object)taxamount);
            entry.set("deductibletax", (Object)taxamount);
            entry.set("notaxamount", (Object)totalamount.subtract(taxamount));
            entry.set("price", (Object)totalamount.subtract(taxamount));
        }
    }

    private static boolean judgeIfContinue(DynamicObject orderBill, int type) {
        String server;
        if (type == 0) {
            return false;
        }
        String orderFormId = orderBill.getDynamicObjectType().getName();
        return !TripReimCreateOrderEntrysUtil.judgeIfContinue(orderFormId, server = orderBill.getString("server"));
    }

    private static boolean judgeIfContinue(String orderFormId, String server) {
        if (!StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) && !StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId)) {
            return true;
        }
        if (!StringUtils.equalsAny((CharSequence)server, (CharSequence[])new CharSequence[]{"XIECHENG", "CHAILVYIHAO", "TONGCHENG", "ALI", "MEIYA", "QICHENG"})) {
            return true;
        }
        List<String> servers = Arrays.asList("XIECHENG", "TONGCHENG", "ALI");
        if (StringUtils.equals((CharSequence)orderFormId, (CharSequence)"er_vehiclebill") && servers.contains(server)) {
            return true;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)server)});
        String billingAndTax = dynamicObject.getString("billingandtax");
        return StringUtils.isEmpty((CharSequence)billingAndTax) || "0".equals(billingAndTax);
    }

    private static void judgeIsDeductible(Map<String, Object> invoiceSetMap, DynamicObject orderBill, BigDecimal ticketAmount) {
        int priceBillingType = orderBill.getInt("pricebillingtype");
        Object invoiceType = invoiceSetMap.getOrDefault("invoiceTypeTotal", 0);
        List invoiceTypeList = Lists.newArrayListWithCapacity((int)16);
        if (invoiceType instanceof List) {
            invoiceTypeList = (List)invoiceType;
        }
        switch (priceBillingType) {
            case 2: {
                Boolean deductible = Boolean.FALSE;
                if (invoiceTypeList.contains("1") || invoiceTypeList.contains("6")) {
                    Object o1;
                    Object o = invoiceSetMap.get("1");
                    boolean totalTmp = Boolean.FALSE;
                    if (o != null) {
                        totalTmp = TripReimCreateOrderEntrysUtil.setTitcketDeductrate(invoiceSetMap, o, ticketAmount);
                    }
                    if ((o1 = invoiceSetMap.get("6")) != null) {
                        totalTmp = TripReimCreateOrderEntrysUtil.setTitcketDeductrate(invoiceSetMap, o1, ticketAmount);
                    }
                    deductible = totalTmp;
                }
                if (deductible.booleanValue()) break;
                TripReimCreateOrderEntrysUtil.refreshInvoiceSetMap(invoiceSetMap, deductible);
                break;
            }
            case 1: {
                Boolean deductible2 = Boolean.FALSE;
                if (invoiceTypeList.contains("0") || invoiceTypeList.contains("2")) {
                    Object o1;
                    Object o = invoiceSetMap.get("0");
                    boolean totalTmp = Boolean.FALSE;
                    if (o != null) {
                        totalTmp = TripReimCreateOrderEntrysUtil.setTitcketDeductrate(invoiceSetMap, o, ticketAmount);
                    }
                    if ((o1 = invoiceSetMap.get("2")) != null) {
                        totalTmp = TripReimCreateOrderEntrysUtil.setTitcketDeductrate(invoiceSetMap, o1, ticketAmount);
                    }
                    deductible2 = totalTmp;
                }
                if (deductible2.booleanValue()) break;
                TripReimCreateOrderEntrysUtil.refreshInvoiceSetMap(invoiceSetMap, deductible2);
                break;
            }
            default: {
                TripReimCreateOrderEntrysUtil.refreshInvoiceSetMap(invoiceSetMap, Boolean.FALSE);
            }
        }
    }

    private static boolean setTitcketDeductrate(Map<String, Object> invoiceSetMap, Object o, BigDecimal ticketAmount) {
        String objStr = o.toString();
        String[] split = objStr.split(",");
        boolean tmp_1 = Boolean.parseBoolean(split[0]);
        BigDecimal tmp_2 = new BigDecimal(split[1]);
        invoiceSetMap.put("ticketDeductrate", tmp_2);
        BigDecimal afterTicketAmount = ticketAmount.multiply(tmp_2).divide(BigDecimal.ONE.add(tmp_2), 2, RoundingMode.HALF_UP);
        invoiceSetMap.put("orderamounttax", afterTicketAmount);
        BigDecimal serviceamounttax = (BigDecimal)invoiceSetMap.get("serviceamounttax");
        invoiceSetMap.put("totalTax", afterTicketAmount.add(serviceamounttax));
        boolean totalTmp = tmp_1;
        return totalTmp;
    }

    private static void refreshInvoiceSetMap(Map<String, Object> invoiceSetMap, Boolean deductible) {
        BigDecimal totalTax = (BigDecimal)invoiceSetMap.get("totalTax");
        BigDecimal orderamounttax = (BigDecimal)invoiceSetMap.get("orderamounttax");
        invoiceSetMap.put("totalTax", totalTax.subtract(orderamounttax));
        invoiceSetMap.put("orderamounttax", BigDecimal.ZERO);
        if (invoiceSetMap.containsKey("isSplitServiceFee")) {
            int isSplitServiceFee = (Integer)invoiceSetMap.get("isSplitServiceFee");
            if (isSplitServiceFee == 0) {
                invoiceSetMap.put("isdeductible", deductible != false || invoiceSetMap.containsKey("SERVICE") && (Boolean)invoiceSetMap.get("SERVICE") != false);
            } else {
                invoiceSetMap.put("isdeductible", deductible);
            }
        }
        invoiceSetMap.put("ticketDeductrate", BigDecimal.ZERO);
    }
}

