/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dailybiz;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripBusinessRelatDailyBusinessUtil;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class TripReimUpdateOrderEntrysUtil {
    private static final Log logger = LogFactory.getLog(TripReimUpdateOrderEntrysUtil.class);

    public static void updateOrderEntrys(DynamicObject[] orderBills) {
        Map tripOrderGroupbyBillnoMap = Arrays.stream(orderBills).filter(v -> StringUtils.isNotBlank((CharSequence)v.getString("oabillnum"))).collect(Collectors.groupingBy(v -> v.getString("oabillnum"), Collectors.mapping(v -> v, Collectors.toList())));
        if (tripOrderGroupbyBillnoMap == null || tripOrderGroupbyBillnoMap.isEmpty()) {
            return;
        }
        HashSet<String> reqBillNos = new HashSet<String>(tripOrderGroupbyBillnoMap.size());
        for (Map.Entry tripOrderMap : tripOrderGroupbyBillnoMap.entrySet()) {
            String reqbillno = tripOrderMap.getKey();
            reqBillNos.add(reqbillno);
        }
        DynamicObject[] reqDos = (DynamicObject[])QueryServiceHelper.query((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", reqBillNos)}).toArray((Object[])new DynamicObject[0]);
        if (reqDos.length < 1) {
            return;
        }
        List reqIds = Arrays.stream(reqDos).map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
        DynamicObject[] reqBills = BusinessDataServiceHelper.load((Object[])reqIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_tripreqbill"));
        Map<Long, List<DynamicObject>> sameCompanyReqBills = Arrays.stream(reqBills).filter(dynamicObject -> dynamicObject.getDynamicObject("company") != null).collect(Collectors.groupingBy(dynamicObject -> ErCommonUtils.getPk(dynamicObject.getDynamicObject("company"))));
        Map<Long, List<DynamicObject>> reqBillIdAndReimburseBillMap = TripReimUpdateOrderEntrysUtil.queryReimbursebillsNew(sameCompanyReqBills);
        if (reqBillIdAndReimburseBillMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<Long, List<DynamicObject>>> entries = reqBillIdAndReimburseBillMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entryObj : entries) {
            HashSet<DynamicObject> updateBillColl = new HashSet<DynamicObject>(4);
            Long reqBillId = entryObj.getKey();
            DynamicObject reqBill = Arrays.stream(reqBills).filter(dynamicObject -> dynamicObject.getLong("id") == reqBillId.longValue()).findFirst().get();
            List<DynamicObject> reimburseBills = entryObj.getValue();
            try {
                DynamicObject reimburseBill;
                int reqbilltoreimbursecount;
                DynamicObjectCollection tripentrys;
                String billno;
                List<DynamicObject> waitHandleOrders;
                if (reimburseBills.isEmpty() || (waitHandleOrders = tripOrderGroupbyBillnoMap.get(billno = reqBill.getString("billno"))) == null || waitHandleOrders.isEmpty()) continue;
                Map<String, DynamicObject> waitHandleOrderMap = waitHandleOrders.stream().collect(Collectors.toMap(v -> v.getString("ordernum"), v -> v));
                boolean isShowInvoiceEntry = SystemParamterUtil.getIsShowInvoiceEntry(ErCommonUtils.getPk(reqBill.getDynamicObject("company")));
                HashMap<String, Object> existMonthEntryMap = new HashMap<String, Object>();
                for (DynamicObject reimburseBill2 : reimburseBills) {
                    boolean isUpdate = false;
                    tripentrys = reimburseBill2.getDynamicObjectCollection("tripentry");
                    for (DynamicObject tripentry : tripentrys) {
                        ArrayList<DynamicObject> currentUsedTripOrders = new ArrayList<DynamicObject>();
                        DynamicObjectCollection entrys = tripentry.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entrys) {
                            String ordernum = entry.getString("ordernum");
                            DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
                            Object operationtype = "";
                            if (expenseitem != null) {
                                operationtype = expenseitem.getString("operationtype");
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)ordernum) || waitHandleOrderMap.get(ordernum) == null || ((String)operationtype).contains(AbstractOrderModel.OperationType.G.getKey())) continue;
                            logger.info("\u8ba2\u5355\u8ffd\u52a0\u4ee5\u5b58\u5728\u7684\u6708\u7ed3\u8ba2\u5355\uff1a{}", (Object)ordernum);
                            existMonthEntryMap.put(ordernum, entry);
                            DynamicObject order = waitHandleOrderMap.get(ordernum);
                            currentUsedTripOrders.add(order);
                        }
                        if (currentUsedTripOrders == null || currentUsedTripOrders.isEmpty()) continue;
                        isUpdate = true;
                        HashSet<Long> travelerIdSet = new HashSet<Long>(4);
                        currentUsedTripOrders.stream().forEach(tripOrder -> {
                            Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId(tripOrder);
                            travelerIdSet.add(sourcetravelerId);
                        });
                        logger.info("\u8ba2\u5355\u7b2c\u4e00\u6b21\u8ffd\u52a0{}", travelerIdSet);
                        TripReimCreateOrderEntrysUtil.initOrderEntrys(reimburseBill2, tripentry, travelerIdSet, currentUsedTripOrders, isShowInvoiceEntry, existMonthEntryMap, null, null);
                        waitHandleOrders.removeAll(currentUsedTripOrders);
                    }
                    if (!isUpdate) continue;
                    TripReimburseServiceHelper.updateBillHeadAmount(reimburseBill2);
                    updateBillColl.add(reimburseBill2);
                }
                if (waitHandleOrders == null || waitHandleOrders.isEmpty() || (reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam(ErCommonUtils.getPk(reqBill.getDynamicObject("company")), "reqbilltoreimbursecount")) > 0) continue;
                Map tripOrderGroupByTripIdMap = waitHandleOrders.stream().collect(Collectors.groupingBy(v -> v.getString("tripid"), Collectors.mapping(v -> v, Collectors.toList())));
                for (DynamicObject reimburseBill3 : reimburseBills) {
                    boolean isUpdate = false;
                    DynamicObjectCollection tripentrys2 = reimburseBill3.getDynamicObjectCollection("tripentry");
                    for (DynamicObject tripentry : tripentrys2) {
                        List<DynamicObject> currentTripOrders;
                        String sourceTripEntryId = tripentry.getString("tripentrysourceid");
                        if (StringUtils.isBlank((CharSequence)sourceTripEntryId) || (currentTripOrders = tripOrderGroupByTripIdMap.get(sourceTripEntryId)) == null || currentTripOrders.isEmpty()) continue;
                        HashSet<Long> travelerIdSet = new HashSet<Long>();
                        DynamicObjectCollection travelers = tripentry.getDynamicObjectCollection("travelers");
                        if (travelers != null && !travelers.isEmpty()) {
                            for (DynamicObject traveler : travelers) {
                                Long travelerId = ErCommonUtils.getPk(traveler.get("fbasedataid_id"));
                                travelerIdSet.add(travelerId);
                            }
                        }
                        if (travelerIdSet == null || travelerIdSet.isEmpty()) continue;
                        logger.info("\u8ba2\u5355\u7b2c\u4e8c\u6b21\u8ffd\u52a0{}", travelerIdSet);
                        List<DynamicObject> successOrders = TripReimCreateOrderEntrysUtil.initOrderEntrys(reimburseBill3, tripentry, travelerIdSet, currentTripOrders, isShowInvoiceEntry, existMonthEntryMap, reqBill, null);
                        if (successOrders == null || successOrders.isEmpty()) continue;
                        isUpdate = true;
                        waitHandleOrders.removeAll(successOrders);
                    }
                    if (!isUpdate) continue;
                    TripReimburseServiceHelper.updateBillHeadAmount(reimburseBill3);
                    updateBillColl.add(reimburseBill3);
                }
                if (waitHandleOrders == null || waitHandleOrders.isEmpty() || (tripentrys = (reimburseBill = reimburseBills.get(0)).getDynamicObjectCollection("tripentry")) == null || tripentrys.isEmpty()) continue;
                DynamicObject tripentry = (DynamicObject)tripentrys.get(0);
                HashSet<Long> travelerIdSet = new HashSet<Long>(4);
                waitHandleOrders.stream().forEach(tripOrder -> {
                    Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId(tripOrder);
                    travelerIdSet.add(sourcetravelerId);
                });
                logger.info("\u8ba2\u5355\u7b2c\u4e09\u6b21\u8ffd\u52a0{}", travelerIdSet);
                TripReimCreateOrderEntrysUtil.initOrderEntrys(reimburseBill, tripentry, travelerIdSet, waitHandleOrders, isShowInvoiceEntry, existMonthEntryMap, reqBill, null);
                TripReimburseServiceHelper.updateBillHeadAmount(reimburseBill);
                updateBillColl.add(reimburseBill);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (updateBillColl.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])updateBillColl.toArray(new DynamicObject[updateBillColl.size()]));
            }
        }
    }

    private static Map<Long, List<DynamicObject>> queryReimbursebillsNew(Map<Long, List<DynamicObject>> sameCompanyReqBills) {
        Set<Long> companyIds = sameCompanyReqBills.keySet();
        Iterator<Long> iterator = companyIds.iterator();
        HashMap settingIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            Long companyId = iterator.next();
            int autoAppend = SystemParamterUtil.getloancheckparam(companyId, "orderautoappend");
            if (settingIdAndCompanyIdMap.containsKey(autoAppend)) {
                ((Set)settingIdAndCompanyIdMap.get(autoAppend)).add(companyId);
                continue;
            }
            HashSet companyIdSet = Sets.newHashSetWithExpectedSize((int)2);
            companyIdSet.add(companyId);
            settingIdAndCompanyIdMap.put(autoAppend, companyIdSet);
        }
        Set setEntry = settingIdAndCompanyIdMap.entrySet();
        HashMap sameSettingReqBills = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry settingEntry : setEntry) {
            Integer key = (Integer)settingEntry.getKey();
            Set value = (Set)settingEntry.getValue();
            sameCompanyReqBills.forEach((k, v) -> {
                if (value.contains(k)) {
                    if (sameSettingReqBills.containsKey(key)) {
                        ((List)sameSettingReqBills.get(key)).addAll(v);
                    } else {
                        ArrayList list = Lists.newArrayListWithCapacity((int)16);
                        list.addAll(v);
                        sameSettingReqBills.put(key, list);
                    }
                }
            });
        }
        Set entries = sameSettingReqBills.entrySet();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : entries) {
            Integer settIng = (Integer)entry.getKey();
            List<String> filterList = TripReimUpdateOrderEntrysUtil.getFilter(settIng);
            if (filterList.isEmpty()) continue;
            List reqBills = (List)entry.getValue();
            Set<Long> ids = reqBills.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            resultMap.putAll(TripReimUpdateOrderEntrysUtil.queryReimburseBills(ids, filterList));
        }
        return resultMap;
    }

    private static List<String> getFilter(Integer autoAppend) {
        List<Object> objects = Lists.newArrayListWithCapacity((int)4);
        if (autoAppend == 0 || autoAppend == 1) {
            return objects;
        }
        if (autoAppend == 2) {
            objects = Arrays.asList("A", "D");
        } else if (autoAppend == 3) {
            objects = Arrays.asList("A", "B", "D");
        }
        return objects;
    }

    private static Map<Long, List<DynamicObject>> queryReimburseBills(Set<Long> reqBillIds, List<String> statusList) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])reqBillIds.toArray(new Long[reqBillIds.size()]));
        HashSet reimburseIds = (HashSet)targetBills.get("er_tripreimbursebill");
        if (reimburseIds == null || reimburseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, Set<Long>> returnMap = TripReimUpdateOrderEntrysUtil.getReqBillIdAndReimburseBillIdMap(reqBillIds, reimburseIds);
        QFilter reimburFilter = new QFilter("id", "in", (Object)reimburseIds).and(new QFilter("billstatus", "in", statusList));
        DynamicObject[] reimburseBillIds = (DynamicObject[])QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id", (QFilter[])new QFilter[]{reimburFilter}).toArray((Object[])new DynamicObject[0]);
        Set reimburseIdSets = Arrays.stream(reimburseBillIds).map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])reimburseIdSets.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_tripreimbursebill"));
        Set<Map.Entry<Long, Set<Long>>> entries = returnMap.entrySet();
        HashMap reqBillIdAndReimburseBillMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, Set<Long>> entry : entries) {
            Long reqBillId = entry.getKey();
            Set<Long> targetReimburseBillIds = entry.getValue();
            List fitReimburseBills = Arrays.stream(load).filter(object -> targetReimburseBillIds.contains(object.getLong("id"))).collect(Collectors.toList());
            reqBillIdAndReimburseBillMap.put(reqBillId, fitReimburseBills);
        }
        return reqBillIdAndReimburseBillMap;
    }

    private static Map<Long, Set<Long>> getReqBillIdAndReimburseBillIdMap(Set<Long> reqBillIds, HashSet<Long> reimburseIds) {
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"er_tripreqbill", (Long[])reqBillIds.toArray(new Long[0]), null);
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        for (BFRowLinkDownNode bfRowLinkDownNode : bfRowLinkDownNodes) {
            BFRowId rowId = bfRowLinkDownNode.getRowId();
            Map tNodes = bfRowLinkDownNode.getTNodes();
            Long billId = rowId.getBillId();
            Set entries = tNodes.entrySet();
            for (Map.Entry entry : entries) {
                BFRowId key = (BFRowId)entry.getKey();
                Long targetId = key.getBillId();
                if (!reimburseIds.contains(targetId)) continue;
                if (returnMap.containsKey(billId)) {
                    ((Set)returnMap.get(billId)).add(targetId);
                    continue;
                }
                HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
                ids.add(targetId);
                returnMap.put(billId, ids);
            }
        }
        return returnMap;
    }
}

