/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.dao.AbstractOrderDao;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.MealOrderModel;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class MealOrderDao
extends AbstractOrderDao {
    private static final Log logger = LogFactory.getLog(MealOrderDao.class);

    @Override
    protected void handleIndividrualData(AbstractOrderModel orderModel, DynamicObject orderDynamic) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,MealOrderDao" + orderModel.getOrderNum());
        MealOrderModel mealOrderModel = (MealOrderModel)orderModel;
        this.handleBookedPerson(orderDynamic, mealOrderModel);
    }

    private void handleBookedPerson(DynamicObject orderDynamic, MealOrderModel mealOrderModel) {
        DynamicObject sourceUser = this.existData.getUserMapping().get(mealOrderModel.getSourceBookedId());
        if (sourceUser != null) {
            orderDynamic.set("sourcebookedid", sourceUser.getPkValue());
        }
        orderDynamic.set("orderstatus", (Object)mealOrderModel.getOrderStatus().getKey());
        String oabillnum = mealOrderModel.getOaBillNum();
        DynamicObject dynamicObject = this.existData.getMealApplyBillMapping().get(oabillnum);
        DynamicObject reqBillDynamicObject = this.existData.getReqbillMapping().get(oabillnum);
        DynamicObject dailyApplyBillDynamicObject = this.existData.getDailyApplybillMapping().get(oabillnum);
        if (null != dynamicObject) {
            String dinnerscene = dynamicObject.getString("dinnerscene");
            orderDynamic.set("dinnerscene", (Object)dinnerscene);
            orderDynamic.set("oabillformid", (Object)"er_mealapplication_bill");
        } else if (reqBillDynamicObject != null) {
            orderDynamic.set("dinnerscene", (Object)"3");
            orderDynamic.set("oabillformid", (Object)"er_tripreqbill");
        } else if (null != dailyApplyBillDynamicObject) {
            String dinnerscene = TripCommonUtil.getReimburseType(dailyApplyBillDynamicObject.getString("reimbursetype"));
            dinnerscene = StringUtils.isBlank((CharSequence)dinnerscene) ? "9" : dinnerscene;
            orderDynamic.set("dinnerscene", (Object)dinnerscene);
            orderDynamic.set("oabillformid", (Object)"er_dailyapplybill");
        } else {
            orderDynamic.set("dinnerscene", (Object)"9");
        }
    }
}

