/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.exception;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class TripSyncLogUtils {
    private static Log logger = LogFactory.getLog(TripSyncLogUtils.class);
    private static final int CLOG_MAX_LENGTH = 1999;
    private static final int STR_MAX_LENGTH = 50;
    private static final String POINT_END = "...";
    private static final String ER_TRIPSYNC_LOG_SIGN = "er_tripsync_log";

    public static void saveErrorLog(List<TripSyncLogParam> logParamList) {
        if (logParamList == null || logParamList.size() < 1) {
            return;
        }
        try {
            boolean keepAll = TripSyncConfigUtil.getBoolean("keep_all_log");
            Stream<Object> stream = logParamList.stream();
            if (!keepAll) {
                stream = logParamList.stream().filter(v -> "B".equalsIgnoreCase(v.getStatus()));
            }
            TripSyncLogUtils.saveErrorDOsByLog(stream.collect(Collectors.toList()));
        }
        catch (Throwable e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u4fdd\u5b58\u5931\u8d25:", e);
        }
        TripSyncLogUtils.sendReqSyncMsg(logParamList);
    }

    private static void saveErrorDOs(Stream<TripSyncLogParam> stream) {
        try {
            MainEntityType billType = EntityMetadataCache.getDataEntityType((String)ER_TRIPSYNC_LOG_SIGN);
            LinkedList dynamicObjects = new LinkedList();
            stream.forEach(arg_0 -> TripSyncLogUtils.lambda$saveErrorDOs$1((DynamicObjectType)billType, dynamicObjects, arg_0));
            SaveServiceHelper.save((IDataEntityType)billType, (Object[])dynamicObjects.toArray());
        }
        catch (Throwable e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u4fdd\u5b58\u5931\u8d25:", e);
        }
    }

    private static void saveErrorDOsByLog(final List<TripSyncLogParam> logParamList) {
        ThreadService.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (null == logParamList || logParamList.size() == 0) {
                    return;
                }
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u65e5\u5fd7\u4fdd\u5b58\uff1alogParamList:{},traceid:{}", (Object)logParamList.size(), (Object)((TripSyncLogParam)logParamList.get(0)).getTraceid());
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_trip_log");
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (TripSyncLogParam logParam : logParamList) {
                    DynamicObject triplog = new DynamicObject((DynamicObjectType)entityType);
                    triplog.set("traceid", (Object)logParam.getTraceid());
                    HashSet<String> serverSet = new HashSet<String>();
                    serverSet.add(logParam.getServer());
                    Map<Object, DynamicObject> server = TripCommonUtil.getTripServiceInfoDOMap(serverSet);
                    triplog.set("server", (Object)(server == null ? "" : ((DynamicObject)server.values().stream().collect(Collectors.toList()).get(0)).getLocaleString("name").getLocaleValue()));
                    String function = TripCommonUtil.getInvokeClassMap().get(logParam.getFunction());
                    triplog.set("function", (Object)(null == function ? logParam.getFunction() : function));
                    triplog.set("status", (Object)logParam.getStatus());
                    triplog.set("message", (Object)TripSyncLogUtils.genErrorStr(logParam.getMessage()));
                    triplog.set("message_tag", (Object)logParam.getMessage());
                    triplog.set("requesturl", (Object)logParam.getRequesturl());
                    triplog.set("requestdata", TripSyncLogUtils.genJsonStr(logParam.getRequestdata()));
                    triplog.set("requestdata_tag", TripSyncLogUtils.genClobJsonStr(logParam.getRequestdata()));
                    triplog.set("responsedata", TripSyncLogUtils.genJsonStr(logParam.getResponsedata()));
                    triplog.set("responsedata_tag", TripSyncLogUtils.genClobJsonStr(logParam.getResponsedata()));
                    triplog.set("billno", (Object)TripSyncLogUtils.genErrorStr(logParam.getBillno()));
                    triplog.set("billno_tag", (Object)logParam.getBillno());
                    triplog.set("username", (Object)"");
                    triplog.set("opname", (Object)"");
                    triplog.set("opdesc", (Object)triplog.getString("billno"));
                    list.add(triplog);
                }
                LogORM logORM = LogORM.create();
                for (List dynamicObjects : Lists.partition(list, (int)100)) {
                    try {
                        logORM.insert(dynamicObjects);
                    }
                    catch (Exception e) {
                        logger.info("\u5546\u65c5\u96c6\u6210,\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)ThrowableHelper.toString((Exception)e));
                    }
                }
            }
        }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
    }

    private static void sendReqSyncMsg(List<TripSyncLogParam> logParamList) {
        try {
            HashSet<Long> reqBillIds = new HashSet<Long>();
            logParamList.stream().filter(v -> "B".equalsIgnoreCase(v.getStatus()) && ("tripReqBillInvoke".equalsIgnoreCase(v.getFunction()) || "dailyVehicleBillInvoke".equalsIgnoreCase(v.getFunction()))).forEach(v -> {
                Long billId = Long.valueOf(v.getBillid());
                reqBillIds.add(billId);
            });
            if (reqBillIds == null || reqBillIds.size() < 1) {
                return;
            }
            List<Long> userIds = TripSyncConfigUtil.getReqSyncMsgReceiverIds();
            if (userIds == null || userIds.size() < 1) {
                return;
            }
            String formid = "er_tripreqbill";
            if ("dailyVehicleBillInvoke".equalsIgnoreCase(logParamList.get(0).getFunction())) {
                formid = "er_dailyvehiclebill";
            }
            ErMessageServiceHelper.sendMessageByBillId("trip_reqbillsyncmsg", formid, reqBillIds, userIds);
        }
        catch (Throwable e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u7533\u8bf7\u5355\u96c6\u6210\u5931\u8d25\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38:", e);
        }
    }

    public static void sendReqSyncMsgNew(final List<TripSyncLogParam> logParamList, final Map<String, Object> params) {
        if (null == logParamList || logParamList.isEmpty()) {
            return;
        }
        ThreadService.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u53d1\u9001\u6d88\u606f\uff1aloglist:{},traceid:{}", (Object)logParamList.size(), (Object)((TripSyncLogParam)logParamList.get(0)).getTraceid());
                DynamicObject fieldmap = (DynamicObject)params.get("fieldmap");
                String function = fieldmap.getDynamicObject("function").getString("number");
                try {
                    HashSet<Long> billIds = new HashSet<Long>();
                    logParamList.stream().filter(v -> "B".equalsIgnoreCase(v.getStatus())).forEach(v -> {
                        DynamicObject idd;
                        String billno = v.getBillno();
                        if (null != billno && !billno.isEmpty() && null != (idd = QueryServiceHelper.queryOne((String)function, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)}))) {
                            Long billId = idd.getLong("id");
                            billIds.add(billId);
                        }
                    });
                    if (billIds == null || billIds.size() < 1) {
                        return;
                    }
                    List<Long> userIds = TripSyncConfigUtil.getReqSyncMsgReceiverIds();
                    if (userIds == null || userIds.size() < 1) {
                        return;
                    }
                    ErMessageServiceHelper.sendMessageByBillId("trip_reqbillsyncmsg", function, billIds, userIds);
                }
                catch (Throwable e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u7533\u8bf7\u5355\u96c6\u6210\u5931\u8d25\u65f6\u53d1\u9001\u6d88\u606f\u5f02\u5e38:", e);
                }
            }
        }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
    }

    public static String genErrorStr(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 150) {
            return s;
        }
        if (!s.startsWith("{")) {
            int j;
            int i = s.indexOf(10);
            if (i > 0) {
                s = s.substring(0, i);
            }
            if ((j = s.indexOf(58)) > 0) {
                s = s.substring(j + 1);
            }
        }
        if (s.length() > 50) {
            s = s.substring(0, 50) + POINT_END;
        }
        return s.trim();
    }

    public static Object genJsonStr(Object data) {
        String jsonStr;
        if (data instanceof String && data.toString().contains("{")) {
            data = JSON.parse((String)data.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)(jsonStr = StringUtils.trim((String)JSON.toJSONString((Object)data)))) && jsonStr.length() > 50) {
            jsonStr = jsonStr.substring(0, 50) + POINT_END;
        }
        return jsonStr;
    }

    public static Object genClobJsonStr(Object data) {
        if (data instanceof String && data.toString().contains("{")) {
            data = JSON.parse((String)data.toString());
        }
        return JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
    }

    public static void delErrByServerFunction(String server, String function) {
        QFilter filter = new QFilter("server", "=", (Object)server).and("function", "=", (Object)function);
        filter.and("status", "=", (Object)"B");
        try {
            DeleteServiceHelper.delete((String)ER_TRIPSYNC_LOG_SIGN, (QFilter[])new QFilter[]{filter});
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u5f02\u5e38\u65e5\u5fd7\u5bf9\u8c61\uff01", (Throwable)e);
        }
    }

    public static void delErrByServerBillIds(String server, Set<String> billIds) {
        if (billIds == null || billIds.size() < 1) {
            return;
        }
        QFilter filter = new QFilter("billid", "in", billIds).and("server", "=", (Object)server);
        filter.and("status", "=", (Object)"B");
        try {
            DeleteServiceHelper.delete((String)ER_TRIPSYNC_LOG_SIGN, (QFilter[])new QFilter[]{filter});
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u5f02\u5e38\u65e5\u5fd7\u5bf9\u8c61\uff01", (Throwable)e);
        }
    }

    public static void delErrByBillId(Set<String> billIds) {
        if (billIds == null || billIds.size() < 1) {
            return;
        }
        QFilter filter = new QFilter("billid", "in", billIds);
        filter.and("status", "=", (Object)"B");
        try {
            DeleteServiceHelper.delete((String)ER_TRIPSYNC_LOG_SIGN, (QFilter[])new QFilter[]{filter});
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u5f02\u5e38\u65e5\u5fd7\u5bf9\u8c61\uff01", (Throwable)e);
        }
    }

    public static void delErrByKeepDays() {
        int keepDays = TripSyncConfigUtil.getIntValue("keep_log_days", 30);
        if (keepDays <= 0) {
            keepDays = 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.get(5) - keepDays);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date lastDay = calendar.getTime();
        QFilter filter = new QFilter("synctime", "<", (Object)lastDay);
        try {
            DeleteServiceHelper.delete((String)ER_TRIPSYNC_LOG_SIGN, (QFilter[])new QFilter[]{filter});
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u96c6\u6210\u65e5\u5fd7,\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u5f02\u5e38\u65e5\u5fd7\u5bf9\u8c61\uff01", (Throwable)e);
        }
    }

    public static void saveReqBillMqErrorLog(String billId, String billno, Set<String> servers, Object msg) {
        if (servers == null || servers.size() < 1) {
            return;
        }
        HashSet<String> billIds = new HashSet<String>();
        billIds.add(billId);
        servers.forEach(server -> TripSyncLogUtils.delErrByServerBillIds(server, billIds));
        ArrayList<TripSyncLogParam> tripSyncLogParamList = new ArrayList<TripSyncLogParam>(4);
        servers.forEach(server -> {
            TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), (String)server, "tripReqBillInvoke");
            tripSyncLogParam.setBillid(billId);
            tripSyncLogParam.setBillno(billno);
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(msg);
            tripSyncLogParamList.add(tripSyncLogParam);
        });
        TripSyncLogUtils.saveErrorDOsByLog(tripSyncLogParamList);
    }

    private static /* synthetic */ void lambda$saveErrorDOs$1(DynamicObjectType billType, List dynamicObjects, TripSyncLogParam logParam) {
        DynamicObject exceptionInfo = new DynamicObject(billType);
        exceptionInfo.set("traceid", (Object)logParam.getTraceid());
        exceptionInfo.set("server", (Object)logParam.getServer());
        exceptionInfo.set("function", (Object)logParam.getFunction());
        exceptionInfo.set("status", (Object)logParam.getStatus());
        exceptionInfo.set("synctime", (Object)new Date());
        exceptionInfo.set("message", (Object)TripSyncLogUtils.genErrorStr(logParam.getMessage()));
        exceptionInfo.set("message_tag", (Object)logParam.getMessage());
        exceptionInfo.set("requesturl", (Object)logParam.getRequesturl());
        exceptionInfo.set("requestdata", TripSyncLogUtils.genJsonStr(logParam.getRequestdata()));
        exceptionInfo.set("requestdata_tag", TripSyncLogUtils.genClobJsonStr(logParam.getRequestdata()));
        exceptionInfo.set("responsedata", TripSyncLogUtils.genJsonStr(logParam.getResponsedata()));
        exceptionInfo.set("responsedata_tag", TripSyncLogUtils.genClobJsonStr(logParam.getResponsedata()));
        exceptionInfo.set("billno", (Object)logParam.getBillno());
        exceptionInfo.set("billid", (Object)logParam.getBillid());
        dynamicObjects.add(exceptionInfo);
    }
}

