/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.iscadmin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class TripSyncLogListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListView listView;
        ListSelectedRowCollection selectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (("reqbillretry".equals(operateKey) || "dailyvehiclebillretry".equals(operateKey)) && (selectedRowCollection = (listView = (ListView)this.getView()).getSelectedRows()).size() > 1) {
            listView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"TripSyncLogListPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult result = evt.getOperationResult();
        if (("reqbillretry".equals(operateKey) || "dailyvehiclebillretry".equals(operateKey)) && result.isSuccess()) {
            try {
                this.doTestReqBill(operateKey);
            }
            catch (Exception exception) {
            }
            finally {
                ((ListView)this.getView()).refresh();
            }
        }
    }

    private void doTestReqBill(String operateKey) {
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection selectedRowCollection = listView.getSelectedRows();
        if (selectedRowCollection.size() < 1) {
            return;
        }
        HashSet rowIds = new HashSet();
        selectedRowCollection.forEach(row -> rowIds.add(row.getPrimaryKeyValue()));
        DynamicObject[] rows = (DynamicObject[])QueryServiceHelper.query((String)"er_tripsync_log", (String)"billid,server,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", rowIds)}).toArray((Object[])new DynamicObject[0]);
        Map params = Arrays.stream(rows).filter(row -> StringUtils.isNotBlank((CharSequence)row.getString("billid")) && StringUtils.isNotBlank((CharSequence)row.getString("server"))).collect(Collectors.groupingBy(row -> row.getString("server"), Collectors.mapping(row -> row.getString("billid"), Collectors.toList())));
        for (Map.Entry param : params.entrySet()) {
            String server = param.getKey();
            List<Object> billids = param.getValue();
            String tripServiceName = TripCommonUtil.getStandtripname().get(server);
            ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
            billids.forEach(billid -> {
                if (operateKey.equals("reqbillretry")) {
                    if (server.equals(Supplier.XIECHENG.name())) {
                        boolean isReqPushSuccess = Boolean.FALSE;
                        if (TripCommonUtil.existsTripServicePlugin(server, "tripReqBillInvoke").booleanValue()) {
                            String code = iTripService.synReqbillToTrip(billid, "1");
                            isReqPushSuccess = "200".equals(code);
                        } else {
                            HashMap<String, Object> map = new HashMap<String, Object>(2);
                            String formid = "er_tripreqbill";
                            QFilter qFilter = new QFilter("billid", "=", billid);
                            DynamicObject bill = QueryServiceHelper.queryOne((String)formid, (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
                            if (null != bill) {
                                map.put("billno", bill.getString("billno"));
                                Object list = TripCommonUtil.invoke(server, formid, null, null, map);
                                if (null != list && list instanceof List) {
                                    List ls = (List)list;
                                    Map result = (Map)ls.get(0);
                                    if (null != result && !result.getOrDefault("success", Boolean.TRUE).booleanValue()) {
                                        String code = iTripService.synReqbillToTrip(billid, "1");
                                        isReqPushSuccess = "200".equals(code);
                                    } else {
                                        isReqPushSuccess = TripCommonUtil.checkCTripReqResult(result);
                                    }
                                }
                            } else {
                                listView.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"TripSyncLogListPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                            }
                        }
                        if (isReqPushSuccess) {
                            TripCommonUtil.tripBudgetPush(billid, null, server, "1");
                        }
                    } else {
                        iTripService.synReqbillToTrip(billid, "1");
                    }
                }
                if (operateKey.equals("dailyvehiclebillretry")) {
                    iTripService.synDilyVehicleToTrip(billid, "1");
                }
            });
        }
    }
}

