/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.iscadmin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.model.TripType;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;

public class TripTestFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(TripTestFormPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String REQUEST_PARAM = "param_tag";
    private static final String STRUCTRUE_PARAM = "structrue_param_tag";
    private static final String DETAIL_PARAM = "detail_param_tag";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"structrue_param", "detail_param"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String name = e.getProperty().getName();
        if (name.equals("function") || name.equals("server")) {
            IDataModel model = this.getModel();
            Object newValue = changeSet[0].getNewValue();
            boolean checkingDataByBillNo = TripSyncConfigUtil.getBoolean("checkingdata_by_billno", false);
            IFormView view = this.getView();
            switch (name) {
                case "server": {
                    Object function = model.getValue("function");
                    if (function != null && function.equals("checkingInvoke") && "CHAILVYIHAO".equals(newValue.toString())) {
                        view.setVisible(Boolean.valueOf(checkingDataByBillNo), new String[]{"structrue_param", "detail_param"});
                        view.setVisible(Boolean.valueOf(!checkingDataByBillNo), new String[]{"param"});
                        return;
                    }
                    if (function != null && function.equals("orderInvoke") && "MEITUAN".equals(newValue.toString())) {
                        view.setVisible(Boolean.valueOf(true), new String[]{"structrue_param", "detail_param"});
                        view.setVisible(Boolean.valueOf(false), new String[]{"param"});
                        return;
                    }
                    view.setVisible(Boolean.valueOf(false), new String[]{"structrue_param", "detail_param"});
                    view.setVisible(Boolean.valueOf(true), new String[]{"param"});
                    break;
                }
                case "function": {
                    Object server = model.getValue("server");
                    if (server != null && "CHAILVYIHAO".equals(server) && "checkingInvoke".equals(newValue.toString())) {
                        view.setVisible(Boolean.valueOf(checkingDataByBillNo), new String[]{"structrue_param", "detail_param"});
                        view.setVisible(Boolean.valueOf(!checkingDataByBillNo), new String[]{"param"});
                        return;
                    }
                    if (server != null && "MEITUAN".equals(server) && "orderInvoke".equals(newValue.toString())) {
                        view.setVisible(Boolean.valueOf(true), new String[]{"structrue_param", "detail_param"});
                        view.setVisible(Boolean.valueOf(false), new String[]{"param"});
                        return;
                    }
                    view.setVisible(Boolean.valueOf(false), new String[]{"structrue_param", "detail_param"});
                    view.setVisible(Boolean.valueOf(true), new String[]{"param"});
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult result = evt.getOperationResult();
        if (BTN_OK.equals(operateKey) && result.isSuccess()) {
            this.doBtnOk();
        }
    }

    private void doBtnOk() {
        String server = (String)this.getModel().getValue("server");
        String tripServiceName = TripCommonUtil.getStandtripname().get(server);
        ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
        String function = (String)this.getModel().getValue("function");
        logger.info(String.format("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u670d\u52a1\u5546:%s,\u529f\u80fd:%s,\u96c6\u6210\u7528\u6237:%s", server, function, RequestContext.get().getUserName()));
        switch (function) {
            case "tripReqBillInvoke": {
                this.doTestReqBill(iTripService);
                break;
            }
            case "orderInvoke": {
                this.doTestOrderBill(iTripService, server);
                break;
            }
            case "imageInvoke": {
                this.doTestImageBill(iTripService, server);
                break;
            }
            case "orderUpdateInvoke": {
                this.doTestUpdateOrderBill(iTripService, server);
                break;
            }
            case "checkingInvoke": {
                this.doTestCheckingBill(iTripService, server);
                break;
            }
            case "invoiceReceiveInvoke": {
                this.doTestReceiveInvoiceBill(iTripService, server);
                break;
            }
            case "dailyVehicleBillInvoke": {
                this.doTestDailyVehicleBill(iTripService);
                break;
            }
            case "checkInvoke": {
                this.doTestCheckInvoke(server);
                break;
            }
        }
    }

    private void doTestCheckInvoke(String server) {
        String paramStr = this.getParams();
        String type = (String)this.getModel().getValue("type");
        String funtion = (String)this.getModel().getValue("function");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("input_data", JSONObject.parseObject((String)paramStr));
        paramMap.put("needVerifySign", Boolean.FALSE);
        TripCommonUtil.invoke(server, "er_checkingbill", null, null, paramMap);
    }

    private void doTestImageBill(ITripService iTripService, String server) {
        String orderbillParamStr = this.getParams();
        HashMap<String, JSONArray> paramMap = new HashMap<String, JSONArray>();
        if (!Supplier.CHAILVYIHAO.name().equals(server)) {
            return;
        }
        JSONObject orderObject = JSONObject.parseObject((String)orderbillParamStr);
        JSONArray array = new JSONArray();
        array.add((Object)JSON.parseObject((String)JSON.toJSONString((Object)orderObject.get((Object)"data"))));
        paramMap.put("jsondata", array);
        try {
            iTripService.synImageFromTrip(paramMap);
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u8ba2\u5355\u540c\u6b65\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void doTestDailyVehicleBill(ITripService iTripService) {
        String billNo = this.getParams();
        if (billNo.contains("constant")) {
            if (!billNo.startsWith("constants_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u9020\u5e38\u91cf\u7c7b\uff0c\u8bf7\u4ee5\u201cconstants_\u201d\u4e3a\u5f00\u59cb\u5b57\u7b26\u3002", (String)"TripTestFormPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
                return;
            }
            int index = billNo.indexOf("_") + 1;
            this.doGetConstants(billNo.substring(index));
            return;
        }
        DynamicObject dailyVehiclebill = QueryServiceHelper.queryOne((String)"er_dailyvehiclebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (dailyVehiclebill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u8f66\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"TripTestFormPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
        }
        logger.info("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65\u5f00\u59cb,\u7533\u8bf7\u5355\u53f7:" + billNo);
        iTripService.synDilyVehicleToTrip(dailyVehiclebill.getLong("id"), "1");
    }

    private void doTestReqBill(ITripService iTripService) {
        String billNo = this.getParams();
        if ("hello_db".equalsIgnoreCase(billNo)) {
            FormModel formModel = new FormModel("er_private_ksql_navicat", "hello_db", "1");
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
            return;
        }
        if (billNo.contains("constant")) {
            if (!billNo.startsWith("constants_")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u9020\u5e38\u91cf\u7c7b\uff0c\u8bf7\u4ee5\u201cconstants_\u201d\u4e3a\u5f00\u59cb\u5b57\u7b26\u3002", (String)"TripTestFormPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
                return;
            }
            int index = billNo.indexOf("_") + 1;
            this.doGetConstants(billNo.substring(index));
            return;
        }
        DynamicObject reqbill = BusinessDataServiceHelper.loadSingle((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (reqbill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u3002", (String)"TripTestFormPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        logger.info("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u7533\u8bf7\u5355\u540c\u6b65\u5f00\u59cb,\u7533\u8bf7\u5355\u53f7:" + billNo);
        iTripService.synReqbillToTrip(reqbill.getPkValue(), "1");
    }

    private void doTestOrderBill(ITripService iTripService, String server) {
        String orderbillParamStr = this.getParams();
        String type = (String)this.getModel().getValue("type");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String funtion = "";
        if (Supplier.GAODE.name().equals(server) || Supplier.QICHENG.name().equals(server) || Supplier.TONGCHENG.name().equals(server) || Supplier.ALI.name().equals(server) || Supplier.MEIYA.name().equals(server) || Supplier.DIDI.name().equals(server) && !"CAR".equals(type)) {
            paramMap.put("input_data", JSONObject.parseObject((String)orderbillParamStr));
            paramMap.put("needVerifySign", Boolean.FALSE);
            TripCommonUtil.invoke(server, TripType.getTripType(type).getOrder(), null, null, paramMap);
        } else {
            if (Supplier.ZHONGXING.name().equals(server)) {
                JSONObject orderObject = JSONObject.parseObject((String)orderbillParamStr);
                paramMap.put("method", orderObject.get((Object)"method"));
                paramMap.put("data", JSONObject.toJSONString((Object)orderObject.get((Object)"data")));
            }
            if (Supplier.XIECHENG.name().equals(server) || Supplier.CHAILVYIHAO.name().equals(server) || Supplier.DIDI.name().equals(server)) {
                paramMap.put("jsondata", orderbillParamStr);
            }
            if (Supplier.MEITUAN.name().equals(server)) {
                String structrue_param = (String)this.getModel().getValue(STRUCTRUE_PARAM);
                String detail_param = (String)this.getModel().getValue(DETAIL_PARAM);
                paramMap.put("structrue_param", structrue_param);
                paramMap.put("detail_param", detail_param);
            }
            try {
                iTripService.synOrderFromTrip(paramMap);
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u8ba2\u5355\u540c\u6b65\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private String getParams() {
        String params = (String)this.getModel().getValue(REQUEST_PARAM);
        if (null != params && !params.trim().isEmpty()) {
            return params;
        }
        try {
            AttachmentPanel filePanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            List attachmentDatas = filePanel.getAttachmentData();
            for (Map attachmentData : attachmentDatas) {
                String url = (String)attachmentData.get("url");
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                InputStreamReader in = new InputStreamReader(cache.getInputStream(url), StandardCharsets.UTF_8);
                BufferedReader bfreader = new BufferedReader(in);
                StringBuffer sb = new StringBuffer();
                String line = "";
                while ((line = bfreader.readLine()) != null) {
                    sb.append(line);
                }
                params = sb.toString();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (String)"TripTestFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            logger.error("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return params;
    }

    private void doTestUpdateOrderBill(ITripService iTripService, String server) {
        String orderbillParamStr = this.getParams();
        String type = (String)this.getModel().getValue("type");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("jsondata", orderbillParamStr);
        paramMap.put("businessType", type);
        try {
            iTripService.getOrderUpdateFromTripSettel(paramMap);
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u8ba2\u5355\u540c\u6b65\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void doTestCheckingBill(ITripService iTripService, String server) {
        String paramStr = this.getParams();
        String type = (String)this.getModel().getValue("type");
        String funtion = (String)this.getModel().getValue("function");
        JSONObject paramMap = new HashMap();
        if (Supplier.GAODE.name().equals(server) || Supplier.DIDI.name().equals(server) && !type.equals("CAR")) {
            paramMap.put("input_data", JSONObject.parseObject((String)paramStr));
            paramMap.put("needVerifySign", Boolean.FALSE);
            TripCommonUtil.invoke(server, TripType.getTripType(type).getChecking(), null, null, (Map<String, Object>)paramMap);
        } else {
            if (Supplier.ZHONGXING.name().equals(server)) {
                JSONObject orderObject;
                paramMap = orderObject = JSONObject.parseObject((String)paramStr);
            }
            if (Supplier.XIECHENG.name().equals(server)) {
                paramMap.put("businessType", type);
                paramMap.put("jsondata", paramStr);
            }
            if (Supplier.CHAILVYIHAO.name().equals(server)) {
                paramMap.put("jsondata", paramStr);
                String structrue_param = (String)this.getModel().getValue(STRUCTRUE_PARAM);
                String detail_param = (String)this.getModel().getValue(DETAIL_PARAM);
                paramMap.put("structrue_param", structrue_param);
                paramMap.put("detail_param", detail_param);
            }
            if (Supplier.DIDI.name().equals(server)) {
                paramMap.put("jsondata", paramStr);
            }
            try {
                iTripService.synSettlementsFromTrip((Map<String, ? extends Object>)paramMap);
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5,\u7ed3\u7b97\u5355\u540c\u6b65\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void doTestReceiveInvoiceBill(ITripService iTripService, String server) {
        if (Supplier.DIDI.getValue().equals(server)) {
            String orderbillParamStr = this.getParams();
            JSONArray jsonArray = JSONObject.parseArray((String)orderbillParamStr);
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("jsondata", (List<Object>)jsonArray);
            iTripService.getInvoiceDetail(params);
        } else if (Supplier.XIECHENG.getValue().equals(server)) {
            String orderbillParamStr = this.getParams();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)JSON.parseObject((String)orderbillParamStr));
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("jsondata", (List<Object>)jsonArray);
            iTripService.getInvoiceDetail(params);
        } else if (Supplier.CHAILVYIHAO.getValue().equals(server)) {
            String orderbillParamStr = this.getParams();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)JSON.parseObject((String)orderbillParamStr));
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("jsondata", (List<Object>)jsonArray);
            iTripService.getInvoiceDetail(params);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u6709\u6ef4\u6ef4\uff0c\u643a\u7a0b\uff0c\u5dee\u65c5\u58f9\u53f7\u652f\u6301\u53d1\u7968\u63a5\u53d7\u529f\u80fd\u96c6\u6210\u6d4b\u8bd5\u3002", (String)"TripTestFormPlugin_5", (String)"fi-er-business", (Object[])new Object[0]));
        }
    }

    private void doGetConstants(String entityName) {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityName);
        List properties = entity.getJsonSerializerProperties();
        properties.forEach(prop -> {
            if (!(prop instanceof EntryProp)) {
                propMap.put(prop.getName(), prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().getLocaleValue());
            }
        });
        properties.forEach(prop -> {
            if (prop instanceof EntryProp) {
                propMap.put("EntryProp-" + prop.getName() + "-Start,", prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().getLocaleValue());
                propMap.put(prop.getName(), prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().getLocaleValue());
                DataEntityPropertyCollection entryProps = ((EntryProp)prop).getItemType().getProperties();
                entryProps.forEach(entryProp -> {
                    if (!entryProp.getName().contains("_id")) {
                        propMap.put(entryProp.getName(), entryProp.getDisplayName() == null ? entryProp.getName() : entryProp.getDisplayName().getLocaleValue());
                    }
                });
                propMap.put("EntryProp-" + prop.getName() + "-End,", prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().getLocaleValue());
            }
        });
        long time = new Date().getTime();
        StringBuilder dataSb = new StringBuilder();
        propMap.forEach((k, v) -> {
            String dataStr = null;
            dataStr = k.contains("EntryProp-") ? "/*******************************************" + k + v + "*******************************************/\r\n" : "public static final String " + k.toUpperCase() + " = \"" + k + "\";//" + v + "\r\n";
            dataSb.append(dataStr);
        });
        ByteArrayInputStream ins = new ByteArrayInputStream(dataSb.toString().getBytes(StandardCharsets.UTF_8));
        String txtName = entityName + "_" + time + ".txt";
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(txtName, (InputStream)ins, 5000);
        this.getView().openUrl(url);
    }
}

