/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.invoice.GenerateInvoicerAssistant;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.utils.ActionLocalCache;

public class CheckingBillExistDataModel
extends ExistDataModel {
    private static final Log logger = LogFactory.getLog(CheckingBillExistDataModel.class);
    public final Map<String, DynamicObject> checkingbillDetailMapping = new HashMap<String, DynamicObject>();
    public final Map<String, DynamicObject> allCheckingBillDynamicMapping = new HashMap<String, DynamicObject>();
    public final Map<String, DynamicObject> allOrderBillMapping = new HashMap<String, DynamicObject>();
    public final Map<String, DynamicObject> orderDetailMapping = new HashMap<String, DynamicObject>();
    public final Map<String, DynamicObject> checkingbill = new HashMap<String, DynamicObject>();
    public final Set<String> allChecingBillFilter = new HashSet<String>();
    public final Map<String, Set<String>> checingBillFilter = new HashMap<String, Set<String>>();
    public final Set<String> billNums = new HashSet<String>();
    public final Set<String> checkingbillType = new HashSet<String>();
    public final Map<String, long[]> idsMap = new HashMap<String, long[]>();
    public final Map<String, Integer> idIndexMap = new HashMap<String, Integer>();
    private List<Map<String, String>> invoiceSetting = null;

    public List<Map<String, String>> getInvoiceSetting() {
        return this.invoiceSetting;
    }

    public Map<String, DynamicObject> getCheckingbillDetailMapping() {
        return this.checkingbillDetailMapping;
    }

    @Override
    public void query() {
        DynamicObject[] allCheckingBillDynamics;
        DynamicObject[] checkings;
        super.query();
        IErDao checkingbillDao = ErDaoFactory.getInstance("er_checkingbill");
        for (DynamicObject checking : checkings = checkingbillDao.query(new QFilter("billnum", "in", this.billNums).and(new QFilter("server", "=", (Object)this.getServer())))) {
            this.checkingbill.put(checking.getString("billnum"), checking);
        }
        this.checingBillFilter.forEach((key, value) -> {
            DynamicObject[] checkingBillDynamics;
            IErDao checkingDao = ErDaoFactory.getInstance(key);
            for (DynamicObject checkingBillDynamic : checkingBillDynamics = checkingDao.query(new QFilter("ordernum", "in", value).and(new QFilter("server", "=", (Object)this.getServer())))) {
                this.checkingbillDetailMapping.put(checkingBillDynamic.getString("orderNum"), checkingBillDynamic);
            }
        });
        Collection<DynamicObject> values = this.checkingbillDetailMapping.values();
        long count = this.checingBillFilter.entrySet().stream().flatMap(v -> ((Set)v.getValue()).stream()).count();
        if (values.size() <= 0 || (long)values.size() != count) {
            this.checkingbillType.forEach(type -> {
                if (null != type && !type.isEmpty()) {
                    String entityName = EntityMetadataCache.getDataEntityType((String)type).getAlias();
                    long[] ids = DBServiceHelper.genLongIds((String)entityName, (int)this.checingBillFilter.get(type).size());
                    this.idsMap.put((String)type, ids);
                    this.idIndexMap.put((String)type, 0);
                }
            });
        }
        IErDao allCheckingBillDao = ErDaoFactory.getInstance("er_allcheckingbill");
        for (DynamicObject allCheckingBill : allCheckingBillDynamics = allCheckingBillDao.query(new QFilter("orderNum", "in", this.allChecingBillFilter).and(new QFilter("server", "=", (Object)this.getServer())))) {
            this.allCheckingBillDynamicMapping.put(allCheckingBill.getString("orderNum"), allCheckingBill);
        }
        QFilter orderFilter = new QFilter("orderNum", "in", this.allChecingBillFilter).and(new QFilter("server", "=", (Object)this.getServer()));
        IErDao allOrderDao = ErDaoFactory.getInstance("er_allorderbill");
        DynamicObject[] allOrderBillDynamics = allOrderDao.query("ordernum, totalamount, server, expcommitcomnum, expcommitdepnum, operationtype,orderformid,isreconciliation", orderFilter);
        if (allOrderBillDynamics != null) {
            for (DynamicObject allOrder : allOrderBillDynamics) {
                this.allOrderBillMapping.put(allOrder.getString("orderNum"), allOrder);
            }
        }
        if (allOrderBillDynamics != null && allOrderBillDynamics.length > 0) {
            Arrays.stream(allOrderBillDynamics).collect(Collectors.groupingBy(dynamic -> dynamic.get("orderformid"))).forEach((key, dynamicObjects) -> {
                DynamicObject[] orderDetailBillDynamics;
                IErDao orderDetailDao = ErDaoFactory.getInstance(key.toString());
                String selectProperties = "id, server, orderNum, expcommitcomnum, expcommitdepnum, isreconciliation, reimbursestatus,downloadlink,kddownloadlink,std_project";
                if ("er_planebill".equalsIgnoreCase(String.valueOf(key))) {
                    selectProperties = selectProperties + ",ticketstatus";
                }
                if ("er_trainbill".equalsIgnoreCase(String.valueOf(key))) {
                    selectProperties = selectProperties + ",trainticketnum";
                }
                for (DynamicObject orderDetail : orderDetailBillDynamics = orderDetailDao.query(selectProperties, orderFilter)) {
                    this.orderDetailMapping.put(orderDetail.getString("orderNum"), orderDetail);
                }
            });
        }
        logger.info("\u7ed3\u7b97\u5355\u8ba2\u5355\u8be6\u60c5map:" + this.orderDetailMapping.size());
        this.invoiceSetting = GenerateInvoicerAssistant.getInvoiceSetting(this.getServer(), null);
    }

    @Override
    public void save() throws TripException {
        try (TXHandle txHandle = TX.requiresNew();){
            boolean isJsonData = false;
            try {
                isJsonData = (Boolean)ActionLocalCache.get().getDefaultIfNull("isJsonData", false);
            }
            catch (Exception e) {
                logger.error("\u53c2\u6570\u83b7\u53d6\u9519\u8bef");
            }
            try {
                if (this.checkingbill != null && this.checkingbill.size() > 0 && !isJsonData) {
                    SaveServiceHelper.save((DynamicObject[])this.checkingbill.values().toArray(new DynamicObject[this.checkingbill.size()]));
                } else if (this.checkingbill == null || this.checkingbill.size() == 0) {
                    throw new TripException(ResManager.loadKDString((String)"\u6570\u636e\u7ec4\u88c5\u9519\u8bef\uff0c\u6ca1\u6709\u5bf9\u8d26\u5355\u5934\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"CheckingBillExistDataModel_0", (String)"fi-er-business", (Object[])new Object[0]));
                }
                if (this.checkingbillDetailMapping.size() > 0) {
                    this.checkingbillDetailMapping.values().stream().collect(Collectors.groupingBy(DynamicObject::getDynamicObjectType)).forEach((key, values) -> {
                        if (values != null && values.size() > 0) {
                            SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[values.size()]));
                        }
                    });
                }
                if (this.allCheckingBillDynamicMapping.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])this.allCheckingBillDynamicMapping.values().toArray(new DynamicObject[this.allCheckingBillDynamicMapping.size()]));
                }
                if (this.allOrderBillMapping.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])this.allOrderBillMapping.values().toArray(new DynamicObject[this.allOrderBillMapping.size()]));
                }
                if (this.orderDetailMapping.size() > 0) {
                    this.orderDetailMapping.values().stream().collect(Collectors.groupingBy(DynamicObject::getDynamicObjectType)).forEach((key, values) -> {
                        if (values != null && values.size() > 0) {
                            SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[values.size()]));
                        }
                    });
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("-1", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("-1", e.getMessage()), new Object[0]);
        }
    }
}

