/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import org.apache.commons.lang3.StringUtils;

public abstract class ExistDataModel {
    private static final Log logger = LogFactory.getLog(ExistDataModel.class);
    private String server = "";
    private Map<String, DynamicObject> reqbillMapping = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> dailyApplybillMapping = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> dailyVehicleBillMapping = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> mealApplyBillMapping = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> userMapping = new HashMap<String, DynamicObject>();
    private Map<String, DynamicObject> travelerMapping = new HashMap<String, DynamicObject>();
    private Set<String> reqbillFilter = new HashSet<String>();
    private Set<String> applybillFilter = new HashSet<String>();
    private Set<String> userFilter = new HashSet<String>();

    public void query() {
        DynamicObject[] users;
        DynamicObject[] mealApplyBills;
        DynamicObject[] dailyApplyBills;
        DynamicObject[] dailyVehicleBills;
        String selectFields = "billno, company, org,costcompany,costdept, currency, tripentry, tripentry.from, tripentry.to, tripentry.startdate, tripentry.enddate,tripentry.travelers,tripentry.std_project,std_costcenter";
        QFilter qFilter = new QFilter("billno", "in", this.reqbillFilter);
        DynamicObject[] reqbills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        this.applybillFilter.addAll(this.reqbillFilter);
        for (DynamicObject reqbill : reqbills) {
            this.reqbillMapping.put(reqbill.getString("billno"), reqbill);
            this.applybillFilter.remove(reqbill.getString("billno"));
            DynamicObjectCollection tripentry = reqbill.getDynamicObjectCollection("tripentry");
            for (DynamicObject trip : tripentry) {
                DynamicObjectCollection travelersDyn = trip.getDynamicObjectCollection("travelers");
                if (travelersDyn == null || travelersDyn.size() <= 0) continue;
                for (DynamicObject travelerDyn : travelersDyn) {
                    DynamicObject user = travelerDyn.getDynamicObject("fbasedataid");
                    this.travelerMapping.put(user.getString("number"), user);
                    logger.info("\u5546\u65c5\u96c6\u6210,\u5df2\u5b58\u5728\u6570\u636e\u51fa\u5dee\u4eba\uff1a" + user.getString("name") + "," + user.getPkValue());
                }
            }
        }
        qFilter = new QFilter("billno", "in", this.applybillFilter);
        selectFields = "billno, company, org,costcompany,costdept, currency, vehicletype, headproject,std_costcenter";
        for (DynamicObject dailyVehicleBill : dailyVehicleBills = BusinessDataServiceHelper.load((String)"er_dailyvehiclebill", (String)selectFields, (QFilter[])new QFilter[]{qFilter})) {
            if (!StringUtils.isNotBlank((CharSequence)dailyVehicleBill.getString("billno"))) continue;
            this.dailyVehicleBillMapping.put(dailyVehicleBill.getString("billno"), dailyVehicleBill);
            this.applybillFilter.remove(dailyVehicleBill.getString("billno"));
        }
        selectFields = "billno, company, org,costcompany,costdept, currency, reimbursetype,std_costcenter";
        for (DynamicObject dailyApplybill : dailyApplyBills = BusinessDataServiceHelper.load((String)"er_dailyapplybill", (String)selectFields, (QFilter[])new QFilter[]{qFilter})) {
            if (!StringUtils.isNotBlank((CharSequence)dailyApplybill.getString("billno"))) continue;
            this.dailyApplybillMapping.put(dailyApplybill.getString("billno"), dailyApplybill);
            this.applybillFilter.remove(dailyApplybill.getString("billno"));
        }
        selectFields = "billno, company, org,costcompany,costdept, currency, dinnerscene, headproject,std_costcenter";
        for (DynamicObject mealApplyBill : mealApplyBills = BusinessDataServiceHelper.load((String)"er_mealapplication_bill", (String)selectFields, (QFilter[])new QFilter[]{qFilter})) {
            if (!StringUtils.isNotBlank((CharSequence)mealApplyBill.getString("billno"))) continue;
            this.mealApplyBillMapping.put(mealApplyBill.getString("billno"), mealApplyBill);
        }
        String userSelectFields = "id,number,name,entryentity.id,entryentity.position,entryentity.dpt";
        QFilter userQFilter = new QFilter("number", "in", this.userFilter);
        for (DynamicObject user : users = BusinessDataServiceHelper.load((String)"bos_user", (String)userSelectFields, (QFilter[])new QFilter[]{userQFilter})) {
            this.userMapping.put(user.getString("number"), user);
        }
    }

    public abstract void save() throws TripException;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public Map<String, DynamicObject> getReqbillMapping() {
        return this.reqbillMapping;
    }

    public Map<String, DynamicObject> getDailyApplybillMapping() {
        return this.dailyApplybillMapping;
    }

    public Map<String, DynamicObject> getDailyVehicleBillMapping() {
        return this.dailyVehicleBillMapping;
    }

    public Map<String, DynamicObject> getMealApplyBillMapping() {
        return this.mealApplyBillMapping;
    }

    public Map<String, DynamicObject> getUserMapping() {
        return this.userMapping;
    }

    public Map<String, DynamicObject> getTravelerMapping() {
        return this.travelerMapping;
    }

    public Set<String> getReqbillFilter() {
        return this.reqbillFilter;
    }

    public Set<String> getUserFilter() {
        return this.userFilter;
    }
}

