/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.openapi.Handler;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;

public class GetTripInvoiceHandler {
    private Log logger = LogFactory.getLog(GetTripInvoiceHandler.class);
    private String service;
    private String method;
    private Map data;
    private static final String SYNC_METHOD = "invoiceReceiveInvoke";

    public ApiResult doHandleInvoice(Map<String, Object> invoiceData) {
        this.getInvoiceMustInputData(invoiceData);
        ApiResult result = this.verifyIsHaveInvoiceBill(invoiceData);
        if (result != null) {
            return result;
        }
        result = this.doOperation();
        return result;
    }

    private void getInvoiceMustInputData(Map<String, Object> invoiceData) {
        Object service = invoiceData.get("service");
        Object method = invoiceData.get("method");
        Object data = invoiceData.get("data");
        this.service = (String)service;
        this.method = (String)method;
        this.data = (Map)data;
    }

    private ApiResult verifyIsHaveInvoiceBill(Map<String, Object> invoiceData) {
        ApiResult result = new ApiResult();
        String businessCode = (String)this.data.get("businessCode");
        DynamicObject[] invoiceorderbill = (DynamicObject[])QueryServiceHelper.query((String)"er_invoiceorderbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("batchno", "ftlike", (Object)businessCode)}).toArray((Object[])new DynamicObject[0]);
        if (invoiceorderbill.length == 0) {
            result.setSuccess(false);
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5f00\u7968\u7533\u8bf7\u5355,\u8bf7\u786e\u8ba4\u6570\u636e\u6b63\u786e\u6027\u3002\u5f53\u524d\u4e1a\u52a1\u7f16\u53f7:%s", (String)"GetTripInvoiceHandler_0", (String)"fi-er-business", (Object[])new Object[0]), businessCode));
            return result;
        }
        return null;
    }

    private ApiResult doOperation() {
        ApiResult result = new ApiResult();
        if (StringUtils.endsWithIgnoreCase((CharSequence)this.method, (CharSequence)SYNC_METHOD)) {
            HashMap<String, List<Object>> paraMap = new HashMap<String, List<Object>>();
            ArrayList<Map> list = new ArrayList<Map>();
            list.add(this.data);
            paraMap.put("data", list);
            String tripServiceClazz = "";
            if (Supplier.XIECHENG.name().equalsIgnoreCase(this.service)) {
                tripServiceClazz = "CTripService";
            } else if (Supplier.ZHONGXING.name().equalsIgnoreCase(this.service)) {
                tripServiceClazz = "ETripService";
            } else if (Supplier.CHAILVYIHAO.name().equalsIgnoreCase(this.service)) {
                tripServiceClazz = "TTripService";
            }
            ITripService tripService = TripServiceFactory.getTripService(tripServiceClazz);
            try {
                tripService.getInvoiceDetail(paraMap);
            }
            catch (Exception e) {
                String detail = ErExceptionServiceHelper.getStackTrace(e);
                this.logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5546\u65c5\u670d\u52a1\u5546\u63a8\u9001\u5f00\u7968\u4fe1\u606f\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:" + detail);
                result.setSuccess(false);
                result.setMessage(detail);
            }
        }
        if (!result.getSuccess()) {
            return this.buildFaileResult(result);
        }
        return this.buildSuccessResult();
    }

    private ApiResult buildFaileResult(ApiResult result) {
        result.setSuccess(false);
        result.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u670d\u52a1\u5546\u63a8\u9001\u5f00\u7968\u4fe1\u606f\u5931\u8d25\u3002", (String)"GetTripInvoiceHandler_1", (String)"fi-er-business", (Object[])new Object[0]));
        result.setErrorCode("300");
        this.logger.info("\u5546\u65c5\u96c6\u6210," + this.service + ":\u5546\u65c5\u670d\u52a1\u5546\u63a8\u9001\u5f00\u7968\u4fe1\u606f\u5931\u8d25\u3002 errorMessage:" + result.getMessage() + ", errorCode:" + result.getErrorCode());
        return result;
    }

    private ApiResult buildSuccessResult() {
        HashMap responseMap = Maps.newHashMap();
        responseMap.put("resultCode", "200");
        responseMap.put("service", this.service);
        responseMap.put("method", this.method);
        responseMap.put("businessCode", this.data.get("businessCode"));
        ApiResult ret = new ApiResult();
        ret.setSuccess(true);
        ret.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u670d\u52a1\u5546\u63a8\u9001\u5f00\u7968\u4fe1\u606f\u6210\u529f\u3002", (String)"GetTripInvoiceHandler_2", (String)"fi-er-business", (Object[])new Object[0]));
        ret.setErrorCode("200");
        ret.setData((Object)responseMap);
        this.logger.info("\u5546\u65c5\u96c6\u6210," + this.service + ":\u5546\u65c5\u670d\u52a1\u5546\u63a8\u9001\u5f00\u7968\u4fe1\u606f\u6210\u529f\u3002");
        return ret;
    }
}

