/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.openapi.Handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class TripOrderAndCheckingHandler {
    private static Log logger = LogFactory.getLog(TripOrderAndCheckingHandler.class);
    private String server;
    private String method;
    private String sign;

    public ApiResult doHandleOrderAndChecking(Map<String, Object> params) {
        this.getMustInputData(params);
        ApiResult result = this.verifyData(params);
        if (result != null) {
            return result;
        }
        result = this.doOperation(params);
        return result;
    }

    private void getMustInputData(Map<String, Object> jsondata) {
        Object server = jsondata.get("service");
        Object method = jsondata.get("method");
        Object sign = jsondata.get("sign");
        this.server = (String)server;
        this.method = (String)method;
        this.sign = (String)sign;
    }

    private ApiResult verifyData(Map<String, Object> params) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(params));
        JSONArray data = jsonObject.getJSONArray("data");
        if (data.size() > 10) {
            ApiResult result = new ApiResult();
            result.setErrorCode("500");
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0cdata\u6700\u591a\u4e00\u6b21\u53ea\u5141\u8bb8\u540c\u6b6510\u6761\u3002", (String)"TripSyncOpenApi_2", (String)"fi-er-business", (Object[])new Object[0]));
            return result;
        }
        return null;
    }

    private ApiResult doOperation(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        HashMap<String, Map<String, Object>> tripSync = new HashMap<String, Map<String, Object>>(1);
        tripSync.put("tripSync", params);
        map.put("input_data", JSON.parseObject((String)JSON.toJSONString(tripSync)));
        map.put("notDeedLock", Boolean.TRUE);
        Object list = TripCommonUtil.invoke(null, this.method, null, null, map);
        this.buildResult(result, list);
        return result;
    }

    private ApiResult buildResult(ApiResult apiresult, Object list) {
        if (null == list || !(list instanceof List)) {
            apiresult.setErrorCode("500");
            apiresult.setSuccess(Boolean.FALSE.booleanValue());
            apiresult.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s\u63a8\u9001\u5f02\u5e38\uff1a%3$s", (String)"ErTripAction_03", (String)"fi-er-business", (Object[])new Object[0]), 1, this.server, ""));
            return apiresult;
        }
        List ls = (List)list;
        Map result = (Map)ls.get(0);
        if (null == result || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) {
            apiresult.setErrorCode("500");
            apiresult.setSuccess(Boolean.FALSE.booleanValue());
            apiresult.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s\u63a8\u9001\u5f02\u5e38\uff1a%3$s", (String)"ErTripAction_03", (String)"fi-er-business", (Object[])new Object[0]), 2, this.server, result != null ? result.get("msg") : ""));
            return apiresult;
        }
        Map re = result;
        Object success = re.get("success");
        Object dataob = re.get("data");
        if (null == success || !(success instanceof Boolean) || null == dataob) {
            apiresult.setErrorCode("500");
            apiresult.setSuccess(Boolean.FALSE.booleanValue());
            apiresult.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s\u63a8\u9001\u5f02\u5e38\uff1a%3$s", (String)"ErTripAction_03", (String)"fi-er-business", (Object[])new Object[0]), 3, this.server, result.get("msg")));
            return apiresult;
        }
        TripSyncLogParam tripSyncLogParam = (TripSyncLogParam)JSON.parseObject((String)JSON.toJSONString(dataob), TripSyncLogParam.class);
        if (null == tripSyncLogParam || "B".equals(tripSyncLogParam.getStatus())) {
            apiresult.setErrorCode("500");
            apiresult.setSuccess(Boolean.FALSE.booleanValue());
            apiresult.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s\u63a8\u9001\u5f02\u5e38\uff1a%3$s", (String)"ErTripAction_03", (String)"fi-er-business", (Object[])new Object[0]), 4, this.server, null != tripSyncLogParam ? tripSyncLogParam.getMessage() : ""));
            return apiresult;
        }
        apiresult.setSuccess(true);
        apiresult.setMessage(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f\u3002", (String)"TripOrderAndCheckingHandler_1", (String)"fi-er-business", (Object[])new Object[0]));
        apiresult.setErrorCode("200");
        logger.info("\u5546\u65c5\u96c6\u6210," + this.server + ":\u5546\u65c5\u670d\u52a1\u5546\u63a8\u9001\u5f00\u7968\u4fe1\u606f\u6210\u529f\u3002");
        return apiresult;
    }
}

