/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.openapi;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;
import kd.fi.er.business.trip.openapi.Handler.GetTripInvoiceHandler;
import kd.fi.er.business.trip.openapi.Handler.TripOrderAndCheckingHandler;

public class TripSyncOpenApi
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(TripSyncOpenApi.class);
    private String method;
    private static final String INVOICE_OPENAPI_METHOD = "invoiceReceiveInvoke";

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = this.verifyRequiredKey(params);
        if (result != null) {
            return result;
        }
        try {
            switch (this.method) {
                case "invoiceReceiveInvoke": {
                    result = new GetTripInvoiceHandler().doHandleInvoice(params);
                    break;
                }
                case "er_planebill": 
                case "er_planecheckingbill": 
                case "er_hotelbill": 
                case "er_hotelcheckingbill": 
                case "er_trainbill": 
                case "er_traincheckingbill": 
                case "er_vehiclebill": 
                case "er_vehiclecheckingbill": 
                case "er_checkingbill": {
                    result = new TripOrderAndCheckingHandler().doHandleOrderAndChecking(params);
                    break;
                }
                default: {
                    result = new ApiResult();
                    result.setErrorCode("500");
                    result.setSuccess(Boolean.FALSE.booleanValue());
                    result.setMessage(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5 %s\u3002", (String)"TripSyncOpenApi_01", (String)"fi-er-business", (Object[])new Object[0]), this.method));
                    break;
                }
            }
        }
        catch (Exception e) {
            String detail = ErExceptionServiceHelper.getStackTrace(e);
            logger.info("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u4fe1\u606f\u63a8\u9001\u540c\u6b65\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:" + detail);
            throw e;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u5546\u65c5\u4fe1\u606f\u63a8\u9001\u540c\u6b65,\u8fd4\u56de\u7ed3\u679c:" + JSON.toJSONString((Object)result));
        return result;
    }

    private ApiResult verifyRequiredKey(Map<String, Object> data) {
        String serviceSign = "service";
        Object service = data.get(serviceSign);
        if (service == null || StringUtils.isEmpty((CharSequence)String.valueOf(service))) {
            return this.getVerifyResult(serviceSign);
        }
        String methodSign = "method";
        Object method = data.get(methodSign);
        if (method == null || StringUtils.isEmpty((CharSequence)String.valueOf(method))) {
            return this.getVerifyResult(methodSign);
        }
        String dataSign = "data";
        Object ob = data.get(dataSign);
        if (ob == null || StringUtils.isEmpty((CharSequence)String.valueOf(ob))) {
            return this.getVerifyResult(dataSign);
        }
        this.method = (String)method;
        return null;
    }

    private ApiResult getVerifyResult(String requiredKey) {
        ApiResult result = new ApiResult();
        result.setSuccess(false);
        result.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u7f3a\u5c11\u5fc5\u586b\u9879:%s", (String)"TripSyncOpenApi_0", (String)"fi-er-business", (Object[])new Object[0]), requiredKey));
        return result;
    }
}

