/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.factory;

import java.lang.reflect.Method;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.ctrip.CTripService;
import kd.fi.er.business.trip.supplier.didi.DiDiTripService;
import kd.fi.er.business.trip.supplier.meituan.MeiTuanTripService;
import kd.fi.er.business.trip.supplier.travelno1.TTripService;
import kd.fi.er.business.trip.supplier.zte.ETripService;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class TripServiceFactory {
    private static final Log logger = LogFactory.getLog(TripServiceFactory.class);

    public static ITripService getTripService(String tripFlag) {
        if (StringUtils.isBlank((String)tripFlag) || null == tripFlag) {
            logger.error(String.format("\u5546\u65c5\u96c6\u6210,\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a:[%s] ", tripFlag));
            return null;
        }
        String tripClass = TripServiceFactory.getTripClassByFlag(tripFlag);
        logger.info("\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u7684\u5bf9\u5e94\u670d\u52a1\u7c7b, key: {}, value : {}", (Object)tripFlag, (Object)tripClass);
        switch (tripFlag) {
            case "CTripService": {
                return CTripService.getInstance();
            }
            case "ETripService": {
                return ETripService.getInstance();
            }
            case "TTripService": {
                return TTripService.getInstance();
            }
            case "DiDiTripService": {
                return DiDiTripService.getInstance();
            }
            case "MeiTuanTripService": {
                return MeiTuanTripService.getInstance();
            }
        }
        try {
            Class<?> o = Class.forName(tripClass);
            Method getInstance = o.getDeclaredMethod("getInstance", new Class[0]);
            return (ITripService)getInstance.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error(String.format("\u5546\u65c5\u96c6\u6210,\u5f53\u524d\u670d\u52a1\u5546:[%s] \u5b9e\u4f8b\u5316\u5904\u7406\u7c7b\u5931\u8d25:%s,\u8bf7\u68c0\u67e5\u5904\u7406\u7c7b\u662f\u5426\u5df2\u90e8\u7f72\u5230\u73af\u5883\u4e2d\u6216\u5904\u7406\u7c7b\u662f\u5426\u5b58\u5728\u65e0\u53c2\u6784\u9020\u5668!", tripFlag, e));
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u5904\u7406\u7c7b\u4e0d\u5b58\u5728\u6216\u5904\u7406\u7c7b\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u5668,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5e76\u91cd\u65b0\u90e8\u7f72\u5904\u7406\u7c7b\u3002", (String)"TripServiceFactory_3", (String)"fi-er-business", (Object[])new Object[0]));
        }
    }

    private static String getTripClassByFlag(String tripFlag) {
        if (StringUtils.isEmpty((String)tripFlag)) {
            return null;
        }
        String tripClass = TripCommonUtil.getStandtripsrevice().get(tripFlag);
        if (StringUtils.isEmpty((String)tripClass)) {
            tripClass = tripFlag;
        }
        return tripClass;
    }
}

