/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCityInvoke
extends InPutFunctionTemp<JSONObject> {
    private static final Log logger = LogFactory.getLog(AbstractCityInvoke.class);
    private int capacity = 4;
    private long timeStamp = System.currentTimeMillis();

    @Override
    protected JSONObject process(Map<String, ?> params) {
        JSONObject postJson = new JSONObject();
        postJson.put("Auth", (Object)CorpSync.getAuthentification());
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u83b7\u53d6\u56fd\u5bb6,\u63a5\u53e3\u4e0a\u9001\u6570\u636e:" + postJson.toJSONString());
        this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/switchAPI/basedata/v2/getcountry");
        this.tripSyncLogParam.setRequestdata(postJson);
        String result = HttpRetryServiceHelper.PostData("https://ct.ctrip.com/switchAPI/basedata/v2/getcountry", postJson.toJSONString());
        String flag = params.get("all").toString();
        HashMap countryIdAndNameMap = Maps.newHashMapWithExpectedSize((int)16);
        List<Integer> countryIdList = this.dealCountryJson(JSONObject.parseObject((String)result), flag, countryIdAndNameMap);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", this.queryCountryCityInfoNew(postJson, countryIdList, countryIdAndNameMap));
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JSONObject> queryCountryCityInfo(final JSONObject postJson, final List<Integer> countryIdList, final Map<Integer, String> countryIdAndNameMap) {
        if (CollectionUtils.isEmpty(countryIdList)) {
            return new HashMap<String, JSONObject>();
        }
        logger.info("countryIdList{}", countryIdList);
        final HashMap countryCityInfo = Maps.newHashMapWithExpectedSize((int)countryIdList.size());
        int cpus = Runtime.getRuntime().availableProcessors();
        try {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final int tmpCountryIdIndex = countryIdList.size();
            ThreadService.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (int i = 0; i < tmpCountryIdIndex; ++i) {
                            int countryId = (Integer)countryIdList.get(i);
                            long requestStartTime = System.currentTimeMillis();
                            ArrayList logLists = Lists.newArrayListWithCapacity((int)1);
                            JSONObject newPostJson = new JSONObject();
                            newPostJson.putAll((Map)postJson);
                            TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), AbstractCityInvoke.this.supplier(), AbstractCityInvoke.this.function());
                            newPostJson.put("countryId", (Object)countryId);
                            tripSyncLogParam.setRequesturl("https://ct.ctrip.com/switchapi/basedata/v2/queryAllPOIInfo");
                            tripSyncLogParam.setRequestdata(newPostJson);
                            String result = HttpServiceHelper.PostData("https://ct.ctrip.com/switchapi/basedata/v2/queryAllPOIInfo", newPostJson.toJSONString());
                            tripSyncLogParam.setResponsedata(result);
                            JSONObject jsonObject = JSONObject.parseObject((String)result);
                            if (jsonObject == null || !jsonObject.getJSONObject("status").getString("errorCode").equals("20000")) {
                                tripSyncLogParam.setStatus("B");
                                tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u65e5\u5fd7\u96c6\u6210\uff0c\u83b7\u53d6\u643a\u7a0b\u57ce\u5e02\u8fd4\u56de\u6570\u636e\u9519\u8bef\u3002", (String)"AbstractCityInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
                                logLists.add(tripSyncLogParam);
                                continue;
                            }
                            countryCityInfo.put(countryId + "#" + (String)countryIdAndNameMap.get(countryId), jsonObject);
                            logLists.add(tripSyncLogParam);
                            TripSyncLogUtils.saveErrorLog(logLists);
                            long requestEndTime = System.currentTimeMillis();
                            logger.info("request usedtime{}", (Object)(requestEndTime - requestStartTime));
                        }
                    }
                    catch (Exception e) {
                        logger.error("execute request sub thread error", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            }, (TaskType)TaskType.ER_LOWFREQUENCYTASK_TASK, (RequestContext)RequestContext.get());
            countDownLatch.await();
        }
        catch (Exception e) {
            logger.error("execute thread error", (Throwable)e);
        }
        logger.info("convert data size{}", (Object)countryCityInfo.size());
        return countryCityInfo;
    }

    private List<Integer> dealCountryJson(JSONObject countryJson, String flag, Map<Integer, String> countryIdAndNameMap) {
        if (countryJson == null) {
            return new ArrayList<Integer>();
        }
        ArrayList resultList = Lists.newArrayListWithCapacity((int)countryJson.size());
        JSONArray countryList = countryJson.getJSONArray("countryList");
        if (countryList == null) {
            return new ArrayList<Integer>();
        }
        int size = countryList.size();
        if (flag.equals("false")) {
            int chinaCountryId = 0;
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = countryList.getJSONObject(i);
                if (!ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]).equals(jsonObject.get((Object)"name")) && !"china".equalsIgnoreCase(jsonObject.getString("enName"))) continue;
                chinaCountryId = jsonObject.getIntValue("countryId");
                countryIdAndNameMap.put(chinaCountryId, jsonObject.getString("name"));
            }
            resultList.add(chinaCountryId);
        } else if (flag.equals("true")) {
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = countryList.getJSONObject(i);
                int countryId = jsonObject.getIntValue("countryId");
                resultList.add(countryId);
                countryIdAndNameMap.put(countryId, jsonObject.getString("name"));
            }
        }
        return resultList;
    }

    @Override
    protected void saveInfos(Object infos) throws TripException {
        List tripCityDynamicObjectList = (List)infos;
        logger.info("saveInfos{}", (Object)tripCityDynamicObjectList.size());
        TripCityUtil.saveTripCityData(tripCityDynamicObjectList);
    }

    @Override
    protected Object convert(JSONObject jsonObject) {
        Object data = jsonObject.get((Object)"data");
        if (data == null) {
            logger.info("convert data is null");
            return null;
        }
        Map jsonData = (Map)data;
        logger.info("jsonData keySet {}", jsonData.keySet());
        ArrayList resultDatas = Lists.newArrayListWithCapacity((int)jsonData.size());
        Set entries = jsonData.entrySet();
        for (Map.Entry entry : entries) {
            ArrayList datas = Lists.newArrayListWithCapacity((int)jsonData.size());
            JSONObject json = (JSONObject)entry.getValue();
            String countryIdAndName = (String)entry.getKey();
            JSONArray dataList = json.getJSONArray("dataList");
            if (dataList == null) continue;
            int size = dataList.size();
            for (int i = 0; i < size; ++i) {
                JSONObject innerJson = dataList.getJSONObject(i);
                JSONArray prefectureLevelCityInfoList = innerJson.getJSONArray("prefectureLevelCityInfoList");
                this.convertDetailJson(prefectureLevelCityInfoList, datas, countryIdAndName);
            }
            logger.info("datas size {}countryid{}", (Object)datas.size(), (Object)countryIdAndName);
            resultDatas.addAll(datas);
        }
        Map<String, List<FourTuple>> grouped = resultDatas.stream().filter(tuple -> {
            String[] split = ((String)tuple.four).split("#");
            return !"1".equals(split[0]);
        }).collect(Collectors.groupingBy(tuple -> (String)tuple.third + (String)tuple.four));
        Set toRemove = grouped.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<FourTuple, Boolean> toRemoveMap = toRemove.stream().collect(Collectors.toMap(t -> t, t -> true));
        Iterator iterator = resultDatas.iterator();
        while (iterator.hasNext()) {
            if (!toRemoveMap.containsKey(iterator.next())) continue;
            iterator.remove();
        }
        logger.info("need match datas size {}", (Object)resultDatas.size());
        return this.cityMatch(resultDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DynamicObject> cityMatch(List<FourTuple<Integer, String, String, String>> datas) {
        final List partitionList = Lists.partition(datas, (int)500);
        String setectProperties = "id,nameen,admindivisionid.country.name,admindivisionid.fullspell,code,cityID,namePinyin,fullcityid";
        DynamicObject[] cityObjMaps = BusinessDataServiceHelper.load((String)"er_city", (String)setectProperties, (QFilter[])new QFilter[0]);
        final List<DynamicObject> allDatas = Collections.synchronizedList(new ArrayList());
        try {
            final HashSet countryFullSpellSet = Sets.newHashSetWithExpectedSize((int)16);
            final HashMap fullSpellAndIndexMap = Maps.newHashMapWithExpectedSize((int)16);
            final HashMap adminNameAndIndexMap = Maps.newHashMapWithExpectedSize((int)16);
            long startTime = System.currentTimeMillis();
            final List<FourTuple<String, String, DynamicObject, String>> needCycleDatas = this.dealRestMatchDatas(cityObjMaps, countryFullSpellSet, fullSpellAndIndexMap, adminNameAndIndexMap);
            long endTime = System.currentTimeMillis();
            int size = partitionList.size();
            logger.info(String.format("dealRestMatchDatas usedtime:%1$s partitionList size %2$s", endTime - startTime, size));
            final CountDownLatch countDownLatch = new CountDownLatch(size);
            RequestContext context = RequestContext.get();
            int i = 0;
            while (i < size) {
                final int finalI = i++;
                ThreadService.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            List fourTuples = (List)partitionList.get(finalI);
                            List dynamicObjects = AbstractCityInvoke.this.finalCityMatch(fourTuples, needCycleDatas, fullSpellAndIndexMap, countryFullSpellSet, adminNameAndIndexMap);
                            if (allDatas != null && CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                                allDatas.addAll(dynamicObjects);
                            }
                            long endTime = System.currentTimeMillis();
                            logger.info("currentThread{} usedtime{}", (Object)Thread.currentThread().getName(), (Object)(endTime - startTime));
                        }
                        catch (Exception e) {
                            logger.error("execute match sub thread error", (Throwable)e);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }, (TaskType)TaskType.ER_LOWFREQUENCYTASK_TASK, (RequestContext)context);
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            logger.error("Line 274 cityMatch error", (Throwable)e);
        }
        logger.info("need update datas{}", (Object)allDatas.size());
        return allDatas;
    }

    private List<DynamicObject> finalCityMatch(List<FourTuple<Integer, String, String, String>> fourTuples, List<FourTuple<String, String, DynamicObject, String>> needCycleDatas, Map<String, List<Integer>> fullSpellAndIndexMap, HashSet<String> countryFullSpellSet, Map<String, List<Integer>> adminNameAndIndexMap) {
        ArrayList<DynamicObject> cityDynamicObjectList = new ArrayList<DynamicObject>();
        try {
            int size = fourTuples.size();
            int paramValue = TripSyncConfigUtil.getIntValue("trip_cityid_update", 0, Arrays.asList(1, 0));
            for (int i = 0; i < size; ++i) {
                FourTuple<Integer, String, String, String> fourTuple = fourTuples.get(i);
                String countryIdAndCountryName = (String)fourTuple.four;
                String[] split = countryIdAndCountryName.split("#");
                String countryIdStr = split[0];
                String countryName = split[1];
                int countryId = Integer.parseInt(countryIdStr);
                if (countryId == 1) {
                    this.matchChinaCityData(fourTuple, needCycleDatas, adminNameAndIndexMap, countryName, cityDynamicObjectList, paramValue);
                    continue;
                }
                String cityEnName = (String)fourTuple.third;
                String cityEnNameLowerCase = cityEnName.toLowerCase();
                if (!countryFullSpellSet.contains(cityEnNameLowerCase) || !fullSpellAndIndexMap.containsKey(cityEnNameLowerCase)) continue;
                this.matchOtherCountryCityData(fourTuple, needCycleDatas, fullSpellAndIndexMap, countryName, cityDynamicObjectList, paramValue);
            }
        }
        catch (Exception e) {
            logger.error("cityMatch error", (Throwable)e);
        }
        logger.info("need add data {}", (Object)cityDynamicObjectList.size());
        return cityDynamicObjectList;
    }

    private void matchOtherCountryCityData(FourTuple<Integer, String, String, String> fourTuple, List<FourTuple<String, String, DynamicObject, String>> needCycleDatas, Map<String, List<Integer>> fullSpellAndIndexMap, String countryName, List<DynamicObject> cityDynamicObjectList, int paramValue) {
        Integer cityId = (Integer)fourTuple.first;
        String cityEnName = (String)fourTuple.third;
        String cityEnNameLowerCase = cityEnName.toLowerCase();
        List<Integer> matchDataIndex = fullSpellAndIndexMap.get(cityEnNameLowerCase);
        this.setValue(needCycleDatas, countryName, cityDynamicObjectList, cityId, matchDataIndex, paramValue);
    }

    private void matchChinaCityData(FourTuple<Integer, String, String, String> fourTuple, List<FourTuple<String, String, DynamicObject, String>> needCycleDatas, Map<String, List<Integer>> adminNameAndIndexMap, String countryName, List<DynamicObject> cityDynamicObjectList, int paramValue) {
        String name = (String)fourTuple.second;
        if (!adminNameAndIndexMap.containsKey(name = TripCityUtil.judgeCityName(name))) {
            return;
        }
        Integer cityId = (Integer)fourTuple.first;
        List<Integer> matchDataIndex = adminNameAndIndexMap.get(name);
        this.setValue(needCycleDatas, countryName, cityDynamicObjectList, cityId, matchDataIndex, paramValue);
    }

    private void setValue(List<FourTuple<String, String, DynamicObject, String>> needCycleDatas, String countryName, List<DynamicObject> cityDynamicObjectList, Integer cityId, List<Integer> matchDataIndex, int paramValue) {
        int indexSize = matchDataIndex.size();
        for (int index = 0; index < indexSize; ++index) {
            FourTuple<String, String, DynamicObject, String> matchData = needCycleDatas.get(matchDataIndex.get(index));
            String tmpCountryName = (String)matchData.four;
            if (!countryName.equals(tmpCountryName)) continue;
            DynamicObject third = (DynamicObject)matchData.third;
            String cityid = third.getString("fullcityid");
            if (StringUtils.isNotBlank((CharSequence)cityid) && 0 == paramValue) {
                third.set("fullcityid", (Object)cityId);
            }
            if ("0".equals(cityid)) {
                third.set("fullcityid", (Object)cityId);
            }
            cityDynamicObjectList.add(third);
        }
    }

    private List<FourTuple<String, String, DynamicObject, String>> dealRestMatchDatas(DynamicObject[] tmpCityObjMaps, HashSet<String> countryFullSpellSet, Map<String, List<Integer>> fullSpellAndIndexMap, Map<String, List<Integer>> adminNameAndIndexMap) {
        ArrayList needCycleData = Lists.newArrayListWithCapacity((int)16);
        fullSpellAndIndexMap.clear();
        countryFullSpellSet.clear();
        adminNameAndIndexMap.clear();
        HashSet tmpSet = Sets.newHashSetWithExpectedSize((int)tmpCityObjMaps.length);
        Collections.addAll(tmpSet, tmpCityObjMaps);
        Iterator iterator = tmpSet.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            List<Object> dataIndexs;
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            String adminName = dynamicObject.getString("admindivisionid.name");
            String fullspell = dynamicObject.getString("admindivisionid.fullspell").replaceAll(" City", "").replaceAll(" city", "").replaceAll(" Area", "").replaceAll(" area", "").replaceAll(" County", "").replaceAll(" county", "").replaceAll(" District", "").replaceAll(" district", "");
            String countryName = dynamicObject.getString("admindivisionid.country.name");
            String fullSpellLowerCase = fullspell.toLowerCase();
            countryFullSpellSet.add(fullSpellLowerCase);
            if (countryName.startsWith(ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]))) {
                if (adminName != null) {
                    adminName = TripCityUtil.judgeCityName(adminName);
                }
                if (adminNameAndIndexMap.containsKey(adminName)) {
                    List<Integer> dataIndex = adminNameAndIndexMap.get(adminName);
                    dataIndex.add(index++);
                } else {
                    dataIndexs = Lists.newArrayListWithCapacity((int)16);
                    dataIndexs.add(index++);
                    adminNameAndIndexMap.put(adminName, dataIndexs);
                }
            } else if (fullSpellAndIndexMap.containsKey(fullSpellLowerCase)) {
                dataIndexs = fullSpellAndIndexMap.get(fullSpellLowerCase);
                dataIndexs.add(index++);
            } else {
                dataIndexs = Lists.newArrayListWithCapacity((int)16);
                dataIndexs.add(index++);
                fullSpellAndIndexMap.put(fullSpellLowerCase, dataIndexs);
            }
            if (countryName.startsWith(ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]))) {
                countryName = countryName.replaceAll(countryName, ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            FourTuple<String, String, DynamicObject, String> fourTuple = new FourTuple<String, String, DynamicObject, String>(adminName, fullspell, dynamicObject, countryName);
            needCycleData.add(fourTuple);
        }
        return needCycleData;
    }

    private void convertDetailJson(JSONArray prefectureLevelCityInfoList, List<FourTuple<Integer, String, String, String>> datas, String countryIdAndName) {
        int size = prefectureLevelCityInfoList.size();
        String[] split = countryIdAndName.split("#");
        String countryId = split[0];
        String countryName = split[1];
        for (int i = 0; i < size; ++i) {
            JSONArray countyList;
            JSONObject jsonObject = prefectureLevelCityInfoList.getJSONObject(i);
            datas.add(new FourTuple<Integer, String, String, String>(jsonObject.getIntValue("cityId"), jsonObject.getString("cityName"), jsonObject.getString("cityEnName"), countryIdAndName));
            if ("1".equals(countryId) && ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]).equals(countryName) || (countyList = jsonObject.getJSONArray("countyList")) == null) continue;
            int countySize = countyList.size();
            for (int j = 0; j < countySize; ++j) {
                JSONObject county = countyList.getJSONObject(j);
                datas.add(new FourTuple<Integer, String, String, String>(county.getIntValue("countyId"), county.getString("countyName"), county.getString("countyEnName"), countryIdAndName));
            }
        }
    }

    private synchronized DynamicObject[] removeArrEle(DynamicObject[] cityObjMaps, List<DynamicObject> delEle) {
        LinkedList<DynamicObject> linkedList = new LinkedList<DynamicObject>(Arrays.asList(cityObjMaps));
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(delEle);
        linkedList.removeIf(set::contains);
        cityObjMaps = linkedList.toArray(new DynamicObject[0]);
        return cityObjMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, JSONObject> queryCountryCityInfoNew(final JSONObject postJson, List<Integer> countryIdList, final Map<Integer, String> countryIdAndNameMap) {
        if (CollectionUtils.isEmpty(countryIdList)) {
            return new HashMap<String, JSONObject>();
        }
        final HashMap countryCityInfo = Maps.newHashMapWithExpectedSize((int)countryIdList.size());
        final List partition = Lists.partition(countryIdList, (int)3);
        int size = partition.size();
        try {
            final CountDownLatch countDownLatch = new CountDownLatch(size);
            final ArrayList interuptList = Lists.newArrayListWithCapacity((int)16);
            int j = 0;
            while (j < size) {
                final int finalI = j++;
                ThreadService.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List tmpCountryId = (List)partition.get(finalI);
                        int tmpCountryIdIndex = tmpCountryId.size();
                        try {
                            while (!AbstractCityInvoke.this.getToken()) {
                            }
                            AbstractCityInvoke.this.batchPostRequest(tmpCountryIdIndex, tmpCountryId, postJson, countryCityInfo, countryIdAndNameMap);
                        }
                        catch (Exception e) {
                            interuptList.add(tmpCountryId);
                            logger.error("new sub thread error", (Throwable)e);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
            }
            countDownLatch.await();
            if (CollectionUtils.isNotEmpty((Collection)interuptList)) {
                CountDownLatch tmpCountDownLatch = new CountDownLatch(1);
                int errorSize = interuptList.size();
                logger.info("loss size{}", (Object)errorSize);
                ThreadService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                tmpCountDownLatch.await();
            }
        }
        catch (Exception e) {
            logger.error("new thread error", (Throwable)e);
        }
        logger.info("new convert data size{}", (Object)countryCityInfo.size());
        return countryCityInfo;
    }

    public synchronized boolean getToken() {
        if (this.capacity > 0) {
            --this.capacity;
            return true;
        }
        long current = System.currentTimeMillis();
        if (current - this.timeStamp >= 2000L) {
            if ((current - this.timeStamp) / 1000L >= 2L) {
                this.capacity += (int)((current - this.timeStamp) / 1000L) - 1;
            }
            this.timeStamp = current;
            if (this.capacity > 4) {
                this.capacity = 4;
            }
            return true;
        }
        return false;
    }

    private void batchPostRequest(int tmpCountryIdIndex, List<Integer> countryIdList, JSONObject postJson, Map<String, JSONObject> countryCityInfo, Map<Integer, String> countryIdAndNameMap) {
        for (int i = 0; i < tmpCountryIdIndex; ++i) {
            int countryId = countryIdList.get(i);
            long requestStartTime = System.currentTimeMillis();
            ArrayList logLists = Lists.newArrayListWithCapacity((int)1);
            JSONObject newPostJson = new JSONObject();
            newPostJson.putAll((Map)postJson);
            TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
            newPostJson.put("countryId", (Object)countryId);
            String countryName = countryIdAndNameMap.get(countryId);
            tripSyncLogParam.setRequesturl("https://ct.ctrip.com/switchapi/basedata/v2/queryAllPOIInfo");
            tripSyncLogParam.setRequestdata(newPostJson);
            tripSyncLogParam.setBillno(countryName);
            String result = HttpServiceHelper.PostData("https://ct.ctrip.com/switchapi/basedata/v2/queryAllPOIInfo", newPostJson.toJSONString());
            tripSyncLogParam.setResponsedata(result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject == null || !jsonObject.getJSONObject("status").getString("errorCode").equals("20000")) {
                tripSyncLogParam.setStatus("B");
                tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u65e5\u5fd7\u96c6\u6210\uff0c\u83b7\u53d6\u643a\u7a0b\u57ce\u5e02\u8fd4\u56de\u6570\u636e\u9519\u8bef\u3002", (String)"AbstractCityInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
                logLists.add(tripSyncLogParam);
                TripSyncLogUtils.saveErrorLog(logLists);
                continue;
            }
            countryCityInfo.put(countryId + "#" + countryName, jsonObject);
            logLists.add(tripSyncLogParam);
            TripSyncLogUtils.saveErrorLog(logLists);
            long requestEndTime = System.currentTimeMillis();
            logger.info("request usedtime{}", (Object)(requestEndTime - requestStartTime));
        }
    }

    static class FourTuple<A, B, C, D> {
        public final A first;
        public final B second;
        public final C third;
        public final D four;

        public FourTuple(A a, B b, C c, D d) {
            this.first = a;
            this.second = b;
            this.third = c;
            this.four = d;
        }
    }
}

