/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.UserModel;
import kd.fi.er.business.trip.service.DataServiceHelper;
import kd.fi.er.business.trip.service.function.template.OutPutFunctionTemp;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.SyncUserTypeEnum;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.UserHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractUserInvoke<T>
extends OutPutFunctionTemp {
    private static Log logger = LogFactory.getLog(AbstractUserInvoke.class);
    protected DynamicObject bizInfoObject = null;
    protected String lastSyncPeopleTamp;
    private Integer pageSize = 1000;
    private static ThreadLocal<List<TripSyncLogParam>> logListThreadLocal = new ThreadLocal<List<TripSyncLogParam>>(){

        @Override
        protected List<TripSyncLogParam> initialValue() {
            return new ArrayList<TripSyncLogParam>(10);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Object ... objects) {
        boolean success = true;
        HashMap<String, Object> map = null;
        if (objects != null && objects.length > 0) {
            map = (HashMap<String, Object>)objects[0];
        }
        boolean beforeSaveLog = false;
        this.tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        String lockKey = TripCommonUtil.getUserSyncLockKey(this.supplier());
        if (map != null && map.containsKey("userList")) {
            lockKey = lockKey + RequestContext.get().getCurrUserId();
        }
        try (DLock dLock = DLock.create((String)lockKey);){
            DynamicObject bizInfo;
            block45: {
                if (!dLock.tryLock()) {
                    this.tripSyncLogParam.setStatus("B");
                    this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u5546\u65c5\u7528\u6237\u540c\u6b65\u9501\u5931\u8d25\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u5176\u4ed6\u540c\u6b65\u4efb\u52a1\u7ed3\u675f\u540e\u91cd\u8bd5\u3002", (String)"AbstractUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
                    String string = "300";
                    return string;
                }
                this.bizInfoObject = bizInfo = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncpeopletamp,syncusertype, entryentity.org, entryentity.lastsyncstamp,entryentity.entrystatus", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
                String stamp = bizInfo.getString("lastsyncpeopletamp");
                String syncusertype = bizInfo.getString("syncusertype");
                if ("2".equals(syncusertype)) {
                    List<Map<Long, Date>> orgList = this.getOrgLastSyncDateList(bizInfo);
                    if (map == null) {
                        map = new HashMap<String, Object>(2);
                    }
                    if (!map.containsKey("userList")) {
                        map.putIfAbsent("orgList", orgList);
                    }
                }
                if (this.supplier().equals(Supplier.CHAILVYIHAO.name()) || this.supplier().equals(Supplier.XIECHENG.name())) {
                    if (null == map) {
                        map = new HashMap(2);
                        map.put("updatetime", true);
                    }
                    map.put("deleteflag", false);
                }
                this.lastSyncPeopleTamp = stamp;
                this.tripSyncLogParamList = new LinkedList();
                if (this.syncUserByPage()) {
                    Date date = bizInfo.getDate("lastsyncpeopletamp");
                    int i = 1;
                    Long time = System.currentTimeMillis();
                    while (true) {
                        Object data;
                        TripSyncLogParam param;
                        block46: {
                            param = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
                            data = null;
                            try {
                                data = this.getInnerData(stamp, i, this.pageSize, map);
                                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u540c\u6b65\u5230\u7b2c{}\u9875\uff0c\u603b\u8017\u65f6 : {}", (Object)i, (Object)(System.currentTimeMillis() - time));
                                if (data == null) break block45;
                                if (data instanceof Set && ((Set)data).size() == 0) {
                                }
                                break block46;
                            }
                            catch (Exception exception) {
                                success = false;
                                logger.error("\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u540c\u6b65:", (Throwable)exception);
                                param.setRequestdata(data);
                                this.tripSyncLogParam.setRequestdata(data);
                                this.tripSyncLogParam.setMessage(exception);
                                this.tripSyncLogParam.setStatus("B");
                                param.setStatus("B");
                                param.setBillno(this.tripSyncLogParam.getBillno());
                                param.setMessage(exception);
                                logListThreadLocal.get().add(param);
                            }
                            break block45;
                        }
                        try {
                            data = this.convert(data);
                            String code = this.batPushProcess(data);
                            if (!"200".equals(code)) {
                                success = false;
                            }
                        }
                        catch (Exception exception) {
                            success = false;
                            logger.error("\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u540c\u6b65:", (Throwable)exception);
                            param.setRequestdata(data);
                            this.tripSyncLogParam.setRequestdata(data);
                            this.tripSyncLogParam.setMessage(exception);
                            this.tripSyncLogParam.setStatus("B");
                            param.setBillno(this.tripSyncLogParam.getBillno());
                            param.setStatus("B");
                            param.setMessage(exception);
                            logListThreadLocal.get().add(param);
                        }
                        finally {
                            ++i;
                        }
                        if (!beforeSaveLog && CollectionUtils.isNotEmpty((Collection)logListThreadLocal.get())) {
                            beforeSaveLog = true;
                        }
                        TripSyncLogUtils.saveErrorLog(logListThreadLocal.get());
                        logListThreadLocal.get().clear();
                    }
                }
                beforeSaveLog = true;
                String code = null;
                try {
                    Object innerData = this.getInnerData();
                    Object t = this.convert(innerData);
                    code = this.batPushProcess(t);
                }
                catch (Exception e) {
                    try {
                        this.setErrorMsg(e);
                        logger.error("\u5546\u65c5\u96c6\u6210,\u5931\u8d25:{}", (Object)ThrowableHelper.toString((Exception)e));
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.handleErrorLog(code);
                        throw throwable;
                    }
                }
                this.handleErrorLog(code);
            }
            if (success) {
                this.updateLastsyncPeopleTamp(bizInfo, map);
            }
        }
        finally {
            logListThreadLocal.remove();
            if (!beforeSaveLog && this.tripSyncLogParam.getRealMessage() != null) {
                ArrayList<TripSyncLogParam> list = new ArrayList<TripSyncLogParam>(1);
                list.add(this.tripSyncLogParam);
                TripSyncLogUtils.saveErrorLog(list);
            }
        }
        return success ? "200" : "300";
    }

    private void updateLastsyncPeopleTamp(DynamicObject obj, Map<String, Object> map) {
        Date date = new Date();
        if (map == null || null != map.get("updatetime") && ((Boolean)map.get("updatetime")).booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentTime = sdf.format(date);
            obj.set("lastsyncpeopletamp", (Object)currentTime);
            this.updateLastsyncPeopleTampByOrg(obj, date, null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        } else if (map.get("orgList") != null) {
            this.updateLastsyncPeopleTampByOrg(obj, date, (List)map.get("orgList"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncpeopletamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncPeopleTamp = this.bizInfoObject.getString("lastsyncpeopletamp");
        Set<UserModel> userModelSet = DataServiceHelper.getUsers(this.lastSyncPeopleTamp);
        if (userModelSet != null) {
            userModelSet = userModelSet.stream().filter(e -> StringUtils.isNotBlank((String)e.getEmployeeID())).collect(Collectors.toSet());
        }
        return userModelSet;
    }

    @Override
    protected String function() {
        return "userInvoke";
    }

    protected Integer getUserTotal(Date changeTime, Map<String, Object> map) {
        Integer total = 0;
        SyncUserTypeEnum userTypeEnum = UserHelper.getSyncType(map);
        total = userTypeEnum == SyncUserTypeEnum.SYNC_BY_USER ? UserHelper.getCount(map) : (userTypeEnum == SyncUserTypeEnum.SYNC_BY_ORG ? UserHelper.getCountByTime(changeTime, map) : (TripCommonUtil.isInitTime(changeTime) ? UserHelper.getCount(map) : UserHelper.getCountByTime(changeTime, map)));
        return total % this.pageSize == 0 ? total / this.pageSize : total / this.pageSize + 1;
    }

    protected Object getInnerData(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        if (null == map || null == map.get("deleteflag")) {
            SyncUserTypeEnum userTypeEnum = UserHelper.getSyncType(map);
            if (userTypeEnum == SyncUserTypeEnum.SYNC_BY_USER) {
                return UserDao.getInstance().getChargePeopleTotal(pageIndex, pageSize, map);
            }
            if (userTypeEnum == SyncUserTypeEnum.SYNC_BY_ORG) {
                return UserDao.getInstance().getChargePeople(pageIndex, pageSize, changeTime, map);
            }
            if (TripCommonUtil.isInitTime(TripCommonUtil.convertToDate(changeTime))) {
                return UserDao.getInstance().getChargePeopleTotal(pageIndex, pageSize, map);
            }
            return UserDao.getInstance().getChargePeople(pageIndex, pageSize, changeTime, map);
        }
        return UserDao.getInstance().getChargePeopleNew(pageIndex, pageSize, changeTime, map);
    }

    protected boolean syncUserByPage() {
        return false;
    }

    protected void addTripSyncLogParam(TripSyncLogParam logParam) {
        if (logParam != null) {
            logParam.setTraceid(RequestContext.get().getTraceId());
            logListThreadLocal.get().add(logParam);
        }
    }

    private boolean isDelete(Map<String, Object> map) {
        return UserHelper.getSyncType(map) == SyncUserTypeEnum.SYNC_BY_INCREMENT;
    }

    private void updateLastsyncPeopleTampByOrg(DynamicObject bizInfo, Date date, List<Map<Long, Date>> orgList) {
        DynamicObjectCollection collection = bizInfo.getDynamicObjectCollection("entryentity");
        if (orgList == null && collection != null) {
            collection.stream().forEach(e -> e.set("lastsyncstamp", (Object)date));
        } else if (collection != null && orgList != null) {
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            for (Map<Long, Date> map : orgList) {
                orgIds.addAll(map.keySet());
            }
            collection.stream().filter(e -> orgIds.contains(ErCommonUtils.getPk(e.get("org")))).forEach(e -> e.set("lastsyncstamp", (Object)date));
        }
    }

    private List<Map<Long, Date>> getOrgLastSyncDateList(DynamicObject bizInfo) {
        DynamicObjectCollection collection = bizInfo.getDynamicObjectCollection("entryentity");
        ArrayList<Map<Long, Date>> list = new ArrayList<Map<Long, Date>>();
        for (DynamicObject d : collection) {
            if ("0".equals(d.getString("entrystatus")) || d.get("org") == null) continue;
            HashMap<Long, Date> orgMap = new HashMap<Long, Date>(2);
            orgMap.put(ErCommonUtils.getPk(d.get("org")), d.getDate("lastsyncstamp"));
            list.add(orgMap);
        }
        return list;
    }
}

