/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.validate;

import java.lang.reflect.Field;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.er.business.trip.annotation.KDTripField;

public class Validate {
    public Result result = new Result();

    public Result validate(Object model) {
        this.result = new Result();
        this.HandleAllClassField(model, model.getClass());
        return this.result;
    }

    private void HandleAllClassField(Object model, Class<?> modelClass) {
        Class<?> parentClass = modelClass.getSuperclass();
        if (!"Object".equals(parentClass.getSimpleName()) && !"Object".equals(modelClass.getSimpleName())) {
            this.HandleAllClassField(model, parentClass);
        }
        Field[] fields = modelClass.getDeclaredFields();
        this.handleFieldValue(model, fields);
    }

    private void handleFieldValue(Object model, Field[] fields) {
        Stream.of(fields).forEach(field -> {
            KDTripField fieldAnnotation = field.getAnnotation(KDTripField.class);
            boolean mustInput = false;
            try {
                if (fieldAnnotation != null && (mustInput = fieldAnnotation.mustInput())) {
                    field.setAccessible(true);
                    Object o = field.get(model);
                    if (o == null) {
                        this.result.success = false;
                        this.result.message.append(String.format(ResManager.loadKDString((String)"%s:\u5fc5\u5f55 | ", (String)"Validate_0", (String)"fi-er-business", (Object[])new Object[0]), fieldAnnotation.alias()));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    public class Result {
        public boolean success = true;
        public StringBuilder message = new StringBuilder("| ");
    }
}

