/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.CheckingBillModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.TrainCheckingBillDetailModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.service.function.AbstractCheckingInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripCarCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripHotelCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripPlaneCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripTrainCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.CTripHotelUtil;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang3.math.NumberUtils;

public class CTripCheckingInvoke
extends AbstractCheckingInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(CTripCheckingInvoke.class);
    private static final String SUCCESS = "Success";

    public CTripCheckingInvoke() {
    }

    public CTripCheckingInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    protected Object convert(Object value) throws TripException {
        if (value == null) {
            return null;
        }
        JSONObject t = (JSONObject)value;
        CheckingBillModel billModel = new CheckingBillModel();
        int paramValue = TripSyncConfigUtil.getIntValue("Ctrip_Billing_method", 1);
        ArrayList<CheckingBillModel> checkingBillModelList = new ArrayList<CheckingBillModel>();
        if (paramValue == 1) {
            CheckingBillHeaderModel headerModel = this.buildHeaderModel(t);
            List<AbstractCheckingBillDetailModel> details = this.buildDetailModel(t);
            if (details.size() == 0) {
                return null;
            }
            billModel.setCheckingBillHeaderModel(headerModel);
            billModel.setCheckingBillDetailModels(details);
            checkingBillModelList.add(billModel);
        } else {
            this.buildDataByBatchNo(t, checkingBillModelList, paramValue);
        }
        return checkingBillModelList;
    }

    private List<AbstractCheckingBillDetailModel> buildDetailModel(JSONObject checkingBillJson) {
        JSONArray detailCheckingBill = checkingBillJson.getJSONArray("data");
        if (null == detailCheckingBill) {
            return new ArrayList<AbstractCheckingBillDetailModel>(0);
        }
        ArrayList<AbstractCheckingBillDetailModel> details = new ArrayList<AbstractCheckingBillDetailModel>(detailCheckingBill.size());
        String businessType = checkingBillJson.getOrDefault((Object)"businessType", (Object)"").toString();
        this.finalBuildDetailModel(detailCheckingBill, businessType, details);
        return details;
    }

    private void finalBuildDetailModel(JSONArray detailCheckingBill, String businessType, List<AbstractCheckingBillDetailModel> details) {
        switch (businessType) {
            case "HOTEL": {
                ArrayList hotelDetails = Lists.newArrayListWithCapacity((int)detailCheckingBill.size());
                try {
                    boolean paramValue = TripSyncConfigUtil.getBoolean("Split_hotel_settlement");
                    if (!paramValue) {
                        CTripHotelUtil.handleHotelJson(detailCheckingBill);
                    }
                    for (int hotelIndex = 0; hotelIndex < detailCheckingBill.size(); ++hotelIndex) {
                        JSONObject settlementInfoDetailObject;
                        List<HotelCheckingBillDetailModel> datas;
                        if (null == detailCheckingBill.get(hotelIndex) || CollectionUtils.isEmpty(datas = CTripHotelCheckingDetailConvert.convert(settlementInfoDetailObject = (JSONObject)detailCheckingBill.get(hotelIndex)))) continue;
                        hotelDetails.addAll(datas);
                        for (HotelCheckingBillDetailModel data : datas) {
                            this.handleHotelCheckingExtCovert(data, settlementInfoDetailObject);
                        }
                    }
                    details.addAll(this.handleRepeatHotelTicketNo(hotelDetails));
                    break;
                }
                catch (CloneNotSupportedException e1) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7ed3\u7b97\u5355,HotelCheckingDetailConvert_error:", (Throwable)e1);
                    throw new RuntimeException(e1);
                }
            }
            case "PLANE": {
                try {
                    List<PlaneCheckingBillDetailModel> planedetails = new ArrayList<PlaneCheckingBillDetailModel>(detailCheckingBill.size());
                    for (int planeIndex = 0; planeIndex < detailCheckingBill.size(); ++planeIndex) {
                        JSONObject settlementInfoDetailObject;
                        List<PlaneCheckingBillDetailModel> datas;
                        if (null == detailCheckingBill.get(planeIndex) || null == (datas = CTripPlaneCheckingDetailConvert.convert(settlementInfoDetailObject = (JSONObject)detailCheckingBill.get(planeIndex))) || datas.isEmpty()) continue;
                        planedetails.addAll(datas);
                        for (PlaneCheckingBillDetailModel data : datas) {
                            this.handlePlaneCheckingExtCovert(data, settlementInfoDetailObject);
                        }
                    }
                    planedetails = CTripCheckingInvoke.handleRepeatTicketNo(planedetails);
                    details.addAll(planedetails);
                    break;
                }
                catch (CloneNotSupportedException e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7ed3\u7b97\u5355,PlaneCheckingDetailConvert_error:", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            case "CAR": {
                ArrayList vehicleDetails = Lists.newArrayListWithCapacity((int)detailCheckingBill.size());
                for (int carIndex = 0; carIndex < detailCheckingBill.size(); ++carIndex) {
                    JSONObject settlementInfoDetailObject;
                    List<VehicleCheckingBillDetailModel> datas;
                    if (null == detailCheckingBill.get(carIndex) || null == (datas = CTripCarCheckingDetailConvert.convert(settlementInfoDetailObject = (JSONObject)detailCheckingBill.get(carIndex))) || datas.isEmpty()) continue;
                    vehicleDetails.addAll(datas);
                    for (VehicleCheckingBillDetailModel data : datas) {
                        this.handleCarCheckingExtCovert(data, settlementInfoDetailObject);
                    }
                }
                details.addAll(this.handleRepeatVehicleTicketNo(vehicleDetails));
                break;
            }
            case "TRAIN": {
                ArrayList trainDetails = Lists.newArrayListWithCapacity((int)detailCheckingBill.size());
                for (int trainIndex = 0; trainIndex < detailCheckingBill.size(); ++trainIndex) {
                    JSONObject settlementInfoDetailObject;
                    List<TrainCheckingBillDetailModel> datas;
                    if (null == detailCheckingBill.get(trainIndex) || null == (datas = CTripTrainCheckingDetailConvert.convert(settlementInfoDetailObject = (JSONObject)detailCheckingBill.get(trainIndex))) || datas.isEmpty()) continue;
                    trainDetails.addAll(datas);
                    for (TrainCheckingBillDetailModel data : datas) {
                        this.handleTrainCheckingExtCovert(data, settlementInfoDetailObject);
                    }
                }
                details.addAll(this.handleRepeatTrainTicketNo(trainDetails));
            }
        }
    }

    private static List<PlaneCheckingBillDetailModel> handleRepeatTicketNo(List<PlaneCheckingBillDetailModel> details) {
        ArrayListMultimap mapS2 = ArrayListMultimap.create();
        ArrayList<PlaneCheckingBillDetailModel> newDetails = new ArrayList<PlaneCheckingBillDetailModel>(details.size());
        CTripCheckingInvoke.splitOrderByBatchno(details);
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripCheckingInvoke.lambda$handleRepeatTicketNo$0((Multimap)mapS2, arg_0));
        for (PlaneCheckingBillDetailModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS2.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS2.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().map(e -> e.getTotalAmount() == null ? BigDecimal.ZERO : e.getTotalAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setAirportPrice(list.stream().map(e -> e.getAirportPrice() == null ? BigDecimal.ZERO : e.getAirportPrice()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setFuelPrice(list.stream().map(e -> e.getFuelPrice() == null ? BigDecimal.ZERO : e.getFuelPrice()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setRefundAmount(list.stream().map(e -> e.getRefundAmount() == null ? BigDecimal.ZERO : e.getRefundAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setAssuranceAmount(list.stream().map(e -> e.getAssuranceAmount() == null ? BigDecimal.ZERO : e.getAssuranceAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().map(e -> e.getServiceFee() == null ? BigDecimal.ZERO : e.getServiceFee()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setOtherAmount(list.stream().map(e -> e.getOtherAmount() == null ? BigDecimal.ZERO : e.getOtherAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setTicketPrice(list.stream().map(e -> e.getTicketPrice() == null ? BigDecimal.ZERO : e.getTicketPrice()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setEndorsementAmount(list.stream().map(e -> e.getEndorsementAmount() == null ? BigDecimal.ZERO : e.getEndorsementAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private CheckingBillHeaderModel buildHeaderModel(JSONObject checkingBillJson) {
        CheckingBillHeaderModel headerModel = new CheckingBillHeaderModel();
        JSONArray CheckingBillArray = checkingBillJson.getJSONArray("data");
        if (null == CheckingBillArray) {
            CheckingBillArray = new JSONArray();
        }
        String businessType = checkingBillJson.getOrDefault((Object)"businessType", (Object)"").toString();
        BigDecimal totalAmount = BigDecimal.ZERO;
        totalAmount = this.getTotalAmount(CheckingBillArray, businessType, totalAmount);
        headerModel.setBillNo(businessType + TripCommonUtil.getLastMonthFirstDay());
        headerModel.setSettlementAmount(totalAmount);
        headerModel.setBillstatusname("1");
        headerModel.setPeriodStartDate(TripCommonUtil.strToDate(TripCommonUtil.getLastMonthFirstDay(), "yyyy-MM-dd"));
        headerModel.setPeriodEndDate(TripCommonUtil.strToDate(TripCommonUtil.getLastMonthLastDay(), "yyyy-MM-dd"));
        headerModel.setServer(Supplier.XIECHENG.name());
        return headerModel;
    }

    private BigDecimal getTotalAmount(JSONArray CheckingBillArray, String businessType, BigDecimal totalAmount) {
        switch (businessType) {
            case "HOTEL": {
                for (int i = 0; i < CheckingBillArray.size(); ++i) {
                    JSONObject settlementDetailObject;
                    JSONObject settlementInfoDetailObject = CheckingBillArray.getJSONObject(i);
                    if (null == settlementInfoDetailObject || null == (settlementDetailObject = settlementInfoDetailObject.getJSONObject("SettlementDetail"))) continue;
                    BigDecimal amount = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("Amount"));
                    BigDecimal servicefee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("Servicefee"));
                    BigDecimal extraCharge = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("ExtraCharge"));
                    amount = null != settlementDetailObject && "Y".equals(settlementDetailObject.getOrDefault((Object)"PayType", (Object)"")) ? amount.add(servicefee).add(extraCharge) : servicefee;
                    totalAmount = totalAmount.add(amount);
                }
                break;
            }
            case "PLANE": {
                for (int i = 0; i < CheckingBillArray.size(); ++i) {
                    JSONObject settlementInfoDetailObject = CheckingBillArray.getJSONObject(i);
                    if (null == settlementInfoDetailObject) continue;
                    JSONObject orderSettlementBaseInfo = settlementInfoDetailObject.getJSONObject("OrderSettlementBaseInfo");
                    orderSettlementBaseInfo = orderSettlementBaseInfo == null ? new JSONObject() : orderSettlementBaseInfo;
                    BigDecimal amount = TripClassUtil.getDefaultBigDecimal(orderSettlementBaseInfo.getBigDecimal("Amount"));
                    amount = amount.add(TripClassUtil.getDefaultBigDecimal(orderSettlementBaseInfo.getBigDecimal("PostServiceFee")));
                    totalAmount = totalAmount.add(amount);
                }
                break;
            }
            case "CAR": {
                for (int i = 0; i < CheckingBillArray.size(); ++i) {
                    JSONObject settlementInfoDetailObject = CheckingBillArray.getJSONObject(i);
                    if (null == settlementInfoDetailObject) continue;
                    JSONObject settlementBaseInfo = settlementInfoDetailObject.getJSONObject("SettlementBaseInfo");
                    settlementBaseInfo = settlementBaseInfo == null ? new JSONObject() : settlementBaseInfo;
                    BigDecimal amount = "M".equals(settlementBaseInfo.getOrDefault((Object)"SelType", (Object)"M").toString()) ? TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("RealAmountHasPost")) : TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PostServiceFee"));
                    totalAmount = totalAmount.add(amount);
                }
                break;
            }
            case "TRAIN": {
                for (int i = 0; i < CheckingBillArray.size(); ++i) {
                    JSONObject settlementInfoDetailObject = CheckingBillArray.getJSONObject(i);
                    if (null == settlementInfoDetailObject) continue;
                    JSONObject trainSettlementDetailInfo = settlementInfoDetailObject.getJSONObject("TrainSettlementDetail");
                    trainSettlementDetailInfo = trainSettlementDetailInfo == null ? new JSONObject() : trainSettlementDetailInfo;
                    BigDecimal amount = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("RealAmountHasPost"));
                    totalAmount = totalAmount.add(amount);
                }
                break;
            }
        }
        return totalAmount;
    }

    protected JSONObject process(Map params) throws TripException {
        JSONObject dataJsonObject = new JSONObject();
        JSONArray checkingArray = new JSONArray();
        String businessType = (String)params.get("businessType");
        if (params.get("jsondata") != null) {
            boolean isDev = TripSyncConfigUtil.getBoolean("trip_isdev", Boolean.FALSE);
            if (!isDev) {
                ActionLocalCache.get().put("isJsonData", true);
            }
            dataJsonObject = JSONObject.parseObject((String)((String)params.get("jsondata")));
        } else {
            dataJsonObject = this.getCheckingOrder(params, businessType);
        }
        if (dataJsonObject == null) {
            return dataJsonObject;
        }
        switch (businessType) {
            case "HOTEL": {
                JSONArray hotelsettlementArray = dataJsonObject.getJSONArray("LstHtlSettlement");
                if (hotelsettlementArray == null) break;
                for (int i = 0; i < hotelsettlementArray.size(); ++i) {
                    JSONObject hotelsettlementObjects = hotelsettlementArray.getJSONObject(i);
                    if (null == hotelsettlementObjects) continue;
                    JSONArray hotelSettlementDetail = hotelsettlementObjects.getJSONArray("LstHotelSettlementDetail") == null ? new JSONArray() : hotelsettlementObjects.getJSONArray("LstHotelSettlementDetail");
                    JSONObject hotelSettlementObject = new JSONObject();
                    for (int j = 0; j < hotelSettlementDetail.size(); ++j) {
                        hotelSettlementObject = hotelSettlementDetail.getJSONObject(j);
                        if (null == hotelSettlementObject) continue;
                        checkingArray.add((Object)hotelSettlementObject);
                    }
                }
                break;
            }
            case "PLANE": {
                JSONArray planesettlementArray = dataJsonObject.getJSONArray("FlightOrderAccountSettlementList");
                if (planesettlementArray == null) break;
                for (int i = 0; i < planesettlementArray.size(); ++i) {
                    JSONObject planeSettlementObjects = planesettlementArray.getJSONObject(i);
                    if (null == planeSettlementObjects) continue;
                    JSONArray planeSettlementDetail = planeSettlementObjects.getJSONArray("OrderSettlementList");
                    planeSettlementDetail = planeSettlementDetail == null ? new JSONArray() : planeSettlementDetail;
                    JSONObject planeSettlementObject = new JSONObject();
                    for (int j = 0; j < planeSettlementDetail.size(); ++j) {
                        planeSettlementObject = planeSettlementDetail.getJSONObject(j);
                        if (null == planeSettlementObject) continue;
                        checkingArray.add((Object)planeSettlementObject);
                    }
                }
                break;
            }
            case "CAR": {
                JSONArray carOrderAccountSettlementList = dataJsonObject.getJSONArray("CarOrderAccountSettlementList");
                if (carOrderAccountSettlementList == null) break;
                for (int i = 0; i < carOrderAccountSettlementList.size(); ++i) {
                    JSONObject carOrderSettlementObjects = carOrderAccountSettlementList.getJSONObject(i);
                    JSONArray carSettlementDetailList = carOrderSettlementObjects.getJSONArray("CarSettlementDetailList");
                    carSettlementDetailList = carSettlementDetailList == null ? new JSONArray() : carSettlementDetailList;
                    for (int j = 0; j < carSettlementDetailList.size(); ++j) {
                        JSONObject carSettlementObject = carSettlementDetailList.getJSONObject(j);
                        if (null == carSettlementObject) continue;
                        checkingArray.add((Object)carSettlementObject);
                    }
                }
                break;
            }
            case "TRAIN": {
                JSONArray trainOrderAccountSettlementList = dataJsonObject.getJSONArray("LstTrainSettlement");
                if (trainOrderAccountSettlementList == null) break;
                for (int i = 0; i < trainOrderAccountSettlementList.size(); ++i) {
                    JSONObject trainOrderSettlementObjects = trainOrderAccountSettlementList.getJSONObject(i);
                    if (null == trainOrderSettlementObjects) continue;
                    JSONArray trainSettlementDetailList = trainOrderSettlementObjects.getJSONArray("LstTrainSettlementDetail");
                    trainSettlementDetailList = trainSettlementDetailList == null ? new JSONArray() : trainSettlementDetailList;
                    for (int j = 0; j < trainSettlementDetailList.size(); ++j) {
                        JSONObject trainSettlementObject = trainSettlementDetailList.getJSONObject(j);
                        if (null == trainSettlementObject) continue;
                        checkingArray.add((Object)trainSettlementObject);
                    }
                }
                break;
            }
        }
        dataJsonObject.put("data", (Object)checkingArray);
        dataJsonObject.put("businessType", (Object)businessType);
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7ed3\u7b97\u5355,\u8fd4\u56de\u7ed3\u679c:" + dataJsonObject.size());
        return dataJsonObject;
    }

    private JSONObject getCheckingOrder(Map<String, String> params, String businessType) {
        JSONObject postJson = new JSONObject();
        boolean isNeedPage = false;
        postJson.put("Auth", (Object)CorpSync.getCacheAuthentification("CTripCheckingInvoke"));
        if (null != params.get("ordernum")) {
            postJson.put("OrderID", (Object)params.get("ordernum"));
            this.tripSyncLogParam.setBillid(params.get("ordernum"));
            this.tripSyncLogParam.setBillno(params.get("ordernum"));
        }
        if (null != params.get("beginDate") && null != params.get("endDate")) {
            String dateFromStr = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), "yyyy-MM-dd");
            String dateToStr = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), "yyyy-MM-dd");
            postJson.put("DateFrom", (Object)dateFromStr);
            postJson.put("DateTo", (Object)dateToStr);
            isNeedPage = true;
        }
        String billId = "";
        if (null != params.get("checkingbillnum") && !params.get("checkingbillnum").isEmpty()) {
            billId = String.valueOf(params.get("checkingbillnum"));
            postJson.put("BatchNo", (Object)params.get("checkingbillnum"));
            this.tripSyncLogParam.setBillid(billId);
            this.tripSyncLogParam.setBillno(billId);
            isNeedPage = true;
        }
        if (null != params.get("BatchNo")) {
            billId = String.valueOf(params.get("BatchNo"));
            postJson.put("BatchNo", (Object)billId);
            this.tripSyncLogParam.setBillid(billId);
            this.tripSyncLogParam.setBillno(billId);
            isNeedPage = true;
        }
        String url = "";
        int scope_settlement_data = TripSyncConfigUtil.getIntValue("scope_settlement_data", 0, Arrays.asList(1, 0));
        switch (businessType) {
            case "HOTEL": {
                url = "https://ct.ctrip.com/switchapi/SettlementHltOrder/SearchSettlementHltOrderDetail";
                if (scope_settlement_data != 0) break;
                postJson.put("PayType", (Object)"Y");
                break;
            }
            case "PLANE": {
                url = "https://ct.ctrip.com/switchapi/FlightOrderSettlement/GetCorpAccountFlightOrderSettlements?type=jso";
                if (scope_settlement_data == 0) {
                    postJson.put("PayType", (Object)"Y");
                    break;
                }
                postJson.put("PayType", (Object)"ALL");
                break;
            }
            case "CAR": {
                url = "https://ct.ctrip.com/switchapi/CarOrderSettlement/SearchSettlementCarOrderDetail";
                if (scope_settlement_data != 0) break;
                postJson.put("SelType", (Object)"M");
                break;
            }
            case "TRAIN": {
                url = "https://ct.ctrip.com/switchapi/SettlementTrainOrder/SearchSettlementTrainOrderDetail";
                if (scope_settlement_data != 0) break;
                postJson.put("SettlementType", (Object)"M");
            }
        }
        int pageIndex = 1;
        if (isNeedPage) {
            postJson.put("PageIndex", (Object)pageIndex);
            postJson.put("PageSize", (Object)500);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("businessType", businessType);
        this.handleQueryParamsExt(url, postJson, map);
        this.tripSyncLogParam.setRequesturl(url);
        this.tripSyncLogParam.setRequestdata(postJson);
        String result = HttpRetryServiceHelper.PostData(url, postJson.toJSONString());
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject backJson = JSONObject.parseObject((String)result);
        if (backJson != null) {
            JSONObject statusJson;
            Boolean sucess;
            if (isNeedPage) {
                int totalSize = backJson.getIntValue("TotalSize");
                logger.info("totalSize{}", (Object)totalSize);
                ArrayList logLists = Lists.newArrayListWithCapacity((int)totalSize);
                while (pageIndex < totalSize) {
                    JSONObject newPostJson = postJson.clone();
                    TripSyncLogParam syncLogParam = this.tripSyncLogParam.clone();
                    newPostJson.put("PageIndex", (Object)(++pageIndex));
                    this.handleQueryParamsExt(url, postJson, map);
                    String newResult = HttpRetryServiceHelper.PostData(url, newPostJson.toJSONString());
                    JSONObject newBackJson = JSONObject.parseObject((String)newResult);
                    syncLogParam.setResponsedata(newBackJson);
                    syncLogParam.setRequestdata(newPostJson);
                    syncLogParam.setRequesturl(url);
                    CTripCheckingInvoke.jsonMerge(newBackJson, backJson);
                    logLists.add(syncLogParam);
                }
                TripSyncLogUtils.saveErrorLog(logLists);
            }
            if ((sucess = (Boolean)(statusJson = (statusJson = backJson.getJSONObject("Status")) == null ? new JSONObject() : statusJson).getOrDefault((Object)SUCCESS, (Object)Boolean.FALSE)).booleanValue()) {
                return backJson;
            }
        }
        this.tripSyncLogParam.setStatus("B");
        return null;
    }

    private List<TrainCheckingBillDetailModel> handleRepeatTrainTicketNo(List<TrainCheckingBillDetailModel> details) {
        ArrayListMultimap mapS2 = ArrayListMultimap.create();
        ArrayList<TrainCheckingBillDetailModel> newDetails = new ArrayList<TrainCheckingBillDetailModel>(details.size());
        CTripCheckingInvoke.splitOrderByBatchno(details);
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripCheckingInvoke.lambda$handleRepeatTrainTicketNo$10((Multimap)mapS2, arg_0));
        for (TrainCheckingBillDetailModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS2.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS2.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().filter(e -> e.getTotalAmount() != null).map(e -> e.getTotalAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setRefundamount(list.stream().filter(e -> e.getRefundamount() != null).map(e -> e.getRefundamount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setAssuranceAmount(list.stream().filter(e -> e.getAssuranceAmount() != null).map(e -> e.getAssuranceAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().filter(e -> e.getServiceFee() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setTicketPrice(list.stream().map(e -> e.getTicketPrice() == null ? BigDecimal.ZERO : e.getTicketPrice()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private Collection<? extends AbstractCheckingBillDetailModel> handleRepeatVehicleTicketNo(List<VehicleCheckingBillDetailModel> details) {
        ArrayListMultimap mapS2 = ArrayListMultimap.create();
        CTripCheckingInvoke.splitOrderByBatchno(details);
        ArrayList<VehicleCheckingBillDetailModel> newDetails = new ArrayList<VehicleCheckingBillDetailModel>(details.size());
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripCheckingInvoke.lambda$handleRepeatVehicleTicketNo$25((Multimap)mapS2, arg_0));
        for (VehicleCheckingBillDetailModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS2.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS2.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().filter(e -> e.getTotalAmount() != null).map(e -> e.getTotalAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setDealAmount(list.stream().filter(e -> e.getServiceFee() != null).map(e -> e.getDealAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().filter(e -> e.getServiceFee() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private static void splitOrderByBatchno(List<? extends AbstractCheckingBillDetailModel> details) {
        ArrayListMultimap mapS1 = ArrayListMultimap.create();
        details.forEach(arg_0 -> CTripCheckingInvoke.lambda$splitOrderByBatchno$35((Multimap)mapS1, arg_0));
        for (AbstractCheckingBillDetailModel abstractCheckingBillDetailModel : details) {
            String fix;
            Collection checkingBillDetailModels = mapS1.get((Object)abstractCheckingBillDetailModel.getOrderNum());
            if (checkingBillDetailModels.size() <= 1) continue;
            String minBatchNo = null;
            for (AbstractCheckingBillDetailModel checkingBillDetailModel : checkingBillDetailModels) {
                String fix2;
                String batchno = checkingBillDetailModel.getBatchno().replaceAll("-", "");
                String string = fix2 = batchno.length() >= 8 ? batchno.substring(batchno.length() - 8) : batchno;
                if (minBatchNo == null) {
                    minBatchNo = fix2;
                    continue;
                }
                if (!NumberUtils.isCreatable((String)fix2) || new BigDecimal(minBatchNo).compareTo(new BigDecimal(fix2)) <= 0) continue;
                minBatchNo = fix2;
            }
            String batchno = abstractCheckingBillDetailModel.getBatchno().replaceAll("-", "");
            String string = fix = batchno.length() >= 8 ? batchno.substring(batchno.length() - 8) : batchno;
            if (null == minBatchNo || minBatchNo.equals(fix)) continue;
            fix = batchno.length() >= 4 ? batchno.substring(batchno.length() - 4) : batchno;
            abstractCheckingBillDetailModel.setOrderNum(abstractCheckingBillDetailModel.getOrderNum() + "-" + fix);
        }
    }

    private Collection<? extends AbstractCheckingBillDetailModel> handleRepeatHotelTicketNo(List<HotelCheckingBillDetailModel> details) {
        ArrayListMultimap mapS2 = ArrayListMultimap.create();
        ArrayList<HotelCheckingBillDetailModel> newDetails = new ArrayList<HotelCheckingBillDetailModel>(details.size());
        CTripCheckingInvoke.splitOrderByBatchno(details);
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripCheckingInvoke.lambda$handleRepeatHotelTicketNo$36((Multimap)mapS2, arg_0));
        for (HotelCheckingBillDetailModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS2.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS2.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().filter(e -> e.getTotalAmount() != null).map(e -> e.getTotalAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().filter(e -> e.getServiceFee() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setRoomAmount(list.stream().filter(e -> e.getRoomAmount() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setPersonalFee(list.stream().filter(e -> e.getPersonalFee() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private void buildDataByBatchNo(JSONObject checkingBillJson, List<CheckingBillModel> checkingBillModelList, int paramValue) {
        Map<String, JSONArray> batchNoMap = this.getBatchNoMap(checkingBillJson, paramValue);
        String businessType = checkingBillJson.getString("businessType");
        this.getHeaderDataAndDetailData(batchNoMap, checkingBillModelList, businessType);
    }

    private Map<String, JSONArray> getBatchNoMap(JSONObject checkingBillJson, int paramValue) {
        String businessType = checkingBillJson.getString("businessType");
        JSONArray checkingBillArray = checkingBillJson.getJSONArray("data");
        HashMap batchNoMap = Maps.newHashMapWithExpectedSize((int)16);
        String batchParam = this.getBatchParam(paramValue, businessType);
        String detailKey = "";
        switch (businessType) {
            case "HOTEL": {
                detailKey = "SettlementDetail";
                break;
            }
            case "PLANE": {
                detailKey = "OrderSettlementBaseInfo";
                break;
            }
            case "CAR": {
                detailKey = "SettlementBaseInfo";
                break;
            }
            case "TRAIN": {
                detailKey = "TrainSettlementDetail";
            }
        }
        this.dealData(checkingBillArray, batchNoMap, batchParam, detailKey);
        return batchNoMap;
    }

    private String getBatchParam(int paramValue, String businessType) {
        String batchParam = "";
        if (paramValue == 3) {
            batchParam = "SubAccCheckBatchNo";
            return batchParam;
        }
        switch (businessType) {
            case "HOTEL": 
            case "PLANE": {
                batchParam = "AccCheckBatchNo";
                break;
            }
            case "CAR": 
            case "TRAIN": {
                batchParam = "BatchNo";
            }
        }
        return batchParam;
    }

    private void dealData(JSONArray CheckingBillArray, Map<String, JSONArray> batchNoMap, String batchParam, String detailKey) {
        for (int i = 0; i < CheckingBillArray.size(); ++i) {
            JSONObject settlementInfoDetailObject = CheckingBillArray.getJSONObject(i);
            if (null == settlementInfoDetailObject) continue;
            JSONObject settlementDetailObject = settlementInfoDetailObject.getJSONObject(detailKey);
            settlementDetailObject = settlementDetailObject == null ? new JSONObject() : settlementDetailObject;
            String batchNo = settlementDetailObject.getOrDefault((Object)batchParam, (Object)"").toString();
            if (batchNoMap.containsKey(batchNo)) {
                JSONArray value = batchNoMap.get(batchNo);
                value.add((Object)settlementInfoDetailObject);
                continue;
            }
            JSONArray dataArray = new JSONArray();
            dataArray.add((Object)settlementInfoDetailObject);
            batchNoMap.put(batchNo, dataArray);
        }
    }

    private void getHeaderDataAndDetailData(Map<String, JSONArray> batchNoMap, List<CheckingBillModel> checkingBillModelList, String businessType) {
        if (batchNoMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, JSONArray>> entries = batchNoMap.entrySet();
        for (Map.Entry<String, JSONArray> entry : entries) {
            ArrayList details = Lists.newArrayListWithCapacity((int)16);
            CheckingBillModel billModel = new CheckingBillModel();
            checkingBillModelList.add(billModel);
            JSONArray value = entry.getValue();
            CheckingBillHeaderModel headerModel = new CheckingBillHeaderModel();
            String batchNo = entry.getKey();
            billModel.setCheckingBillHeaderModel(this.completeHeaderData(headerModel, value, batchNo, businessType));
            this.finalBuildDetailModel(value, businessType, details);
            billModel.setCheckingBillDetailModels(details);
        }
    }

    private CheckingBillHeaderModel completeHeaderData(CheckingBillHeaderModel headerModel, JSONArray value, String batchNo, String businessType) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        totalAmount = this.getTotalAmount(value, businessType, totalAmount);
        headerModel.setBillNo(businessType + batchNo);
        headerModel.setSettlementAmount(totalAmount);
        headerModel.setBillstatusname("1");
        if (batchNo.contains("_") && batchNo.substring(batchNo.lastIndexOf("_") + 1).length() == 8) {
            String date = batchNo.substring(batchNo.lastIndexOf("_") + 1);
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6, 8)), 0, 0, 0);
            headerModel.setPeriodStartDate(TripCommonUtil.strToDate(new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime()), "yyyy-MM-dd"));
            int month = cal.get(2);
            int day = cal.get(5);
            cal.set(2, month + 1);
            cal.set(5, day - 1);
            headerModel.setPeriodEndDate(TripCommonUtil.strToDate(new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime()), "yyyy-MM-dd"));
        } else {
            headerModel.setPeriodStartDate(TripCommonUtil.strToDate(TripCommonUtil.getLastMonthFirstDay(), "yyyy-MM-dd"));
            headerModel.setPeriodEndDate(TripCommonUtil.strToDate(TripCommonUtil.getLastMonthLastDay(), "yyyy-MM-dd"));
        }
        headerModel.setServer(Supplier.XIECHENG.name());
        return headerModel;
    }

    private static JSONObject jsonMerge(JSONObject source, JSONObject target) {
        if (target == null) {
            return source;
        }
        for (String key : source.keySet()) {
            Object value = source.get((Object)key);
            if (!target.containsKey((Object)key)) {
                target.put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject valueJson = (JSONObject)value;
                JSONObject targetValue = CTripCheckingInvoke.jsonMerge(valueJson, target.getJSONObject(key));
                target.put(key, (Object)targetValue);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray valueArray = (JSONArray)value;
                target.getJSONArray(key).addAll((Collection)valueArray);
                continue;
            }
            target.put(key, value);
        }
        return target;
    }

    private static /* synthetic */ void lambda$handleRepeatHotelTicketNo$36(Multimap mapS2, HotelCheckingBillDetailModel e) {
        mapS2.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$splitOrderByBatchno$35(Multimap mapS1, AbstractCheckingBillDetailModel e) {
        mapS1.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$handleRepeatVehicleTicketNo$25(Multimap mapS2, VehicleCheckingBillDetailModel e) {
        mapS2.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$handleRepeatTrainTicketNo$10(Multimap mapS2, TrainCheckingBillDetailModel e) {
        mapS2.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$handleRepeatTicketNo$0(Multimap mapS2, PlaneCheckingBillDetailModel e) {
        mapS2.put((Object)e.getOrderNum(), (Object)e);
    }
}

