/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.service.function.AbstractOrderInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.CTripReqbillInvoke;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripCarOrderConvert;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripHotelOrderConvert;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripPlaneOrderConvert;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.codec.digest.DigestUtils;

public class CTripOrderInvoke
extends AbstractOrderInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(CTripReqbillInvoke.class);
    private static final String[] HOTEL_ORDER_STATUS = new String[]{"Paid", "Dealt", "CheckIn", "CheckOut", "Cancelled"};

    public CTripOrderInvoke() {
    }

    public CTripOrderInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    protected JSONObject process(Map params) {
        String jsonData2;
        JSONObject jsonObject;
        String data = (String)params.get("jsondata");
        if (data != null && !JSONObject.parseObject((String)data).containsKey((Object)"jsontest")) {
            return JSONObject.parseObject((String)data);
        }
        if (params.containsKey("jsondata") && (jsonObject = JSONObject.parseObject((String)(jsonData2 = (String)params.get("jsondata")))).containsKey((Object)"jsontest")) {
            params.put("orderStatus", jsonObject.get((Object)"orderStatus"));
            params.put("corpId", jsonObject.get((Object)"corpId"));
            params.put("productType", jsonObject.get((Object)"productType"));
            params.put("sign", jsonObject.get((Object)"sign"));
            params.put("orderId", jsonObject.get((Object)"orderId"));
            params.put("segments", jsonObject.get((Object)"segments"));
            params.put("ticketNo", jsonObject.get((Object)"ticketNo"));
        }
        if (null != params.get("segments")) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException | KDBizException jsonData2) {
                // empty catch block
            }
            String orderId = (String)params.get("orderId");
            String corpId = (String)params.get("corpId");
            String segments = (String)params.get("segments");
            String ticketNo = (String)params.get("ticketNo");
            String sign = (String)params.get("sign");
            Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(this.supplier());
            String secret = corpMap.get("reservedfield3");
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("secret", secret);
                hashMap.put("corpId", corpId);
                hashMap.put("segments", segments);
                hashMap.put("orderId", orderId);
                hashMap.put("ticketNo", ticketNo);
                String sign1 = this.getSign(hashMap);
                if (!sign1.equals(sign)) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u6821\u9a8c\u7b7e\u540d\u5931\u8d25,\u643a\u7a0b\u8fd4\u56design:" + sign + ",\u7cfb\u7edf\u751f\u6210sign:" + sign1 + "\u5165\u53c2:" + JSON.toJSONString(hashMap));
                    return new JSONObject();
                }
                JSONArray segmentArray = JSON.parseArray((String)segments);
                Boolean isNoStatus = true;
                for (Object s : segmentArray) {
                    JSONObject json = JSON.parseObject((String)JSON.toJSONString(s));
                    Integer segStatus = json.getInteger("segStatus");
                    if (null == segStatus || segStatus != 2 && segStatus != 3 && segStatus != 4 && segStatus != 6 && segStatus != 7) continue;
                    isNoStatus = false;
                    break;
                }
                if (isNoStatus.booleanValue()) {
                    return new JSONObject();
                }
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u751f\u6210\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
            }
            return this.searchOrder(orderId);
        }
        if (null != params.get("orderId") && null != params.get("sign")) {
            String orderStatus = (String)params.get("orderStatus");
            String orderId = (String)params.get("orderId");
            String corpId = (String)params.get("corpId");
            String productType = (String)params.get("productType");
            String sign = (String)params.get("sign");
            Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(this.supplier());
            String secret = corpMap.get("reservedfield1");
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("secret", secret);
                hashMap.put("corpId", corpId);
                hashMap.put("productType", productType);
                hashMap.put("orderId", orderId);
                hashMap.put("orderStatus", orderStatus);
                logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u751f\u6210\u7b7e\u540d,\u5165\u53c2:" + JSON.toJSONString(hashMap));
                if (Arrays.asList("HotelContract", "HotelMember").contains(productType) && !this.judgeHotelIsNeedPull(orderId, orderStatus).booleanValue()) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u9152\u5e97\u8ba2\u5355,\u65e0\u9700\u7ee7\u7eed\u83b7\u53d6");
                    return new JSONObject();
                }
                String sign1 = this.getSign(hashMap);
                if (!sign1.equals(sign)) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u6821\u9a8c\u7b7e\u540d\u5931\u8d25,\u643a\u7a0b\u8fd4\u56design:" + sign + ",\u7cfb\u7edf\u751f\u6210sign:" + sign1);
                    return new JSONObject();
                }
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u751f\u6210\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
            }
            return this.searchOrder(orderId);
        }
        return this.searchOrder(params);
    }

    private Boolean judgeHotelIsNeedPull(String orderId, String orderStatus) {
        if (!Arrays.asList(HOTEL_ORDER_STATUS).contains(orderStatus)) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u9152\u5e97\u8ba2\u5355\u72b6\u6001\u4e0d\u5c5e\u4e8e\u5df2\u652f\u4ed8 \u5df2\u7ecf\u6210\u4ea4 \u5165\u5e97\u6253\u5361 \u79bb\u5e97\u6253\u5361 \u5df2\u53d6\u6d88,\u4e0d\u9700\u8981\u83b7\u53d6\u8ba2\u5355");
            return Boolean.FALSE;
        }
        if ("Cancelled".equals(orderStatus)) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u9152\u5e97\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u53d6\u6d88,\u5224\u65ad\u8ba2\u5355\u662f\u5426\u5df2\u62c9\u53d6");
            boolean exists = QueryServiceHelper.exists((String)"er_hotelbill", (QFilter[])new QFilter[]{new QFilter("ordernum", "like", (Object)(orderId + "%"))});
            if (!exists) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u9152\u5e97\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u53d6\u6d88,\u672a\u83b7\u53d6\u8fc7\u8be5\u53d6\u6d88\u8ba2\u5355\u7684\u5176\u4f59\u72b6\u6001,\u4e0d\u9700\u8981\u62c9\u53d6");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private String getSign(HashMap<String, String> hashMap) {
        Set<String> collection = hashMap.keySet();
        ArrayList<String> list = new ArrayList<String>(collection);
        Collections.sort(list);
        StringBuilder strSb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            strSb.append(list.get(i));
            strSb.append("=");
            strSb.append(hashMap.get(list.get(i)));
            if (i == list.size() - 1) continue;
            strSb.append("&");
        }
        return DigestUtils.shaHex((String)strSb.toString()).toUpperCase();
    }

    private JSONObject searchOrder(Map<String, Object> params) {
        JSONObject postJson = new JSONObject();
        if (null != params.get("ordernum")) {
            postJson.put("OrderID", params.get("ordernum"));
            this.tripSyncLogParam.setBillid(params.get("ordernum").toString());
            this.tripSyncLogParam.setBillno(params.get("ordernum").toString());
        }
        if (null != params.get("beginDate") && null != params.get("endDate")) {
            String dateFromStr = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), "yyyy-MM-dd");
            String dateToStr = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), "yyyy-MM-dd");
            postJson.put("DateFrom", (Object)dateFromStr);
            postJson.put("DateTo", (Object)dateToStr);
        }
        if (null != params.get("reqnum") && !params.get("reqnum").toString().isEmpty()) {
            postJson.put("JourneyNo", params.get("reqnum"));
            this.tripSyncLogParam.setBillid(params.get("reqnum").toString());
            this.tripSyncLogParam.setBillno(params.get("reqnum").toString());
        }
        if (null != params.get("type") && !params.get("type").toString().isEmpty()) {
            postJson.put("SearchType", params.get("type"));
        }
        postJson.put("Auth", (Object)CorpSync.getAuthentification());
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u5165\u53c2:" + postJson.toJSONString());
        this.tripSyncLogParam.setRequestdata(postJson);
        this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/switchapi/Order/SearchOrder");
        String result = HttpRetryServiceHelper.PostData("https://ct.ctrip.com/switchapi/Order/SearchOrder", postJson.toJSONString());
        this.tripSyncLogParam.setResponsedata(result);
        this.tripSyncLogParam.setStatus("B");
        JSONObject backJson = JSONObject.parseObject((String)result);
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u8fd4\u56de\u7ed3\u679c:" + backJson.toJSONString());
        if (backJson == null || backJson.getJSONObject("Status") == null) {
            return null;
        }
        JSONObject statusJson = backJson.getJSONObject("Status");
        Boolean sucess = (Boolean)statusJson.get((Object)"Success");
        if (sucess.booleanValue()) {
            this.tripSyncLogParam.setStatus("A");
            return backJson;
        }
        return null;
    }

    private JSONObject searchOrder(String orderNum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ordernum", orderNum);
        return this.searchOrder(params);
    }

    protected Object convert(Object json) throws TripException {
        if (json == null) {
            return new ArrayList();
        }
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)json));
        JSONArray orderDataArray = jsonObject.getJSONArray("ItineraryList");
        JSONArray jSONArray = orderDataArray = orderDataArray == null ? new JSONArray() : orderDataArray;
        if (orderDataArray == null || orderDataArray.size() < 1) {
            return new ArrayList();
        }
        ArrayList<AbstractOrderModel> orders = new ArrayList<AbstractOrderModel>(4);
        try {
            boolean existHotel = Boolean.FALSE;
            for (int i = 0; i < orderDataArray.size(); ++i) {
                JSONArray carArray;
                JSONArray fightArray;
                JSONObject orderData = orderDataArray.getJSONObject(i);
                if (null == orderData) continue;
                JSONArray hotelArray = orderData.getJSONArray("HotelOrderInfoList");
                JSONArray jSONArray2 = hotelArray = hotelArray == null ? new JSONArray() : hotelArray;
                if (hotelArray != null && hotelArray.size() > 0) {
                    for (int j = 0; j < hotelArray.size(); ++j) {
                        JSONObject hotelJsonObject = hotelArray.getJSONObject(j);
                        if (null == hotelJsonObject || hotelJsonObject.isEmpty()) continue;
                        List<AbstractOrderModel> tempOrders = CTripHotelOrderConvert.convert(hotelJsonObject);
                        orders.addAll(tempOrders);
                        if (tempOrders == null || tempOrders.size() < 1) continue;
                        if (!existHotel) {
                            existHotel = Boolean.TRUE;
                        }
                        HotelOrderModel hotelOrder = (HotelOrderModel)tempOrders.get(0);
                        this.handleHotelOrderExtCovert(hotelOrder, hotelJsonObject);
                        this.handleHotelOrderExtCovert(tempOrders, hotelJsonObject);
                    }
                }
                JSONArray jSONArray3 = fightArray = (fightArray = orderData.getJSONArray("FlightOrderInfoList")) == null ? new JSONArray() : fightArray;
                if (fightArray != null && fightArray.size() > 0) {
                    for (int j = 0; j < fightArray.size(); ++j) {
                        JSONObject planeJsonObject = fightArray.getJSONObject(j);
                        if (null == planeJsonObject || planeJsonObject.isEmpty()) continue;
                        List<AbstractOrderModel> tempOrders = CTripPlaneOrderConvert.convert(planeJsonObject);
                        orders.addAll(tempOrders);
                        if (tempOrders == null || tempOrders.size() < 1) continue;
                        PlaneOrderModel planeOrder = (PlaneOrderModel)tempOrders.get(0);
                        this.handlePlaneOrderExtCovert(planeOrder, planeJsonObject);
                        this.handlePlaneOrderExtCovert(tempOrders, planeJsonObject);
                    }
                }
                JSONArray jSONArray4 = carArray = (carArray = orderData.getJSONArray("CarQuickOrderInfoList")) == null ? new JSONArray() : carArray;
                if (carArray == null || carArray.size() <= 0) continue;
                for (int j = 0; j < carArray.size(); ++j) {
                    JSONObject carJsonObject = carArray.getJSONObject(j);
                    if (null == carJsonObject || carJsonObject.isEmpty()) continue;
                    List<AbstractOrderModel> tempOrders = CTripCarOrderConvert.convert(carJsonObject);
                    orders.addAll(tempOrders);
                    if (tempOrders == null || tempOrders.size() < 1) continue;
                    VehicleOrderModel vehicleOrder = (VehicleOrderModel)tempOrders.get(0);
                    this.handleCarOrderExtCovert(vehicleOrder, carJsonObject);
                    this.handleCarOrderExtCovert(tempOrders, carJsonObject);
                }
            }
            this.filterHotelData(orders, existHotel);
        }
        catch (CloneNotSupportedException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,CTripOrderInvoke.convert.CloneNotSupportedException", (Throwable)e);
            throw new TripException(e.getMessage());
        }
        return orders;
    }

    private void filterHotelData(List<AbstractOrderModel> orders, boolean existHotel) {
        if (!existHotel || orders.size() == 0) {
            return;
        }
        ArrayList hotelOrderModels = Lists.newArrayListWithCapacity((int)16);
        int size = orders.size();
        for (int i = 0; i < size; ++i) {
            AbstractOrderModel abstractOrderModel = orders.get(i);
            if (null == abstractOrderModel || !(abstractOrderModel instanceof HotelOrderModel)) continue;
            HotelOrderModel hotel = (HotelOrderModel)abstractOrderModel;
            hotelOrderModels.add(hotel);
        }
        if (CollectionUtils.isEmpty((Collection)hotelOrderModels)) {
            return;
        }
        Set cancelHotelOrderNums = hotelOrderModels.stream().filter(obj -> obj != null && StringUtils.isNotEmpty((String)obj.getOrderNum()) && HotelOrderModel.OrderStatus.I.getKey().equals(obj.getOrderStatus().getKey())).map(AbstractOrderModel::getOrderNum).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(cancelHotelOrderNums)) {
            return;
        }
        QFilter filter = new QFilter("1", "=", (Object)1);
        int index = 0;
        for (String cancelHotelOrderNum : cancelHotelOrderNums) {
            if (cancelHotelOrderNum.contains("-")) {
                cancelHotelOrderNum = cancelHotelOrderNum.substring(0, cancelHotelOrderNum.indexOf("-"));
            }
            if (index == 0) {
                filter.and(QFilter.like((String)"ordernum", (String)(cancelHotelOrderNum + "%")));
            } else {
                filter.or(QFilter.like((String)"ordernum", (String)(cancelHotelOrderNum + "%")));
            }
            ++index;
        }
        DynamicObjectCollection dbDatas = QueryServiceHelper.query((String)"er_hotelbill", (String)"ordernum", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isNotEmpty((Collection)dbDatas)) {
            Set existHotelOrderNums = dbDatas.stream().filter(Objects::nonNull).map(obj -> obj.getString("ordernum")).collect(Collectors.toSet());
            existHotelOrderNums = existHotelOrderNums.stream().map(obj -> {
                if (obj.contains("-")) {
                    return obj.substring(0, obj.indexOf("-"));
                }
                return obj;
            }).collect(Collectors.toSet());
            cancelHotelOrderNums = cancelHotelOrderNums.stream().map(obj -> {
                if (obj.contains("-")) {
                    return obj.substring(0, obj.indexOf("-"));
                }
                return obj;
            }).collect(Collectors.toSet());
            cancelHotelOrderNums.removeAll(existHotelOrderNums);
        }
        Set finalCancelHotelOrderNums = cancelHotelOrderNums;
        orders.removeIf(obj -> finalCancelHotelOrderNums.stream().anyMatch(tmpOrderNum -> obj.getOrderNum() != null && obj.getOrderNum().startsWith((String)tmpOrderNum)));
    }
}

