/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.model.JourneyModel;
import kd.fi.er.business.trip.model.TripReqbillModel;
import kd.fi.er.business.trip.service.function.AbstractTripReqBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang.StringUtils;

public class CTripReqbillInvoke
extends AbstractTripReqBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(CTripReqbillInvoke.class);
    private static final String SUCCESS = "Success";

    public CTripReqbillInvoke(Object pk) {
        super(pk);
    }

    public CTripReqbillInvoke() {
    }

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    protected JSONObject convert(Object value) {
        if (this.pk != null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u51fa\u5dee\u7533\u8bf7\u5355,\u5355\u636ebillid\u4e3a:" + this.pk);
            return this.convertPushBill(value);
        }
        String syncStatus = (String)this.getParams().get("syncStatus");
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u51fa\u5dee\u7533\u8bf7\u5355,\u540c\u6b65\u7684\u72b6\u6001\u6709:1_\u63a8\u9001\u5355\u636e,2_\u5173\u95ed\u5355\u636e,3_\u542f\u7528\u5355\u636e,4_\u64a4\u9500\u5355\u636e,\u5f53\u524d\u72b6\u6001\u4e3a:" + syncStatus);
        switch (syncStatus) {
            case "1": 
            case "3": {
                return this.convertPushBill(value);
            }
            case "2": {
                return this.convertCloseBill(value);
            }
        }
        return null;
    }

    protected String batPushProcess(Object value) {
        JSONObject ApprovalJson;
        JSONObject status;
        if (value == null) {
            return null;
        }
        JSONObject t = (JSONObject)value;
        JSONObject requestJson = new JSONObject();
        requestJson.put("request", (Object)t);
        String jsonStr = JSON.toJSONString((Object)requestJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "https://ct.ctrip.com/switchapi/approval.svc/rest/setapproval";
        this.tripSyncLogParam.setRequestdata(jsonStr);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpRetryServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null && (status = (ApprovalJson = jsonObject.getJSONObject("SetApprovalResult")).getJSONObject("Status")).getBoolean(SUCCESS).booleanValue()) {
            return "200";
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        boolean paramValue;
        TripReqbillModel reqbill = (TripReqbillModel)info;
        JSONObject bodyDataJson = new JSONObject();
        List<JourneyModel> journeyModelList = reqbill.getJourneyModelList();
        JSONArray flightEndorsementDetails = new JSONArray();
        JSONArray hotelEndorsementDetails = new JSONArray();
        JSONArray CarQuickEndorsementDetails = new JSONArray();
        JSONArray TrainEndorsementDetails = new JSONArray();
        ArrayList<Date> dates = new ArrayList<Date>(journeyModelList.size());
        for (JourneyModel journeyModel : journeyModelList) {
            dates.add(journeyModel.getStartDate());
            dates.add(journeyModel.getEndDate());
        }
        String firstStartDate = TripCommonUtil.date2TimeStamp((Date)Collections.min(dates), "yyyy-MM-dd");
        String lastEndDate = TripCommonUtil.date2TimeStamp((Date)Collections.max(dates), "yyyy-MM-dd");
        HashSet passengerSet = new HashSet();
        HashSet passengerNumSet = new HashSet();
        HashSet passengerNameSet = new HashSet();
        LinkedHashSet<Long> admindivisionIDs = new LinkedHashSet<Long>(journeyModelList.size() * 2);
        LinkedHashSet<Long> toAdmindivisionIds = new LinkedHashSet<Long>(journeyModelList.size());
        Boolean ispasswaypush = TripSyncConfigUtil.getBoolean("ctrip_PassWay_Push");
        for (int i = 0; i < journeyModelList.size(); ++i) {
            JourneyModel journeyModel = journeyModelList.get(i);
            admindivisionIDs.add(journeyModel.getFromCityID());
            toAdmindivisionIds.add(journeyModel.getToCityID());
            if (ispasswaypush.booleanValue() && null != journeyModel.getMulwaytos() && journeyModel.getMulwaytos().size() > 0) {
                journeyModel.getMulwaytos().forEach(v -> {
                    admindivisionIDs.add(v.getFromCityID());
                    toAdmindivisionIds.add(v.getToCityID());
                });
            }
            Set<DynamicObject> travelers = journeyModel.getTravelers();
            travelers.stream().forEach(traveler -> {
                JSONObject passengerOb = new JSONObject();
                JSONObject passengerNumOb = new JSONObject();
                JSONObject passengerNameOb = new JSONObject();
                passengerOb.put("Name", (Object)traveler.getString("name"));
                passengerOb.put("EID", (Object)traveler.getString("number"));
                passengerNameOb.put("Name", (Object)traveler.getString("name"));
                passengerNumOb.put("EID", (Object)traveler.getString("number"));
                passengerSet.add(passengerOb);
                passengerNumSet.add(passengerNumOb);
                passengerNameSet.add(passengerNameOb);
            });
        }
        List<Set<String>> citylist = TripCityUtil.getCityCodeAndIds(admindivisionIDs);
        Set<String> cityCodes = citylist.get(0);
        Set<String> cityIds = citylist.get(1);
        List<Set<String>> toCityList = TripCityUtil.getCityCodeAndIds(toAdmindivisionIds);
        Set<String> toCityCodes = toCityList.get(0);
        Set<String> toCityIds = toCityList.get(1);
        LinkedHashSet<String> fromCityCodeList = new LinkedHashSet<String>();
        LinkedHashSet<String> toCityCodeList = new LinkedHashSet<String>();
        LinkedHashSet<String> fromCityIdList = new LinkedHashSet<String>();
        LinkedHashSet<String> toCityIdList = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(cityCodes) && CollectionUtils.isNotEmpty(toCityCodes)) {
            fromCityCodeList.addAll(cityCodes);
            fromCityCodeList.addAll(toCityCodes);
            toCityCodeList.addAll(toCityCodes);
            toCityCodeList.addAll(cityCodes);
        }
        fromCityIdList.addAll(cityIds);
        fromCityIdList.addAll(toCityIds);
        toCityIdList.addAll(toCityIds);
        toCityIdList.addAll(cityIds);
        String cityIdsStr = StringUtils.join((Object[])toCityIdList.toArray(), (String)",");
        Map<String, Object> tripControlSettingMap = new HashMap<String, Object>();
        tripControlSettingMap = this.getTripSetting(tripControlSettingMap, reqbill.getCompanyId());
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        JSONObject flightEndorsementDetail = new JSONObject();
        flightEndorsementDetail.put("DepartCityCodes", fromCityCodeList);
        flightEndorsementDetail.put("ArrivalCityCodes", toCityCodeList);
        flightEndorsementDetail.put("DepartCityIds", fromCityIdList);
        flightEndorsementDetail.put("ArrivalCityIds", toCityIdList);
        flightEndorsementDetail.put("ReturnDateBegin", (Object)firstStartDate);
        flightEndorsementDetail.put("ReturnDateEnd", (Object)lastEndDate);
        flightEndorsementDetail.put("DepartDateBegin", (Object)firstStartDate);
        flightEndorsementDetail.put("DepartDateEnd", (Object)lastEndDate);
        flightEndorsementDetail.put("CurrencyType", (Object)reqbill.getCurrency());
        flightEndorsementDetail.put("SeatClass", (Object)0);
        flightEndorsementDetail.put("ProductType", (Object)"1");
        if (tripCtrlObject != null) {
            flightEndorsementDetail.put("FlightWay", (Object)tripCtrlObject.getString("domairroundtripctrl"));
            flightEndorsementDetail.put("Discount", (Object)tripCtrlObject.getBigDecimal("domairdiscountctrl").toString());
            String domPeopleCtr = tripCtrlObject.getString("domairtrippeoplectrl");
            Integer flightSkipFields = (Integer)tripControlSettingMap.get("flightSkipFields");
            if (StringUtils.isNotEmpty((String)domPeopleCtr) && "1".equals(domPeopleCtr)) {
                flightEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
            } else if (StringUtils.isNotEmpty((String)domPeopleCtr) && "0".equals(domPeopleCtr)) {
                flightEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerNameSet).toString()));
            } else if (StringUtils.isNotEmpty((String)domPeopleCtr) && "2".equals(domPeopleCtr)) {
                flightEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
                flightSkipFields = flightSkipFields + 32;
            }
            flightEndorsementDetail.put("SkipFields", (Object)flightSkipFields);
        } else {
            flightEndorsementDetail.put("FlightWay", (Object)"2");
            flightEndorsementDetail.put("SkipFields", (Object)64991);
        }
        JSONObject flightEndorsementIntDetail = flightEndorsementDetail.clone();
        flightEndorsementIntDetail.put("ProductType", (Object)"2");
        flightEndorsementDetails.add((Object)flightEndorsementDetail);
        flightEndorsementDetails.add((Object)flightEndorsementIntDetail);
        JSONObject hotelEndorsementDetail = new JSONObject();
        hotelEndorsementDetail.put("CheckInDateBegin", (Object)firstStartDate);
        hotelEndorsementDetail.put("CheckInDateEnd", (Object)lastEndDate);
        hotelEndorsementDetail.put("CheckOutDateBegin", (Object)firstStartDate);
        hotelEndorsementDetail.put("CheckOutDateEnd", (Object)lastEndDate);
        hotelEndorsementDetail.put("CheckInCityCodes", toCityIdList);
        hotelEndorsementDetail.put("CurrencyType", (Object)reqbill.getCurrency());
        hotelEndorsementDetail.put("ProductType", (Object)"3");
        if (tripCtrlObject != null) {
            hotelEndorsementDetail.put("MaxStarRating", (Object)tripCtrlObject.getInt("maxstarclass"));
            hotelEndorsementDetail.put("MinStarRating", (Object)tripCtrlObject.getInt("mixstarclass"));
            int dayroomcount = tripCtrlObject.getInt("dayroomcount");
            dayroomcount = dayroomcount >= 8 ? (dayroomcount = 8) : dayroomcount;
            hotelEndorsementDetail.put("RoomCount", (Object)dayroomcount);
            String hotelPeopleCtr = tripCtrlObject.getString("hoteltrippeoplectrl");
            Integer hotelSkipFields = (Integer)tripControlSettingMap.get("hotelSkipFields");
            if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "1".equals(hotelPeopleCtr)) {
                hotelEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
            } else if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "0".equals(hotelPeopleCtr)) {
                hotelEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerNameSet).toString()));
            } else if (StringUtils.isNotEmpty((String)hotelPeopleCtr) && "2".equals(hotelPeopleCtr)) {
                hotelEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
                hotelSkipFields = hotelSkipFields + 16;
            }
            hotelEndorsementDetail.put("SkipFields", (Object)hotelSkipFields);
        } else {
            hotelEndorsementDetail.put("SkipFields", (Object)16367);
        }
        JSONObject hotelEndorsementIntDetail = hotelEndorsementDetail.clone();
        hotelEndorsementIntDetail.put("ProductType", (Object)"4");
        hotelEndorsementDetails.add((Object)hotelEndorsementDetail);
        hotelEndorsementDetails.add((Object)hotelEndorsementIntDetail);
        JSONObject CarQuickEndorsementDetail = new JSONObject();
        CarQuickEndorsementDetail.put("ProductType", (Object)"10");
        CarQuickEndorsementDetail.put("Cities", (Object)cityIdsStr);
        CarQuickEndorsementDetail.put("ArrivalCities", (Object)cityIdsStr);
        CarQuickEndorsementDetail.put("BeginUseDate", (Object)firstStartDate);
        CarQuickEndorsementDetail.put("EndUseDate", (Object)lastEndDate);
        if (tripCtrlObject != null) {
            Integer carSkipFields = (Integer)tripControlSettingMap.get("carSkipFields");
            String carPeopleCtr = tripCtrlObject.getString("cartrippeoplectrl");
            if (StringUtils.isNotEmpty((String)carPeopleCtr) && "1".equals(carPeopleCtr)) {
                CarQuickEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
            } else if (StringUtils.isNotEmpty((String)carPeopleCtr) && "0".equals(carPeopleCtr)) {
                CarQuickEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerNameSet).toString()));
            } else if (StringUtils.isNotEmpty((String)carPeopleCtr) && "2".equals(carPeopleCtr)) {
                CarQuickEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
                carSkipFields = carSkipFields + 1;
            }
            CarQuickEndorsementDetail.put("SkipFields", (Object)carSkipFields);
        } else {
            CarQuickEndorsementDetail.put("SkipFields", (Object)2046);
        }
        CarQuickEndorsementDetails.add((Object)CarQuickEndorsementDetail);
        JSONObject TrainEndorsementDetail = new JSONObject();
        TrainEndorsementDetail.put("ProductType", (Object)"5");
        TrainEndorsementDetail.put("DepartDateBegin", (Object)firstStartDate);
        TrainEndorsementDetail.put("ReturnDateBegin", (Object)firstStartDate);
        TrainEndorsementDetail.put("DepartDateEnd", (Object)lastEndDate);
        TrainEndorsementDetail.put("ReturnDateEnd", (Object)lastEndDate);
        TrainEndorsementDetail.put("FromCities", fromCityIdList);
        TrainEndorsementDetail.put("ToCities", toCityIdList);
        TrainEndorsementDetail.put("ArrivalCityCodes", toCityIdList);
        TrainEndorsementDetail.put("DepartCityCodes", fromCityIdList);
        if (tripCtrlObject != null) {
            Integer trainSkipFields = (Integer)tripControlSettingMap.get("trainSkipFields");
            String trainPeopleCtr = tripCtrlObject.getString("traintrippeoplectrl");
            if (StringUtils.isNotEmpty((String)trainPeopleCtr) && "1".equals(trainPeopleCtr)) {
                TrainEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
            } else if (StringUtils.isNotEmpty((String)trainPeopleCtr) && "0".equals(trainPeopleCtr)) {
                TrainEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerNameSet).toString()));
            } else {
                TrainEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
            }
            TrainEndorsementDetail.put("TrainSkipFields", (Object)trainSkipFields);
            String trainRoundtripCtrl = tripCtrlObject.getString("trainroundtripctrl");
            TrainEndorsementDetail.put("TripType", (Object)(StringUtils.isEmpty((String)trainRoundtripCtrl) ? "2" : trainRoundtripCtrl));
        } else {
            TrainEndorsementDetail.put("TripType", (Object)"2");
            TrainEndorsementDetail.put("TrainSkipFields", (Object)1792);
            TrainEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
        }
        TrainEndorsementDetails.add((Object)TrainEndorsementDetail);
        JSONObject extendField = new JSONObject();
        extendField.put("FieldName", (Object)"CostCenter1");
        extendField.put("FieldValue", (Object)reqbill.getCostCompany());
        extendField.put("FieldType", (Object)"String");
        JSONArray extendFieldList = new JSONArray();
        extendFieldList.add((Object)extendField);
        try {
            JSONObject auth = CorpSync.getAuthentification();
            bodyDataJson.put("Auth", (Object)auth);
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchAPI/Order/Ticket");
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"CTripReqbillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        StringBuilder employeeID = new StringBuilder(reqbill.getApplyEmpNum());
        Boolean isdoc = TripSyncConfigUtil.getBoolean("ctrip_reqbill_DocumentMaker");
        if (!employeeID.toString().equals(reqbill.getCreatEmpNum()) && isdoc.booleanValue()) {
            employeeID.append(",").append(reqbill.getCreatEmpNum());
        }
        if (paramValue = TripSyncConfigUtil.getBoolean("Reservation_ personnel_range")) {
            for (int i = 0; i < journeyModelList.size(); ++i) {
                JourneyModel journeyModel = journeyModelList.get(i);
                Set<DynamicObject> travelers = journeyModel.getTravelers();
                Set travelNumerSet = travelers.stream().filter(traveler -> StringUtils.isNotEmpty((String)traveler.getString("number"))).map(traveler -> traveler.getString("number")).collect(Collectors.toSet());
                employeeID.append(",").append(StringUtils.join(travelNumerSet, (String)","));
            }
        }
        bodyDataJson.put("EmployeeID", (Object)employeeID.toString());
        bodyDataJson.put("ApprovalNumber", (Object)reqbill.getBillNo());
        bodyDataJson.put("Status", (Object)1);
        bodyDataJson.put("FlightEndorsementDetails", (Object)flightEndorsementDetails);
        bodyDataJson.put("HotelEndorsementDetails", (Object)hotelEndorsementDetails);
        bodyDataJson.put("CarQuickEndorsementDetails", (Object)CarQuickEndorsementDetails);
        bodyDataJson.put("TrainEndorsementDetails", (Object)TrainEndorsementDetails);
        bodyDataJson.put("ExtendFieldList", (Object)extendFieldList);
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u51fa\u5dee\u7533\u8bf7\u5355,bodyDataJson:" + bodyDataJson);
        return bodyDataJson;
    }

    private Map<String, Object> getTripSetting(Map<String, Object> tripControlSettingMap, Long orgId) {
        DynamicObject tripCtrlObject;
        if (orgId != null && (tripCtrlObject = TripCommonUtil.getTripControlSettings(orgId, this.supplier())) != null) {
            String cardatectrl;
            String hotelcityctrl;
            String hoteldatectrl;
            String cityctrl;
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u51fa\u5dee\u7533\u8bf7\u5355,tripCtrlObject != null");
            int flightSkipFields = 64991;
            int hotelSkipFields = 16367;
            int carSkipFields = 2046;
            int trainSkipFields = 2047;
            flightSkipFields -= 8;
            String datectrl = tripCtrlObject.getString("domairdatectrl");
            if (!"0".equals(datectrl)) {
                flightSkipFields = flightSkipFields - 2 - 4 - 128 - 256;
            }
            if (!"0".equals(cityctrl = tripCtrlObject.getString("domaircityctrl"))) {
                flightSkipFields = flightSkipFields - 16 - 1024;
            }
            if (!"0".equals(hoteldatectrl = tripCtrlObject.getString("hoteldatectrl"))) {
                hotelSkipFields = hotelSkipFields - 1 - 2 - 4 - 8;
            }
            if (!"0".equals(hotelcityctrl = tripCtrlObject.getString("hotelcityctrl"))) {
                hotelSkipFields -= 32;
            }
            hotelSkipFields -= 4096;
            hotelSkipFields -= 512;
            hotelSkipFields -= 1024;
            String carcityctrl = tripCtrlObject.getString("carcityctrl");
            if (!"0".equals(carcityctrl)) {
                carSkipFields -= 2;
            }
            if (!"0".equals(cardatectrl = tripCtrlObject.getString("cardatectrl"))) {
                carSkipFields = carSkipFields - 8 - 16;
            }
            String trainDateCtrl = tripCtrlObject.getString("traindatectrl");
            String trainCityCtrl = tripCtrlObject.getString("traincityctrl");
            String trainTripPeopleCtrl = tripCtrlObject.getString("traintrippeoplectrl");
            --trainSkipFields;
            if (StringUtils.isNotEmpty((String)trainDateCtrl) && "1".equals(trainDateCtrl)) {
                trainSkipFields = trainSkipFields - 2 - 4 - 8 - 16;
            }
            if (StringUtils.isNotEmpty((String)trainCityCtrl) && "1".equals(trainCityCtrl)) {
                trainSkipFields = trainSkipFields - 64 - 128;
            }
            if (StringUtils.isNotEmpty((String)trainTripPeopleCtrl) && !"2".equals(trainTripPeopleCtrl)) {
                trainSkipFields -= 32;
            }
            tripControlSettingMap.put("orgId", orgId);
            tripControlSettingMap.put("tripCtrlObject", tripCtrlObject);
            tripControlSettingMap.put("flightSkipFields", flightSkipFields);
            tripControlSettingMap.put("hotelSkipFields", hotelSkipFields);
            tripControlSettingMap.put("carSkipFields", carSkipFields);
            if (StringUtils.isEmpty((String)trainDateCtrl) && StringUtils.isEmpty((String)trainCityCtrl) && StringUtils.isEmpty((String)trainTripPeopleCtrl)) {
                tripControlSettingMap.put("trainSkipFields", 1792);
            } else {
                tripControlSettingMap.put("trainSkipFields", trainSkipFields);
            }
        }
        return tripControlSettingMap;
    }

    private JSONObject convertStatusChange(TripReqbillModel reqbill, String syncStatus) {
        JSONObject bodyDataJson = new JSONObject();
        JSONObject auth = CorpSync.getAuthentification();
        bodyDataJson.put("Auth", (Object)auth);
        JSONArray flightEndorsementDetails = new JSONArray();
        JSONObject flightEndorsementDetail = new JSONObject();
        flightEndorsementDetail.put("FlightWay", (Object)"2");
        flightEndorsementDetail.put("ProductType", (Object)"1");
        flightEndorsementDetails.add((Object)flightEndorsementDetail);
        bodyDataJson.put("FlightEndorsementDetails", (Object)flightEndorsementDetails);
        bodyDataJson.put("EmployeeID", (Object)reqbill.getApplyEmpNum());
        bodyDataJson.put("ApprovalNumber", (Object)reqbill.getBillNo());
        bodyDataJson.put("Status", (Object)0);
        return bodyDataJson;
    }

    private JSONObject convertCloseBill(Object reqBill) {
        JSONObject jsonObject = this.convertPushBill(reqBill);
        jsonObject.put("Status", (Object)0);
        return jsonObject;
    }
}

