/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class CTripCarOrderConvert {
    private static final Log logger = LogFactory.getLog(CTripCarOrderConvert.class);
    private static String ACCNT = "ACCNT";

    public static List<AbstractOrderModel> convert(JSONObject carObj) throws CloneNotSupportedException {
        ArrayList<AbstractOrderModel> carList = new ArrayList<AbstractOrderModel>(4);
        VehicleOrderModel orderModel = new VehicleOrderModel();
        JSONObject basicInfo = carObj.getJSONObject("BasicInfo");
        JSONObject jSONObject = basicInfo = basicInfo == null ? new JSONObject() : basicInfo;
        if (basicInfo == null || basicInfo.isEmpty()) {
            return new ArrayList<AbstractOrderModel>();
        }
        orderModel.setOrderNum(basicInfo.getOrDefault((Object)"OrderId", (Object)"").toString());
        orderModel.setParentOrderNum(basicInfo.getOrDefault((Object)"OrderId", (Object)"").toString());
        orderModel.setOrderDate(basicInfo.getDate("CreateTime"));
        orderModel.setServer(Supplier.XIECHENG.name());
        orderModel.setOrderType(AbstractOrderModel.OrderType.O);
        orderModel.setOaBillNum(basicInfo.getOrDefault((Object)"JouneryID", (Object)"").toString());
        orderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
        orderModel.setOrderNatrue(CTripCarOrderConvert.setOrderNatrue(basicInfo.getOrDefault((Object)"FeeType", (Object)"").toString()));
        if (!ACCNT.equals(basicInfo.getOrDefault((Object)"PaymentType", (Object)"").toString())) {
            return new ArrayList<AbstractOrderModel>();
        }
        String orderStatus = basicInfo.getOrDefault((Object)"OrderStatus", (Object)"").toString();
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u8ba2\u5355\u72b6\u6001\uff1a" + orderStatus);
        if (!VehicleOrderModel.OrderStatus.G.getKey().equals(orderStatus)) {
            return new ArrayList<AbstractOrderModel>();
        }
        orderModel.setProductType(CTripCarOrderConvert.setProductType(basicInfo.getOrDefault((Object)"PaymentType", (Object)"").toString()));
        orderModel.setBooknum(basicInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
        orderModel.setSourceBookedId(basicInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
        orderModel.setBookedname(basicInfo.getOrDefault((Object)"PreEmployeeName", (Object)"").toString());
        JSONArray paymentInfoList = carObj.getJSONArray("PaymentInfoList");
        JSONArray jSONArray = paymentInfoList = paymentInfoList == null ? new JSONArray() : paymentInfoList;
        if (paymentInfoList != null && !paymentInfoList.isEmpty()) {
            orderModel.setHappendDate(basicInfo.getDate("CreateTime"));
            orderModel.setDealAmount(BigDecimal.ZERO);
        }
        orderModel.setOperationType(AbstractOrderModel.OperationType.C);
        orderModel.setOrderStatus(ConvertUtil.getEnum(orderStatus, VehicleOrderModel.OrderStatus.class));
        orderModel.setPaymentStatus(ConvertUtil.getEnum(basicInfo.getOrDefault((Object)"PaymentStatus", (Object)"").toString(), VehicleOrderModel.PaymentStatus.class));
        orderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
        orderModel.setServiceFee(BigDecimal.ZERO);
        orderModel.setPasseger(basicInfo.getOrDefault((Object)"EmployeeId", (Object)"").toString());
        JSONObject passengerInfo = carObj.getJSONObject("PassengerInfo");
        passengerInfo = passengerInfo == null ? new JSONObject() : passengerInfo;
        orderModel.setPassegername(passengerInfo.getOrDefault((Object)"PassengerName", (Object)"").toString());
        JSONObject orderProduct = carObj.getJSONObject("OrderProduct");
        orderProduct = orderProduct == null ? new JSONObject() : orderProduct;
        JSONObject departAddress = orderProduct.getJSONObject("DepartAddress");
        departAddress = departAddress == null ? new JSONObject() : departAddress;
        JSONObject arriveAddress = orderProduct.getJSONObject("ArriveAddress");
        arriveAddress = arriveAddress == null ? new JSONObject() : arriveAddress;
        JSONObject vehicle = orderProduct.getJSONObject("Vehicle");
        vehicle = vehicle == null ? new JSONObject() : vehicle;
        JSONArray carQuickControlList = orderProduct.getJSONArray("CarQuickControlList");
        carQuickControlList = carQuickControlList == null ? new JSONArray() : carQuickControlList;
        orderModel.setUseTime(TripCommonUtil.convertToDate(orderProduct.getOrDefault((Object)"UseTime", (Object)"").toString()));
        orderModel.setDepartAddress(departAddress.getOrDefault((Object)"Address", (Object)"").toString());
        orderModel.setArriveAddress(arriveAddress.getOrDefault((Object)"Address", (Object)"").toString());
        orderModel.setVendorName(vehicle.getOrDefault((Object)"VendorName", (Object)"").toString());
        orderModel.setVehicleType(ConvertUtil.getEnum(vehicle.getOrDefault((Object)"VehicleId", (Object)"1").toString(), VehicleOrderModel.VehicleType.class));
        orderModel.setCityName(departAddress.getOrDefault((Object)"CityName", (Object)"").toString());
        orderModel.setCarControlType(CTripCarOrderConvert.getCarControlType(carQuickControlList));
        orderModel.setDistance(orderProduct.getOrDefault((Object)"NormalDistance", (Object)"").toString());
        carList.add(orderModel);
        return carList;
    }

    private static String getCarControlType(JSONArray jsonArray) {
        if (jsonArray != null && !jsonArray.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (JSONObject next : jsonArray) {
                sb.append(next.getOrDefault((Object)"CarControlType", (Object)"").toString());
                sb.append('-');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("ACCNT".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String orderNatrue) {
        if ("C".equals(orderNatrue)) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        return AbstractOrderModel.OrderNatrue.B;
    }
}

