/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.ExternalConstants;

public class DiDiTripCarRegulationInvoke
extends InPutFunctionTemp<JSONObject> {
    private static Log logger = LogFactory.getLog(DiDiTripCarRegulationInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    @Override
    protected String function() {
        return "tripCarRegulationInvoke";
    }

    @Override
    protected JSONObject process(Map<String, ? extends Object> params) throws TripException {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            return null;
        }
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        String signKey = supplierMap.get("reservedfield1");
        String regulationSign = DiDiServiceUtil.genSign(signMap, signKey);
        HashMap<String, String> regulationparamMap = new HashMap<String, String>();
        regulationparamMap.put("client_id", client_id);
        regulationparamMap.put("company_id", company_id);
        regulationparamMap.put("access_token", access_token);
        regulationparamMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        regulationparamMap.put("sign", regulationSign);
        this.tripSyncLogParam.setRequesturl((String)ExternalConstants.DIDIURLMAP.get("regulationGetKey"));
        JSONObject result = HttpRetryServiceHelper.doGet((String)ExternalConstants.DIDIURLMAP.get("regulationGetKey"), regulationparamMap, JSONObject.class);
        this.tripSyncLogParam.setRequestdata(regulationparamMap);
        this.tripSyncLogParam.setResponsedata(result);
        if (Integer.parseInt(String.valueOf(result.get((Object)"errno"))) == 0) {
            this.tripSyncLogParam.setStatus("A");
        } else {
            this.tripSyncLogParam.setStatus("B");
        }
        logger.info("DiDiTripCarRegulationInvoke process{}", (Object)result.size());
        Map<String, Object> detailCarRegulationData = this.getDetailCarRegulationData(supplierMap, access_token, result);
        JSONObject returnJSON = new JSONObject();
        returnJSON.put("data", (Object)result);
        returnJSON.put("detailData", detailCarRegulationData);
        return returnJSON;
    }

    private Map<String, Object> getDetailCarRegulationData(Map<String, String> supplierMap, String access_token, JSONObject result) {
        if (result == null || null == result.get((Object)"data")) {
            return new HashMap<String, Object>();
        }
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        ArrayList regulationArray = (ArrayList)result.get((Object)"data");
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", timeStamp);
        String signKey = supplierMap.get("reservedfield1");
        String detailUrl = (String)ExternalConstants.DIDIURLMAP.get("detailRegulationGetKey");
        HashMap detailMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList logLists = Lists.newArrayListWithCapacity((int)16);
        for (int i = 0; i < regulationArray.size(); ++i) {
            TripSyncLogParam tripSyncLogParamDetail = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
            logLists.add(tripSyncLogParamDetail);
            tripSyncLogParamDetail.setRequesturl(detailUrl);
            HashMap regulationData = (HashMap)regulationArray.get(i);
            String regulationNumber = String.valueOf(regulationData.get("regulation_id"));
            signMap.put("regulation_id", regulationNumber);
            String sign = DiDiServiceUtil.genSign(signMap, signKey);
            HashMap<String, String> regulationparamMap = new HashMap<String, String>();
            regulationparamMap.put("client_id", client_id);
            regulationparamMap.put("company_id", company_id);
            regulationparamMap.put("access_token", access_token);
            regulationparamMap.put("timestamp", timeStamp);
            regulationparamMap.put("sign", sign);
            regulationparamMap.put("regulation_id", regulationNumber);
            JSONObject detailResult = HttpRetryServiceHelper.doGet(detailUrl, regulationparamMap, JSONObject.class);
            tripSyncLogParamDetail.setRequestdata(regulationparamMap);
            tripSyncLogParamDetail.setResponsedata(detailResult);
            if (Integer.parseInt(String.valueOf(detailResult.get((Object)"errno"))) == 0) {
                tripSyncLogParamDetail.setStatus("A");
            } else {
                tripSyncLogParamDetail.setStatus("B");
            }
            Object approveType = this.getApproveType(detailResult);
            detailMap.put(regulationNumber, approveType == null ? "" : approveType);
        }
        logger.info("\u7528\u8f66\u5236\u5ea6\u660e\u7ec6\u83b7\u53d6:{}", (Object)detailMap.size());
        if (CollectionUtils.isNotEmpty((Collection)logLists)) {
            TripSyncLogUtils.saveErrorLog(logLists);
        }
        return detailMap;
    }

    private Object getApproveType(JSONObject detailResult) {
        if (detailResult == null) {
            return null;
        }
        LinkedHashMap regulationArray = (LinkedHashMap)detailResult.get((Object)"data");
        return regulationArray.get("approval_type");
    }

    @Override
    protected Object convert(JSONObject value) throws TripException {
        if (value == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u6ef4\u6ef4\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"DiDiTripCarRegulationInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        String setectProperties = "id,number,name,status,enable,createtime,modifytime,scenetype,isapprove,isusequota,approvaltype,server";
        DynamicObject[] regulationObjs = BusinessDataServiceHelper.load((String)"er_trip_carregulation", (String)setectProperties, (QFilter[])new QFilter[]{new QFilter("server.number", "=", (Object)this.supplier())});
        HashMap<String, DynamicObject> regulationMap = new HashMap<String, DynamicObject>(regulationObjs.length);
        for (DynamicObject reObject : regulationObjs) {
            regulationMap.put(reObject.getString("number"), reObject);
        }
        Object billType = regulationObjs.length > 0 ? regulationObjs[0].getDynamicObjectType() : EntityMetadataCache.getDataEntityType((String)"er_trip_carregulation");
        JSONObject jsonObject = (JSONObject)value.get((Object)"data");
        Map detailData = (Map)value.get((Object)"detailData");
        ArrayList regulationArray = (ArrayList)jsonObject.get((Object)"data");
        if (regulationArray == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u6ef4\u6ef4\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"DiDiTripCarRegulationInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        DynamicObject bizInfo = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        ArrayList<DynamicObject> regulationDynamicObjectList = new ArrayList<DynamicObject>(regulationArray.size());
        for (int i = 0; i < regulationArray.size(); ++i) {
            HashMap regulationData = (HashMap)regulationArray.get(i);
            String sceneType = String.valueOf(regulationData.get("scene_type"));
            String regulationNumber = String.valueOf(regulationData.get("regulation_id"));
            String regulationName = String.valueOf(regulationData.get("regulation_name"));
            Object rl_status = regulationData.get("regulation_status");
            String regulationStatus = rl_status == null ? null : String.valueOf(rl_status);
            Object rl_use_quota = regulationData.get("is_use_quota");
            String isUseQuotaStr = rl_use_quota == null ? null : String.valueOf(rl_use_quota);
            Object rl_is_approve = regulationData.get("is_approve");
            String isApproveStr = rl_is_approve == null ? null : String.valueOf(rl_is_approve);
            boolean isUseQuota = !"0".equals(isUseQuotaStr);
            boolean isApprove = !"0".equals(isApproveStr);
            DynamicObject regulationObjValue = (DynamicObject)regulationMap.get(regulationNumber);
            if (regulationObjValue != null) {
                regulationObjValue.set("name", (Object)regulationName);
                regulationObjValue.set("number", (Object)regulationNumber);
                regulationObjValue.set("enable", (Object)regulationStatus);
                regulationObjValue.set("status", (Object)Character.valueOf('A'));
                regulationObjValue.set("scenetype", (Object)sceneType);
                regulationObjValue.set("isusequota", (Object)isUseQuota);
                regulationObjValue.set("isapprove", (Object)isApprove);
                regulationObjValue.set("modifytime", (Object)new Date());
                regulationObjValue.set("approvaltype", detailData.get(regulationNumber));
                regulationObjValue.set("server", (Object)bizInfo);
            } else {
                regulationObjValue = new DynamicObject((DynamicObjectType)billType);
                regulationObjValue.set("name", (Object)regulationName);
                regulationObjValue.set("number", (Object)regulationNumber);
                regulationObjValue.set("enable", (Object)regulationStatus);
                regulationObjValue.set("status", (Object)Character.valueOf('A'));
                regulationObjValue.set("scenetype", (Object)sceneType);
                regulationObjValue.set("isusequota", (Object)isUseQuota);
                regulationObjValue.set("isapprove", (Object)isApprove);
                regulationObjValue.set("createtime", (Object)new Date());
                regulationObjValue.set("approvaltype", detailData.get(regulationNumber));
                regulationObjValue.set("server", (Object)bizInfo);
            }
            regulationDynamicObjectList.add(regulationObjValue);
        }
        return regulationDynamicObjectList;
    }

    @Override
    protected void saveInfos(Object infos) throws TripException {
        List regulationDynamicObjectList = (List)infos;
        if (regulationDynamicObjectList != null && regulationDynamicObjectList.size() > 0) {
            String regulationDynamicObjectStr = Arrays.toString(regulationDynamicObjectList.toArray());
            SaveServiceHelper.save((DynamicObject[])regulationDynamicObjectList.toArray(new DynamicObject[regulationDynamicObjectList.size()]));
        }
    }
}

