/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.ExternalConstants;

public class DiDiTripGetCompanyIdInvoke
extends InPutFunctionTemp<JSONObject> {
    private IDataModel model;

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    @Override
    protected String function() {
        return "DiDiTripGetCompanyId";
    }

    @Override
    protected JSONObject process(Map<String, ? extends Object> params) throws TripException {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.DIDI.name());
        String client_id = supplierMap.get("appkey");
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("out_company_id", RequestContext.get().getAccountId());
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u4f01\u4e1a\u6388\u6743\u516c\u53f8id\u7684token\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DiDiTripGetCompanyIdInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        if (params != null && params.size() > 0) {
            this.model = (IDataModel)params.get("model");
        }
        signMap.put("access_token", access_token);
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        String signKey = supplierMap.get("reservedfield1");
        String getCompanyIdSign = DiDiServiceUtil.genSign(signMap, signKey);
        JSONObject authObj = new JSONObject(signMap);
        authObj.put("sign", (Object)getCompanyIdSign);
        this.tripSyncLogParam.setRequestdata(authObj);
        this.tripSyncLogParam.setRequesturl((String)ExternalConstants.DIDIURLMAP.get("getAuthStatusKey"));
        String result = HttpRetryServiceHelper.PostData((String)ExternalConstants.DIDIURLMAP.get("getAuthStatusKey"), authObj.toString());
        this.tripSyncLogParam.setRequestdata(result);
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        return resultJsonObject;
    }

    @Override
    protected Object convert(JSONObject resultJsonObject) throws TripException {
        String company_id = null;
        if (resultJsonObject == null || !"0".equals(resultJsonObject.getString("errno"))) {
            this.tripSyncLogParam.setStatus("B");
            return "300";
        }
        JSONObject data = (JSONObject)resultJsonObject.get((Object)"data");
        Integer auth_status = data.getInteger("auth_status");
        if (auth_status != 0) {
            company_id = data.getString("company_id");
            this.model.setValue("orationid", (Object)company_id);
        }
        return company_id;
    }

    @Override
    protected void saveInfos(Object value) throws TripException {
        QFilter qFilter = new QFilter("number", "=", (Object)this.supplier());
        qFilter.and(new QFilter("enable", "=", (Object)true));
        DynamicObject[] bizinfos = BusinessDataServiceHelper.load((String)"er_biz_info", (String)"id,orationid", (QFilter[])new QFilter[]{qFilter});
        if (bizinfos != null && bizinfos.length > 0) {
            DynamicObject bizinfo = bizinfos[0];
            bizinfo.set("orationid", value);
            SaveServiceHelper.save((DynamicObject[])bizinfos);
        }
    }
}

