/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.model.InvoiceModel;
import kd.fi.er.business.trip.service.function.AbstractInvoiceReceiveInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.TripJSONAnalysisConstruct;
import kd.fi.er.common.ExternalConstants;

public class DiDiTripInvoiceReceiveInvoke
extends AbstractInvoiceReceiveInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(DiDiTripInvoiceReceiveInvoke.class);
    protected static final String EXT_CONVERT = "invoice_bill_ext_convert";

    @Override
    protected String supplier() {
        return Supplier.DIDI.getValue();
    }

    protected Object process(Map params) {
        HashMap<String, Object> invoiceBillMap;
        JSONArray responseArray;
        if (params == null || params.isEmpty()) {
            return null;
        }
        Object data = params.get("jsondata");
        if (data != null) {
            responseArray = (JSONArray)data;
            if (responseArray.size() == 0) {
                logger.info("\u6ef4\u6ef4\u96c6\u6210\u6d4b\u8bd5\u8c03\u7528\u53d1\u7968\u63a5\u53e3\u5931\u8d25\uff0c\u4ee3\u7528\u4f20\u53c2\u4e3a\uff1a" + responseArray.toJSONString());
                return null;
            }
            Set invoiceIdColl = responseArray.stream().filter(response -> ((JSONObject)response).getString("invoice_id") != null).map(response -> ((JSONObject)response).getString("invoice_id")).collect(Collectors.toSet());
            QFilter[] filterArray = new QFilter[]{new QFilter("server", "=", (Object)Supplier.DIDI.getValue()).and(new QFilter("invoicecode", "in", invoiceIdColl))};
            DynamicObject[] invoiceBillArr = BusinessDataServiceHelper.load((String)"er_invoiceorderbill", (String)"id,billno,invoicestatus,invoicecode,trdinvoiceid,invoicenum,invoicestatustime,amountnotax,invoicetax,invoiceamount,invoicetaxrate,systemtaxrate", (QFilter[])filterArray);
            invoiceBillMap = new HashMap(invoiceBillArr.length);
            for (int i = 0; i < invoiceBillArr.length; ++i) {
                DynamicObject invoiceBill = invoiceBillArr[i];
                invoiceBillMap.put(invoiceBill.getString("invoicecode"), invoiceBill);
            }
        } else {
            Map param = params;
            invoiceBillMap = new HashMap<String, DynamicObject>(params.size());
            for (Map.Entry entry : param.entrySet()) {
                List billValueList = (List)entry.getValue();
                if (billValueList.size() <= 0) continue;
                DynamicObject invoiceBill = (DynamicObject)billValueList.get(0);
                invoiceBillMap.put((String)entry.getKey(), invoiceBill);
            }
            responseArray = this.getExternalInvoiceData(invoiceBillMap);
        }
        return this.getInvoiceBill(invoiceBillMap, responseArray);
    }

    private Map<String, DynamicObject> getInvoiceBill(Map<String, DynamicObject> invoiceBillMapping, JSONArray responseArray) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        if (invoiceBillMapping.isEmpty() || responseArray.size() == 0) {
            return result;
        }
        Map<String, DiDiExternalInvoiceInfo> invoiceInfoMap = this.getInvoiceInfo(responseArray);
        if (invoiceInfoMap == null || invoiceInfoMap.isEmpty()) {
            return result;
        }
        Iterator<Map.Entry<String, DynamicObject>> invoiceIterator = invoiceBillMapping.entrySet().iterator();
        ArrayList<DynamicObject> failInvoice = new ArrayList<DynamicObject>();
        while (invoiceIterator.hasNext()) {
            Map.Entry<String, DynamicObject> entry = invoiceIterator.next();
            String invoiceId = entry.getKey();
            DynamicObject invoiceBill = entry.getValue();
            DiDiExternalInvoiceInfo invoiceInfo = invoiceInfoMap.get(invoiceId);
            if (invoiceInfo != null) {
                String invoiceStatus = invoiceInfo.getInvoiceStatus();
                invoiceBill.set("invoicestatus", (Object)invoiceStatus);
                if (!invoiceStatus.equals("3")) {
                    failInvoice.add(invoiceBill);
                    invoiceIterator.remove();
                    continue;
                }
                invoiceBill.set("invoiceamount", (Object)invoiceInfo.getInvoiceAmount());
                invoiceBill.set("invoicenum", (Object)invoiceInfo.getInvoiceNo());
                continue;
            }
            invoiceIterator.remove();
        }
        if (failInvoice.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])failInvoice.toArray(new DynamicObject[failInvoice.size()]));
        }
        return invoiceBillMapping;
    }

    private JSONArray getExternalInvoiceData(Map<String, DynamicObject> invoiceBillMapping) {
        JSONArray responseArray = new JSONArray();
        if (invoiceBillMapping == null || invoiceBillMapping.isEmpty()) {
            return responseArray;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String invoiceNoGetUrl = (String)ExternalConstants.DIDIURLMAP.get("invoiceChargeKey");
        TripJSONAnalysisConstruct construct = new TripJSONAnalysisConstruct("data", "records", "offset", 0, 100, new TripJSONAnalysisConstruct.DefaultOffsetCaculation());
        Calendar calendar = Calendar.getInstance();
        Date startDate = invoiceBillMapping.entrySet().stream().filter(entry -> ((DynamicObject)entry.getValue()).getDate("invoicestatustime") != null).map(entry -> ((DynamicObject)entry.getValue()).getDate("invoicestatustime")).distinct().min((e1, e2) -> e1.compareTo((Date)e2)).get();
        Date endDate = invoiceBillMapping.entrySet().stream().filter(entry -> ((DynamicObject)entry.getValue()).getDate("invoicestatustime") != null).map(entry -> ((DynamicObject)entry.getValue()).getDate("invoicestatustime")).distinct().max((e1, e2) -> e1.compareTo((Date)e2)).get();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("invoice_type", 3);
        requestParam.put("start_date", dateFormat.format(startDate));
        calendar.setTime(endDate);
        calendar.add(5, 1);
        requestParam.put("end_date", calendar.getTime());
        DiDiServiceUtil.getExternalDataByRecure(invoiceNoGetUrl, requestParam, responseArray, construct, this.tripSyncLogParam.clone(), this.tripSyncLogParamList);
        return responseArray;
    }

    private Map<String, DiDiExternalInvoiceInfo> getInvoiceInfo(JSONArray responseArray) {
        if (responseArray.size() == 0) {
            return null;
        }
        Map<String, List<JSONObject>> invoiceGroup = responseArray.stream().map(response -> (JSONObject)response).filter(response -> response.getString("invoice_id") != null).collect(Collectors.groupingBy(response -> response.getString("invoice_id")));
        HashMap<String, DiDiExternalInvoiceInfo> result = new HashMap<String, DiDiExternalInvoiceInfo>(invoiceGroup.size());
        for (Map.Entry<String, List<JSONObject>> entry : invoiceGroup.entrySet()) {
            List<JSONObject> invoiceList = entry.getValue();
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            HashSet<String> invoiceStatusSet = new HashSet<String>(invoiceList.size());
            StringBuilder invoiceNum = new StringBuilder();
            for (int i = 0; i < invoiceList.size(); ++i) {
                JSONObject invoice = invoiceList.get(i);
                String extenernalStatus = invoice.getString("invoice_status").trim();
                invoiceStatusSet.add(extenernalStatus);
                invoiceAmount = invoiceAmount.add(invoice.getBigDecimal("total_price"));
                String invoiceNo = invoice.getString("invoice_no").trim();
                if (invoiceNum.length() > 0) {
                    invoiceNum.append(",");
                }
                invoiceNum.append(invoiceNo);
            }
            String invoiceStatus = invoiceStatusSet.size() >= 3 || invoiceStatusSet.isEmpty() ? "2" : (invoiceStatusSet.size() == 2 ? (invoiceStatusSet.contains("\u5df2\u51b2\u7ea2") && invoiceStatusSet.contains("\u5df2\u9a73\u56de") ? "5" : "2") : (invoiceStatusSet.contains("\u5df2\u5f00\u7968") ? "3" : (invoiceStatusSet.contains("\u5df2\u51b2\u7ea2") || invoiceStatusSet.contains("\u5df2\u9a73\u56de") ? "5" : "2")));
            result.put(entry.getKey(), new DiDiExternalInvoiceInfo(invoiceAmount, invoiceStatus, invoiceNum.toString()));
        }
        return result;
    }

    protected Object convert(Object o) {
        if (o == null) {
            return o;
        }
        Map invoiceBill = (Map)o;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)invoiceBill.size());
        for (Map.Entry entry : invoiceBill.entrySet()) {
            DynamicObject invoiceDetail = (DynamicObject)entry.getValue();
            InvoiceModel model = new InvoiceModel();
            model.setServer(this.supplier());
            model.setTrdInvoiceId(invoiceDetail.getString("trdinvoiceid"));
            model.setCustInvSequence(invoiceDetail.getString("trdinvoiceid"));
            model.setInvoicenum(invoiceDetail.getString("invoicenum"));
            model.setInvoicecode(invoiceDetail.getString("invoicecode"));
            BigDecimal invoiceAmount = invoiceDetail.getBigDecimal("invoiceamount");
            model.setInvoiceamount(invoiceAmount);
            BigDecimal invoiceTaxrate = invoiceDetail.getBigDecimal("systemtaxrate");
            BigDecimal taxAmount = invoiceAmount.multiply(invoiceTaxrate.divide(BigDecimal.valueOf(100L))).divide(BigDecimal.ONE.add(invoiceTaxrate.divide(BigDecimal.valueOf(100L))), 2, RoundingMode.HALF_UP);
            BigDecimal noTaxamount = invoiceAmount.subtract(taxAmount);
            model.setTaxamount(invoiceTaxrate);
            model.setAmountnotax(noTaxamount);
            model.setInvoicetaxrate(invoiceTaxrate);
            JSONObject invoiceBillDyObj = new JSONObject();
            invoiceBillDyObj.put(EXT_CONVERT, (Object)invoiceDetail);
            this.handleInvoiceReceiveExtConvert(model, invoiceBillDyObj);
            list.add(model);
        }
        return list;
    }

    private static class DiDiExternalInvoiceInfo {
        private BigDecimal invoiceAmount;
        private String invoiceStatus;
        private String invoiceNo;

        public DiDiExternalInvoiceInfo(BigDecimal invoiceAmount, String invoiceStatus, String invoiceNo) {
            this.invoiceAmount = invoiceAmount;
            this.invoiceStatus = invoiceStatus;
            this.invoiceNo = invoiceNo;
        }

        public BigDecimal getInvoiceAmount() {
            return this.invoiceAmount;
        }

        public void setInvoiceAmount(BigDecimal invoiceAmount) {
            this.invoiceAmount = invoiceAmount;
        }

        public String getInvoiceStatus() {
            return this.invoiceStatus;
        }

        public void setInvoiceStatus(String invoiceStatus) {
            this.invoiceStatus = invoiceStatus;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public void setInvoiceNo(String invoiceNo) {
            this.invoiceNo = invoiceNo;
        }
    }
}

