/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.service.function.AbstractUserInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiOrgAndUserInvokeUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.SyncUserTypeEnum;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.business.trip.util.UserHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.TripUserGrantUtils;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang3.StringUtils;

public class DiDiTripUserInvoke
extends AbstractUserInvoke<Set<JSONObject>> {
    private static Log logger = LogFactory.getLog(DiDiTripUserInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncpeopletamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncPeopleTamp = this.bizInfoObject.getString("lastsyncpeopletamp");
        return this.queryChangeInfo(this.lastSyncPeopleTamp, 1, 1000000, null);
    }

    @Override
    protected Object getInnerData(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        return this.queryChangeInfo(changeTime, pageIndex, pageSize, map);
    }

    private Map<String, JSONArray> queryChangeInfo(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        this.judgeGrant(map);
        QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
        uFilter.and(new QFilter("datatype", "=", (Object)"bos_org"));
        Map<Object, Object> dataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "outdataid");
        return this.getChangedUserMap(changeTime, pageIndex, pageSize, dataOrgMappingMap, map);
    }

    private void judgeGrant(Map<String, Object> map) {
        Object paramValue;
        if (map == null) {
            return;
        }
        DynamicObjectCollection servers = TripUserGrantUtils.getServers(this.supplier());
        if (CollectionUtils.isNotEmpty((Collection)servers) && (paramValue = map.getOrDefault("didi", "0")) != null && "1".equals(paramValue.toString())) {
            Map bosUsers;
            List userList;
            DynamicObjectCollection dynamicObjects = TripUserGrantUtils.queryUserGrantInfosByServer(Collections.singletonList(this.supplier()));
            Set grantUserNos = dynamicObjects.stream().map(dynamicObject -> ErCommonUtils.getPk(dynamicObject.get("grantuser"))).collect(Collectors.toSet());
            if (map.containsKey("userList")) {
                userList = (List)map.get("userList");
                grantUserNos.retainAll(userList);
            }
            if ((null == grantUserNos || grantUserNos.isEmpty()) && map.containsKey("userList") && null != (bosUsers = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(userList = (List)map.get("userList")))})) && !bosUsers.isEmpty()) {
                Set number = bosUsers.values().stream().map(v -> v.getString("number")).collect(Collectors.toSet());
                this.tripSyncLogParam.setBillno(StringUtils.join(number, (String)","));
            }
            map.put("userList", grantUserNos == null ? new ArrayList() : new ArrayList(grantUserNos));
        }
    }

    private Map<String, JSONArray> getAllUserInfos(Integer pageIndex, Integer pageSize, Map<Object, Object> dataOrgMappingMap, Map<String, Object> map) {
        List<Map<String, Object>> userObjAlls = UserHelper.getAllUserChangeInfos(pageIndex, pageSize, map);
        if ((userObjAlls = userObjAlls.stream().filter(m -> !"4".equals(m.get("type"))).collect(Collectors.toList())) == null || userObjAlls.size() < 1) {
            SyncUserTypeEnum userTypeEnum = UserHelper.getSyncType(map);
            if (pageIndex == 1 && userTypeEnum != SyncUserTypeEnum.SYNC_BY_USER) {
                this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5168\u91cf\u66f4\u65b0,\u4eba\u5458\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u4eba\u5458\u4fe1\u606f!", (String)"DiDiTripUserInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            return null;
        }
        HashMap<String, JSONArray> postUserMap = new HashMap<String, JSONArray>();
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String signKey = supplierMap.get("reservedfield1");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripUserInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        JSONArray addUserList = new JSONArray();
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNumberNew(userObjAlls);
        for (Map<String, Object> userObjAll : userObjAlls) {
            this.buildAddUserList(userObjAll.get("id"), userObjAll.get("phone"), userObjAll.get("name"), userObjAll.get("number"), userObjAll.get("dptId"), client_id, company_id, access_token, signKey, dataOrgMappingMap, addUserList, reimburseLevelMap, userObjAll.get("supernumber"));
        }
        postUserMap.put("add", addUserList);
        return postUserMap;
    }

    private void buildAddUserList(Object userId, Object phone, Object name, Object number, Object dptId, String client_id, String company_id, String access_token, String signKey, Map<Object, Object> dataMappingMap, JSONArray addUserList, Map<Long, String> reimburseLevelMap, Object superNumber) {
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        JSONObject userDataJsonObject = new JSONObject();
        userDataJsonObject.put("phone", phone);
        userDataJsonObject.put("realname", name);
        userDataJsonObject.put("employee_number", number);
        int intValue = TripSyncConfigUtil.getIntValue("trip_Superior", 0, Arrays.asList(0, 1));
        if (intValue == 1) {
            userDataJsonObject.put("immediate_superior_employee_number", superNumber == null ? "" : superNumber);
        }
        userDataJsonObject.put("is_remark", (Object)2);
        Object externalDptId = dataMappingMap.get(dptId);
        this.setBudgetCenterId(dataMappingMap, dptId, userDataJsonObject, userId);
        this.setUserReimburseLevel(userId, reimburseLevelMap, userDataJsonObject, dptId);
        userDataJsonObject.put("use_company_money", (Object)this.getUseCompanyMoney());
        DiDiTripUserInvoke.setInvoceInfo(dptId, userDataJsonObject);
        signMap.put("data", userDataJsonObject.toString());
        String addUserSign = DiDiServiceUtil.genSign(signMap, signKey);
        JSONObject addUserObj = new JSONObject(signMap);
        addUserObj.put("sign", (Object)addUserSign);
        addUserList.add((Object)addUserObj);
    }

    private static void setInvoceInfo(Object dptId, JSONObject userDataJsonObject) {
        Long deptid = Long.parseLong(dptId.toString());
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId(deptid, true);
        DynamicObject std_costcenter = ErCostCenterUtil.getCostCenterByCostDept(deptid);
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(deptid);
        Long stdCostcenterId = 0L;
        if (std_costcenter != null) {
            stdCostcenterId = std_costcenter.getLong("id");
        }
        JSONObject extJson = new JSONObject();
        extJson.put("deptId", dptId);
        if (null != companyId) {
            extJson.put("companyId", (Object)companyId);
        }
        extJson.put("costCompanyId", (Object)costCompanyId);
        extJson.put("stdCostcenterId", (Object)stdCostcenterId);
        extJson.put("taxpayer_subject", (Object)costCompanyId);
        userDataJsonObject.put("invoice_info", (Object)extJson.toJSONString());
    }

    private void setUserReimburseLevel(Object userId, Map<Long, String> reimburseLevelMap, JSONObject userDataJsonObject, Object dptId) {
        String dtrip_personnel_rank = TripSyncConfigUtil.getTripsyncSettingByKey("dtrip_personnel_rank");
        if (StringUtils.isEmpty((CharSequence)dtrip_personnel_rank)) {
            return;
        }
        String reimbursenumber = reimburseLevelMap.get(Long.parseLong(userId.toString()));
        if ("0".equals(dtrip_personnel_rank)) {
            return;
        }
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(Long.parseLong(dptId.toString()));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyId)});
        switch (dtrip_personnel_rank) {
            case "1": {
                if (!StringUtils.isNotEmpty((CharSequence)reimbursenumber) || dynamicObject == null) break;
                userDataJsonObject.put("out_rank_id", (Object)(dynamicObject.getString("number") + "-" + reimbursenumber.trim()));
                break;
            }
            case "2": {
                if (!StringUtils.isNotEmpty((CharSequence)reimbursenumber)) break;
                userDataJsonObject.put("out_rank_id", (Object)reimbursenumber.trim());
                break;
            }
            case "3": {
                if (StringUtils.isNotEmpty((CharSequence)reimbursenumber) && dynamicObject != null) {
                    userDataJsonObject.put("out_rank_id", (Object)(dynamicObject.getString("number") + "-" + reimbursenumber.trim()));
                    break;
                }
                if (dynamicObject == null) break;
                userDataJsonObject.put("out_rank_id", (Object)(dynamicObject.getString("number") + "-General-01"));
                break;
            }
            case "4": {
                if (StringUtils.isNotEmpty((CharSequence)reimbursenumber)) {
                    userDataJsonObject.put("out_rank_id", (Object)reimbursenumber.trim());
                    break;
                }
                userDataJsonObject.put("out_rank_id", (Object)"General-01");
                break;
            }
            case "5": {
                if (StringUtils.isNotEmpty((CharSequence)reimbursenumber) && dynamicObject != null) {
                    userDataJsonObject.put("out_rank_id", (Object)(dynamicObject.getString("number") + "-" + reimbursenumber.trim()));
                    break;
                }
                userDataJsonObject.put("out_rank_id", (Object)"General-01");
            }
        }
    }

    private void buildEditUserList(Object userId, Object phone, Object name, Object number, Object dptId, String client_id, String company_id, String access_token, String signKey, Map<Object, Object> dataOrgMappingMap, Map<Object, Object> dataUserMappingMap, JSONArray editUserList, Map<Long, String> reimburseLevelMap, Object superNumber) {
        Object externalNumber = dataUserMappingMap.get(number);
        if (dataUserMappingMap != null && dataUserMappingMap.size() > 0 && externalNumber != null) {
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            signMap.put("client_id", client_id);
            signMap.put("company_id", company_id);
            signMap.put("access_token", access_token);
            signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            signMap.put("member_id", dataUserMappingMap.get(number));
            JSONObject userDataJsonObject = new JSONObject();
            userDataJsonObject.put("phone", phone);
            userDataJsonObject.put("is_remark", (Object)2);
            userDataJsonObject.put("realname", name);
            userDataJsonObject.put("employee_number", number);
            int intValue = TripSyncConfigUtil.getIntValue("trip_Superior", 0, Arrays.asList(0, 1));
            if (intValue == 1) {
                userDataJsonObject.put("immediate_superior_employee_number", superNumber == null ? "" : superNumber);
            }
            Object externalDptId = dataOrgMappingMap.get(dptId);
            this.setBudgetCenterId(dataOrgMappingMap, dptId, userDataJsonObject, userId);
            this.setUserReimburseLevel(userId, reimburseLevelMap, userDataJsonObject, dptId);
            DiDiTripUserInvoke.setInvoceInfo(dptId, userDataJsonObject);
            userDataJsonObject.put("use_company_money", (Object)this.getUseCompanyMoney());
            signMap.put("data", userDataJsonObject.toString());
            String editUserSign = DiDiServiceUtil.genSign(signMap, signKey);
            JSONObject editUserObj = new JSONObject(signMap);
            editUserObj.put("sign", (Object)editUserSign);
            editUserList.add((Object)editUserObj);
        }
    }

    private void buildDelUserList(String client_id, String company_id, String access_token, String signKey, String userIdDelGroup, JSONArray delUserList) {
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        signMap.put("member_id", userIdDelGroup);
        String delUserSign = DiDiServiceUtil.genSign(signMap, signKey);
        JSONObject delUserObj = new JSONObject(signMap);
        delUserObj.put("sign", (Object)delUserSign);
        delUserList.add((Object)delUserObj);
    }

    private Map<String, JSONArray> getChangedUserMap(String changeTime, Integer pageIndex, Integer pageSize, Map<Object, Object> dataOrgMappingMap, Map<String, Object> map) {
        DynamicObjectCollection servers;
        Date changeDate = TripCommonUtil.convertToDate(changeTime);
        List<Map<String, Object>> userChangeInfos = UserHelper.getUserInfosByTimeNew(pageIndex, pageSize, changeDate, map);
        if (userChangeInfos == null || userChangeInfos.size() < 1) {
            if (pageIndex == 1) {
                this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5dee\u91cf\u66f4\u65b0,\u5dee\u91cf\u4eba\u5458\u4e3a\u7a7a!", (String)"DiDiTripUserInvoke_2", (String)"fi-er-business", (Object[])new Object[0]));
            }
            return null;
        }
        HashMap<String, JSONArray> postUserMap = new HashMap<String, JSONArray>();
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String signKey = supplierMap.get("reservedfield1");
        String access_token = "";
        QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
        uFilter.and(new QFilter("datatype", "=", (Object)"bos_user"));
        Map<Object, Object> dataUserMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "number", "outdataid");
        JSONArray addUserList = new JSONArray();
        List tmpUserChangeInfo = userChangeInfos.stream().filter(userChangeObjMap -> !dataUserMappingMap.containsKey(userChangeObjMap.get("number"))).collect(Collectors.toList());
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNumberNew(userChangeInfos);
        tmpUserChangeInfo.stream().filter(userChangeObjMap -> !(null != userChangeObjMap.get("enable") && "0".equals(userChangeObjMap.get("enable").toString()) || null != userChangeObjMap.get("isforbidden") && "true".equals(userChangeObjMap.get("isforbidden").toString()))).forEach(userChangeObjMap -> this.buildAddUserList(userChangeObjMap.get("id"), userChangeObjMap.get("phone"), userChangeObjMap.get("name"), userChangeObjMap.get("number"), userChangeObjMap.get("dptId"), client_id, company_id, access_token, signKey, dataOrgMappingMap, addUserList, reimburseLevelMap, userChangeObjMap.get("supernumber")));
        if (CollectionUtils.isNotEmpty((Collection)addUserList)) {
            postUserMap.put("add", addUserList);
        }
        ArrayList<Map<String, Object>> maxTimeUserChangeInfos = new ArrayList<Map<String, Object>>();
        userChangeInfos.stream().collect(Collectors.groupingBy(v -> v.get("id").toString())).forEach((key, valueList) -> maxTimeUserChangeInfos.add(valueList.stream().filter(v -> v.get("modifytime") != null).max(Comparator.comparing(v -> (Date)v.get("modifytime"))).get()));
        this.sortList(maxTimeUserChangeInfos);
        JSONArray editUserList = new JSONArray();
        maxTimeUserChangeInfos.stream().filter(userChangeObjMap -> !(userChangeObjMap.get("number") == null || !dataUserMappingMap.containsKey(userChangeObjMap.get("number")) || null != userChangeObjMap.get("enable") && "0".equals(userChangeObjMap.get("enable").toString()) || null != userChangeObjMap.get("isforbidden") && "true".equals(userChangeObjMap.get("isforbidden").toString()))).collect(Collectors.toList()).forEach(userChangeObjMap -> this.buildEditUserList(userChangeObjMap.get("id"), userChangeObjMap.get("phone"), userChangeObjMap.get("name"), userChangeObjMap.get("number"), userChangeObjMap.get("dptId"), client_id, company_id, access_token, signKey, dataOrgMappingMap, dataUserMappingMap, editUserList, reimburseLevelMap, userChangeObjMap.get("supernumber")));
        if (CollectionUtils.isNotEmpty((Collection)editUserList)) {
            postUserMap.put("edit", editUserList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(servers = TripUserGrantUtils.getServers(this.supplier())))) {
            Integer paramValue;
            Integer n = paramValue = map == null ? Integer.valueOf(0) : map.getOrDefault("didi", "0");
            if (paramValue == null || "0".equals(((Object)paramValue).toString())) {
                postUserMap.clear();
            }
        }
        List<Object> delUserChangeInfos = new ArrayList();
        JSONArray delUserList = new JSONArray();
        delUserChangeInfos = maxTimeUserChangeInfos.stream().filter(userChangeDO -> userChangeDO.get("number") != null && (null != userChangeDO.get("enable") && "0".equals(userChangeDO.get("enable").toString()) || null != userChangeDO.get("isforbidden") && "true".equals(userChangeDO.get("isforbidden").toString()))).collect(Collectors.toList());
        if (delUserChangeInfos.size() > 0) {
            int i;
            int size = delUserChangeInfos.size() / 100 + 1;
            HashMap userMapGroup = new HashMap(size);
            for (i = 0; i < size; ++i) {
                userMapGroup.put(i, new ArrayList(100));
            }
            for (i = 0; i < delUserChangeInfos.size(); ++i) {
                int index = i / 100;
                Object number = ((Map)delUserChangeInfos.get(i)).get("number");
                ((List)userMapGroup.get(index)).add(number);
            }
            for (i = 0; i < userMapGroup.size(); ++i) {
                List userMapGroupList = (List)userMapGroup.get(i);
                StringBuilder userIdSb = new StringBuilder();
                for (int j = 0; j < userMapGroupList.size(); ++j) {
                    String innerNumber = (String)userMapGroupList.get(j);
                    Long outerUserId = (Long)dataUserMappingMap.get(innerNumber);
                    if (outerUserId == null || outerUserId == 0L) continue;
                    userIdSb = "".equals(userIdSb.toString()) ? userIdSb.append(outerUserId) : userIdSb.append("_").append(outerUserId);
                }
                if (!StringUtils.isNotEmpty((CharSequence)userIdSb.toString())) continue;
                this.buildDelUserList(client_id, company_id, access_token, signKey, userIdSb.toString(), delUserList);
            }
            if (CollectionUtils.isNotEmpty((Collection)delUserList)) {
                postUserMap.put("del", delUserList);
            }
        }
        return postUserMap;
    }

    protected Object convert(Object info) {
        return info;
    }

    protected String batPushProcess(Object data) {
        Map postUserJSONArrayMap = (Map)data;
        if (postUserJSONArrayMap == null || postUserJSONArrayMap.size() <= 0) {
            String code = "200";
            if (this.tripSyncLogParam.getStatus().equals("B")) {
                code = "300";
            }
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u5dee\u91cf\u66f4\u65b0,\u5dee\u91cf\u4eba\u5458\u4e3a\u7a7a!", (String)"DiDiTripUserInvoke_2", (String)"fi-er-business", (Object[])new Object[0]));
            return code;
        }
        AtomicReference<Boolean> successflag = new AtomicReference<Boolean>(true);
        ArrayList waitDelData = Lists.newArrayListWithCapacity((int)1);
        postUserJSONArrayMap.forEach((syncKey, postUserJSONArray) -> {
            String url = "";
            switch (syncKey) {
                case "add": {
                    url = (String)ExternalConstants.DIDIURLMAP.get("memberSingleKey");
                    break;
                }
                case "edit": {
                    url = (String)ExternalConstants.DIDIURLMAP.get("memberEditKey");
                    break;
                }
                case "del": {
                    url = (String)ExternalConstants.DIDIURLMAP.get("memberDelKey");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)url)) {
                Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
                String signKey = supplierMap.get("reservedfield1");
                RefObject refObject = new RefObject(new ArrayList(10));
                List<TripSyncDataMappingModel> dataMappingList = DiDiOrgAndUserInvokeUtil.postChangeData(successflag, syncKey, "bos_user", postUserJSONArray, url, this.supplier(), this.tripSyncLogParam, this.tripSyncLogParamList, signKey, (RefObject<List<TripSyncLogParam>>)refObject);
                TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
                if (StringUtils.equals((CharSequence)syncKey, (CharSequence)"del")) {
                    waitDelData.add(postUserJSONArray);
                }
                ((List)refObject.getValue()).stream().forEach(e -> this.addTripSyncLogParam((TripSyncLogParam)e));
            }
        });
        this.dealWaitDelData(waitDelData);
        String code = "300";
        if (successflag.get().booleanValue()) {
            code = "200";
        }
        return code;
    }

    @Override
    protected boolean syncUserByPage() {
        return true;
    }

    private void setBudgetCenterId(Map<Object, Object> dataOrgMappingMap, Object dptId, JSONObject userDataJsonObject, Object userId) {
        if (dataOrgMappingMap.isEmpty()) {
            return;
        }
        int paramValue = TripSyncConfigUtil.getIntValue("budget_center_id", 1);
        Object budgetCenterId = null;
        switch (paramValue) {
            case 0: 
            case 2: {
                budgetCenterId = dataOrgMappingMap.get(dptId);
                break;
            }
            case 1: {
                DynamicObject userInfo = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,number,entryentity.dpt,entryentity.ispartjob,entryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(userId.toString()))});
                if (userInfo == null) break;
                DynamicObjectCollection entryEntity = userInfo.getDynamicObjectCollection("entryentity");
                int size = entryEntity.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    boolean ispartjob = dynamicObject.getBoolean("ispartjob");
                    if (ispartjob) continue;
                    Long id = ErCommonUtils.getPk(dynamicObject.get("dpt"));
                    Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(id);
                    budgetCenterId = dataOrgMappingMap.get(companyId);
                }
                break;
            }
            case 3: {
                Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(Long.parseLong(dptId.toString()));
                budgetCenterId = dataOrgMappingMap.get(accountOrgId);
            }
        }
        userDataJsonObject.put("budget_center_id", budgetCenterId);
    }

    private Integer getUseCompanyMoney() {
        return TripSyncConfigUtil.getBoolean("dtrip_use_company_money") ? 1 : 0;
    }

    private void sortList(List<Map<String, Object>> maxTimeUserChangeInfos) {
        maxTimeUserChangeInfos.sort(Comparator.comparing(t -> String.valueOf(t.get("modifytime"))));
    }

    private void dealWaitDelData(List<JSONArray> waitDelData) {
        if (CollectionUtils.isEmpty(waitDelData)) {
            return;
        }
        JSONArray delJsonArray = waitDelData.get(0);
        ArrayList outIdLists = Lists.newArrayListWithCapacity((int)16);
        for (Object o : delJsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            String member_id = jsonObject.getString("member_id");
            if (StringUtils.isEmpty((CharSequence)member_id)) continue;
            String[] outIDs = member_id.split("_");
            outIdLists.addAll(Arrays.stream(outIDs).collect(Collectors.toList()));
        }
        logger.info("\u5916\u90e8\u6570\u636eID", (Object)outIdLists.size());
        QFilter tmpFilter = new QFilter("server", "=", (Object)this.supplier());
        tmpFilter.and(new QFilter("datatype", "=", (Object)"bos_user"));
        ArrayList numbers = Lists.newArrayListWithCapacity((int)16);
        Map<Object, Object> dataUserMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(tmpFilter, "outdataid", "number");
        for (String outId : outIdLists) {
            Object number;
            long outIdLong = Long.parseLong(outId);
            if (!dataUserMappingMap.containsKey(outIdLong) || (number = dataUserMappingMap.get(outIdLong)) == null || StringUtils.isEmpty((CharSequence)number.toString())) continue;
            numbers.add(number);
        }
        if (CollectionUtils.isEmpty((Collection)numbers)) {
            return;
        }
        DeleteServiceHelper.delete((String)"er_tripsync_datamapping", (QFilter[])new QFilter[]{new QFilter("server", "=", (Object)this.supplier()), new QFilter("number", "in", (Object)numbers)});
    }
}

