/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.service.function.AbstractOrderInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiTripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class DiDiTripOrderInvoke
extends AbstractOrderInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(DiDiTripOrderInvoke.class);
    private Date lastSyncOrderBillTamp;
    private Date currSyncOrderBillTamp;
    private AtomicReference<Boolean> syncSuccessFlag;
    private DynamicObject bizInfoObject = null;
    private Boolean isScheduledTask = Boolean.TRUE;
    private static final String LASTSYNCORDERBILLTAMP_PROP = "lastsyncorderbilltamp";

    public DiDiTripOrderInvoke() {
    }

    public DiDiTripOrderInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    protected Object process(Map params) throws TripException {
        if (params != null && params.get("jsondata") != null) {
            this.syncSuccessFlag = new AtomicReference<Boolean>(Boolean.FALSE);
            JSONObject currOrderObject = (JSONObject)JSONObject.parseObject((String)((String)params.get("jsondata"))).get((Object)"data");
            JSONArray records = (JSONArray)currOrderObject.get((Object)"records");
            return records;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,\u67e5\u8be2\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u5f00\u59cb");
        if (params != null && params.size() > 0 && params.get("beginDate") != null && params.get("endDate") != null) {
            Date beginNewDate = TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            Date endNewDate = TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            this.lastSyncOrderBillTamp = beginNewDate;
            this.currSyncOrderBillTamp = endNewDate;
            this.isScheduledTask = Boolean.FALSE;
        } else {
            this.isScheduledTask = true;
        }
        JSONArray dataArray = new JSONArray();
        this.queryOrderData(dataArray);
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,\u67e5\u8be2\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u7ed3\u675f");
        return dataArray;
    }

    private void queryOrderData(JSONArray dataArray) {
        if (this.isScheduledTask.booleanValue()) {
            this.getTripLastSyncOrderBillTamp();
        }
        this.syncSuccessFlag = new AtomicReference<Boolean>(Boolean.TRUE);
        int index = 0;
        int pageSize = 100;
        this.startQueryOrderData(index, pageSize, dataArray);
    }

    private void getTripLastSyncOrderBillTamp() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)LASTSYNCORDERBILLTAMP_PROP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrderBillTamp = this.bizInfoObject.getDate(LASTSYNCORDERBILLTAMP_PROP);
        String orderbillStartdate = TripSyncConfigUtil.getTripsyncSettingByKey("dtrip_orderbill_startdate");
        if (null != orderbillStartdate && !orderbillStartdate.trim().isEmpty()) {
            this.lastSyncOrderBillTamp = TripCommonUtil.strToDate(orderbillStartdate, "yyyy-MM-dd HH:mm:ss");
            return;
        }
        if (this.lastSyncOrderBillTamp.before(ErCommonUtils.getDateFromLocalDate(LocalDate.of(2000, 1, 1)))) {
            this.lastSyncOrderBillTamp = TripCommonUtil.delayByMonth(new Date(), -1);
        }
    }

    private void startQueryOrderData(int index, int length, JSONArray dataArray) {
        String url = (String)ExternalConstants.DIDIURLMAP.get("orderGetKey");
        Map<String, Object> getOrderparamMap = this.buildPostParams(index, length);
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        currentLog.setRequesturl(url);
        currentLog.setRequestdata(getOrderparamMap);
        JSONObject result = HttpRetryServiceHelper.doGet(url, getOrderparamMap, JSONObject.class);
        currentLog.setResponsedata(result);
        if (result == null) {
            this.syncSuccessFlag.set(Boolean.FALSE);
            logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,\u83b7\u53d6\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u5931\u8d25,\u62a5\u9519\u4fe1\u606ferrmsg:" + result);
            return;
        }
        if (result != null && !result.getString("errno").equals("0")) {
            currentLog.setStatus("B");
            currentLog.setMessage(result.getString("errmsg"));
            this.syncSuccessFlag.set(Boolean.FALSE);
            dataArray.clear();
            logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,\u83b7\u53d6\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u5931\u8d25, \u62a5\u9519\u4fe1\u606ferrmsg:" + result);
            this.tripSyncLogParamList.add(currentLog);
            return;
        }
        currentLog.setStatus("A");
        this.syncSuccessFlag.set(Boolean.TRUE);
        this.tripSyncLogParamList.add(currentLog);
        HashMap currOrderMap = (HashMap)result.get((Object)"data");
        ArrayList records = (ArrayList)currOrderMap.get("records");
        int total = (Integer)currOrderMap.get("total");
        if (records == null) {
            return;
        }
        dataArray.addAll((Collection)records);
        if (length == records.size()) {
            this.startQueryOrderData(index += length, length, dataArray);
        }
    }

    private Map<String, Object> buildPostParams(int index, int length) {
        if (this.isScheduledTask.booleanValue()) {
            String orderbillEnddate = TripSyncConfigUtil.getTripsyncSettingByKey("dtrip_orderbill_enddate");
            this.currSyncOrderBillTamp = null != orderbillEnddate && !orderbillEnddate.trim().isEmpty() ? TripCommonUtil.strToDate(orderbillEnddate, "yyyy-MM-dd HH:mm:ss") : new Date();
        }
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"DiDiTripOrderInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("start_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(TripCommonUtil.addDayByHour(this.lastSyncOrderBillTamp, -1)));
        signMap.put("end_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.currSyncOrderBillTamp));
        signMap.put("need_approval_id", 1);
        signMap.put("offset", index);
        signMap.put("length", length);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        signMap.put("timestamp", timestamp);
        String signKey = supplierMap.get("reservedfield1");
        String getOrderSign = DiDiServiceUtil.genSign(signMap, signKey);
        HashMap<String, Object> getOrderparamMap = new HashMap<String, Object>();
        getOrderparamMap.put("client_id", client_id);
        getOrderparamMap.put("company_id", company_id);
        getOrderparamMap.put("access_token", access_token);
        getOrderparamMap.put("start_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(TripCommonUtil.addDayByHour(this.lastSyncOrderBillTamp, -1)));
        getOrderparamMap.put("end_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.currSyncOrderBillTamp));
        getOrderparamMap.put("need_approval_id", 1);
        getOrderparamMap.put("offset", index);
        getOrderparamMap.put("length", length);
        getOrderparamMap.put("timestamp", timestamp);
        getOrderparamMap.put("sign", getOrderSign);
        return getOrderparamMap;
    }

    protected Object convert(Object value) throws TripException {
        JSONArray orderArray = JSON.parseArray((String)JSON.toJSONString((Object)value));
        if (orderArray == null || orderArray.size() < 1) {
            return new ArrayList();
        }
        ArrayList<VehicleOrderModel> carList = new ArrayList<VehicleOrderModel>(orderArray.size());
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,convert\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u5f00\u59cb\uff0c\u8ba2\u5355\u6570\u636e\uff1a" + orderArray.size());
        for (int i = 0; i < orderArray.size(); ++i) {
            JSONObject didiOrderInfo = JSON.parseObject((String)JSON.toJSONString((Object)orderArray.get(i)));
            VehicleOrderModel carOrderModel = new VehicleOrderModel();
            carOrderModel.setOrderNum(didiOrderInfo.getString("order_id"));
            carOrderModel.setParentOrderNum(didiOrderInfo.getString("order_id"));
            carOrderModel.setOaBillNum(didiOrderInfo.getString("out_approval_id"));
            carOrderModel.setDepartAddress(didiOrderInfo.getString("actual_start_name"));
            carOrderModel.setArriveAddress(didiOrderInfo.getString("actual_end_name"));
            carOrderModel.setPassegername(didiOrderInfo.getString("passenger_name"));
            carOrderModel.setUseTime(TripCommonUtil.convertToDate(didiOrderInfo.getString("departure_time")));
            carOrderModel.setOrderDate(TripCommonUtil.convertToDate(didiOrderInfo.getString("create_time")));
            carOrderModel.setHappendDate(TripCommonUtil.convertToDate(didiOrderInfo.getString("pay_time")));
            carOrderModel.setCityName(didiOrderInfo.getString("city_name"));
            carOrderModel.setServer(this.supplier());
            carOrderModel.setDistance(didiOrderInfo.getString("normal_distance"));
            carOrderModel.setVendorName(ResManager.loadKDString((String)"\u6ef4\u6ef4", (String)"DiDiTripOrderInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            carOrderModel.setProductType(DiDiTripPropMapping.getPayTypeEnumByKey(didiOrderInfo.getString("pay_type")));
            String productType = carOrderModel.getProductType().getKey();
            if (StringUtils.equals((String)productType, (String)"1")) {
                carOrderModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
            } else {
                carOrderModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.B);
            }
            carOrderModel.setVehicleType(DiDiTripPropMapping.setVehicleType(didiOrderInfo.getString("require_level")));
            carOrderModel.setOperationType(AbstractOrderModel.OperationType.C);
            carOrderModel.setPersonalFee(new BigDecimal(didiOrderInfo.getString("personal_real_pay")).subtract(new BigDecimal(didiOrderInfo.getString("personal_real_refund"))));
            carOrderModel.setDealAmount(new BigDecimal(didiOrderInfo.getString("actual_price")));
            BigDecimal totalAmount = new BigDecimal(didiOrderInfo.getString("company_real_pay")).subtract(new BigDecimal(didiOrderInfo.getString("company_real_refund")));
            carOrderModel.setTotalAmount(totalAmount);
            String orderStatus = didiOrderInfo.getString("status");
            carOrderModel.setOrderStatus(DiDiTripPropMapping.setOrderStatus(Integer.parseInt(orderStatus)));
            if ("3".equals(orderStatus)) {
                carOrderModel.setServiceFee(BigDecimal.ZERO);
            } else if (null == didiOrderInfo.getString("service_fee")) {
                carOrderModel.setServiceFee(BigDecimal.ZERO);
            } else {
                carOrderModel.setServiceFee(new BigDecimal(didiOrderInfo.getString("service_fee")));
            }
            carOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
            AbstractOrderModel.OrderType orderType = AbstractOrderModel.OrderType.O;
            if ("3".equals(orderStatus) || "7".equals(orderStatus)) {
                orderType = AbstractOrderModel.OrderType.T;
            }
            carOrderModel.setOrderType(orderType);
            String member_id = didiOrderInfo.getString("member_id");
            if (StringUtils.isNotEmpty((String)member_id)) {
                Long memberId = Long.valueOf(member_id);
                QFilter qFilter = new QFilter("outdataid", "=", (Object)memberId);
                qFilter.and("datatype", "=", (Object)"bos_user");
                Map<Object, Object> dataMapping = TripSyncDataMappingUtil.getDataMappingMapByFilter(qFilter, "outdataid", "number");
                if (!dataMapping.isEmpty()) {
                    Object o = dataMapping.get(memberId);
                    if (o != null) {
                        carOrderModel.setPasseger(String.valueOf(o));
                        carOrderModel.setSourceBookedId(String.valueOf(o));
                        carOrderModel.setBookedname(didiOrderInfo.getString("passenger_name"));
                    }
                } else {
                    DynamicObject passegarUser;
                    DynamicObject bookUser = CommonServiceHelper.getObjByProp("bos_user", "phone", didiOrderInfo.getString("call_phone"));
                    if (bookUser != null) {
                        carOrderModel.setSourceBookedId(String.valueOf(bookUser.getString("number")));
                        carOrderModel.setBookedname(bookUser.getString("name"));
                    }
                    if ((passegarUser = CommonServiceHelper.getObjByProp("bos_user", "phone", didiOrderInfo.getString("passenger_phone"))) != null) {
                        carOrderModel.setPasseger(String.valueOf(passegarUser.getString("number")));
                    }
                }
            }
            carOrderModel.setPassegername(didiOrderInfo.getString("passenger_name"));
            String expDetOuterOrgId = String.valueOf(didiOrderInfo.get((Object)"budget_center_id"));
            QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
            uFilter.and(new QFilter("datatype", "=", (Object)"bos_org"));
            Map<Object, Object> dataMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "outdataid", "innerdataid");
            Object settleDept = dataMappingMap.get(expDetOuterOrgId);
            if (dataMappingMap != null && dataMappingMap.size() > 0 && settleDept != null) {
                carOrderModel.setExpcommitdepnum(String.valueOf(settleDept));
                Map companyfromOrg = OrgUnitServiceHelper.getCompanyfromOrg((Object)settleDept);
                carOrderModel.setExpcommitcomnum((String)companyfromOrg.get("id"));
            }
            if (null != didiOrderInfo.get((Object)"invoice_info") && !didiOrderInfo.getString("invoice_info").trim().isEmpty()) {
                String invoiceInfo = didiOrderInfo.getString("invoice_info");
                JSONObject jsonObject = JSON.parseObject((String)invoiceInfo);
                carOrderModel.setExpcommitcomnum(jsonObject.getString("costCompanyId"));
                carOrderModel.setExpcommitdepnum(jsonObject.getString("dptId"));
                carOrderModel.setOrg(jsonObject.getLong("dptId"));
                carOrderModel.setCompany(jsonObject.getLong("companyId"));
                carOrderModel.setStd_costcenter(jsonObject.getLong("stdCostcenterId"));
            }
            this.handleCarOrderExtCovert(carOrderModel, didiOrderInfo);
            carList.add(carOrderModel);
        }
        return carList;
    }

    @Override
    public void execute() {
        super.execute();
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,save\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u5f00\u59cb");
        if (this.isScheduledTask.booleanValue()) {
            this.saveLastSyncOrderbilltTamp();
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,save\u6ef4\u6ef4\u8ba2\u5355\u6570\u636e\u7ed3\u675f");
    }

    private void saveLastSyncOrderbilltTamp() {
        if (this.syncSuccessFlag.get().booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u8ba2\u5355,\u66f4\u65b0\u540c\u6b65\u8ba2\u5355\u65f6\u95f4\u6233\u4e3a\uff1a" + this.currSyncOrderBillTamp);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentTime = sdf.format(this.currSyncOrderBillTamp);
            this.bizInfoObject.set(LASTSYNCORDERBILLTAMP_PROP, (Object)currentTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bizInfoObject});
        }
    }
}

